
(defun crlf-to-lf (str)
  (let* ((size (length str))
	 (sp 0)
	 c 
	 (new-str (make-list 1 0)))
    (while (< sp size)
      (setq c (aref str sp))
      (if (not (eq c ?\C-m))
	  (nconc new-str (list c)))
      (setq sp (1+ sp)))
    (concat (cdr new-str))))

(defun comint-filter (process string)
  (let ((obuf (current-buffer))
	opoint obeg oend)
    (set-buffer (process-buffer process))
    (setq opoint (point))
    (setq obeg (point-min))
    (setq oend (point-max))
    (setq string (crlf-to-lf string))
    (let ((buffer-read-only nil)
	  (nchars (length string)))
      (widen)
      (goto-char (process-mark process))
      (if (<= (point) opoint)
	  (setq opoint (+ opoint nchars)))
      ;; Insert after old_begv, but before old_zv.
      (if (< (point) obeg)
	  (setq obeg (+ obeg nchars)))
      (if (<= (point) oend)
	  (setq oend (+ oend nchars)))

      (insert-before-markers string)
      ;; Don't insert initial prompt outside the top of the window.
      (if (= (window-start (selected-window)) (point))
	  (set-window-start (selected-window) (- (point) (length string))))

      (and comint-last-input-end
	   (marker-buffer comint-last-input-end)
	   (= (point) comint-last-input-end)
	   (set-marker comint-last-input-end
		       (- comint-last-input-end nchars)))
      (set-marker (process-mark process) (point) nil)
      (force-mode-line-update))

    (narrow-to-region obeg oend)
    (goto-char opoint)
    (set-buffer obuf)))

