;;; demacs.el --- Demacs specific functions.

;; Copyright (C) 1993 Free Software Foundation, Inc.

;; Author: Satoshi Hirano  <hirano@tkl.iis.u-tokyo.ac.jp>
;;         Manabu Higashida <manabu@sigmath.es.osaka-u.ac.jp>
;; Version: 2.0

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; Edition History:
;;
;; Demacs Date     By               Nemacs  Emacs
;; ------ -------- ---------------- ------- -------
;; 1.1.1  91/10/16 Halca.Hirano     3.3.2   18.55
;;   creation
;;   Things to do: CTRL-C, fix call-process, parent directory write protect
;;
;; 1.1.2  91/10/23 Manabu Higashida 3.3.2   18.55
;;   slightly modification including bug fix
;;   Things to do: get size of free disk space and set it to core limit size.
;;                 handle unready floppy disk drive.
;;
;; 1.1.3  91/10/29 Manabu Higashida 3.3.2   18.55 (partly 18.57)
;;   bug fix
;;
;; 1.1.4  91/11/22 Manabu Higashida 3.3.2   18.55 (partly 18.57)
;;   bug fix and pc98 specified fetures
;;
;; 1.1.5  91/11/25 Manabu Higashida 3.3.2   18.55 (partly 18.57)
;;   bug fix and addition of pc98 terminal specified fetures
;;
;; 1.1.6  91/11/27 Manabu Higashida 3.3.2   18.55 (partly 18.57)
;;   bug fix thanks to mrs@netcom.com

;; Demacs Date     By               Emacs Mule
;; ------ -------- ---------------- ----- -----
;; 2.0    93/07/15 Manabu Higashida 19.16 0.9.8
;;   modified for Eamcs Ver.19.16

;;; Code:

(defconst demacs-version "2.0" "\
Version numbers of this version of Demacs. major.minor")

(defconst demacs-version-date "1993.7.15" "\
Distribution date of this version of Demacs.")

(defun demacs-version ()  "\
Return string describing the version of Demacs that is running."
  (interactive)
  (if (interactive-p)
      (message "%s" (demacs-version))
    (format "Demacs version %s of %s" demacs-version demacs-version-date)))


;; File translation mode
(setq-default buffer-file-translation-mode *dos-text*)

(setq file-name-file-translation-mode-alist
  '(
    ("\\.bat$" . *dos-text*) ; *.bat text translation
    ("[:/].*config.sys" . *dos-text*) ; config.sys text translation
    ("\\.sys$" . nil)  ; *.sys binary translation
    ("\\.elc$" . nil)  ; *.elc binary translation
    ("\\.obj$" . nil)  ; *.obj binary translation
    ("\\.exe$" . nil)  ; *.exe binary translation
    ("\\.com$" . nil)  ; *.com binary translation
    ("\\.lib$" . nil)  ; *.lib binary translation
    ("\\.chk$" . nil)  ; *.chk binary translation ;; chkdsk.exe dumps this.
    ("\\.o$"   . nil)  ; *.o binary translation
    ("\\.a$"   . nil)  ; *.a binary translation
    ("\\.out$" . nil)  ; *.out binary translation
    ))

;; Default machine type
(setq-default dos-machine-type 'ibmpc)

;;
;; Re-definition of variables specific to DOS and Win32
;;
;;;(setq user-init-filename "_emacs")
(setq null-filename "nul")
(setq backup-filename "~/backup.~")
(setq shell-command-option "\/c")
(setq abbrev-file-name "~/abbrev.def")
(setq save-context-predicate
      (function
       (lambda (w)
	 (and (buffer-file-name (window-buffer w))
	      (not (string-match ".:\\(/usr\\)?/tmp/"
				 (buffer-file-name (window-buffer w))))))))

;;
;; Re-definition of function specific to DOS
;;
(defun dos-add-char-to-file-name (file char)
  (let ((fn (file-name-nondirectory file)))
    (concat (file-name-directory file)
	    (if (string-match "\\..*$" fn)
		(let ((ext (substring fn (1+ (match-beginning 0))))
		      (body (substring fn 0 (match-beginning 0))))
		  (if (< (length ext) 3)
		      (concat fn char)
		    (concat body "." (substring ext 0 2) char)))
	      (concat fn "." char)))))

(defun make-backup-file-name (file)
  "Create the non-numeric backup file name for FILE.
This is a separate function so you can redefine it for customization.
On ms-dos system rule, foo -> foo.~, foo.c -> foo.c~, foo.abc -> foo.ab~"
  (dos-add-char-to-file-name file "~"))

(defun make-auto-save-file-name ()
  "Return file name to use for auto-saves of current buffer.
Does not consider auto-save-visited-file-name; that is checked
before calling this function.
You can redefine this for customization.
See also auto-save-file-name-p.
On ms-dos system rule, abcdefgh -> #abcdefg.# or #%abcdef.#, 
foo.c -> #foo.c# and foo.abc -> #foo.ab#."
  (if buffer-file-name
      (concat (file-name-directory buffer-file-name)
              "#"
	      (dos-add-char-to-file-name
	       (file-name-nondirectory buffer-file-name) "#"))
    (expand-file-name (concat "#%"
			      (dos-add-char-to-file-name (buffer-name) "#")))))

;;;

;;; The following are ramains for backward compatibility.
;;;   OLD: file-type     NEW: buffer-file-translation-mode
;;;   ("text"   . 0) <=> (*dos-text* . 1)
;;;   ("binary" . 1) <=> (nil . 0)
;
;(defun convert-file-type-to-file-translation-mode (code)
;  (if (= code 0) *dos-text*))
;
;;; file-type   (0 "text") (1 "binary")
;(setq-default file-type 0)
;
;;;
;;; utilities
;;;
;(defconst file-type-alist '(("text" . 0) ("binary" . 1)))
;
;(defun file-type-p (code)
;  (and (numberp code) (or (eq 0 code) (eq 1 code))))
;
;(defun file-type-internal (code)
;  (let ((case-fold-search t)
;        (string (cond ((stringp code) code)
;                      ((symbolp code) (symbol-name code))
;                      (t ""))))
;    (cond ((string-match "t.*" string)
;           0)
;          ((string-match "b.*" string)
;           1)
;          (t 0))))
;
;(defun set-file-type (code &optional buffer)
;  (interactive (list (completing-read "File Type : "
;                                      file-type-alist nil t nil)))
;  (or (null code)
;      (if (symbolp code)
;          (setq code (file-type-internal code))
;        (if (stringp code)
;            (setq code (cdr (assoc code file-type-alist))))
;        (if (not (file-type-p code))
;            (setq code (cdr (assoc (completing-read "File Type : "
;                                                    file-type-alist nil t nil)
;                                   file-type-alist))))))
;  (save-excursion
;    (set-buffer (or buffer (current-buffer)))
;    ;; 92.11.2 by M.Higashida
;    (setq buffer-file-translation-mode 
;          (convert-file-type-to-file-translation-mode code)))
;  code)
;
;(defun set-default-file-type (code)
;  (interactive (list (completing-read "File Type : "
;                                      file-type-alist nil t nil)))
;  (or (null code)
;      (if (symbolp code)
;          (setq code (file-type-internal code))
;        (if (stringp code)
;            (setq code (cdr (assoc code file-type-alist))))
;        (if (not (file-type-p code))
;            (setq code (cdr (assoc (completing-read "File Type : "
;                                                    file-type-alist nil t nil)
;                                   file-type-alist))))))
;  ;; 92.11.2 by M.Higashida
;  (setq-default buffer-file-translation-mode 
;                (convert-file-type-to-file-translation-mode code)))

;; completion
(setq completion-ignored-extensions
      (append completion-ignored-extensions
	      '(".obj" ".exe" ".bin" ".com")))

(setq auto-mode-alist
      (append '(("\\.txt$" . text-mode)) auto-mode-alist))

(setq explicit-shell-file-name "/bin/cmd.exe")
(setq explicit-cmd.exe-args '("/Q"))


