#ifndef _YTVDICTIONARYDLL_
#define _YTVDICTIONARYDLL_ _YTVDICTIONARYDLL_
/*
Registry Functions
The following functions are used with the registry:  
RegCloseKey  
RegConnectRegistry  
RegCreateKey  
RegCreateKeyEx  
RegDeleteKey  
RegDeleteValue  
RegEnumKey  
RegEnumKeyEx  
RegEnumValue  
RegFlushKey  
RegGetKeySecurity  
RegLoadKey  
RegNotifyChangeKeyValue  
RegOpenKey  
RegOpenKeyEx  
RegQueryInfoKey  
RegQueryMultipleValues  
RegQueryValue  
RegQueryValueEx  
RegReplaceKey  
RegRestoreKey  
RegSaveKey  
RegSetKeySecurity  
RegSetValue  
RegSetValueEx  
RegUnLoadKey  
Obsolete Functions
  
 
GetPrivateProfileInt  
GetPrivateProfileSection  
GetPrivateProfileSectionNames  
GetPrivateProfileString  
GetPrivateProfileStruct  
GetProfileInt  
GetProfileSection  
GetProfileString  
WritePrivateProfileSection  
WritePrivateProfileString  
WritePrivateProfileStruct  
WriteProfileSection  
WriteProfileString
*/
enum enYtvTypeTables
{
   encstYtvDict0=1,
   encstYtvMesDesc=2,
   encstYtvTreeDict0=4,
   encstYtvGlobalDict0=8,
   encenYtvEnumType=16,
   encbtYtvInt=32,
   encYTV_TRIG=64,
   encbtYtvChar=128,
   encpv0Pointer=0x80000000,
   encpv1Pointer=0x40000000,
   encpv0uCode=  0x20000000,
   encpv1uCode=  0x10000000
};
struct stYtvGlobalDict0
{
	UINT uCodeTable;
	enYtvTypeTables uTypeStructTableFlags;
    void* pvTable;
    LPTSTR szText;    
};
struct stYtvTreeDict0
{
	UINT uCode;
	UINT uObjectType;
	LPTSTR szText;    
};
struct stYtvDict0
{
   int code;
   char *value;
};
typedef struct
{
    SHORT sin;
    SHORT cos;
} YTV_TRIG;
/*enum enYtvTypeTables
{
   encstYtvDict0=1,
   encstYtvMesDesc=2,
   encstYtvTreeDict0=4,
   encstYtvGlobalDict0=8,
   encenYtvEnumType=16,
   encbtYtvInt=32,
   encYTV_TRIG=64,
   encbtYtvChar=128,
   encpv0Pointer=0x80000000,
   encpv1Pointer=0x40000000,
   encpv0uCode=  0x20000000,
   encpv1uCode=  0x10000000
};*/
enum enYtvActionProperties
{
   YTV_UNKNOWN_PROPERTY=0,
   YTV_PATH_FROM=1,
   YTV_PATH_TO=2,
   YTV_PORT_FROM,
   YTV_PORT_TO,
   YTV_E_MAIL_TO,
   YTV_E_MAIL_FROM,
   YTV_NETWORK_FROM,
   YTV_NETWORK_TO,
   YTV_REGISTRY_FROM,
   YTV_REGISTRY_TO,
   YTV_ENTER_FROM_KEYBOARD,
   YTV_FROM_CLIPBOARD,
   YTV_OUTPUT_ON_SCREEN,
   YTV_TO_CLIPBOARD,
   YTV_IN_PATH,
   YTV_E_MAIL,
   YTV_CLOSE_PORT,
   YTV_CLOSE_NETWORK_CONNECTION,
   YTV_REGISTRY_CHANGE,
   YTV_TIME_DATE_ALARM,
   YTV_SCREEN_COORDINATES,
   YTV_WINDOW_COORDINATES,
   YTV_CLIENT_AREA_COORDINATES,
   YTV_WINDOW_DEFINED_BY_HANDLE,
   YTV_ASK_TO_POINT_WINDOW,
   YTV_WINDOW_DEFINED_BY_PROPERTIES,
   YTV_WINDOW_DEFINED_BY_MODULE,
   YTV_PROCESS_DEFINED_BY_PATH,
   YTV_PROCESS_DEFINED_BY_WINDOW,
   YTV_ASK_SHOW_WINDOW_OF_PROCESS,
   YTV_FILTER_WINDOWS,
   YTV_FILTER_MESSAGES,
   YTV_FILTER_MODULES,
   YTV_ON_WM_MESSAGE_POSTED,
   YTV_ON_WM_MESSAGE_RECEIVED,
   YTV_ON_WM_MESSAGE_PROCESSED,
   YTV_ON_EXEPTION,
   YTV_ON_MUTEX_SIGNALED,
   YTV_ON_PROCESS_STARTED,
   YTV_ON_PROCESS_ENDED,
   YTV_ON_TIME_SPAN_EXPIRED,
   YTV_ON_NO_RESPONCE,
   YTV_ON_THREAD_STARTED,
   YTV_ON_THREAD_EXIT,
   YTV_ON_FAILED_TEST,
   YTV_ON_WINDOW_CREATE,
   YTV_ON_WINDOW_ACTIVATE,
   YTV_ON_WINDOW_DESTROY,
   YTV_ON_WINDOW_MAX_MIN,
   YTV_ON_WINDOW_MOVE_SIZE,
   YTV_ON_WINDOW_SET_FOCUS,
   YTV_ON_SYSCOMMAND,
   YTV_USER_KEYBOARD_AND_MOUSE_MESSAGES_BEGIN_END,
   YTV_GOT_KEYBOARD_MESSAGE,
   YTV_GOT_CLICK_MESSAGE
};
enum enstYtvTreeTypes
{
   YTVTREE_MESSAGES=1,
   YTVTREE_WINDOWS=2,
   YTVTREE_DIRFILES=4,
   YTVTREE_REGISTRY=8,
   YTVTREE_EVENTSACTIONS=16,
   YTVTREE_RUNNINGMODULES=32,
   YTVTREE_YTVNETWORK=64,
   YTVLIST_FILES=128,
   YTVLIST_REGISTRIES=256,
   YTVLIST_FIX=512,
   YTVTREE_MARKUP=1024,
   YTVLIST_MARKUP=2048,
   YTVTREE_FILTER=4096,
   YTVTREE_IMAGE_FILE_WITH_ATTACHED_RECTANGLES=0x00002000,
   YTVTREE_SCREEN_WITH_ATTACHED_RECTANGLES=0x00004000,
   YTVTREE_WINDOW_WITH_ATTACHED_RECTANGLES=0x00008000
};
enum enYtvObjectsProperties
{
YTV_MENU_NAME=1,
YTV_PARENT_WINDOW=2,
YTV_RECTANGLE=3,
YTV_OBJ_WINDOW=4,
YTV_MODULE=5,
YTV_PROCESS=6,
YTV_THREAD=7,
YTV_ICON=8,
YTV_CURSOR=9,
YTV_SMALL_ICON=10,
YTV_NODE=11,
YTV_TOP_WINDOW=12,
YTV_PARENT_PROCESS=13,
YTV_WINDOW_ID=14,
YTV_NEW_WINDOW=15,
YTV_DIALOG_WINDOW=16,
YTV_FRAME_WINDOW=17,
YTV_POPUP_WINDOW=18,
YTV_CHILD_WINDOW=19,
YTV_CHILD_PROCESSES=20,
YTV_NEW_PROCESSES=21,
YTV_WINDOW_WITH_ICON=22,
YTV_WINDOW_WITHOUT_ICON=23,
YTV_WINDOW_ACTIVATED=24,
YTV_WINDOW_LOST_FOCUS=25,
YTV_PROCESS_TERMINATED=26,
YTV_WINDOW_DESTROYED=27,
YTV_NEW_THREAD=28,
YTV_THREAD_TERMINATED=29
};
enum enYtvMessageTableFlags
{
YTV_MTF_SELECTED=                0x00000001,
TMP_YTV_MTF_TYPE_IME=            0x00000002,
YTV_MTF_TYPE_CBT=                0x00000010,
YTV_MTF_TYPE_USER=               0x00000100,
YTV_MTF_TYPE_UNKNOWN=            0x00000200,
YTV_MTF_TYPE_APP=                0x00000400,
YTV_MTF_TYPE_STRING=             0x00000800,
YTV_MTF_TYPE_MOUSE=              0x00010000,
YTV_MTF_TYPE_DDE=                0x00020000,
YTV_MTF_TYPE_CLIP=               0x00040000,
YTV_MTF_TYPE_NC=                 0x00080000,
YTV_MTF_TYPE_KEYBD=              0x00100000,
YTV_MTF_TYPE_LB=                 0x00200000,
YTV_MTF_TYPE_BM=                 0x00400000,
YTV_MTF_TYPE_STM=                0x00800000,
YTV_MTF_TYPE_CB=                 0x01000000,
YTV_MTF_TYPE_EM=                 0x02000000,
//#ifdef FE_IME
YTV_MTF_TYPE_IME=                0x04000000
//#endif
};
struct stYtvMesDesc
{
    LPTSTR pszMsg;
    UINT msg;
    UINT Flags;
    UINT FilterActions;
};
#define IDSOUND_QUESTION                1102
#define IDSOUND_CORRECT                 1103
#define IDSOUND_INCORRECT               1104
#define IDSOUND_GIVEUP                  1105
#define IDSOUND_GOODBYE                 1106
#define IDSOUND_PIG                     1107
#define IDSOUND_DOG                     1108      
#define IDSOUND_FROG                    1109       
#define IDSOUND_BANGBANG                1110   
#define IDSOUND_BOUNCE                  1111     
#define IDSOUND_CHIMES                  1112     
#define IDSOUND_HUM                     1113      
#define IDSOUND_DING                    1114         
#define IDSOUND_GUNFIRE                 1115    
#define IDSOUND_TRAIN                   1116     
#define IDSOUND_EXLAMATION              1117 
#define IDSOUND_NOTIFY                  1118      
#define IDSOUND_RINGIN                  1119      
#define IDSOUND_RINGOUT                 1120   
#define IDSOUND_ERROR                   1121
__declspec(dllimport) char YtvFilterEventMesAct[];
__declspec(dllimport) char YtvFilterEventMesAct_s[];
__declspec(dllimport) char YtvParentFilter_s[];
__declspec(dllimport) char YtvFilter_d[];
__declspec(dllimport) char YtvActions[];
__declspec(dllimport) char YtvMesGroup[];
__declspec(dllimport) char YtvMes_d[];
__declspec(dllimport) char YtvMesGroupName[];
__declspec(dllimport) char YtvFiltersObjAct[];
__declspec(dllimport) char YtvFilterObjAct_s[];
__declspec(dllimport) char YtvPropGroup[];
__declspec(dllimport) char YtvProp_d[];
__declspec(dllimport) char YtvPropGroupName[];
__declspec(dllimport) char YtvTopFilters[];
__declspec(dllimport) char YtvTopFilter_s[];
__declspec(dllimport) char YtvObjGroup[];
__declspec(dllimport) char YtvObj_d[];
__declspec(dllimport) char YtvObjGroupName[];
__declspec(dllimport) char chYtvSep1;
__declspec(dllimport) struct stYtvDict0 tbYtvTypesOfTables[];
__declspec(dllimport) struct stYtvTreeDict0 tbYtvWM_NOTIFYNotifications[];
__declspec(dllimport) struct stYtvGlobalDict0 tbYtvListAllTables[];
__declspec(dllimport) struct stYtvDict0 tbYtvWindowStyle[];
__declspec(dllimport) struct stYtvDict0 tbYtvWindowClassStyle[];
__declspec(dllimport) struct stYtvDict0 tbYtvWindowClassLong[];
__declspec(dllimport) struct stYtvDict0 tbYtvWindowLong[];
__declspec(dllimport) struct stYtvDict0 tbYtvScript[];
__declspec(dllimport) struct stYtvDict0 tbYtvMesGroups[];
__declspec(dllimport) struct stYtvDict0 tbYtvRegistryTopNodes[];
__declspec(dllimport) struct stYtvDict0 tbYtvRegistryTypes[];
__declspec(dllimport) struct stYtvDict0 tbYtvFoldersFilesTopNodes[];
__declspec(dllimport) struct stYtvDict0 tbYtvDriveTypes[];
__declspec(dllimport) struct stYtvDict0 tbYtvTreeCntrlCommands[];
__declspec(dllimport) int YTV_CLOSE;
__declspec(dllimport) int YTV_MINIMIZE;
__declspec(dllimport) int YTV_DESTROY_WINDOW;
__declspec(dllimport) int YTV_HIDE;
__declspec(dllimport) int YTV_NOTIFY;
__declspec(dllimport) struct stYtvDict0 tbYtvObjectProperties[];
__declspec(dllimport) struct stYtvDict0 tbYtvProcessPriorities[];
__declspec(dllimport) struct stYtvDict0 tbYtvBrushesColors[];
__declspec(dllimport) struct stYtvDict0 tbYtvClassTypes[];
__declspec(dllimport) struct stYtvDict0 tbYtvExtendedWindowStyle[];
__declspec(dllimport) struct stYtvDict0 tbYtvDebugEvents[];
__declspec(dllimport) struct stYtvDict0 tbYtvWinExecRes[];
__declspec(dllimport) struct stYtvMesDesc tbYtvRectanglesTypes[];
__declspec(dllimport) DWORD YtvTypeProperties;
__declspec(dllimport) DWORD YtvTypeWindowStyles;
__declspec(dllimport) DWORD YtvTypeWndClassStyles;
__declspec(dllimport) DWORD YtvTypeWindowExtStyles;
__declspec(dllimport) DWORD YtvTypeMessages;
__declspec(dllimport) DWORD YtvTypeActions;
__declspec(dllimport) DWORD YtvTypeObjects;
__declspec(dllimport) DWORD YtvTypeEventFilter;
__declspec(dllimport) DWORD YtvTypeObjectFilter;
__declspec(dllimport) DWORD YtvTypeBackGroundBrush;
__declspec(dllimport) DWORD YtvTypeTopFilter;
__declspec(dllimport) YTV_TRIG YtvCirTab[];
__declspec(dllimport) struct stYtvDict0 tbYtvSoundFlags[];
__declspec(dllimport) struct stYtvDict0 tbYtvSounds[];
__declspec(dllimport) int nYtvX[];
__declspec(dllimport) int nYtvY[];
extern "C" __declspec(dllimport) char* YtvAddFix(const char* Key, char* Value, char* Field,char sep=0x01);
extern "C" __declspec(dllimport) char* YtvReplaceFix(const char* Key, char* Value, char* Field,char sep=0x01);
extern "C" __declspec(dllimport) char* YtvDeleteFix(const char* Key, char* Field,char sep=0x01);
extern "C" __declspec(dllimport) char* YtvGetFixValue(const char* Key, char* Field,char* Res, char sep=0x01);
extern "C" __declspec(dllimport) int YtvGetFixIntValue(const char* Key, char* Field,char sep=0x01);
extern "C" __declspec(dllimport) char* YtvGetNextDict(int *indnext, struct stYtvDict0 dict[], DWORD* code=NULL);
extern "C" __declspec(dllimport) char* YtvFindDict(int code, struct stYtvDict0 dict[]);
extern "C" __declspec(dllimport) char** YtvFindDictAnd(int code, struct stYtvDict0 dict[]);
extern "C" __declspec(dllimport) int YtvFindDictValue(const char* Key,  struct stYtvDict0 dict[]);
extern "C" __declspec(dllimport) char* YtvGetNextMes(int *indnext, DWORD* Group);
extern "C" __declspec(dllimport) char* YtvFindMes(DWORD code);
extern "C" __declspec(dllimport) char* YtvFindNextMesGroup(int *indnext, DWORD code);
extern "C" __declspec(dllimport) DWORD YtvFindMesValue(const char* Key);
extern "C" __declspec(dllimport) DWORD YtvAddMesActionFilter(DWORD code, DWORD af);
extern "C" __declspec(dllimport) DWORD YtvRemoveMesActionFilter(DWORD code, DWORD af);
extern "C" __declspec(dllimport) DWORD YtvGetMesActionFilter(DWORD code);
extern "C" __declspec(dllimport) DWORD YtvGetMesGroup(DWORD code);
extern "C" __declspec(dllimport) DWORD YtvSetMesGroup(DWORD code, DWORD flags=0, BOOL b=TRUE);
extern "C" __declspec(dllimport) char* YtvGetNextActProp(int *indnext, DWORD* Group);
extern "C" __declspec(dllimport) char* YtvFindActProp(DWORD code);
extern "C" __declspec(dllimport) char* YtvFindNextActPropGroup(int *indnext, DWORD code, DWORD* key=0);
extern "C" __declspec(dllimport) DWORD YtvFindActPropValue(const char* Key);
__declspec(dllimport) struct stYtvDict0 tbYtvMouseHitLocationType[];
enum enstYtvDict0{
YTV_EMPTY=0,
YTV_CLOSE_UN=1,
YTV_MINIMIZE_UN=2,
YTV_COMMAND=3, 
YTV_DESTROY_WINDOW_UN=4, 
YTV_BOOL=5,
YTV_PARAMETERS=6,
YTV_WINDOW=7,
YTV_HIDE_UN=8,
YTV_PROCESSID=9,
YTV_THREADID=10,
YTV_HOOK=11,
YTV_STATE=12,
YTV_ON_CREATE_MINIMIZE=13,
YTV_ON_CREATE_CLOSE=14,
YTV_ON_CREATE_WATCH=15,
YTV_NOTIFY_UN=16,
YTV_SEND_MESSAGE_HOOK=32,//p5
YTV_RECEIVE_MESSAGE_HOOK=64,//p6
YTV_RETURN_MESSAGE_HOOK=128,//p7
YTV_CBT_HOOK=256,//p8
YTV_RECORD_INSTRUCTIONS=512,//p9
YTV_AUTOMATA_OPEN_INSTRUCTIONS=1024,//p10
YTV_EXECUTE_INSTRUCTIONS=2048,//p11
YTV_START_THREAD=4096,//p12
YTV_ON_CREATE=4097,
YTV_TERMINATE_PROCESS=8192,//p13
YTV_PLAY_INSTRUCTIONS=16384,//p14
YTV_BUTTON=16385, 
YTV_COMBOBOX=16386,
YTV_EDIT=16387,
YTV_LISTBOX=16388,//
YTV_MDICLIENT=16389, //
YTV_RichEdit=16390, // 
YTV_RICHEDIT_CLASS=16391,  
YTV_SCROLLBAR=16392,  
YTV_STATIC=16393,
YTV_COPY_DATA=16384+16384,//p15
YTV_DELETE_DATA=16384+16384+16384+16384,//p16
YTV_SET_EVENT=YTV_DELETE_DATA+YTV_DELETE_DATA,//p17
YTV_START_PROCESS=YTV_SET_EVENT+YTV_SET_EVENT,//p18
YTV_DEFINE_SET_LOGIN=YTV_START_PROCESS+YTV_START_PROCESS,//p19
YTV_RECORD_KEYBOARD=YTV_DEFINE_SET_LOGIN+YTV_DEFINE_SET_LOGIN,//20
YTV_PLAY_CLICKS=YTV_RECORD_KEYBOARD+YTV_RECORD_KEYBOARD,//21
YTV_PLAY_KEYBOARD=YTV_PLAY_CLICKS+YTV_PLAY_CLICKS,//22
YTV_RECORD_POINT=YTV_PLAY_KEYBOARD+YTV_PLAY_KEYBOARD,//23
YTV_SET_POINT=YTV_RECORD_POINT+YTV_RECORD_POINT,//24
YTV_RECORD_RECTANGLE=YTV_SET_POINT+YTV_SET_POINT,//25
YTV_SET_RECTANGLE=YTV_RECORD_RECTANGLE+YTV_RECORD_RECTANGLE,//26
YTV_DISPLAY_IMAGE=YTV_SET_RECTANGLE+YTV_SET_RECTANGLE,//27
YTV_RECORD_IMAGE=YTV_DISPLAY_IMAGE+YTV_DISPLAY_IMAGE,//27
YTV_RECORD_SOUND=YTV_RECORD_IMAGE+YTV_RECORD_IMAGE,//28
YTV_TERMINATE_THREAD=YTV_RECORD_SOUND+YTV_RECORD_SOUND,//29
YTV_SET_FILTERS=0x80000000,//32
YTV_END=0xFFFFFFFF
};
extern "C" __declspec(dllimport) DWORD YtvGetProfileSubSectionList(const char* Section,char* lpBufferData, DWORD nSize, int RegLevel=0);
extern "C" __declspec(dllimport) BOOL YtvWriteProfileBinary(const char* Section, const char* Key, const char* Value, int length,int RegLevel=0);
extern "C" __declspec(dllimport) const unsigned char* YtvGetProfileBinary(const char* Section, const char* Key, const char* Value, int* length,int RegLevel=0);
extern "C" __declspec(dllimport) BOOL YtvDeleteProfileSection(const char* Section, int RegLevel=0);
extern "C" __declspec(dllimport) const char* YtvCreateRelativeRegNode(const char* Section, int RegLevel=0);
extern "C" __declspec(dllimport) BOOL YtvDeleteProfileKey(const char* Section, const char* Key, int RegLevel=0);
extern "C" __declspec(dllimport) BOOL YtvWriteProfileSection(const char* Section,char* lpBufferData, int RegLevel=0);
extern "C" __declspec(dllimport) DWORD YtvGetProfileSection(const char* Section,char* lpBufferData,DWORD nSize, int RegLevel=0);
extern "C" __declspec(dllimport) const char* YtvSetAdditionalRegNode(const char* path);
extern "C" __declspec(dllimport) const char* YtvGetAdditionalRegNode();
extern "C" __declspec(dllimport) long YtvWriteProfileReg(LPCTSTR Section, LPCTSTR lpFile, int RegLevel=0);
extern "C" __declspec(dllimport) long YtvGetProfileReg(LPCTSTR Section, LPCTSTR lpFile, int RegLevel=0);
extern "C" __declspec(dllimport) BOOL YtvWriteProfileString(const char* Section, const char* Key, const char* Value, int RegLevel=0);
extern "C" __declspec(dllimport) const unsigned char* YtvGetProfileString(const char* Section, const char* Key, const char* Deafault="", int RegLevel=0);
extern "C" __declspec(dllimport) BOOL YtvWriteProfileInt(const char* Section, const char* Key, int Value, int RegLevel=0);
extern "C" __declspec(dllimport) int YtvGetProfileInt(const char* Section, const char* Key, int Default=0, int RegLevel=0);
extern "C" __declspec(dllimport) HKEY YtvSetRegKey(HKEY hk);
extern "C" __declspec(dllimport) HKEY YtvGetRegKey();
extern "C" __declspec(dllimport) const char* YtvSetPathRegNode(const char* mn);
extern "C" __declspec(dllimport) const char* YtvGetPathRegNode();
extern "C" __declspec(dllimport) const char* YtvSetMainRegNode(const char* mn);
extern "C" __declspec(dllimport) const char* YtvGetMainRegNode();
extern "C" __declspec(dllimport) const char* YtvSetApplRegNode(const char* mn);
extern "C" __declspec(dllimport) const char* YtvGetApplRegNode();
__declspec(dllimport) DWORD YtvSetType;//set type meta filter
__declspec(dllimport) DWORD YtvResumeDebug;       
__declspec(dllimport) DWORD YtvInterruptDebup;     
__declspec(dllimport) DWORD YtvStartDebug;
__declspec(dllimport) DWORD YtvThreadId;
__declspec(dllimport) DWORD YtvlParam;
__declspec(dllimport) DWORD YtvhwndBack;
__declspec(dllimport) DWORD YtvwmBack;
__declspec(dllimport) DWORD YtvProcessId;
__declspec(dllimport) DWORD YtvEndDebug;         
__declspec(dllimport) DWORD YtvWaitDebug;
__declspec(dllimport) DWORD YtvContinueDebug;
__declspec(dllimport) DWORD YtvGetHandleThreadDebug;
__declspec(dllimport) DWORD YtvTerminate;
__declspec(dllimport) DWORD YtvSuspend;
__declspec(dllimport) DWORD YtvFilterDebug;
__declspec(dllimport) DWORD YtvDebugCommand;
__declspec(dllimport) DWORD YtvCancelWaitDebug;
__declspec(dllimport) DWORD YtvGetHandleProcessDebug;//filter
__declspec(dllimport) DWORD YtvGetExitProcessDebug;
__declspec(dllimport) DWORD YtvGetExitThreadDebug;
__declspec(dllimport) DWORD YtvGetThreadIdDebug;
__declspec(dllimport) DWORD YtvGetProcessIdDebug;
__declspec(dllimport) DWORD YtvGetExitThreadIdDebug;
__declspec(dllimport) DWORD YtvGetExitProcessIdDebug;
__declspec(dllimport) DWORD YtvElseContinueDebug;
extern "C" __declspec(dllimport) const char* YtvGetExecNameExt(const char* ProName);
extern "C" __declspec(dllimport) BOOL YtvGetModuleName(HANDLE mhid, DWORD pid, char* szModName=NULL, HANDLE* pmhid=NULL,DWORD* pmid=NULL);
extern "C" __declspec(dllimport) DWORD YtvFindProcessId(const char* ProName=NULL,DWORD* ModuleId=0,DWORD* NumbThread=0,DWORD* ParentProcessID=0);
extern "C" __declspec(dllimport) BOOL YtvFindProcess(DWORD prId, char* Process=0, DWORD* ParPrId=0, DWORD* ModuleId=0, DWORD* NumbThread=0);
extern "C" __declspec(dllimport) char* YtvGetProcessName(DWORD pid=0);    
#define NUM_SOUNDOUTPUTFORMATS       36
__declspec(dllimport) char* tbListSoundOutputFormatNames[NUM_SOUNDOUTPUTFORMATS];
__declspec(dllimport) enum SPSTREAMFORMAT tbListSoundOutputFormat[NUM_SOUNDOUTPUTFORMATS];
__declspec(dllimport) struct stYtvDict0 tbYtvActions[];  
__declspec(dllimport) struct stYtvMesDesc tbYtvActionProperties[];                                        		   
__declspec(dllimport) struct stYtvDict0 tbYtvFileAttributes[];
__declspec(dllimport) struct stYtvDict0 tbYtvNetResScope[];	
__declspec(dllimport) struct stYtvDict0 tbYtvNetResTypes[];
__declspec(dllimport) struct stYtvDict0 tbYtvNetResUsage[];	
__declspec(dllimport) struct stYtvDict0 tbYtvNetResReturnValues[];
__declspec(dllimport) struct stYtvDict0 tbYtvNetDaysOfWeek[];
__declspec(dllimport) struct stYtvDict0 tbYtvNetComDaysOfWeek[];
__declspec(dllimport) struct stYtvDict0 tbYtvNetComMonths[];
__declspec(dllimport) struct stYtvDict0 tbYtvNetWeeksOfMonth[];
__declspec(dllimport) struct stYtvDict0 tbYtvNetJobSchOptions[];
__declspec(dllimport) struct stYtvDict0 tbYtvNetJobSchComOptions[];
__declspec(dllimport) struct stYtvDict0 tbYtvNetMessagesFlags[];
__declspec(dllimport) struct stYtvDict0 tbYtvTreeTypes[];
__declspec(dllimport) struct stYtvDict0 tbYtvTrackerStyles[];
__declspec(dllimport) struct stYtvDict0  tbYtvTrackerHitArea[];
extern "C" __declspec(dllimport) char* YtvCstrcpyW(char* to, const unsigned short* from);
extern "C" __declspec(dllimport) unsigned short* YtvWstrcpyC(unsigned short* to, const char* from);
extern "C" __declspec(dllimport) char* YtvCmemcpyW(char* to, const unsigned short* from, DWORD len);
extern "C" __declspec(dllimport) unsigned short* YtvWmemcpyC(const unsigned short* to, char* from, DWORD len);
extern "C" __declspec(dllimport) WCHAR* Ytvwcscpy(WCHAR* target, const WCHAR* source);
extern "C" __declspec(dllimport) DWORD YtvRegValueMakeStr(DWORD frm,void* InData,
		DWORD lenout=0, char* OutStr=NULL,DWORD lenin=0);//return length
extern "C" __declspec(dllimport) char* YtvGetLastError();
extern "C" __declspec(dllimport) BOOL YtvSetPrivilege(HANDLE hToken,          // access token handle
    LPCTSTR lpszPrivilege,  // name of privilege to enable/disable
    BOOL bEnablePrivilege   // to enable or disable privilege
    ); 
__declspec(dllimport) struct stYtvDict0 tbYtvSystemElementsColors[];
__declspec(dllimport) struct stYtvDict0 tbYtvFileTypes[];
extern "C" __declspec(dllimport) char* YtvGetTypeFileIconPath(char* szFileExtensionSuffix, char* szExtractFrom, char* szTypeOfFile=NULL);
#endif