// YtvAlarm.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "YtvAlarm.h"
#include "MainFrm.h"
#include "ChildFrm.h"
#include "YtvAlarmDoc.h"
#include "YtvClockAlarmView.h"
#include "YtvSetAlarm.h"
#include "YtvClockDial.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
extern DWORD g_uWM_YTV_ADJUST;
/////////////////////////////////////////////////////////////////////////////
// CYtvAlarmApp

BEGIN_MESSAGE_MAP(CYtvAlarmApp, CWinApp)
	//{{AFX_MSG_MAP(CYtvAlarmApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN_IMPORT_APPL_REG, OnUpdateFileOpenImportApplReg)
	ON_COMMAND(ID_FILE_OPEN_IMPORT_APPL_REG, OnFileOpenImportApplReg)
	ON_UPDATE_COMMAND_UI(ID_FILE_CLOSE_EXPORT_APPL_REG, OnUpdateFileCloseExportApplReg)
	ON_COMMAND(ID_FILE_CLOSE_EXPORT_APPL_REG, OnFileCloseExportApplReg)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CYtvAlarmApp construction

CYtvAlarmApp::CYtvAlarmApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CYtvAlarmApp object

CYtvAlarmApp theApp;

// This identifier was generated to be statistically unique for your app.
// You may change it if you prefer to choose a specific identifier.

// {3CCD1A46-DED3-49C1-910D-45C739C7945C}
static const CLSID clsid =
{ 0x3ccd1a46, 0xded3, 0x49c1, { 0x91, 0xd, 0x45, 0xc7, 0x39, 0xc7, 0x94, 0x5c } };

/////////////////////////////////////////////////////////////////////////////
// CYtvAlarmApp initialization

BOOL CYtvAlarmApp::InitInstance()
{
/*	BOOL b=CheckComputerTime();
    BOOL b0=CheckExpirationTime();
	if(!(b&&b0))
		return FALSE;*/
	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	// Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}
    AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(YtvGetMainRegNode());
	YtvSetApplRegNode(AfxGetAppName());
	LoadStdProfileSettings(16);  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;
    pDocTemplate = new CMultiDocTemplate(
		IDR_YTVALATYPE,
		RUNTIME_CLASS(CYtvAlarmDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CYtvClockAlarmView));
	AddDocTemplate(pDocTemplate);
/*		pDocTemplate = new CMultiDocTemplate(
		IDR_YTV_FILES_FOLDERS_LIST,
		RUNTIME_CLASS(CYtvAlarmListDoc),
		RUNTIME_CLASS(CChildFrSplit), // custom MDI child frame
		RUNTIME_CLASS(YtvFileListView));
	AddDocTemplate(pDocTemplate);
    pDocTemplate = new CMultiDocTemplate(
		IDR_YTV_ACTIONS,
		RUNTIME_CLASS(CYtvTreeDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(YtvActionsView));
	AddDocTemplate(pDocTemplate);
	pDocTemplate = new CMultiDocTemplate(
		IDR_YTV_REGISTRY,
		RUNTIME_CLASS(CYtvTreeDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(YtvRegistryView));
	AddDocTemplate(pDocTemplate);
	
	pDocTemplate = new CMultiDocTemplate(
		IDR_YTV_WINDOWS,
		RUNTIME_CLASS(CYtvTreeDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(YtvWindowsView));
	AddDocTemplate(pDocTemplate);
	pDocTemplate = new CMultiDocTemplate(
		IDR_YTV_PROCESES,
		RUNTIME_CLASS(CYtvTreeDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(YtvProcessesView));
	AddDocTemplate(pDocTemplate);
	pDocTemplate = new CMultiDocTemplate(
		IDR_YTV_MESSAGES,
		RUNTIME_CLASS(CYtvTreeDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(YtvMessagesView));
	AddDocTemplate(pDocTemplate);
	pDocTemplate = new CMultiDocTemplate(
		IDR_YTV_FILTERS,
		RUNTIME_CLASS(CYtvTreeDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(YtvFiltersView));
	AddDocTemplate(pDocTemplate);*/
	// Connect the COleTemplateServer to the document template.
	//  The COleTemplateServer creates new documents on behalf
	//  of requesting OLE containers by using information
	//  specified in the document template.
	m_server.ConnectTemplate(clsid, pDocTemplate, FALSE);

	// Register all OLE server factories as running.  This enables the
	//  OLE libraries to create objects from other applications.
	COleTemplateServer::RegisterAll();
		// Note: MDI applications register all server objects without regard
		//  to the /Embedding or /Automation on the command line.

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Check to see if launched as OLE server
	if (cmdInfo.m_bRunEmbedded || cmdInfo.m_bRunAutomated)
	{
		// Application was run with /Embedding or /Automation.  Don't show the
		//  main window in this case.
		return TRUE;
	}

	// When a server application is launched stand-alone, it is a good idea
	//  to update the system registry in case it has been damaged.
	m_server.UpdateRegistry(OAT_DISPATCH_OBJECT);
	COleObjectFactory::UpdateRegistryAll();

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CYtvAlarmApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CYtvAlarmApp message handlers
extern "C" HWND YtvMakeAlarmDialT(BOOL bModeless, HWND hWReceiver,char* szCaption, HWND hParWnd,char* strRegPath,BOOL m_bYtvInheriteClockSettings,BOOL bInheriteWindowPosition,int leftpos,int toppos,int width,int height)
{
	//	AFX_MANAGE_STATE(AfxGetStaticModuleState());
  BOOL b;
  RECT rt;
  HWND retw;
  if(bModeless)
  {
       YtvClockDial* pdlg=new YtvClockDial;
	   //AfxMessageBox("Test0");
       if(!pdlg)
          return FALSE;	
	   if(bInheriteWindowPosition)
       {
	      if(strRegPath)
		   pdlg->m_strPath=strRegPath;
	      else if(szCaption)
           pdlg->m_strPath=szCaption;
	      else
           pdlg->m_strPath.Empty();
	   }
	   pdlg->m_hSheetWnd=hWReceiver;
	   if(m_bYtvInheriteClockSettings)
               pdlg->m_strPath=strRegPath;
	   //YTVMARK
       //CWnd *pmw=AfxGetMainWnd();
       //b=pdlg->Create(pmw->m_hWnd,szCaption);
	   b=pdlg->Create(hParWnd,szCaption);
	   if(!b)
	   {
         delete pdlg;
	     return NULL;
       }
	   pdlg->ShowWindow(SW_SHOW);
       pdlg->UpdateWindow();
	   AfxGetMainWnd()->PostMessage(g_uWM_YTV_ADJUST,(DWORD)pdlg->m_hWnd,-1);
	   if(IsWindow(pdlg->m_hWnd))
	   {//??

       ::GetClientRect(pdlg->m_hWnd,&rt);
	    if(width!=0)
			rt.right=width;
		if(height!=0)
			rt.bottom=height;
		rt.left=leftpos;
		rt.top=toppos;
		if(bInheriteWindowPosition)
	          pdlg->SetWindowPos(NULL,rt.left,rt.top,rt.right-rt.left+1,rt.bottom-rt.top+1,0);
	   }
	   retw=pdlg->m_hWnd;
       return retw;	   
  }
  YtvClockDial dlg(hParWnd,szCaption);
  dlg.m_hSheetWnd=hWReceiver; 
  if(strRegPath)
		   dlg.m_strPath=strRegPath;
  else if(szCaption)
           dlg.m_strPath=szCaption;
  else
           dlg.m_strPath.Empty();
  if(m_bYtvInheriteClockSettings)
               dlg.m_strPath=strRegPath;
  if(dlg.DoModal()==IDCANCEL)
	  return NULL;
  
  return dlg.m_hWnd;
}

void CYtvAlarmApp::OnUpdateFileOpenImportApplReg(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

void CYtvAlarmApp::OnFileOpenImportApplReg() 
{
	// TODO: Add your command handler code here
	CString m_szAllRegDbNodePath=YtvGetApplRegNode(),lpszPathName;
    BOOL b=FALSE;
    lpszPathName.Empty();
	CFileDialog dlg(TRUE);//, LPCTSTR lpszDefExt = NULL, LPCTSTR lpszFileName = NULL, DWORD dwFlags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, LPCTSTR lpszFilter = NULL, CWnd* pParentWnd = NULL );
    if(dlg.DoModal()==IDCANCEL)
		return;
    lpszPathName=dlg.m_ofn.lpstrFile;
	if(!m_szAllRegDbNodePath.IsEmpty())
	{
        m_szAllRegDbNodePath.Empty();
		b=YtvGetProfileReg(m_szAllRegDbNodePath, lpszPathName,0);
        if(!b)
		{
			//b=TRUE;
			//SetTitle(lpszPathName);
			//UpdateAllViews(NULL,IDC_DB_NAME);			
        }
		//else
          //SetTitle("Error: Can not import DB");
    }
	//m_hbm=0;
}

void CYtvAlarmApp::OnUpdateFileCloseExportApplReg(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

void CYtvAlarmApp::OnFileCloseExportApplReg() 
{
	// TODO: Add your command handler code here
	CString m_szAllRegDbNodePath=YtvGetApplRegNode(),lpszPathName;
    BOOL b=FALSE;
    lpszPathName.Empty();
	CFileDialog dlg(FALSE);//, LPCTSTR lpszDefExt = NULL, LPCTSTR lpszFileName = NULL, DWORD dwFlags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, LPCTSTR lpszFilter = NULL, CWnd* pParentWnd = NULL );
    if(dlg.DoModal()==IDCANCEL)
		return;
    lpszPathName=dlg.m_ofn.lpstrFile;
	if(!m_szAllRegDbNodePath.IsEmpty())
	{
        m_szAllRegDbNodePath.Empty();
		b=YtvWriteProfileReg(m_szAllRegDbNodePath, lpszPathName,0);
        if(!b)
		{
			//b=TRUE;
			//SetTitle(lpszPathName);
			//UpdateAllViews(NULL,IDC_DB_NAME);			
        }
		//else
          //SetTitle("Error: Can not import DB");
    }
}
