use strict;
use warnings;

use Test::More tests => 1;

use Algorithm::Easing::Mediator;
use Algorithm::Easing::Linear;

# this example produces traditional 'bounce' output;
my $linear_translation = Algorithm::Easing::Mediator->new(kind => Algorithm::Easing::Linear->new);

# total time for eased translation as a real positive integer value
my $d = 2.5;

# begin
my $b = 0;

# change
my $c = 319;

# time passed in seconds as a real positive integer between each frame
my $frame_time = 0.015625;

my @p = [0,0];

for(my $t = 0; $t < $d; $t += $frame_time) {
    $p[1] = $linear_translation->ease_out($t,$b,$c,$d)

    # do plot
}

ok(int($p[1]) == 317, "linear translation completed with expected resultant value");
