use strict;
use Test::More 0.98 tests => 5;

use lib './lib';

use_ok 'Data::UUID::Base64URLSafe';                                     # 1

my $dub = new_ok('Data::UUID::Base64URLSafe');                          # 2

my $qr = qr/^(:?[\w\-]{22})$/;
my $uuid = '';
my $ns = 'name-space';
my $str = 'test';

 like $uuid = $dub->create_b64url(), $qr,                               # 3
"succeed to create b64-string: $uuid from nothing";

 like $uuid = $dub->create_from_name_b64url( $ns, $str ), $qr,          # 4
"succeed to create b64-string from name: $uuid";

my $str = $dub->from_b64string($uuid);
my $uuid2 = $dub->to_b64string($str);

is $uuid, $uuid2, "succeed to decode b64-string: $uuid2";               # 5

done_testing();
