#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

हिंदी पाठ[संपादित करें]
प्रस्तावना[संपादित करें]
चूंकि मानव परिवार के सभी सदस्यों के जन्मजात गौरव और समान तथा अविच्छिन्न अधिकार की स्वीकृति ही विश्व-शांति, न्याय और स्वतंत्रता की बुनियाद है,

चूंकि मानव अधिकारों के प्रति उपेक्षा और घृणा के फलस्वरूप ही ऐसे बर्बर कार्य हुए जिनसे मनुष्य की आत्मा पर अत्याचार किया गया, चूंकि एक ऐसी विश्व-व्यवस्था की उस स्थापना को (जिसमें लोगों को भाषण और धर्म की आजादी तथा भय और अभव से मुक्ति मिलेगी) सर्वसाधारण के लिए सर्वोच्च आकांक्षा घोषित किया गया है,

चूंकि अगर अन्याययुक्त शासन और जुल्म के विरुद्ध लोगों को विद्रोह करने के लिय - उसे ही अंतिम उपाय समझकर - मजबूर नहीं हो जाना है, तो कनून द्वारा नियम बनाकर मानव अधिकारों की रक्षा करना अनिवार्य है,

चूंकि राष्ट्रों के बीच मैत्रीपूर्ण संबंधों को बढ़ाना जरूरी है,

चूंकि संयुक्त राष्ट्रों के सदस्य देशों की जनताओं ने बुनियादी मानव अधिकारों में, मानव व्यक्तित्व के गौरव और योग्यता में और नर-नारियों के समान अधिकारों में अपने विश्वास को अधिकार-पत्र में दहुराया है और यह निश्चय किया है कि अधिक व्यापक स्वतंत्रता के अंतर्गत सामाजिक प्रगति एवं जीवन के बेहतर स्तर को ऊंचा किया जाएं,

चूंकि सदस्य देशों ने यह प्रतिज्ञा की है कि वे संयुक्त राष्ट्रों के सहयोग से मानव अधिकारों और बुनियादी आजादियों के प्रति सार्वभौम सम्मान की वृद्धि करेंगे,

चूंकि इस प्रतिज्ञा को पूरी तरह से निभाने के लिए इन अधिकारों और आजादियों का स्वरूप ठीक-ठीक समझना सबसे जरूरी है।

इसलिए, अब, समान्य सभा घोषित करती है कि मानव अधिकारों की यह सार्वभौम घोषणा सभी देशों और सभी लोगों की समान सफलता है। इसका उद्देश्य यह है कि प्रत्येक व्यक्ति और समाज का प्रत्येक भाग इस घोषणा को लगातार दृष्टि में रखते हुए अध्यापन और शिक्षा के द्वारा यह प्रयत्न करेगा कि इन अधिकारों और आजादियों के प्रति सम्मान की भावना जाग्रत हो और उत्तरोत्तर ऐसे राष्ट्रीय तथा अंतर्राष्ट्रीय उपाय किए जाएं जिनसे सदस्य देशों की जनता तथा उनके द्वारा अधिकृत प्रदेशों की जनता इन अधिकारों की सार्वभौम और प्रभावोत्पादक स्वीकृति दे और उनका पालन कराएं।

अनुच्छेद 1[संपादित करें]
सभी मनुष्यों को गौरव और अधिकारों के मामले में जन्मजात स्वतंत्रता और समानता प्राप्त है। उन्हें बुद्धि और अंतरात्मा की देन प्राप्त है और परस्पर उन्हें भाईचारे के भाव से बर्ताव करना चाहिए।

अनुच्छेद 2[संपादित करें]
सभी को इस घोषणा में सन्निहित सभी अधिकरों और आजादियों को प्राप्त करने का हक है और इस मामले में जाति, वर्ण, लिंग, भाषा, धर्म, राजनीतिक या अन्य विचार-प्रणाली, किसी देश या समाज विशेष में जन्म, संपत्ति या किसी प्रकार की अन्य मर्यादा आदि के कारण भेदभाव का विचार न किया जाएगा। इसके अतिरिक्त, चाहे कोई देश या प्रदेश स्वतंत्र हो, संरक्षित हो, या स्वशासन रहित हो, या परिमित प्रभुसत्ता वाला हो, उस देश या प्रदेश की राजनैतिक क्षेत्रीय या अंतर्राष्ट्रीय स्थिति के आधार पर वहां के निवासियों के प्रति कोई फ़रक न रखा जाएगा।

अनुच्छेद 3[संपादित करें]
प्रत्येक व्यक्ति को जीवन, स्वाधीनता और वैयक्तिक सुरक्षा का अधिकार है।

अनुच्छेद 4[संपादित करें]
कोई भी गुलामी या दासता की हालत में न रखा जाएगा, गुलामी-प्रथा और गुलामों का व्यापार अपने सभी रूपों में निषिद्ध होगा।

अनुच्छेद 5[संपादित करें]
किसी को भी शारीरिक यातना न दी जाएगी और न किसी के भी प्रति निर्दय, अमानुषिक या अपमानजनक व्यबहार होगा।

अनुच्छेद 6[संपादित करें]
हर किसी को हर जगह कानून की निगाह में व्यक्ति के रूप में स्वीकृति-प्राप्ति का अधिकार है।

अनुच्छेद 7[संपादित करें]
कानून की निगाह में सभी समान हैं और सभी बिना भेदभाव के समान कानूनी सुरक्षा के अधिकारी हैं। यदि इस घोषणा का अतिक्रमण करके कोई भी भेदभाव किया जाए या उस प्रकार के भेदभाव को किसी प्रकार से उकसाया जाए, तो उसके विरुद्ध समान सुरक्षण का अधिकार सभी को प्राप्त है।

अनुच्छेद 8[संपादित करें]
सभी को संविधान या कानून द्वारा प्राप्त बुनियादी अधिकारों का अतिक्रमण करने वाले कार्यों के विरुद्ध समुचित राष्ट्रीय अदालतों की कारगर सहायता पाने का हक है।

अनुच्छेद 9[संपादित करें]
किसी को भी मनमाने ढंग से गिरफ्तार, नजरबंद, या देश-निष्कसित न किया जाएगा।

अनुच्छेद 10[संपादित करें]
सभी को पूर्ण्तः समान रूप से हक है कि उनके अधिकारों और कर्तव्यों के निश्चय करने के मामले में और उन पर आरोपित फौजदारी के किसी मामले में उनकी सुनवाई न्यायोचित और सार्वजनिक रूप से निरपेक्ष एवं निष्पक्ष अदालत द्वारा हो।

अनुच्छेद 11[संपादित करें]
1. प्रत्येक व्यक्ति, जिस पर दंडनीय अपरोध का आरोप किया गया हो, तब तक निरपराध माना जाएगा, जब तक उसे ऐसी खुली अदालत में, जहां उसे अपनी सफाई की सभी आवश्यक सुविधाएं प्राप्त हों, कानून के अनुसार अपराधी न सिद्ध कर दिया जाए।

2. कोई भी व्यक्ति किसी भी ऐसे कृत या अकृत (अपराध) के कारण उस दंडनीय अपराध का अपराधी न माना जाएगा, जिसे तत्कालीन प्रचलित राष्ट्रीय या अंतर्राष्ट्रीय कानून के अनुसार दंडनीय अपराध न माना जाए और न अससे अधिक भारी दंड दिया जा सकेगा, जो उस समय दिया जाता जिस समय वह दंडनीय अपराध किया गया था।

अनुच्छेद 12[संपादित करें]
किसी व्यक्ति की एकांतता, परिवार, घर, या पत्रव्यवहार के प्रति कोई मनमाना हस्तक्षेप न किया जाएगा, न किसी के सम्मान और ख्याति पर कोई आक्षेप हो सकेगा। ऐसे हस्तक्षेप या आक्षेपों के विरुद्ध प्रत्येक को कनूनी रक्षा का अधिकार प्राप्त है।

अनुच्छेद 13[संपादित करें]
1. प्रत्येक व्यक्ति को प्रत्येक देश की सीमाओं के अंदर स्वतंत्रतापूर्वक आने, जाने और बसने का अधिकार है।

2. प्रत्येक व्यक्ति को अपने या पराए किसी भी देश को छोड़ने और अपने देश वापस आने का अधिकार है।

अनुच्छेद 14[संपादित करें]
1. प्रत्येक व्यक्ति को स्ताए जाने पर दूसरे देशों में शरण लेने और रहने का अधिकार है।

2. इस अधिकार का लाभ ऐसे मामलों में नहीं मिलेगा जो वास्तव में गैर-राजनीतिक अपराधों से संबंधित हैं, या जो संयुक्त राष्ट्रों के उद्देश्यों और सिद्धांतों के विरुद्ध कार्य हैं।

अनुच्छेद 15[संपादित करें]
1. प्रत्येक व्यक्ति को किसी भी राष्ट्र-विशेष को नागरिकता का अधिकार है।

2. किसी को भी मनमाने ढंग से अपने राष्ट्र की नागरिकता से वंचित न किया जाएगा या नागरिकता का परिवर्तन करने से मना न किया जाएगा।

अनुच्छेद 16[संपादित करें]
1. बालिग स्त्री-पुरुषों को बिना किसी जाति, राष्ट्रीयता या दर्म की रुकावटों के आपस में विवाह करने और परिवार स्थापन करने का अधिकार है। उन्हें विवाह के विषय में वैवाहिक जीवन में, तथा विवाह विच्छेद के बारे में समान अधिकार है।

2. विवाह का इरादा रखने वाले स्त्री-पुरुषों की पूर्ण और स्वतंत्र सहमति पर ही विवाह हो सकेगा।

3. परिवार समाज का स्वाभाविक और बुनियादी सामूहिक इकाई है और उसे समाज तथा राज्य द्वारा संरक्षण पाने का अधिकार है।

अनुच्छेद 17[संपादित करें]
1. प्रत्येक व्यक्ति को अकेले और दूसरों के साथ मिलकर संपत्ति रखने का अधिकार है। 2. किसी को भी मनमाने ढंग से अपनी संपत्ति से वंचित न किया जाएगा।

अनुच्छेद 18[संपादित करें]
प्रत्येक व्यक्ति को विचार, अंतरात्मा और धर्म की आजादी का अधिकार है। इस अधिकार के अंतर्गत अपना धर्म या विश्वास बदलने और अकेले या दूसरों के साथ मिलकर तथा सार्वजनिक रूप में अथवा निजी तर पर अपने धर्म या विश्वास को शिक्षा, क्रिया, उपसाना, तथा व्यवहार के द्वारा प्रकट करने की स्वतंत्रता है।

अनुच्छेद 19[संपादित करें]
प्रत्येक व्यक्ति को विचार और उसकी अभिव्यक्ति की स्वतंत्रता का अधिकार है। इसके अंतर्गत बिना हस्तक्षेप के कोई राय रखना और किसी भी माध्यम के जरिए से तथा सीमाओं की परवाह न करके किसी की सूचना और धारणा का अन्वेषण, ग्रहण तथा प्रदान सम्मिलित है।

अनुच्छेद 20[संपादित करें]
1. प्रत्येक व्यक्ति को शांति पूर्ण सभा करने या समित्ति बनाने की स्वतंत्रता का अधिकार है।

2. किसी को भी किसी संस्था का सदस्य बनने के लिए मजबूर नहीं किया जा सकता।

अनुच्छेद 21[संपादित करें]
1. प्रत्येक व्यक्ति को अपने देश के शासन में प्रत्यक्ष रूप से या स्वतंत्र रूप से चुने गए प्रतिनिधिओं के जरिए हिस्सा लेन का अधिकार है।

2. प्रत्येक व्यक्ति को अपने देश की सरकारी नौकरियों को प्राप्त करने का समान अधिकार है।

३. सरकार की सत्ता का आधार जनता की इच्छा होगी। इस इच्छा का प्रकटन समय-समय पर और असली चुनावों द्वारा होगा। ये चुनावों सार्वभौम और समान मताधिकार द्वारा होंगे और गुप्त मतदान द्वारा या किसी अन्य समान स्वतंत्र मतदान पद्धति से कराए जाएंगे।

अनुच्छेद 22[संपादित करें]
समाज के एक सदस्य के रूप में प्रत्येक व्यक्ति को सामाजिक सुरक्षा का अधिकार है और प्रत्येक व्यक्ति को अपने व्यक्तित्व के उस स्वतंत्र विकास तथा गौरव के लिए - जो राष्ट्रीय प्रयत्न या अंतर्राष्ट्रीय सहयोग तथा प्रत्येक राज्य के संगठन एवं साधनों के अनुकूल हो - अनिवार्यतः आवश्यक आर्थिक, सामाजिक और सांस्कृतिक अधिकारों की प्राप्ति का हक है।

अनुच्छेद 23[संपादित करें]
1. प्रत्येक व्यक्ति को काम करने, इच्छानुसार रोजगार के चुनाव, काम की उचित और सुविधाजनक परिस्थितियों को प्राप्त करने और बेकारी से संरक्षण पाने का हक है।

2. प्रत्येक व्यक्ति को समान कार्य के लिएअ बिना किसी भेदभव के समान मजदूरी पाने का अधिकार है।

3. प्रत्येक व्यक्ति को जो काम करता है, अधिकार है कि वह इतनी उचित और अनुकूल लजदूरी पाए, जिससे वह अपने लिए और अपने परिवार के लिए ऐसी आजीविका का प्रबंध कर सके, जो मानवीय गौरव के योग्य हो तथा आवश्यकता होने पर उसकी पूर्ति अन्य प्रकार के सामाजिक संरक्षणों द्वारा हो सके।

4. प्रत्येक व्यक्ति को अपने हितों की रक्षा के लिए श्रमजीवी संघ बनाने और उनमें भाग लेने का अधिकार है।

अनुच्छेद 24[संपादित करें]
प्रत्येक ब्यक्ति को विश्राम और अवकाश का अधिकार है। इसके अंतर्गत काम के घंटों की उचित हदबंदी और समय-समय पर मजदूरी सहित छुट्टियां सम्मिलित है।

अनुच्छेद 25[संपादित करें]
1.प्रत्येक व्यक्ति को ऐसे जीवनस्तर को प्राप्त करने का अधिकार है जो उसे और उसके परिवार के स्वास्थ्य एवं कल्याण के लिए पर्याप्त हो। इसके अंतर्गत खाना, कपड़ा, मकान, चिकित्सा-संबंधी सुविधाएं और आवश्यक सामाजिक सेवाएं सम्मिलित है। सभी को बेकारी, बीमारी, असमर्था, वैधव्य, बुढ़ापे या अन्य किसी ऐसी परिस्थिति में आजीविका का साधन न होने पर जो उसके काबू के बाहर हो, सुरक्षा का अधिकार प्राप्त है।

2. जच्चा और बच्चा को खास सहायता और सुविधा का हक है। प्रत्येक बच्चे को चाहे वह विवाहिता माता से जन्मा हो या अविवाहिता से, समान सामाजिक संरक्षण प्राप्त है।

अनुच्छेद 26[संपादित करें]
1. प्रत्येक व्यक्ति को शिक्षा का अधिकार है। शिक्षा कम से कम प्रारंभिक और बुनियादी अवस्थाओं में निःशुल्क होगी। प्रारंभिक शिक्षा अनिवार्य होगी। टेक्निकल, यांत्रिक और पेशों-संबंधी शिक्षा साधारण रूप से प्राप्त होगी और उच्चतर शिक्षा सभी को योग्यता के आधार पर समान रूप से उपलब्ध होगी। 2. शिक्षा का उद्देश्य होगा मानव व्यक्तित्व का पूर्ण विकास और मानव अधिकारों तथा बुनियादी स्वतंत्रताओं के प्रति सम्मान की पुष्टि। शिक्षा द्वारा राष्ट्रों, जातियों, अथवा धार्मिक समूहों के बीच आपसी सद्भावना, सहिष्णुता और मैत्री का विकास होगा और शांति बनाए रखने के लिए संयुक्त राष्ट्रों के प्रयत्नों को आगे बढ़ाया जाएगा। 3. माता-पिता को सबसे पहले इस बात का अधिकार है कि वह चुनाव कर सकें कि किस किस्म की शिक्षा उनके बच्चों को दी जाएगी।

अनुच्छेद 27[संपादित करें]
1. प्रत्येक व्यक्ति को स्वतंत्रता-पूर्वक समाज के सांस्कृतिक जीवन में हिस्सा लेने, कलाओं का आनंद लेने, तथा वैज्ञानिक उन्नति और उसकी सुविशाओं में भाग लेने का हक है।

2. प्रत्येक व्यक्ति को किसी भी ऐसी वैज्ञानिक साहित्यिक या कलात्मक कृति से उत्पन्न नैतिक और आर्थिक हितों की रक्षा का अधिकार है जिसका रचयिता वह स्वयं है।

अनुच्छेद 28[संपादित करें]
प्रत्येक व्यक्ति को ऐसी सामाजिक और अंतर्राष्ट्रीय व्यवस्था की प्राप्ति का अधिकार है जिसमें उस घोष्णा में उल्लिखित अधिकारों और स्वतंत्रताओं का पूर्णतः प्राप्त किया जा सके।

अनुच्छेद 29[संपादित करें]
1. प्रत्येक व्यक्ति का उसी समाज प्रति कर्तव्य है जिसमें रहकर उसके व्यक्तित्व का स्वतंत्र और पूर्ण विकास संभव हो।

2. अपने अधिकारों और स्वतंत्रताओं का उपयोग करते हुए प्रत्येक व्यक्ति केवल ऐसी ही सीमाओं द्वारा बंध होगा, जो कानून द्वारा निश्चित की जाएंगी और जिनका एकमात्र उद्देश्य दूसरों के अधिकारों और स्वतंत्रताओं के लिए आदर और समुचित स्वीकृति की प्राप्ति होगा तथा जिनकी आवश्यकता एक प्रजातंत्रात्मक समाज में नैतिकता, सार्वजनिक व्यवस्था और समान्य कल्याण की उचित आवश्यकताओं को पूरा करना होगा।

3. इन अधिकारों और स्वतंत्रताओं का उपयोग किसी प्रकार से भी संयुक्त राष्ट्रों के सिद्धांतों और उद्देश्यों के विरुद्ध नहीं किया जाएगा।

अनुच्छेद 30[संपादित करें]
इस घोष्णा में उल्लिखित किसी भी बात का यह अर्थ नहीं लगाना चाहिए जिससे य प्रतीत हो कि किसी भी राज्य, समूह या ब्यक्ति को किसी ऐसे प्रयत्न में संलग्न होने या ऐसा कार्य करने का अधिकार है, जिसका उद्देश्य यहां बताए गए अधिकारों और स्वतंत्रताओं में से किसी का भी विनाश करना हो।



TEXT

is(Text::Guess::Language->guess($text),'hi','is hi');

done_testing;
