package HTML::Shakan::Filter::KatakanaZ;
use Any::Moose;
with 'HTML::Shakan::Role::Filter';
use Lingua::JA::Regular::Unicode qw(
    hiragana2katakana
    katakana_h2z
);

sub filter {
    my ($self, $val) = @_;
    hiragana2katakana(katakana_h2z($val));
}

no Any::Moose;
__PACKAGE__->meta->make_immutable;
__END__

=head1 NAME

HTML::Shakan::Filter::Katakana - convert Hiragana to Katakana

=head1 SYNOPSIS

    TextField(name => 'body', filters => [qw/Katakana/])

=head1 DESCRIPTION

This module converts Hiragana chars to Katakana chars.
(for Japanese)

=head1 SEE ALSO

L<Lingua::JA::Regular::Unicode>

