package HTML::Template::Compiled::Plugin::DHTML;
# $Id: DHTML.pm,v 1.2 2006/10/02 16:05:13 tinita Exp $
use strict;
use warnings;
our $VERSION = "0.02";
use Data::TreeDumper;

HTML::Template::Compiled->register(__PACKAGE__);

sub register {
    my ($class) = @_;
    my %plugs = (
        escape => {
            DHTML => \&dumper,
        },
    );
    return \%plugs;
}

sub dumper {
	my ($var) = @_;
	my $style;
	my $body = DumpTree($var, 'Data',
		DISPLAY_ROOT_ADDRESS => 1,
		DISPLAY_PERL_ADDRESS => 1,
		DISPLAY_PERL_SIZE => 1,
		RENDERER => {
			NAME => 'DHTML',
			STYLE => \$style,
			BUTTON => {
				COLLAPSE_EXPAND => 1,
				SEARCH => 1,
			}
		}
	);
	return $style.$body;
}

1;

__END__

=pod

=head1 NAME

HTML::Template::Compiled::Plugin::DHTML - Dumps variables into clickable HTML output

=head1 SYNOPSIS

    use HTML::Template::Compiled::Plugin::DHTML;

    my $htc = HTML::Template::Compiled->new(
        plugin => [qw(HTML::Template::Compiled::Plugin::DHTML)],
        ...
    );

=head1 METHODS

=over 4

=item register

gets called by HTC

=item dumper

Dumps variables into clickable HTML. See L<examples/dhtml.html>.

=back

=cut

