=head1 NAME

memcached_increment, memcached_decrement

=head1 LIBRARY

C Client Library for memcached (libmemcached, -lmemcached)

=head1 SYNOPSIS

  #include <memcached.h>

  memcached_return
    memcached_increment (memcached_st *ptr, 
                         char *key, size_t key_length,
                         unsigned int offset,
                         uint64_t *value);

  memcached_return
    memcached_decrement (memcached_st *ptr, 
                         char *key, size_t key_length,
                         unsigned int offset,
                         uint64_t *value);

=head1 DESCRIPTION

memcached(1) servers have the ability to increment and decrement keys
(overflow and underflow are not detected). This gives you the ability to use
memcached to generate shared sequences of values.  

memcached_increment() takes a key and keylength and increments the value by
the offset passed to it. The value is then returned via the unsigned int
value pointer you pass to it.

memcached_decrement() takes a key and keylength and decrements the value by
the offset passed to it. The value is then returned via the unsigned int
value pointer you pass to it.

=head1 RETURN

A value of type C<memcached_return> is returned.
On success that value will be C<MEMCACHED_SUCCESS>.
Use memcached_strerror() to translate this value to a printable string.

=head1 HOME

To find out more information please check:
L<http://tangent.org/552/libmemcached.html>

=head1 AUTHOR

Brian Aker, E<lt>brian@tangent.orgE<gt>

=head1 SEE ALSO

memcached(1) libmemcached(3) memcached_strerror(3)

=cut

1;
