#!/usr/local/bin/perl -sw
#
# $Id: Makefile.PL,v 1.4 1997/07/16 19:26:20 timbo Exp $
#
# You may distribute under the terms of either the GNU General Public
# License or the Artistic License, as specified in the Perl README file.
#
BEGIN { require 5.004 }	# 5.004 is required for Win32
use Config;
use ExtUtils::MakeMaker 5.16, qw(&WriteMakefile $Verbose);
use DBI 0.86;		# must be installed first
use DBI::DBD;
use strict;

my %opts = 
(
    'NAME'	=> 'DBD::ODBC',
    'VERSION_FROM' => 'ODBC.pm',
    clean	=> { FILES=> 'ODBC.xsi' },
    dist	=> {
		#DIST_DEFAULT=> 'clean distcheck disttest ci tardist',
		DIST_DEFAULT=> 'clean distcheck ci tardist',
		PREOP    => '$(MAKE) -f Makefile.old distdir',
		COMPRESS => 'gzip', SUFFIX => 'gz'
	    },
    'OBJECT'    => qw( $(O_FILES) ),
#   'OPTIMIZE'  => '-g -O0',
);


print "\nConfiguring DBD::ODBC ...\n
>>>\tRemember to actually *READ* the README file!
   \tAnd re-read it if you have any problems.\n
";

open(SQLH, ">mysql.h") || die "Can't open mysql.h: $!\n";
print SQLH "/* Do not edit this file. It is automatically written by Makefile.PL.\n";
print SQLH "   Any changes made here will be lost. \n*/\n\n";
print SQLH "#undef WORD /* from perly.y */\n";

if ($^O eq 'MSWin32') {
    $opts{SKIP} = ['processPL'];
    $opts{DEFINE}  = "";
    $opts{INC}  = "-I\$(INSTALLSITEARCH)/auto/DBI";
    $opts{dynamic_lib} = { OTHERLDFLAGS => " ODBC32.LIB" };
    $opts{macro}->{EXTRALIB} = 'ODBC32.LIB';
    print SQLH "#include <sql.h> \n#include <sqlext.h>\n";
}
else {
    my $odbc= $ENV{ODBCHOME} || die "ODBCHOME env var not set\n";
    $ENV{LD_LIBRARY_PATH} =~ /\Q$odbc/ || die "LD_LIBRARY_PATH doesn't include $odbc\n";
    warn "Using ODBC in $odbc\n";
    $opts{INC}  = "-I. -I\$(INSTALLSITEARCH)/auto/DBI";

    # This is a hack using Intersolve's free Solaris ODBC manager
    # Since it doesn't come with the sql header files (!) we get them from iODBC!

    $opts{LIBS} = " -L$odbc/lib -R$odbc/lib -lodbc -lqeutl08 -lqebas08 -lodbcinst";

my $iodbc = 1;	# hack for now
    if ($iodbc) {
	# Note: we use DEFINE not INC for iODBC so we don't get its config.h
	$opts{DEFINE}  = "-I/home/timbo/perl/mod/DBD/iODBC/i212";	# hack for now
	print SQLH qq{#define FAR \n#define EXPORT \n#define CALLBACK \n};
	print SQLH qq{#include <isql.h>\n};
	print SQLH qq{#include <isqlext.h>\n};
    }
    else {
	$opts{DEFINE}  = "";
	print SQLH qq{#include <sql.h> \n#include <sqlext.h>\n};
    }
}
print SQLH "\n";
close(SQLH);

WriteMakefile(%opts);

local($^W)=0;
print qq{
The DBD::ODBC tests will use these values for the database connection:
    DBI_DSN=$ENV{DBI_DSN}		e.g. dbi:ODBC:demo
    DBI_USER=$ENV{DBI_USER}
    DBI_PASS=$ENV{DBI_PASS}
};
print "Warning: not all required environment variables are set.\n"
	unless ($ENV{DBI_DSN} && $ENV{DBI_USER} && $ENV{DBI_PASS});
print "Warning: DBI_DSN ($ENV{DBI_DSN}) doesn't start with 'dbi:ODBC:'\n"
	if ($ENV{DBI_DSN} && $ENV{DBI_DSN} !~ m/^dbi:ODBC:/);


sub MY::postamble {
    return dbd_postamble();
}

__END__


