/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.tilecodec;

import com.sun.media.jai.tilecodec.TileCodecUtils;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.OutputStream;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.tilecodec.JaiI18N;
import javax.media.jai.tilecodec.TileCodecDescriptor;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileEncoder;

public abstract class TileEncoderImpl
implements TileEncoder {
    protected String formatName;
    protected OutputStream outputStream;
    protected TileCodecParameterList paramList;

    public TileEncoderImpl(String string, OutputStream outputStream, TileCodecParameterList tileCodecParameterList) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("TileCodecDescriptorImpl0"));
        }
        if (outputStream == null) {
            throw new IllegalArgumentException(JaiI18N.getString("TileEncoderImpl0"));
        }
        TileCodecDescriptor tileCodecDescriptor = TileCodecUtils.getTileCodecDescriptor("tileEncoder", string);
        if (tileCodecParameterList == null) {
            tileCodecParameterList = tileCodecDescriptor.getDefaultParameters("tileEncoder");
        }
        if (tileCodecParameterList != null) {
            if (!tileCodecParameterList.getFormatName().equalsIgnoreCase(string)) {
                throw new IllegalArgumentException(JaiI18N.getString("TileEncoderImpl1"));
            }
            if (!tileCodecParameterList.isValidForMode("tileEncoder")) {
                throw new IllegalArgumentException(JaiI18N.getString("TileEncoderImpl2"));
            }
            if (!tileCodecParameterList.getParameterListDescriptor().equals(tileCodecDescriptor.getParameterListDescriptor("tileEncoder"))) {
                throw new IllegalArgumentException(JaiI18N.getString("TileCodec0"));
            }
        } else {
            ParameterListDescriptor parameterListDescriptor = tileCodecDescriptor.getParameterListDescriptor("tileEncoder");
            if (parameterListDescriptor != null && parameterListDescriptor.getNumParameters() != 0) {
                throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl6"));
            }
        }
        this.formatName = string;
        this.outputStream = outputStream;
        this.paramList = tileCodecParameterList;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public TileCodecParameterList getEncodeParameterList() {
        return this.paramList;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public abstract void encode(Raster var1) throws IOException;
}

