
Note that, in some fonts, the digits ??? are easily misidentified and
some implementations of higher bases exchange other, non-alphabetic
characters for them.  In that case, the names of those systems
are often called something else, e.g., Base62ner(???).

#### Array of digits for bases up to 62

    @Number::More::dec2digit = <
       0 1 2 3 4 5 6 7 8 9
       A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
       a b c d e f g h i j k l m n o p q r s t u v w x y z
       >;

#### Hash of reversed mapping of the array above

    %Number::More::digit2dec = [
       0 =>  0, 1 =>  1, 2 =>  2, 3 =>  3, 4 =>  4, 5 =>  5, 6 =>  6, 7 =>  7, 8 =>  8, 9 =>  9,
       A => 10, B => 11, C => 12, D => 13, E => 14, F => 15, G => 16, H => 17, I => 18, J => 19,
       K => 20, L => 21, M => 22, N => 23, O => 24, P => 25, Q => 26, R => 27, S => 28, T => 29,
       U => 30, V => 31, W => 32, X => 33, Y => 34, Z => 35, a => 36, b => 37, c => 38, d => 39,
       e => 40, f => 41, g => 42, h => 43, i => 44, j => 45, k => 46, l => 47, m => 48, n => 49,
       o => 50, p => 51, q => 52, r => 53, s => 54, t => 55, u => 56, v => 57, w => 58, x => 59,
       y => 60, z => 61
    ];

#### Names for some common base numbers [Ref 6.]

| Base | Number System | Base | Number System | Base | Number System |
| :---  | :--- | :--- | :--- | :--- | :--- |
| 2  | Binary          | 13 | Tridecimal     | 32 | Duotrigesimal       |
| 3  | Ternary         | 14 | Tetradecimal   | 33 | Trtritrigesimal     |
| 4  | Quaternary      | 15 | Pentadecimal   | 36 | Hexatrigesimal      |
| 5  | Quinary         | 16 | Hexadecimal    | 52 | Duoquinquagesimal   |
| 6  | Senary          | 20 | Vigesimal      | 56 | Hexaquinquagesimal  |
| 7  | Heptary         | 23 | Trivigesimal   | 57 | Heptaquinquagesimal |
| 8  | Octal           | 24 | Tetravigesimal | 58 | Octoquinquagesimal  |
| 9  | Nonary [Ref 3.] | 26 | Hexavigesimal  | 60 | Sexagesimal         |
| 10 | Decimal         | 27 | Heptavigesimal | 61 | Unsexagesimal       |
| 11 | Undecimal       | 30 | Trigesimal     | 62 | Duosexagesimal      |
| 12 | Duodecimal      |    |                |    |                     |

## References

0. [Standard positional number systems](https://en.wikipedia.org/wiki/List_of_numeral_systems#Standard_positional_numeral_systems)

1. [Positional number systems](https://en.wikipedia.org/wiki/Numeral_system#Positional_systems_in_detail)

2. [Positional base conversion](https://en.wikipedia.org/wiki/Positional_notation#Base_conversion)

3. [Base](http://mathworld.wolfram.com/Base.html)

4. [Table of bases 2..36 for decimal values 0..256](https://en.wikipedia.org/wiki/Table_of_bases)

5. [Radix](https://en.wikipedia.org/wiki/Radix)

6. [List of numeral systems](https://en.wikipedia.org/wiki/List_of_numeral_systems)

7. [Simple conversion algorithms](http://mathforum.org/library/drmath/view/57074.html)
