use strict;
use Test::More tests => 35;

use_ok('Number::Phone::JP', 'q2');

my $tel  = Number::Phone::JP->new;
my $line = 17;

for (1..$line) {
	my $num = <DATA>;
	chomp $num;
	ok($tel->set_number($num)->is_valid_number);
}

while (<DATA>) {
	chomp;
	ok(! $tel->set_number($_)->is_valid_number);
}

__DATA__
0990 2031234
0990 3001234
0990 3401234
0990 3801234
0990 3821234
0990 5001234
0990 5491234
0990 5801234
0990 6001234
0990 6401234
0990 6801234
0990 6801234
0990 7001234
0990 7031234
0990 7071234
0990 7401234
0990 7401234
0990 0001234
0990 1001234
0990 2001234
0990 3011234
0990 3411234
0990 3501234
0990 3811234
0990 3831234
0990 5501234
0990 5901234
0990 6501234
0990 6601234
0990 6701234
0990 6901234
0990 7011234
0990 7081234
0990 7411234
