use Test::More tests => 14;

BEGIN {
	use_ok( 'IPC::Semaphore::Set' );
	use_ok( 'IPC::Semaphore::Set::Resource' );
};

my $semset = IPC::Semaphore::Set->new(
	key_name  => 'IPC::Semaphore::Set Tests',
	resources => 3,
	available => 2,
);
isa_ok($semset, 'IPC::Semaphore::Set');
my @resources = $semset->resources;
is(scalar(@resources), 3, 'Got [3] resources');
foreach my $resource (@resources) {
	isa_ok($resource, 'IPC::Semaphore::Set::Resource');
	is($resource->available, 2, 'Resource had [2] available');
}
my $resource0 = $semset->resource;
is($resource0->number, 0, 'Got the default first [0] resource');
my $resource1 = $semset->resource(2);
is($resource1->number, 2, 'Got a proper resource by number');
my $resource2 = $semset->resource;
is($resource2->number, 2, 'Got the expected stored resource');
is($semset->remove, 1, 'Successfully removed semaphore');

__END__

