package Google::Ads::AdWords::v201708::ListOperations;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201708' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %clear_of :ATTR(:get<clear>);
my %operators_of :ATTR(:get<operators>);

__PACKAGE__->_factory(
    [ qw(        clear
        operators

    ) ],
    {
        'clear' => \%clear_of,
        'operators' => \%operators_of,
    },
    {
        'clear' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'operators' => 'Google::Ads::AdWords::v201708::ListOperations::ListOperator',
    },
    {

        'clear' => 'clear',
        'operators' => 'operators',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201708::ListOperations

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ListOperations from the namespace https://adwords.google.com/api/adwords/cm/v201708.

Describes the behavior of elements in a list. Instances of ListOperations will always be defined alongside some list in an API POJO. The number of operators in the ListOperations must be equal to the number of elements in the POJO list. Each operator, together with its corresponding list element, describe an intended change. <p>For example, if in a request Campaign.selectiveOptimization contains 2 conversionTypeIds, and the conversionTypeIdsOps is non-null, it must contain 2 operators. If those operators are {PUT, REMOVE} then the API will add the first conversionTypeId (if it doesn't already exist) and remove the second conversionTypeId (if it exists). 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * clear


=item * operators




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

