use strict;
use warnings;
use Test::More tests => 243;

BEGIN
{
    use_ok 'Regexp::Network', qw/cleanether $mac_RE/;
}

while (<DATA>)
{
    my $mac = $_;
    chomp $mac;
    my $clean = cleanether($mac);
    ok $clean =~ /^$mac_RE$/ => "$mac parses and cleans";
}

__DATA__
0:40:5:5e:e6:e9
00:00:b4:85:d8:ca
00:60:67:02:07:c5
0:e0:b8:3d:34:6d
0:0:e8:7b:6:8
0 3 93 76 f3 60
00:10:dc:ae:52:52
00:06:5b:d5:e3:de
0:40:f4:1d:16:11
00:10:c6:06:20:a5
0:80:24:58:b6:42
00:50:bf:4e:36:f8
0-20-e0-70-18-c6
00:40:05:5e:e6:e9
0:60:67:77:21:db
0:0:b4:38:52:4b
0:0:c0:95:73:74
0:0:39:dd:29:8f
00:02:44:0a:c9:ad
00:a0:cc:75:b7:56
0:0:21:0:60:2b
0:3:93:40:d4:14
0:30:65:43:4f:ba
0:60:67:7:40:b6
0:0:21:db:b7:37
00:00:21:f6:6f:95
00:02:44:24:54:8f
00:00:21:2f:0b:0e
0:10:c6:6:20:a5
0:2:44:39:e2:69
00:00:94:a4:44:3d
0 0 e8 f0 a7 67
0-0-21-cb-a2-89
00:10:a4:0f:42:35
00:80:c7:f7:ed:e1
00:10:a4:ad:29:5b
0:30:65:cf:2:60
0:50:ba:87:9b:30
00:20:18:a1:2d:0b
0:0:21:24:22:ba
0:20:e0:63:8c:53
0:40:5:5e:e6:ea
0:a0:cc:d5:8f:9e
00:00:e8:89:be:f9
0:60:67:2:7:c5
8:0:46:2f:12:d
00:02:44:18:80:a7
00:02:44:3a:2d:40
0:d0:59:f:cc:3
0:40:95:2d:9:2a
00:50:bf:da:83:33
00:02:44:18:80:a9
00-e0-b8-3d-34-6d
00:40:f4:1d:16:11
00:00:39:dc:28:da
00:00:21:25:42:cc
0:e0:29:7:98:8f
0 e0 0 57 1e 37
00:20:e0:70:18:c6
00:60:67:77:21:db
0:80:c7:e3:4a:6f
0:0:b4:85:d8:ca
0:50:56:5c:c2:ab
08:00:46:2f:12:0d
0:50:8b:fa:22:e
0:2:44:1b:7b:d9
0:6:5b:d5:e3:de
0:40:f4:37:19:ff
0:20:18:a2:19:83
0:0:21:0:60:b7
00:00:21:27:7c:34
0:e0:7d:ac:3d:6c
0-20-18-a2-32-d1
0:2:a5:1:67:af
0:5:5d:5:36:5d
0:10:a4:f3:17:1f
0:20:18:a2:14:d8
0:48:54:d2:22:1d
00:50:ba:87:9b:30
0:80:c8:e5:99:9e
00:60:67:07:41:fc
0:a0:cc:76:8e:3b
00:20:e0:63:8c:53
00 02 44 18 83 34
0:0:21:f6:6f:95
0:2:44:24:54:8f
0:0:21:ce:48:d2
00:a0:0c:40:cd:72
00:a0:cc:d5:8f:9e
0:c0:26:2e:13:64
00:00:21:fb:fa:52
0:0:94:a4:44:3d
00-00-21-00-60-2b
00:00:21:fb:fa:56
00:02:44:16:5a:1d
0:2:44:d:88:52
0:e0:18:18:4d:14
00:90:f5:0c:20:08
00:02:44:13:00:93
0:e0:4c:39:7:53
0:10:60:cb:8:fa
0:0:e8:56:4e:18
0:0:e8:89:be:f9
0:2:44:18:80:a7
0:2:44:18:80:a8
0:2:44:3a:2d:40
00:80:c7:e3:4a:6f
0:2:44:18:80:a9
00:40:95:2d:09:2a
00 50 8b fa 22 0e
0:50:bf:18:41:1c
00:20:18:a2:19:83
00-40-f4-37-19-ff
0:0:39:dc:28:da
0:0:21:f:14:d2
0:0:21:25:42:cc
00:e0:7d:ac:3d:6c
00:20:18:a2:32:d1
00:04:76:4d:35:fc
0:0:c0:54:51:98
0:80:c7:67:81:29
00:00:21:2a:b8:46
00:02:44:12:87:34
0:50:bf:5a:e8:d5
00:10:a4:f3:17:1f
00:48:54:d2:22:1d
00:00:21:fc:ff:1e
0:60:8:16:18:29
00:02:a5:99:ab:54
0:0:21:27:7c:34
00:60:67:06:04:09
00:00:21:dc:18:74
0-48-54-8e-36-1d
0:e0:8f:2a:28:20
0:60:67:79:64:74
0 a0 c 42 ca 2c
00:c0:26:2e:13:64
0:60:67:7:41:fc
0:5:2:78:79:5f
0:20:18:b8:75:fb
0:10:60:73:d2:c7
00:30:65:cf:02:60
00:00:21:f3:5e:59
0:90:f5:c:20:8
52:54:05:f4:c0:3d
00:00:21:00:60:b7
00:00:21:d8:eb:bf
0:c0:df:ea:6a:f6
00:e0:18:18:4d:14
0:2:44:18:83:34
00:02:44:0d:88:52
00:00:21:f6:6f:4e
00-60-67-07-69-6e
00:e0:4c:39:07:53
0:0:21:fb:fa:52
0:10:7a:60:d9:a5
0:20:ed:a6:84:63
0:2:44:16:5a:1d
0:10:4b:1f:60:1f
0:40:5:59:1c:6b
0:0:21:fb:fa:56
00 50 bf 18 41 1c
0:80:ad:7a:e3:c8
0:20:18:8e:85:13
0:50:8b:ab:e:15
0:0:e2:4:14:1b
0:e0:98:99:26:d3
0:2:44:a:c9:a8
00:00:21:f3:5e:61
00:0a:27:a9:04:f2
00:50:bf:5a:e8:d5
0:40:f4:37:23:13
0-0-21-7-22-e
0:0:e2:4:14:fb
0:48:54:81:8b:30
0:5:2:ac:b7:3a
00:00:e8:7b:06:08
00:03:93:76:f3:60
0:4:76:4d:35:fc
00:48:54:8e:36:1d
00:60:67:79:64:74
0:0:21:2a:b8:46
0:60:97:8e:29:9c
0:40:5:69:a5:5c
0:c0:4f:ca:1a:ba
00:d0:59:0f:cc:03
0:a:27:a9:4:f2
00 20 18 b8 75 fb
0:0:21:2f:b:e
00:10:60:73:d2:c7
00:00:21:0f:14:d2
0:2:44:13:0:93
0-0-21-fc-ff-1e
00:00:b4:38:52:4b
0:c0:f0:30:12:27
00:e0:29:07:98:8f
0:a0:24:2f:3e:74
0:2:44:a:c9:b5
00:00:39:dd:29:8f
0:2:a5:99:ab:54
0:0:21:dc:18:74
00:03:93:40:d4:14
0:10:dc:ae:52:52
00:10:7a:60:d9:a5
00:60:08:16:18:29
00:20:ed:a6:84:63
0:30:65:df:8b:c8
00:10:4b:1f:60:1f
0:50:bf:4e:36:f8
0:0:21:f3:5e:59
52:54:0:e9:7e:f4
00:80:ad:7a:e3:c8
00-20-18-8e-85-13
00 02 44 39 e2 69
0:2:44:a:c9:ad
0:0:21:d8:eb:bf
0:60:67:7:69:6e
00:00:e8:f0:a7:67
00:e0:98:99:26:d3
00:00:21:cb:a2:89
0:a0:cc:75:b7:56
0:0:21:f6:6f:4e
00:05:02:ac:b7:3a
00:02:44:0a:c9:a8
00:40:f4:37:23:13
0:60:67:6:4:9
0:5:2:b6:72:0
00:50:8b:ab:0e:15
0:2:96:3:67:e8
0:0:e8:37:4e:83
0:80:c7:f7:ed:e1
0:80:c7:a6:32:10
0-10-a4-ad-29-5b
0:0:21:f3:5e:61
00:60:97:8e:29:9c
0:90:27:58:6b:f8
00:10:60:cb:08:fa
0:20:18:43:3e:c3
0:2:44:13:e3:b
00 c0 f0 30 12 27
0:2:44:14:ff:d9
0-50-bf-da-83-33
