# ************************************************************************* 
# Copyright (c) 2014, SUSE LLC
# 
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
# 
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
# 
# 3. Neither the name of SUSE LLC nor the names of its contributors may be
# used to endorse or promote products derived from this software without
# specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
# ************************************************************************* 
#
# Token map
#
package App::Dochazka::CLI::TokenMap;

use 5.012;
use strict;
use warnings;

use Exporter qw( import );




=head1 NAME

App::Dochazka::CLI::TokenMap - Token map




=head1 VERSION

Version 0.150

=cut

our $VERSION = '0.150';

our @EXPORT_OK = qw( $regex_map );



=head1 PACKAGE VARIABLES

=over

=item C<< $regex_map >>

Maps tokens to regular expression "strings". These strings are just the
"business end" - the final regular expression is generated from each string in
L<App::Dochazka::CLI::Parser>. 

Whatever information you need to get out of the token needs to be in
parentheses. If the token is just a reserved word from which no information
need be extracted, just put the entire thing in parentheses. 

Note that the regex comparison that takes place in
L<App::Dochazka::CLI::Parser> uses the 'i' modifier for a case-insensitive
comparison.

=back

=cut

our $regex_map = { 
#    ACTIVE    => '(active)',
    ACTIVITY  => '(activi\S*)',
#    ADMIN     => '(adm\S*)',
    AID       => '(aid\S*)',
    ALL       => '(all\S*)',
    BUGREPORT => '(bug\S*)',
    CLEAR     => '(cle\S*)',
    CODE      => '(cod\S*)',
    COOKIEJAR => '(coo\S*)',
    CORE      => '(cor\S*)',
    COUNT     => '(cou\S*)',
    CURRENT   => '(cur\S*)',
    DBSTATUS  => '(dbs\S*)',
    DELETE    => '(del\S*)',
    DISABLED  => '(dis\S*)',
    DUMP      => '(dum\S*)',
    DOCU      => '(doc\S*)',
    ECHO      => '(ech\S*)',
    EFFECTIVE => '(eff\S*)',
    EID       => '(eid\S*)',
    EMPLOYEE  => '(emp[^\s=]*)',
    EMPLOYEE_SPEC => '^((emp|sec|nic|eid)[^\s=]*=[%[:alnum:]_][%[:alnum:]_-]*)',
    EXIT      => '(((exi)|(qui)|(\\\\q))\S*)',
    FETCH     => '(fet\S*)',
    FORBIDDEN => '(for\S*)',
#    FRIDAY     => '(fri\S*)',   RESERVED BY _DOW
    FULLNAME  => '(ful\S*)',
    GET       => '(get\S*)',
    HISTORY   => '(his\S*)',
    HTML      => '(htm\S*)',
    IID       => '(iid\S*)',
#    INACTIVE  => '(ina\S*)',
    INTERVAL  => '(int\S*)',
    LID       => '(lid\S*)',
    LOCK      => '(loc\S*)',
    MEMORY    => '(mem\S*)',
    META      => '(met\S*)',
#    MONDAY     => '(mon\S*)',   RESERVED BY _DOW
    NEW       => '(new\S*)',
    NICK      => '(nic\S*)',
    NOOP      => '(noo\S*)',
    PARAM     => '(par\S*)',
#    PASSERBY  => '(pas\S*)',
    PHID      => '(phi\S*)',
    PHISTORY_SPEC => '^phi[^\s=]*=(\d+)',
    POD       => '(pod\S*)',
    POST      => '(pos\S*)',
    PRIV      => '(pri\S*)',
    PRIV_SPEC  => '((active)|(adm\S*)|(ina\S*)|(pas\S*))',
    PROFILE   => '(pro\S*)',
    PUT       => '(put\S*)',
    REMARK    => '(rem\S*)',
#    SATURDAY    => '(sat\S*)',  RESERVED BY _DOW
    SCHEDULE  => '(sch\S*)',
    SCHEDULE_SPEC => '^((sco|sid)[^\s=]*=[%[:alnum:]_][%[:alnum:]_-]*)',
    SCODE     => '(sco\S*)',
    SEARCH    => '(sea\S*)',
    SEC_ID    => '(sec\S*)',
    SELF      => '(sel\S*)',
    SESSION   => '(ses\S*)',
    SET       => '(set\S*)',
    SHID      => '(shi\S*)',
    SHISTORY_SPEC => '^shi[^\s=]*=(\d+)',
    SHOW      => '(sho\S*)',
    SID       => '(sid\S*)',
    SITE      => '(sit\S*)',
#    SUNDAY    => '(sun\S*)',  RESERVED BY _DOW
    SUMMARY   => '(sum\S*)',
    TEXT      => '(tex\S*)',
#    THURSDAY    => '(thu\S*)',  RESERVED BY _DOW
#    TUESDAY    => '(tue\S*)',  RESERVED BY _DOW
    VERSION   => '(ver\S*)',
#    WEDNESDAY    => '(wed\S*)',  RESERVED BY _DOW
    WHOAMI    => '(who\S*)',
    _DOCU     => '(([^\{\s]+)|(\"[^\"]*\"))',
    _DOW      => '((mon\S*)|(tue\S*)|(wed\S*)|(thu\S*)|(fri\S*)|(sat\S*)|(sun\S*))',
    _HYPHEN   => '(-)',
    _JSON     => '(\{[^\{]*\})',
    _NUM      => '([123456789][0123456789]*)',
    _TERM     => '([%[:alnum:]_][%[:alnum:]_-]*)',
    _TIME     => '(\d{1,2}:\d{1,2})',
    _TIMERANGE => '(\d{1,2}:\d{1,2}-\d{1,2}:\d{1,2})',
    _TIMESTAMP => '(\"?(\d{2,4}-)?\d{1,2}-\d{1,2}(\s+\d{1,2}:\d{1,2}(:\d{1,2})?)?\"?)',
    _TSRANGE  => '([\[\(][^\[\(\]\)]*,[^\[\(]*[\]\)])',
};

1;
