## This file generated by InlineX::C2XS (version 0.22) using Inline::C (version 0.55)
package Win32::GenRandom;
use strict;
use warnings;
use Config;

require Exporter;
*import = \&Exporter::import;
require DynaLoader;

$Win32::GenRandom::VERSION = '0.02';

DynaLoader::bootstrap Win32::GenRandom $Win32::GenRandom::VERSION;

@Win32::GenRandom::EXPORT = ();
@Win32::GenRandom::EXPORT_OK = qw(
    cgr rgr cgr_uv rgr_uv
    );

%Win32::GenRandom::EXPORT_TAGS = (all => [qw(
    cgr rgr cgr_uv rgr_uv
    )]);

sub cgr_uv {
  my @cgr = cgr($_[0], $Config::Config{ivsize});
  my @ret = map {scalar(reverse(unpack "J", $_))} @cgr;
  return @ret;
}

sub rgr_uv {
  my @rgr = rgr($_[0], $Config::Config{ivsize});
  my @ret = map {scalar(reverse(unpack "J", $_))} @rgr;
  return @ret;
}

sub _system_error {
   warn "$^E";
}

sub dl_load_flags {0} # Prevent DynaLoader from complaining and croaking

1;

__END__

=head1 NAME

   Win32::GenRandom - XS wrappers of CryptGenRandom and RtlGenRandom.

=head1 FUNCTIONS

   @c = cgr($how_many, $size);

    Returns an array of $how_many strings - each string consisting of
    $size random bytes.
    This function uses CryptGenRandom to generate the random strings.

   @c = rgr($how_many, $size);

    Returns an array of $how_many strings - each string consisting of
    $size random bytes.
    This function uses RtlGenRandom to generate the random strings.
    (Not available on Windows 2000 and earlier - croaks if used on
    such a system.)

   @c = cgr_uv($how_many);

    Returns an array of $how_many Perl internal unsigned integer
    values (UV).
    This function uses CryptGenRandom to generate the random UVs.

   @c = rgr_uv($how_many);

    Returns an array of $how_many Perl internal unsigned integer
    values (UV).
    This function uses RtlGenRandom to generate the random UVs.
    (Not available on Windows 2000 and earlier - croaks if used on
    such a system.)

=head1 COPYRIGHT

    Copyright Sisyphus 2014.
