# !/usr/bin/perl -w
use strict;

open INTERP, "> interp_guts.h" or die "Can't open interp_guts.h, $!/$^E";

open OPCODES, "opcode_table" or die "Can't open opcode_table, $!/$^E";

print INTERP <<CONST;
/*
 *
 * interp_guts.h
 *
 * this file is autogenerated by build_interp_starter.pl
 *
 * Best not edit it
 */

#define BUILD_TABLE(x) do { \\
CONST

my $count = 1;
while (<OPCODES>) {
    chomp;
    s/#.*$//;
    s/^\s+//;
    next unless $_;
    my($name) = split /\s+/;
    my $num = $count;
    $num = 0 if $name eq 'end';
    print INTERP "\tx[$num] = $name; \\\n";
    $count++ unless $name eq 'end';
}
print INTERP "} while (0);\n";
