package Spike::Site::Request;

use strict;
use warnings;

use feature 'switch';

use base qw(Plack::Request Spike::Object);

use Spike::Site::Response;
use List::Util qw(min);

sub new_response { shift; Spike::Site::Response->new(@_) }

sub _named_url_values {
    my $self = shift;

    @{$self->env->{'spike.request.named_url_values'} ||= [
        grep { defined && length } split /\/+/, $self->path_info
    ]};
}

sub _bind_named_url_names {
    my $self = shift;

    my @names = @_;
    my @values = $self->_named_url_values;

    my $bind = $self->env->{'spike.request.named_url_parameters'} = [];

    while (@names && @values) {
        my $name = shift @names;
        my $value = shift @values;

        next if $name !~ s!^#!!;

        push @$bind, $name, $value;
    }

    delete $self->env->{'spike.request.named_url'};
    delete $self->env->{'spike.request.merged'};
}

sub _named_url_parameters {
    my $self = shift;
    $self->env->{'spike.request.named_url_parameters'} ||= [];
}

sub named_url_parameters {
    my $self = shift;
    $self->env->{'spike.request.named_url'} ||= Hash::MultiValue->new(@{$self->_named_url_parameters});
}

sub parameters {
    my $self = shift;

    $self->env->{'spike.request.merged'} ||= Hash::MultiValue->new(
        $self->SUPER::parameters->flatten,
        @{$self->_named_url_parameters},
    );
}

sub safe_path {
    my $self = shift;

    if (!defined $self->env->{'spike.request.safe_path'}) {
        my @parts;

        for my $part ($self->_named_url_values) {
            $part =~ s!\0!!g;

            given ($part) {
                when ('.') {}
                when ('..') {
                    pop @parts;
                }
                default {
                    push @parts, $part;
                }
            }
        }

        $self->env->{'spike.request.safe_path'} = join '/', @parts;
    }
}

1;
