
use strict;
use warnings;

use 5.010001;

use ExtUtils::MakeMaker 6.30;

use File::ShareDir::Install;
install_share dist => "share";


my %WriteMakefileArgs = (
  "ABSTRACT" => "Rinci/Riap-based command-line application framework",
  "AUTHOR" => "Steven Haryanto <stevenharyanto\@gmail.com>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30",
    "File::ShareDir::Install" => "0.03"
  },
  "DISTNAME" => "Perinci-CmdLine",
  "EXE_FILES" => [
    "bin/peri-run",
    "bin/peri-func-usage",
    "bin/strip-result-env-yaml",
    "bin/strip-result-env-json"
  ],
  "LICENSE" => "perl",
  "NAME" => "Perinci::CmdLine",
  "PREREQ_PM" => {
    "Data::Dump::OneLine" => 0,
    "Data::Format::Pretty::Console" => 0,
    "Data::Unixish" => "1.39",
    "File::HomeDir" => 0,
    "File::Which" => 0,
    "JSON" => 0,
    "Lingua::FR::Nums2Words" => 0,
    "Locale::TextDomain::UTF8" => 0,
    "Log::Any" => 0,
    "Log::Any::App" => 0,
    "Monkey::Patch::Action" => 0,
    "Moo" => 0,
    "Perinci::Access" => "0.30",
    "Perinci::Access::HTTP::Client" => "0.06",
    "Perinci::Access::Perl" => "0.53",
    "Perinci::Access::Schemeless" => "0.53",
    "Perinci::Access::Simple::Client" => 0,
    "Perinci::Object" => "0.11",
    "Perinci::Result::Format" => "0.33",
    "Perinci::Sub::Complete" => 0,
    "Perinci::Sub::ConvertArgs::Argv" => 0,
    "Perinci::Sub::GetArgs::Argv" => "0.28",
    "Perinci::Sub::Util" => "0.36",
    "Perinci::Sub::Wrapper" => "0.40",
    "Perinci::ToUtil" => 0,
    "Progress::Any" => "0.10",
    "Progress::Any::Output" => 0,
    "Progress::Any::Output::TermProgressBarColor" => "0.04",
    "Rinci" => "v1.1.41",
    "SHARYANTO::Getopt::Long::Util" => 0,
    "SHARYANTO::Role::ColorTheme" => "0.62",
    "String::ShellQuote" => 0,
    "Text::ANSITable" => "0.23",
    "Tie::Simple" => 0,
    "UUID::Random" => 0,
    "YAML::Syck" => 0,
    "experimental" => 0
  },
  "TEST_REQUIRES" => {
    "Capture::Tiny" => 0,
    "File::Slurp" => 0,
    "File::Spec" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Test::More" => "0.96"
  },
  "VERSION" => "0.98",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Capture::Tiny" => 0,
  "Data::Dump::OneLine" => 0,
  "Data::Format::Pretty::Console" => 0,
  "Data::Unixish" => "1.39",
  "File::HomeDir" => 0,
  "File::Slurp" => 0,
  "File::Spec" => 0,
  "File::Which" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "JSON" => 0,
  "Lingua::FR::Nums2Words" => 0,
  "Locale::TextDomain::UTF8" => 0,
  "Log::Any" => 0,
  "Log::Any::App" => 0,
  "Monkey::Patch::Action" => 0,
  "Moo" => 0,
  "Perinci::Access" => "0.30",
  "Perinci::Access::HTTP::Client" => "0.06",
  "Perinci::Access::Perl" => "0.53",
  "Perinci::Access::Schemeless" => "0.53",
  "Perinci::Access::Simple::Client" => 0,
  "Perinci::Object" => "0.11",
  "Perinci::Result::Format" => "0.33",
  "Perinci::Sub::Complete" => 0,
  "Perinci::Sub::ConvertArgs::Argv" => 0,
  "Perinci::Sub::GetArgs::Argv" => "0.28",
  "Perinci::Sub::Util" => "0.36",
  "Perinci::Sub::Wrapper" => "0.40",
  "Perinci::ToUtil" => 0,
  "Progress::Any" => "0.10",
  "Progress::Any::Output" => 0,
  "Progress::Any::Output::TermProgressBarColor" => "0.04",
  "Rinci" => "v1.1.41",
  "SHARYANTO::Getopt::Long::Util" => 0,
  "SHARYANTO::Role::ColorTheme" => "0.62",
  "String::ShellQuote" => 0,
  "Test::More" => "0.96",
  "Text::ANSITable" => "0.23",
  "Tie::Simple" => 0,
  "UUID::Random" => 0,
  "YAML::Syck" => 0,
  "experimental" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

{
package
MY;
use File::ShareDir::Install qw(postamble);
}


