package Data::Unixish::lc;

use 5.010;
use strict;
use syntax 'each_on_array'; # to support perl < 5.12
use warnings;
#use Log::Any '$log';

our $VERSION = '1.26'; # VERSION

our %SPEC;

$SPEC{lc} = {
    v => 1.1,
    summary => 'Convert text to lowercase',
    description => <<'_',

_
    args => {
        in  => {schema=>'any'},
        out => {schema=>'any'},
    },
    tags => [qw/text/],
};
sub lc {
    my %args = @_;
    my ($in, $out) = ($args{in}, $args{out});

    while (my ($index, $item) = each @$in) {
        if (defined($item) && !ref($item)) {
            $item = CORE::lc($item);
        }
        push @$out, $item;
    }

    [200, "OK"];
}

1;
# ABSTRACT: Convert text to lowercase



__END__
=pod

=head1 NAME

Data::Unixish::lc - Convert text to lowercase

=head1 VERSION

version 1.26

=head1 SYNOPSIS

In Perl:

 use Data::Unixish::lc;
 my $in  = ["STEVEN"];
 my $out = [];
 Data::Unixish::lc::lc(in=>$in, out=>$out);
 # $out = ["steven"]

In command line:

 % echo -e "STEVEN" | dux lc
 steven

=head1 AUTHOR

Steven Haryanto <stevenharyanto@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by Steven Haryanto.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 DESCRIPTION


This module has L<Rinci> metadata.

=head1 FUNCTIONS


None are exported by default, but they are exportable.

=head2 lc(%args) -> [status, msg, result, meta]

Convert text to lowercase.

Arguments ('*' denotes required arguments):

=over 4

=item * B<in> => I<any>

=item * B<out> => I<any>

=back

Return value:

Returns an enveloped result (an array). First element (status) is an integer containing HTTP status code (200 means OK, 4xx caller error, 5xx function error). Second element (msg) is a string containing error message, or 'OK' if status is 200. Third element (result) is optional, the actual result. Fourth element (meta) is called result metadata and is optional, a hash that contains extra information.

=cut

