use File::Temp qw/ tempdir /;
use Test::More tests => 7;
use utf8;
use strict;
use warnings;

my $dir = tempdir(CLEANUP => 1);
#my $dir = "/tmp";

#
# Test 1: load the module
#
BEGIN {
    use_ok('Graphics::Fig')
};

#
# Test 2: ellipse given a, b
#
eval {
    my $fig = Graphics::Fig->new({ position => [ 3, 2 ] });
    $fig->ellipse(5, 3);
    $fig->save("${dir}/ellipse2.fig");
    system("diff -qb t/ellipse2.fig ${dir}/ellipse2.fig") == 0 || die;
};
ok($@ eq "", "test2");

#
# Test 3: ellipse given a, b, rotation
#
eval {
    my $fig = Graphics::Fig->new({ position => [ 3, 2 ] });
    $fig->ellipse(1, 5, 60);
    $fig->save("${dir}/ellipse3.fig");
    system("diff -qb t/ellipse3.fig ${dir}/ellipse3.fig") == 0 || die;
};
ok($@ eq "", "test3");

#
# Test 4: ellipse given center, two points (rotation from 1st point)
#
eval {
    my $fig = Graphics::Fig->new({ position => [ 3, 2 ] });
    $fig->ellipse({ center => [ 2, 3 ], points => [[ 4, 1 ], [ 1, 5 ]],
                    subtype => "diameters" });
    $fig->save("${dir}/ellipse4.fig");
    system("diff -qb t/ellipse4.fig ${dir}/ellipse4.fig") == 0 || die;
};
ok($@ eq "", "test4");

#
# Test 5: ellipse given center and three points
#
#eval {
    my $fig = Graphics::Fig->new({ position => [ 3, 2 ] });
    $fig->ellipse({ position => [ 4, 4 ],
                    points => [[ 1, 3 ], [ 0, 5 ], [ 3, 2 ]] });
    $fig->save("${dir}/ellipse5.fig");
    system("diff -qb t/ellipse5.fig ${dir}/ellipse5.fig") == 0 || die;
#};
ok($@ eq "", "test5");

#
# Test 6: ellipse given five points
#
eval {
    my $fig = Graphics::Fig->new({ position => [ 3, 2 ] });
    $fig->ellipse([[ -1, -1 ], [ 3, 0 ], [ 0, 2 ], [ 5, 3 ], [ 2, 3 ]]);
    $fig->save("${dir}/ellipse6.fig");
    system("diff -qb t/ellipse6.fig ${dir}/ellipse6.fig") == 0 || die;
};
ok($@ eq "", "test6");

#
# Test 7: scale, rotate and getbbox
#
eval {
    my $fig = Graphics::Fig->new({ position    => [ 4.5, 5.5 ],
    				   orientation => "portrait" });
    $fig->ellipse(2, 1);
    $fig->scale([ -3, 2 ]);
    $fig->rotate(-60);
    my $bb = $fig->getbbox();
    $fig->box($bb);
    $fig->save("${dir}/ellipse7.fig");
    system("diff -qb t/ellipse7.fig ${dir}/ellipse7.fig") == 0 || die;
};
ok($@ eq "", "test7");

exit(0);
