use strict;
use warnings;
package BenchmarkAnything::Storage::Frontend::HTTP;
# git description: 2bbb08c

BEGIN {
  $BenchmarkAnything::Storage::Frontend::HTTP::AUTHORITY = 'cpan:SCHWIGON';
}
# ABSTRACT: Access a BenchmarkAnything store via HTTP
$BenchmarkAnything::Storage::Frontend::HTTP::VERSION = '0.001';
use Mojo::Base 'Mojolicious';

require BenchmarkAnything::Storage::Frontend::Lib;
require File::HomeDir; # MUST 'require', 'use' conflicts with Mojolicious
require Tapper::Benchmark;
require File::Slurp;
require YAML::Any;
require DBI;

my $balib            = BenchmarkAnything::Storage::Frontend::Lib->new->connect;
my $tapper_benchmark = Tapper::Benchmark->new ({ dbh => $balib->{dbh}, debug => 0 });

# This method will run once at server start
sub startup {
        my $self = shift;

        $self->plugin('InstallablePaths');

        # helper
        $self->helper (tapper_benchmark => sub { $tapper_benchmark } );

        # routes
        my $routes = $self->routes;
        $routes
            ->any('/api/v1/search/:value_id' => [value_id => qr/\d+/])
            ->to('search#search', value_id => 0);
        $routes
            ->any('/api/v1/listnames/:pattern' => [pattern => qr/[^\/]+/])
            ->to('search#listnames', pattern => '');
        $routes
            ->any('/api/v1/hello')
            ->to('search#hello');
}

1;

__END__

=pod

=encoding utf-8

=head1 NAME

BenchmarkAnything::Storage::Frontend::HTTP - Access a BenchmarkAnything store via HTTP

=head1 AUTHOR

Steffen Schwigon <ss5@renormalist.net>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Steffen Schwigon.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
