package Date::Manip::TZ::amsan_01;
# Copyright (c) 2008-2009 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 20 14:19:45 EST 2009
#    Data version: tzdata2009s
#    Code version: tzcode2009r

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::amsan_01 - Support for the America/Argentina/San_Luis time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

use vars qw(%Dates %LastRule);

use vars qw($VERSION);
$VERSION="6.02";

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,1,19,34,36],'-04:25:24',[-4,-25,-24],
          'LMT',0,[1894,10,31,4,25,23],[1894,10,30,23,59,59] ],
     ],
   1894 =>
     [
        [ [1894,10,31,4,25,24],[1894,10,31,0,8,36],'-04:16:48',[-4,-16,-48],
          'CMT',0,[1920,5,1,4,16,47],[1920,4,30,23,59,59] ],
     ],
   1920 =>
     [
        [ [1920,5,1,4,16,48],[1920,5,1,0,16,48],'-04:00:00',[-4,0,0],
          'ART',0,[1930,12,1,3,59,59],[1930,11,30,23,59,59] ],
     ],
   1930 =>
     [
        [ [1930,12,1,4,0,0],[1930,12,1,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1931,4,1,2,59,59],[1931,3,31,23,59,59] ],
     ],
   1931 =>
     [
        [ [1931,4,1,3,0,0],[1931,3,31,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1931,10,15,3,59,59],[1931,10,14,23,59,59] ],
        [ [1931,10,15,4,0,0],[1931,10,15,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1932,3,1,2,59,59],[1932,2,29,23,59,59] ],
     ],
   1932 =>
     [
        [ [1932,3,1,3,0,0],[1932,2,29,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1932,11,1,3,59,59],[1932,10,31,23,59,59] ],
        [ [1932,11,1,4,0,0],[1932,11,1,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1933,3,1,2,59,59],[1933,2,28,23,59,59] ],
     ],
   1933 =>
     [
        [ [1933,3,1,3,0,0],[1933,2,28,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1933,11,1,3,59,59],[1933,10,31,23,59,59] ],
        [ [1933,11,1,4,0,0],[1933,11,1,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1934,3,1,2,59,59],[1934,2,28,23,59,59] ],
     ],
   1934 =>
     [
        [ [1934,3,1,3,0,0],[1934,2,28,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1934,11,1,3,59,59],[1934,10,31,23,59,59] ],
        [ [1934,11,1,4,0,0],[1934,11,1,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1935,3,1,2,59,59],[1935,2,28,23,59,59] ],
     ],
   1935 =>
     [
        [ [1935,3,1,3,0,0],[1935,2,28,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1935,11,1,3,59,59],[1935,10,31,23,59,59] ],
        [ [1935,11,1,4,0,0],[1935,11,1,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1936,3,1,2,59,59],[1936,2,29,23,59,59] ],
     ],
   1936 =>
     [
        [ [1936,3,1,3,0,0],[1936,2,29,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1936,11,1,3,59,59],[1936,10,31,23,59,59] ],
        [ [1936,11,1,4,0,0],[1936,11,1,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1937,3,1,2,59,59],[1937,2,28,23,59,59] ],
     ],
   1937 =>
     [
        [ [1937,3,1,3,0,0],[1937,2,28,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1937,11,1,3,59,59],[1937,10,31,23,59,59] ],
        [ [1937,11,1,4,0,0],[1937,11,1,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1938,3,1,2,59,59],[1938,2,28,23,59,59] ],
     ],
   1938 =>
     [
        [ [1938,3,1,3,0,0],[1938,2,28,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1938,11,1,3,59,59],[1938,10,31,23,59,59] ],
        [ [1938,11,1,4,0,0],[1938,11,1,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1939,3,1,2,59,59],[1939,2,28,23,59,59] ],
     ],
   1939 =>
     [
        [ [1939,3,1,3,0,0],[1939,2,28,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1939,11,1,3,59,59],[1939,10,31,23,59,59] ],
        [ [1939,11,1,4,0,0],[1939,11,1,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1940,3,1,2,59,59],[1940,2,29,23,59,59] ],
     ],
   1940 =>
     [
        [ [1940,3,1,3,0,0],[1940,2,29,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1940,7,1,3,59,59],[1940,6,30,23,59,59] ],
        [ [1940,7,1,4,0,0],[1940,7,1,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1941,6,15,2,59,59],[1941,6,14,23,59,59] ],
     ],
   1941 =>
     [
        [ [1941,6,15,3,0,0],[1941,6,14,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1941,10,15,3,59,59],[1941,10,14,23,59,59] ],
        [ [1941,10,15,4,0,0],[1941,10,15,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1943,8,1,2,59,59],[1943,7,31,23,59,59] ],
     ],
   1943 =>
     [
        [ [1943,8,1,3,0,0],[1943,7,31,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1943,10,15,3,59,59],[1943,10,14,23,59,59] ],
        [ [1943,10,15,4,0,0],[1943,10,15,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1946,3,1,2,59,59],[1946,2,28,23,59,59] ],
     ],
   1946 =>
     [
        [ [1946,3,1,3,0,0],[1946,2,28,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1946,10,1,3,59,59],[1946,9,30,23,59,59] ],
        [ [1946,10,1,4,0,0],[1946,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1963,10,1,2,59,59],[1963,9,30,23,59,59] ],
     ],
   1963 =>
     [
        [ [1963,10,1,3,0,0],[1963,9,30,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1963,12,15,3,59,59],[1963,12,14,23,59,59] ],
        [ [1963,12,15,4,0,0],[1963,12,15,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1964,3,1,2,59,59],[1964,2,29,23,59,59] ],
     ],
   1964 =>
     [
        [ [1964,3,1,3,0,0],[1964,2,29,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1964,10,15,3,59,59],[1964,10,14,23,59,59] ],
        [ [1964,10,15,4,0,0],[1964,10,15,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1965,3,1,2,59,59],[1965,2,28,23,59,59] ],
     ],
   1965 =>
     [
        [ [1965,3,1,3,0,0],[1965,2,28,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1965,10,15,3,59,59],[1965,10,14,23,59,59] ],
        [ [1965,10,15,4,0,0],[1965,10,15,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1966,3,1,2,59,59],[1966,2,28,23,59,59] ],
     ],
   1966 =>
     [
        [ [1966,3,1,3,0,0],[1966,2,28,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1966,10,15,3,59,59],[1966,10,14,23,59,59] ],
        [ [1966,10,15,4,0,0],[1966,10,15,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1967,4,2,2,59,59],[1967,4,1,23,59,59] ],
     ],
   1967 =>
     [
        [ [1967,4,2,3,0,0],[1967,4,1,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1967,10,1,3,59,59],[1967,9,30,23,59,59] ],
        [ [1967,10,1,4,0,0],[1967,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1968,4,7,2,59,59],[1968,4,6,23,59,59] ],
     ],
   1968 =>
     [
        [ [1968,4,7,3,0,0],[1968,4,6,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1968,10,6,3,59,59],[1968,10,5,23,59,59] ],
        [ [1968,10,6,4,0,0],[1968,10,6,1,0,0],'-03:00:00',[-3,0,0],
          'ARST',1,[1969,4,6,2,59,59],[1969,4,5,23,59,59] ],
     ],
   1969 =>
     [
        [ [1969,4,6,3,0,0],[1969,4,5,23,0,0],'-04:00:00',[-4,0,0],
          'ART',0,[1969,10,5,3,59,59],[1969,10,4,23,59,59] ],
        [ [1969,10,5,4,0,0],[1969,10,5,1,0,0],'-03:00:00',[-3,0,0],
          'ART',0,[1974,1,23,2,59,59],[1974,1,22,23,59,59] ],
     ],
   1974 =>
     [
        [ [1974,1,23,3,0,0],[1974,1,23,1,0,0],'-02:00:00',[-2,0,0],
          'ARST',1,[1974,5,1,1,59,59],[1974,4,30,23,59,59] ],
        [ [1974,5,1,2,0,0],[1974,4,30,23,0,0],'-03:00:00',[-3,0,0],
          'ART',0,[1988,12,1,2,59,59],[1988,11,30,23,59,59] ],
     ],
   1988 =>
     [
        [ [1988,12,1,3,0,0],[1988,12,1,1,0,0],'-02:00:00',[-2,0,0],
          'ARST',1,[1989,3,5,1,59,59],[1989,3,4,23,59,59] ],
     ],
   1989 =>
     [
        [ [1989,3,5,2,0,0],[1989,3,4,23,0,0],'-03:00:00',[-3,0,0],
          'ART',0,[1989,10,15,2,59,59],[1989,10,14,23,59,59] ],
        [ [1989,10,15,3,0,0],[1989,10,15,1,0,0],'-02:00:00',[-2,0,0],
          'ARST',1,[1990,3,14,1,59,59],[1990,3,13,23,59,59] ],
     ],
   1990 =>
     [
        [ [1990,3,14,2,0,0],[1990,3,13,22,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[1990,10,15,3,59,59],[1990,10,14,23,59,59] ],
        [ [1990,10,15,4,0,0],[1990,10,15,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[1991,3,1,2,59,59],[1991,2,28,23,59,59] ],
     ],
   1991 =>
     [
        [ [1991,3,1,3,0,0],[1991,2,28,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[1991,6,1,3,59,59],[1991,5,31,23,59,59] ],
        [ [1991,6,1,4,0,0],[1991,6,1,1,0,0],'-03:00:00',[-3,0,0],
          'ART',0,[1999,10,3,2,59,59],[1999,10,2,23,59,59] ],
     ],
   1999 =>
     [
        [ [1999,10,3,3,0,0],[1999,10,3,0,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2000,3,3,2,59,59],[2000,3,2,23,59,59] ],
     ],
   2000 =>
     [
        [ [2000,3,3,3,0,0],[2000,3,3,0,0,0],'-03:00:00',[-3,0,0],
          'ART',0,[2004,5,31,2,59,59],[2004,5,30,23,59,59] ],
     ],
   2004 =>
     [
        [ [2004,5,31,3,0,0],[2004,5,30,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2004,7,25,3,59,59],[2004,7,24,23,59,59] ],
        [ [2004,7,25,4,0,0],[2004,7,25,1,0,0],'-03:00:00',[-3,0,0],
          'ART',0,[2007,12,30,2,59,59],[2007,12,29,23,59,59] ],
     ],
   2007 =>
     [
        [ [2007,12,30,3,0,0],[2007,12,30,1,0,0],'-02:00:00',[-2,0,0],
          'ARST',1,[2008,1,21,1,59,59],[2008,1,20,23,59,59] ],
     ],
   2008 =>
     [
        [ [2008,1,21,2,0,0],[2008,1,20,23,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2008,3,9,2,59,59],[2008,3,8,23,59,59] ],
        [ [2008,3,9,3,0,0],[2008,3,8,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2008,10,12,3,59,59],[2008,10,11,23,59,59] ],
        [ [2008,10,12,4,0,0],[2008,10,12,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2009,3,8,2,59,59],[2009,3,7,23,59,59] ],
     ],
   2009 =>
     [
        [ [2009,3,8,3,0,0],[2009,3,7,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2009,10,11,3,59,59],[2009,10,10,23,59,59] ],
        [ [2009,10,11,4,0,0],[2009,10,11,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2010,3,14,2,59,59],[2010,3,13,23,59,59] ],
     ],
   2010 =>
     [
        [ [2010,3,14,3,0,0],[2010,3,13,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2010,10,10,3,59,59],[2010,10,9,23,59,59] ],
        [ [2010,10,10,4,0,0],[2010,10,10,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2011,3,13,2,59,59],[2011,3,12,23,59,59] ],
     ],
   2011 =>
     [
        [ [2011,3,13,3,0,0],[2011,3,12,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2011,10,9,3,59,59],[2011,10,8,23,59,59] ],
        [ [2011,10,9,4,0,0],[2011,10,9,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2012,3,11,2,59,59],[2012,3,10,23,59,59] ],
     ],
   2012 =>
     [
        [ [2012,3,11,3,0,0],[2012,3,10,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2012,10,14,3,59,59],[2012,10,13,23,59,59] ],
        [ [2012,10,14,4,0,0],[2012,10,14,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2013,3,10,2,59,59],[2013,3,9,23,59,59] ],
     ],
   2013 =>
     [
        [ [2013,3,10,3,0,0],[2013,3,9,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2013,10,13,3,59,59],[2013,10,12,23,59,59] ],
        [ [2013,10,13,4,0,0],[2013,10,13,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2014,3,9,2,59,59],[2014,3,8,23,59,59] ],
     ],
   2014 =>
     [
        [ [2014,3,9,3,0,0],[2014,3,8,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2014,10,12,3,59,59],[2014,10,11,23,59,59] ],
        [ [2014,10,12,4,0,0],[2014,10,12,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2015,3,8,2,59,59],[2015,3,7,23,59,59] ],
     ],
   2015 =>
     [
        [ [2015,3,8,3,0,0],[2015,3,7,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2015,10,11,3,59,59],[2015,10,10,23,59,59] ],
        [ [2015,10,11,4,0,0],[2015,10,11,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2016,3,13,2,59,59],[2016,3,12,23,59,59] ],
     ],
   2016 =>
     [
        [ [2016,3,13,3,0,0],[2016,3,12,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2016,10,9,3,59,59],[2016,10,8,23,59,59] ],
        [ [2016,10,9,4,0,0],[2016,10,9,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2017,3,12,2,59,59],[2017,3,11,23,59,59] ],
     ],
   2017 =>
     [
        [ [2017,3,12,3,0,0],[2017,3,11,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2017,10,8,3,59,59],[2017,10,7,23,59,59] ],
        [ [2017,10,8,4,0,0],[2017,10,8,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2018,3,11,2,59,59],[2018,3,10,23,59,59] ],
     ],
   2018 =>
     [
        [ [2018,3,11,3,0,0],[2018,3,10,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2018,10,14,3,59,59],[2018,10,13,23,59,59] ],
        [ [2018,10,14,4,0,0],[2018,10,14,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2019,3,10,2,59,59],[2019,3,9,23,59,59] ],
     ],
   2019 =>
     [
        [ [2019,3,10,3,0,0],[2019,3,9,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2019,10,13,3,59,59],[2019,10,12,23,59,59] ],
        [ [2019,10,13,4,0,0],[2019,10,13,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2020,3,8,2,59,59],[2020,3,7,23,59,59] ],
     ],
   2020 =>
     [
        [ [2020,3,8,3,0,0],[2020,3,7,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2020,10,11,3,59,59],[2020,10,10,23,59,59] ],
        [ [2020,10,11,4,0,0],[2020,10,11,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2021,3,14,2,59,59],[2021,3,13,23,59,59] ],
     ],
   2021 =>
     [
        [ [2021,3,14,3,0,0],[2021,3,13,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2021,10,10,3,59,59],[2021,10,9,23,59,59] ],
        [ [2021,10,10,4,0,0],[2021,10,10,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2022,3,13,2,59,59],[2022,3,12,23,59,59] ],
     ],
   2022 =>
     [
        [ [2022,3,13,3,0,0],[2022,3,12,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2022,10,9,3,59,59],[2022,10,8,23,59,59] ],
        [ [2022,10,9,4,0,0],[2022,10,9,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2023,3,12,2,59,59],[2023,3,11,23,59,59] ],
     ],
   2023 =>
     [
        [ [2023,3,12,3,0,0],[2023,3,11,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2023,10,8,3,59,59],[2023,10,7,23,59,59] ],
        [ [2023,10,8,4,0,0],[2023,10,8,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2024,3,10,2,59,59],[2024,3,9,23,59,59] ],
     ],
   2024 =>
     [
        [ [2024,3,10,3,0,0],[2024,3,9,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2024,10,13,3,59,59],[2024,10,12,23,59,59] ],
        [ [2024,10,13,4,0,0],[2024,10,13,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2025,3,9,2,59,59],[2025,3,8,23,59,59] ],
     ],
   2025 =>
     [
        [ [2025,3,9,3,0,0],[2025,3,8,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2025,10,12,3,59,59],[2025,10,11,23,59,59] ],
        [ [2025,10,12,4,0,0],[2025,10,12,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2026,3,8,2,59,59],[2026,3,7,23,59,59] ],
     ],
   2026 =>
     [
        [ [2026,3,8,3,0,0],[2026,3,7,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2026,10,11,3,59,59],[2026,10,10,23,59,59] ],
        [ [2026,10,11,4,0,0],[2026,10,11,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2027,3,14,2,59,59],[2027,3,13,23,59,59] ],
     ],
   2027 =>
     [
        [ [2027,3,14,3,0,0],[2027,3,13,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2027,10,10,3,59,59],[2027,10,9,23,59,59] ],
        [ [2027,10,10,4,0,0],[2027,10,10,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2028,3,12,2,59,59],[2028,3,11,23,59,59] ],
     ],
   2028 =>
     [
        [ [2028,3,12,3,0,0],[2028,3,11,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2028,10,8,3,59,59],[2028,10,7,23,59,59] ],
        [ [2028,10,8,4,0,0],[2028,10,8,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2029,3,11,2,59,59],[2029,3,10,23,59,59] ],
     ],
   2029 =>
     [
        [ [2029,3,11,3,0,0],[2029,3,10,23,0,0],'-04:00:00',[-4,0,0],
          'WART',0,[2029,10,14,3,59,59],[2029,10,13,23,59,59] ],
        [ [2029,10,14,4,0,0],[2029,10,14,1,0,0],'-03:00:00',[-3,0,0],
          'WARST',1,[2030,3,10,2,59,59],[2030,3,9,23,59,59] ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '-03:00:00',
                'stdoff' => '-04:00:00',

               },
   'rules'  => {
                '03' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '8',
                         'type'    => 'w',
                         'time'    => '00:00:00',
                         'isdst'   => '0',
                         'abb'     => 'WART',
                        },
                '10' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '8',
                         'type'    => 'w',
                         'time'    => '00:00:00',
                         'isdst'   => '1',
                         'abb'     => 'WARST',
                        },

               },
);

1;
