#!/usr/bin/env perl
use strict;
use warnings;
use App::pherkin;
use Test::More;

BEGIN {
    if ( not -t STDOUT and not defined $ENV{'ANSI_COLORS_DISABLED'} ) {
        $ENV{'ANSI_COLORS_DISABLED'} = 1;
    }
}

{
    # Replace the StepFile definitions with ones that ignore the sub passed in
    # and instead just always pass

    for my $method_name (qw/Given When Then Step/) {
        # Actual method we'll replace
        my $fqmn = 'Test::BDD::Cucumber::StepFile::' . $method_name;

        {
            no strict 'refs';
            no warnings 'redefine';
            *$fqmn = sub {
                my ( $regex, $old_sub ) = @_;
                my $new_sub = sub { ok(1, "Found") };
                push( @Test::BDD::Cucumber::StepFile::definitions,
                    [ $method_name, $regex, $new_sub ]);
            };
        }
    }
}

my $result = App::pherkin->new()->run(@ARGV);

# Anything other than 'passing' is not OK, because it means we didn't match all
# the steps
exit( $result->result ne 'passing' );