package Mojolicious::Command::package;
use Mojo::Base 'Mojolicious::Command';

our $VERSION = '0.01';

use Mojo::IOLoop::Client;
use Mojolicious;

has description => 'Package a project for distribution';
has usage => sub { shift->extract_usage };

use File::Basename;
use Cwd qw/getcwd abs_path/;

sub run {
  my $self = shift;

  die "Not a git repo\n" unless -d '.git';

  my $project = basename abs_path getcwd;
  chomp(my $version = qx(head -1 Changes | cut -d ' ' -f 1));

  qx(tar czf ../$project-$version.tar.gz --exclude=.git -X MANIFEST.SKIP ../$project);

  say "../$project-$version.tar.gz";
}

1;

=encoding utf8

=head1 NAME

Mojolicious::Command::package - Package command

=head1 SYNOPSIS

  Usage: APPLICATION package [OPTIONS]

    mojo package

  Options:
    -h, --help   Show this summary of available options

=head1 DESCRIPTION

L<Mojolicious::Command::package> packages the current git repo for
distribution.

=head1 ATTRIBUTES

L<Mojolicious::Command::package> inherits all attributes from
L<Mojolicious::Command> and implements the following new ones.

=head2 description

  my $description = $v->description;
  $v              = $v->description('Foo');

Short description of this command, used for the command list.

=head2 usage

  my $usage = $v->usage;
  $v        = $v->usage('Foo');

Usage information for this command, used for the help screen.

=head1 METHODS

L<Mojolicious::Command::package> inherits all methods from
L<Mojolicious::Command> and implements the following new ones.

=head2 run

  $v->run(@ARGV);

Run this command.

=head1 SEE ALSO

L<Mojolicious>, L<Mojolicious::Guides>, L<http://mojolicio.us>.

=cut
