use Unicode::Collate::CJK::GB2312;
+{
   locale_version => 1.26,
   overrideCJK => \&Unicode::Collate::CJK::GB2312::weightGB2312,
   entry => <<'ENTRY', # for DUCET v9.0.0
0101      ; [.1C47.001C.0002] # LATIN SMALL LETTER A WITH MACRON
0061 0304 ; [.1C47.001C.0002] # LATIN SMALL LETTER A WITH MACRON
0100      ; [.1C47.001C.0008] # LATIN CAPITAL LETTER A WITH MACRON
0041 0304 ; [.1C47.001C.0008] # LATIN CAPITAL LETTER A WITH MACRON
00E1      ; [.1C47.001D.0002] # LATIN SMALL LETTER A WITH ACUTE
0061 0301 ; [.1C47.001D.0002] # LATIN SMALL LETTER A WITH ACUTE
0061 0341 ; [.1C47.001D.0002] # LATIN SMALL LETTER A WITH ACUTE
00C1      ; [.1C47.001D.0008] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0301 ; [.1C47.001D.0008] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0341 ; [.1C47.001D.0008] # LATIN CAPITAL LETTER A WITH ACUTE
01CE      ; [.1C47.001E.0002] # LATIN SMALL LETTER A WITH CARON
0061 030C ; [.1C47.001E.0002] # LATIN SMALL LETTER A WITH CARON
01CD      ; [.1C47.001E.0008] # LATIN CAPITAL LETTER A WITH CARON
0041 030C ; [.1C47.001E.0008] # LATIN CAPITAL LETTER A WITH CARON
00E0      ; [.1C47.001F.0002] # LATIN SMALL LETTER A WITH GRAVE
0061 0300 ; [.1C47.001F.0002] # LATIN SMALL LETTER A WITH GRAVE
0061 0340 ; [.1C47.001F.0002] # LATIN SMALL LETTER A WITH GRAVE
00C0      ; [.1C47.001F.0008] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0300 ; [.1C47.001F.0008] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0340 ; [.1C47.001F.0008] # LATIN CAPITAL LETTER A WITH GRAVE
0113      ; [.1CAA.001C.0002] # LATIN SMALL LETTER E WITH MACRON
0065 0304 ; [.1CAA.001C.0002] # LATIN SMALL LETTER E WITH MACRON
0112      ; [.1CAA.001C.0008] # LATIN CAPITAL LETTER E WITH MACRON
0045 0304 ; [.1CAA.001C.0008] # LATIN CAPITAL LETTER E WITH MACRON
00E9      ; [.1CAA.001D.0002] # LATIN SMALL LETTER E WITH ACUTE
0065 0301 ; [.1CAA.001D.0002] # LATIN SMALL LETTER E WITH ACUTE
0065 0341 ; [.1CAA.001D.0002] # LATIN SMALL LETTER E WITH ACUTE
00C9      ; [.1CAA.001D.0008] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0301 ; [.1CAA.001D.0008] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0341 ; [.1CAA.001D.0008] # LATIN CAPITAL LETTER E WITH ACUTE
011B      ; [.1CAA.001E.0002] # LATIN SMALL LETTER E WITH CARON
0065 030C ; [.1CAA.001E.0002] # LATIN SMALL LETTER E WITH CARON
011A      ; [.1CAA.001E.0008] # LATIN CAPITAL LETTER E WITH CARON
0045 030C ; [.1CAA.001E.0008] # LATIN CAPITAL LETTER E WITH CARON
00E8      ; [.1CAA.001F.0002] # LATIN SMALL LETTER E WITH GRAVE
0065 0300 ; [.1CAA.001F.0002] # LATIN SMALL LETTER E WITH GRAVE
0065 0340 ; [.1CAA.001F.0002] # LATIN SMALL LETTER E WITH GRAVE
00C8      ; [.1CAA.001F.0008] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0300 ; [.1CAA.001F.0008] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0340 ; [.1CAA.001F.0008] # LATIN CAPITAL LETTER E WITH GRAVE
00EA 0304 ; [.1CAA.0021.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
00CA 0304 ; [.1CAA.0021.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
0065 0302 0304 ; [.1CAA.0021.0002] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
0045 0302 0304 ; [.1CAA.0021.0008] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
1EBF      ; [.1CAA.0022.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0301 ; [.1CAA.0022.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0341 ; [.1CAA.0022.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
1EBE      ; [.1CAA.0022.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0301 ; [.1CAA.0022.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0341 ; [.1CAA.0022.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
00EA 0301 ; [.1CAA.0022.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00EA 0341 ; [.1CAA.0022.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00CA 0301 ; [.1CAA.0022.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00CA 0341 ; [.1CAA.0022.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00EA 030C ; [.1CAA.0023.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
00CA 030C ; [.1CAA.0023.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
0065 0302 030C ; [.1CAA.0023.0002] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
0045 0302 030C ; [.1CAA.0023.0008] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
1EC1      ; [.1CAA.0024.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0300 ; [.1CAA.0024.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0340 ; [.1CAA.0024.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
1EC0      ; [.1CAA.0024.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0300 ; [.1CAA.0024.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0340 ; [.1CAA.0024.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
00EA 0300 ; [.1CAA.0024.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00EA 0340 ; [.1CAA.0024.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00CA 0300 ; [.1CAA.0024.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00CA 0340 ; [.1CAA.0024.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00EA      ; [.1CAA.0025.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX
0065 0302 ; [.1CAA.0025.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX
00CA      ; [.1CAA.0025.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
0045 0302 ; [.1CAA.0025.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
1EC5      ; [.1CAA.0025.0002][.0000.002D.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
1EC4      ; [.1CAA.0025.0008][.0000.002D.0002] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
1EC3      ; [.1CAA.0025.0002][.0000.003B.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC2      ; [.1CAA.0025.0008][.0000.003B.0002] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC7      ; [.1CAA.0025.0002][.0000.0042.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
1EC6      ; [.1CAA.0025.0008][.0000.0042.0002] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
012B      ; [.1D32.001C.0002] # LATIN SMALL LETTER I WITH MACRON
0069 0304 ; [.1D32.001C.0002] # LATIN SMALL LETTER I WITH MACRON
012A      ; [.1D32.001C.0008] # LATIN CAPITAL LETTER I WITH MACRON
0049 0304 ; [.1D32.001C.0008] # LATIN CAPITAL LETTER I WITH MACRON
00ED      ; [.1D32.001D.0002] # LATIN SMALL LETTER I WITH ACUTE
0069 0301 ; [.1D32.001D.0002] # LATIN SMALL LETTER I WITH ACUTE
0069 0341 ; [.1D32.001D.0002] # LATIN SMALL LETTER I WITH ACUTE
00CD      ; [.1D32.001D.0008] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0301 ; [.1D32.001D.0008] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0341 ; [.1D32.001D.0008] # LATIN CAPITAL LETTER I WITH ACUTE
01D0      ; [.1D32.001E.0002] # LATIN SMALL LETTER I WITH CARON
0069 030C ; [.1D32.001E.0002] # LATIN SMALL LETTER I WITH CARON
01CF      ; [.1D32.001E.0008] # LATIN CAPITAL LETTER I WITH CARON
0049 030C ; [.1D32.001E.0008] # LATIN CAPITAL LETTER I WITH CARON
00EC      ; [.1D32.001F.0002] # LATIN SMALL LETTER I WITH GRAVE
0069 0300 ; [.1D32.001F.0002] # LATIN SMALL LETTER I WITH GRAVE
0069 0340 ; [.1D32.001F.0002] # LATIN SMALL LETTER I WITH GRAVE
00CC      ; [.1D32.001F.0008] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0300 ; [.1D32.001F.0008] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0340 ; [.1D32.001F.0008] # LATIN CAPITAL LETTER I WITH GRAVE
006D 0304 ; [.1DAA.001C.0002] # <LATIN SMALL LETTER M, COMBINING MACRON>
004D 0304 ; [.1DAA.001C.0008] # <LATIN CAPITAL LETTER M, COMBINING MACRON>
1E3F      ; [.1DAA.001D.0002] # LATIN SMALL LETTER M WITH ACUTE
006D 0301 ; [.1DAA.001D.0002] # LATIN SMALL LETTER M WITH ACUTE
006D 0341 ; [.1DAA.001D.0002] # LATIN SMALL LETTER M WITH ACUTE
1E3E      ; [.1DAA.001D.0008] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0301 ; [.1DAA.001D.0008] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0341 ; [.1DAA.001D.0008] # LATIN CAPITAL LETTER M WITH ACUTE
006D 030C ; [.1DAA.001E.0002] # <LATIN SMALL LETTER M, COMBINING CARON>
004D 030C ; [.1DAA.001E.0008] # <LATIN CAPITAL LETTER M, COMBINING CARON>
006D 0300 ; [.1DAA.001F.0002] # <LATIN SMALL LETTER M, COMBINING GRAVE ACCENT>
006D 0340 ; [.1DAA.001F.0002] # <LATIN SMALL LETTER M, COMBINING GRAVE TONE MARK>
004D 0300 ; [.1DAA.001F.0008] # <LATIN CAPITAL LETTER M, COMBINING GRAVE ACCENT>
004D 0340 ; [.1DAA.001F.0008] # <LATIN CAPITAL LETTER M, COMBINING GRAVE TONE MARK>
006E 0304 ; [.1DB9.001C.0002] # <LATIN SMALL LETTER N, COMBINING MACRON>
004E 0304 ; [.1DB9.001C.0008] # <LATIN CAPITAL LETTER N, COMBINING MACRON>
0144      ; [.1DB9.001D.0002] # LATIN SMALL LETTER N WITH ACUTE
006E 0301 ; [.1DB9.001D.0002] # LATIN SMALL LETTER N WITH ACUTE
006E 0341 ; [.1DB9.001D.0002] # LATIN SMALL LETTER N WITH ACUTE
0143      ; [.1DB9.001D.0008] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0301 ; [.1DB9.001D.0008] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0341 ; [.1DB9.001D.0008] # LATIN CAPITAL LETTER N WITH ACUTE
0148      ; [.1DB9.001E.0002] # LATIN SMALL LETTER N WITH CARON
006E 030C ; [.1DB9.001E.0002] # LATIN SMALL LETTER N WITH CARON
0147      ; [.1DB9.001E.0008] # LATIN CAPITAL LETTER N WITH CARON
004E 030C ; [.1DB9.001E.0008] # LATIN CAPITAL LETTER N WITH CARON
01F9      ; [.1DB9.001F.0002] # LATIN SMALL LETTER N WITH GRAVE
006E 0300 ; [.1DB9.001F.0002] # LATIN SMALL LETTER N WITH GRAVE
006E 0340 ; [.1DB9.001F.0002] # LATIN SMALL LETTER N WITH GRAVE
01F8      ; [.1DB9.001F.0008] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0300 ; [.1DB9.001F.0008] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0340 ; [.1DB9.001F.0008] # LATIN CAPITAL LETTER N WITH GRAVE
014D      ; [.1DDD.001C.0002] # LATIN SMALL LETTER O WITH MACRON
006F 0304 ; [.1DDD.001C.0002] # LATIN SMALL LETTER O WITH MACRON
014C      ; [.1DDD.001C.0008] # LATIN CAPITAL LETTER O WITH MACRON
004F 0304 ; [.1DDD.001C.0008] # LATIN CAPITAL LETTER O WITH MACRON
00F3      ; [.1DDD.001D.0002] # LATIN SMALL LETTER O WITH ACUTE
006F 0301 ; [.1DDD.001D.0002] # LATIN SMALL LETTER O WITH ACUTE
006F 0341 ; [.1DDD.001D.0002] # LATIN SMALL LETTER O WITH ACUTE
00D3      ; [.1DDD.001D.0008] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0301 ; [.1DDD.001D.0008] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0341 ; [.1DDD.001D.0008] # LATIN CAPITAL LETTER O WITH ACUTE
01D2      ; [.1DDD.001E.0002] # LATIN SMALL LETTER O WITH CARON
006F 030C ; [.1DDD.001E.0002] # LATIN SMALL LETTER O WITH CARON
01D1      ; [.1DDD.001E.0008] # LATIN CAPITAL LETTER O WITH CARON
004F 030C ; [.1DDD.001E.0008] # LATIN CAPITAL LETTER O WITH CARON
00F2      ; [.1DDD.001F.0002] # LATIN SMALL LETTER O WITH GRAVE
006F 0300 ; [.1DDD.001F.0002] # LATIN SMALL LETTER O WITH GRAVE
006F 0340 ; [.1DDD.001F.0002] # LATIN SMALL LETTER O WITH GRAVE
00D2      ; [.1DDD.001F.0008] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0300 ; [.1DDD.001F.0008] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0340 ; [.1DDD.001F.0008] # LATIN CAPITAL LETTER O WITH GRAVE
016B      ; [.1EB5.001C.0002] # LATIN SMALL LETTER U WITH MACRON
0075 0304 ; [.1EB5.001C.0002] # LATIN SMALL LETTER U WITH MACRON
016A      ; [.1EB5.001C.0008] # LATIN CAPITAL LETTER U WITH MACRON
0055 0304 ; [.1EB5.001C.0008] # LATIN CAPITAL LETTER U WITH MACRON
00FA      ; [.1EB5.001D.0002] # LATIN SMALL LETTER U WITH ACUTE
0075 0301 ; [.1EB5.001D.0002] # LATIN SMALL LETTER U WITH ACUTE
0075 0341 ; [.1EB5.001D.0002] # LATIN SMALL LETTER U WITH ACUTE
00DA      ; [.1EB5.001D.0008] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0301 ; [.1EB5.001D.0008] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0341 ; [.1EB5.001D.0008] # LATIN CAPITAL LETTER U WITH ACUTE
01D4      ; [.1EB5.001E.0002] # LATIN SMALL LETTER U WITH CARON
0075 030C ; [.1EB5.001E.0002] # LATIN SMALL LETTER U WITH CARON
01D3      ; [.1EB5.001E.0008] # LATIN CAPITAL LETTER U WITH CARON
0055 030C ; [.1EB5.001E.0008] # LATIN CAPITAL LETTER U WITH CARON
00F9      ; [.1EB5.001F.0002] # LATIN SMALL LETTER U WITH GRAVE
0075 0300 ; [.1EB5.001F.0002] # LATIN SMALL LETTER U WITH GRAVE
0075 0340 ; [.1EB5.001F.0002] # LATIN SMALL LETTER U WITH GRAVE
00D9      ; [.1EB5.001F.0008] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0300 ; [.1EB5.001F.0008] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0340 ; [.1EB5.001F.0008] # LATIN CAPITAL LETTER U WITH GRAVE
01D6      ; [.1EB5.0021.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
0075 0308 0304 ; [.1EB5.0021.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
01D5      ; [.1EB5.0021.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
0055 0308 0304 ; [.1EB5.0021.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
00FC 0304 ; [.1EB5.0021.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING MACRON>
00DC 0304 ; [.1EB5.0021.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING MACRON>
01D8      ; [.1EB5.0022.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0301 ; [.1EB5.0022.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0341 ; [.1EB5.0022.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
01D7      ; [.1EB5.0022.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0301 ; [.1EB5.0022.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0341 ; [.1EB5.0022.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
00FC 0301 ; [.1EB5.0022.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00FC 0341 ; [.1EB5.0022.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
00DC 0301 ; [.1EB5.0022.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00DC 0341 ; [.1EB5.0022.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
01DA      ; [.1EB5.0023.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
0075 0308 030C ; [.1EB5.0023.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
01D9      ; [.1EB5.0023.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
0055 0308 030C ; [.1EB5.0023.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
00FC 030C ; [.1EB5.0023.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING CARON>
00DC 030C ; [.1EB5.0023.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING CARON>
01DC      ; [.1EB5.0024.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0300 ; [.1EB5.0024.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0340 ; [.1EB5.0024.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
01DB      ; [.1EB5.0024.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0300 ; [.1EB5.0024.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0340 ; [.1EB5.0024.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
00FC 0300 ; [.1EB5.0024.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00FC 0340 ; [.1EB5.0024.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00DC 0300 ; [.1EB5.0024.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00DC 0340 ; [.1EB5.0024.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00FC      ; [.1EB5.0025.0002] # LATIN SMALL LETTER U WITH DIAERESIS
0075 0308 ; [.1EB5.0025.0002] # LATIN SMALL LETTER U WITH DIAERESIS
00DC      ; [.1EB5.0025.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS
0055 0308 ; [.1EB5.0025.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS
E2D8      ; [.8EAB.0020.0002] # <unknown>
E2D9      ; [.8EAC.0020.0002] # <unknown>
E2DA      ; [.8EAD.0020.0002] # <unknown>
E2DB      ; [.8EAE.0020.0002] # <unknown>
E2DC      ; [.8EAF.0020.0002] # <unknown>
F967      ; [.80D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F967
F905      ; [.8185.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.8AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.81D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95E
2F800     ; [.8635.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F800
F9BA      ; [.8668.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.865E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.899D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FD
F9A8      ; [.868B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A8
2F804     ; [.879A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F804
F9B5      ; [.863C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.8B4D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.8B4D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F805
F965      ; [.80A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F965
2F80B     ; [.8BB2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.8662.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.893B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.893B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.8EB2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.815D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.873B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.873B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F80F     ; [.8AC8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80F
FA72      ; [.88DA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA72
F9D1      ; [.8696.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.8562.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.8484.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.8D70.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.8709.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.873A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.890E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.8D40.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.823F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81A
FA71      ; [.85D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA71
2F81B     ; [.85D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81B
F92E      ; [.8623.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.8656.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.8685.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F955
2F81D     ; [.8FF2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81D
2F81E     ; [.88FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.88A1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.88A1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.866D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.863A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.81A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.85AD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F822     ; [.833D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F822
F98A      ; [.8643.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.8670.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99D
2F992     ; [.860C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F992
FA76      ; [.8CFB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.8CFB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.873C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.873C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.8614.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F952
FA34      ; [.88AB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.88AB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F827
FA77      ; [.8964.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.8964.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.805B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F829
2F82A     ; [.81A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82A
F963      ; [.806E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.806E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.879B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.8445.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.806D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.806D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.80C4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.847B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.86CC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F831     ; [.88B5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.88B5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.88B5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F833
2F836     ; [.8477.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.8FEE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.8567.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.84F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.9154.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83A
2F83B     ; [.915B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83B
F9DE      ; [.8633.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.867C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.8B5F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83D
2F83E     ; [.8143.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.8E2F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83F
F99E      ; [.8C47.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F842     ; [.8A6D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F842
FA79      ; [.919C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA79
2F845     ; [.8953.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.8953.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.85ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.91B8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.91B8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.83D3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.83D3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F849     ; [.8D92.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F849
FA38      ; [.886A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA38
F9A9      ; [.91F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F855     ; [.8BEC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.8140.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.9023.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F854     ; [.9029.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F854
F96C      ; [.892A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.8762.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3A
2F851     ; [.8E64.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F851
2F85D     ; [.8273.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85D
FA7E      ; [.8C56.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.8785.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.8868.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.8079.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.896A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.87C3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F981
2F865     ; [.93E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F865
2F862     ; [.846E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F862
FA80      ; [.93F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F986     ; [.95FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F986
FA04      ; [.8DA1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA04
F9BC      ; [.9391.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BC
2F872     ; [.89C4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F872
2F873     ; [.84D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F873
2F875     ; [.910F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F875
F9BD      ; [.87A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.8AC5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F877
F9DF      ; [.86BF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DF
FA3C      ; [.93CD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3C
2F878     ; [.93CD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F878
2F87A     ; [.9206.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87A
2F87F     ; [.922E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87F
2F881     ; [.8C2F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F882     ; [.812B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F882
2F884     ; [.8F50.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F886     ; [.870A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F886
F98E      ; [.87A1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.825B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88C     ; [.9293.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88C
2F88D     ; [.89E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.864B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.8607.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.8607.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA82      ; [.9295.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA82
FA0B      ; [.85E9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0B
2F890     ; [.9106.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F890
F943      ; [.87BF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F943
2F874     ; [.81E6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F874
2F899     ; [.8BED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.80E5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA84
F9D8      ; [.86C4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D8
FA85      ; [.9243.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.88FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.8E11.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.87A5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A3
F960      ; [.87C2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.864C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AC
FA3D      ; [.8443.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.8443.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
FA86      ; [.92C8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA86
FA88      ; [.8D33.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA88
2F8A6     ; [.819F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.842E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.842E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA87      ; [.8984.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA87
2F8A8     ; [.8984.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A8
FA3E      ; [.858F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3E
FA3F      ; [.8D8E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.8D8E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.8D8E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
2F8B2     ; [.8142.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
2F8B3     ; [.9554.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B3
F9D2      ; [.86B9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.81CE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B5     ; [.8064.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.85EC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F925
FA02      ; [.8ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.802D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
2F8BA     ; [.8827.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BA
F973      ; [.899B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.8AF1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.856B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
F9A4      ; [.87A4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A4
F975      ; [.86CE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.8C57.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.9130.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8D
FA8E      ; [.8A1A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8E
FA8F      ; [.9133.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8F
2F8C3     ; [.875D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
FA41      ; [.874D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.874D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.801C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.8537.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F9BE      ; [.866C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.86BE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F983
FA42      ; [.848F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA42
F9E0      ; [.8CB2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E0
FA12      ; [.88B8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.88B8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA91
FA43      ; [.89D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.89D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
FA06      ; [.8066.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA06
F901      ; [.834B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8D4     ; [.8E9F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.8609.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.8609.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.8609.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.8B00.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.8B00.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
F9E1      ; [.862D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.94AB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.8DBD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.94AC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
F9F4      ; [.8673.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.8695.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C9
F9DA      ; [.8634.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DA
F97A      ; [.8657.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.8710.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.8710.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
F9E2      ; [.8625.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E2
2F8E8     ; [.94F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E8
2F8EF     ; [.81A5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
FA95      ; [.81CC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA95
F972      ; [.897F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.8C55.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.8733.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F968
F9E3      ; [.8797.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E3
F915      ; [.86E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.8247.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F900     ; [.87DE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.8694.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.8694.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.8694.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.83D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.860A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.83AE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.83AE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.8523.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.87B0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.8679.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F5
2F90E     ; [.8C4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.9335.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.832A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.9345.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.868C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.879E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EC
2F90C     ; [.8216.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90C
FA99      ; [.8E7D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.8E7D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.8415.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F904
F94E      ; [.86A4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94E
2F90F     ; [.812A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F915     ; [.9382.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F915
2F913     ; [.9383.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F913
2F835     ; [.843B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F835
F9FB      ; [.8E1E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.8A66.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.866F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.8612.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F916
2F91C     ; [.9638.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91C
FA48      ; [.8E46.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.8E46.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9C
F9C0      ; [.8664.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C0
2F920     ; [.9647.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA9E      ; [.8577.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.8577.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F921
F946      ; [.860D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.8B6D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F924
FA9F      ; [.82A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F92B      ; [.8606.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.8E40.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.8E40.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F961      ; [.86C5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.86C5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.8AFA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F929
F9AD      ; [.867E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.9484.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.862C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.868D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.8E72.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92F     ; [.9493.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92F
FAA3      ; [.8416.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA3
2F936     ; [.946F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F936
F9CD      ; [.8691.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.86CF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F976
F9E5      ; [.863E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E5
2F93A     ; [.97D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F93A
FAA5      ; [.8B24.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA5
FA17      ; [.8CC1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.8CC1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.898D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA7
FAA8      ; [.8E04.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.8E04.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.898C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F946     ; [.8DDB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F946
2F947     ; [.8DDB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F947
FAAA      ; [.8E76.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAA
FA9D      ; [.8897.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9D
2F94E     ; [.968F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94E
F9CE      ; [.868F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.86B0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.86B0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.806B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.8619.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F947
FA18      ; [.8630.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA18
FA4C      ; [.8974.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.8860.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.9654.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA50      ; [.8E97.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.8E97.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.8E54.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.897E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.8BAA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1A
FA1B      ; [.82F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.82F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F956
2F957     ; [.9779.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F957
FA55      ; [.8AC0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA55
F9F7      ; [.863F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F7
F9F8      ; [.98CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F8
2F962     ; [.8E5E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F962
FAAE      ; [.861F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAE
F9F9      ; [.8640.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.852E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1D
FA03      ; [.8A6E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA03
2F968     ; [.9934.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F968
F96A      ; [.8A40.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.861A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94F
FA59      ; [.82A2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA59
FA5A      ; [.89DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.96E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E6
F9AF      ; [.8684.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.8D29.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1E
F934      ; [.860E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.8DD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.8DD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.8DD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.9833.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B0
F953      ; [.861E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.95D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.8D36.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F985     ; [.8815.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F985
FA5C      ; [.816D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.98FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.98FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98B
2F98C     ; [.9901.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98C
F97C      ; [.8659.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97C
FA5D      ; [.903A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5D
FA5E      ; [.903A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5E
2F990     ; [.8D2C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F98F     ; [.9042.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98F
2F991     ; [.8DF8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.8411.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.82AD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.8C3C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.8923.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.8923.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.85C1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F996
F9FE      ; [.8103.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.842D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F99A     ; [.8908.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99A
2F99D     ; [.8700.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99D
2F9A1     ; [.8558.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.857D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.80E6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
F958      ; [.867F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.86DF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F918
FA5F      ; [.8E4B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.8E4B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F9C2      ; [.90E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C2
2F9AC     ; [.90EB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9AC
2F9B3     ; [.87C5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
2F9B7     ; [.985A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
F911      ; [.86D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F911
FA08      ; [.8BEF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C4     ; [.8C9D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.866E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F912      ; [.86DE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F912
FA60      ; [.83E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.981C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB6
FAB7      ; [.8301.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB7
2F9D2     ; [.996E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D7     ; [.8863.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DB     ; [.9977.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DB
2F9DA     ; [.802E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.86B2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F937
2F98D     ; [.819E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98D
F971      ; [.8136.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F971
FA66      ; [.9396.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA66
FA25      ; [.8CB8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.8CB8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA67
F92C      ; [.8608.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92C
FA26      ; [.824F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA26
F919      ; [.8611.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F919
F9B7      ; [.996C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.862E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.865C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.8515.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9C6      ; [.891D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.86A5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.84DA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.8687.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F959
F9DC      ; [.869C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9B2      ; [.8680.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.8616.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F949
F938      ; [.86B1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F938
FA1C      ; [.853B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.853B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC8
F940      ; [.86B4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F940
F9F3      ; [.9A5C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.86E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.8627.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA17     ; [.96AE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA17
2FA18     ; [.99CF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA18
2FA1C     ; [.8084.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
ENTRY
};
