#
#  test of \p{ .. }, \P{ .. } etc.
#
#  this script uses ShiftJIS::String.pm
#
use ShiftJIS::String qw(mkrange);

use ShiftJIS::Regexp qw(re match);

my $n  = 0;
my @NG;

my %char = (
 n => [ "\n" ],
 r => [ "\r", "\t", "\f" ],
 s => [ ' '  ],
 S => [ '@' ],
 b => [ "\x7F" ],
 c => [ mkrange("\x00-\x08\x0b\x0e-\x1F") ],
 p => [ mkrange('!-/:-@[-^`{-~') ],
 q => [ '_' ],
 d => [ mkrange("0-9") ],
 u => [ mkrange("A-Z") ],
 l => [ mkrange("a-z") ],
 D => [ mkrange('O-X') ],
 U => [ mkrange('`-y') ],
 L => [ mkrange('-') ],
 G => [ mkrange('--') ],
 C => [ mkrange('@-`p-') ],
 H => [ mkrange('-JKTU') ],
 K => [ mkrange('@-[RS')   ],
 h => [ mkrange('-') ],
 k => [ mkrange('-') ],
 J => [ mkrange('-r') ],
 Z => [ mkrange('-') ],
 Y => [ mkrange('V-Z') ],
 P => [ mkrange('A-IL-Q\---΁--') ],
 B => [ mkrange('-') ],
 X => [ mkrange("\x81\xAD-\x81\xB7\x81\xC0-\x81\xC7\x81\xCF-\x81\xD9" .
		"\x81\xE9-\x81\xEF\x81\xF8-\x81\xFB\x82\x40-\x82\x4E" .
		"\x82\x59-\x82\x5F\x82\x7A-\x82\x80\x82\x9B-\x82\x9E" .
		"\x82\xF2-\x82\xFC\x83\x97-\x83\x9E\x83\xB7-\x83\xBE" .
		"\x83\xD7-\x83\xFC\x84\x61-\x84\x6F\x84\x92-\x84\x9E" .
		"\x84\xBF-\x86\xFC\x88\x40-\x88\x9E\x98\x73-\x98\x9E" .
		"\xEA\xA5-\xEC\xFC") ],
);

my @cls =	      qw(n r s S b c p q d u l D U L G C H K h k J Z Y P B X);
my %res = (
 '\j'		   =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[\0-\x{fcfc}]'   =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '.'		   =>[qw(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\J'		   =>[qw(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^\n]'	   =>[qw(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\d'		   =>[qw(0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[\d]'		   =>[qw(0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '\D'		   =>[qw(1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[\D]'		   =>[qw(1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\w'		   =>[qw(0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[\w]'		   =>[qw(0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '\W'		   =>[qw(1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[\W]'		   =>[qw(1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\s'		   =>[qw(1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[\s]'		   =>[qw(1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '\S'		   =>[qw(0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[\S]'		   =>[qw(0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],

 '\p{IsDigit}'     =>[qw(0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[[:digit:]]'     =>[qw(0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[^[:^digit:]]'   =>[qw(0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[0-9O-X]'      =>[qw(0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '\P{IsDigit}'     =>[qw(1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[[:^digit:]]'    =>[qw(1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^[:digit:]]'    =>[qw(1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^0-9O-X]'     =>[qw(1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\p{IsUpper}'     =>[qw(0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[[:upper:]]'     =>[qw(0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[^[:^upper:]]'   =>[qw(0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '\P{IsUpper}'     =>[qw(1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[[:^upper:]]'    =>[qw(1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^[:upper:]]'    =>[qw(1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\p{IsLower}'     =>[qw(0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[[:lower:]]'     =>[qw(0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[^[:^lower:]]'   =>[qw(0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0)],
 '\P{IsLower}'     =>[qw(1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[[:^lower:]]'    =>[qw(1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^[:lower:]]'    =>[qw(1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[A-Z`-y]'      =>[qw(0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[a-z-]'      =>[qw(0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[^A-Z`-y]'     =>[qw(1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^a-z-]'     =>[qw(1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1)],
 '(?i)[A-Z`-y]'  =>[qw(0 0 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '(?i)[^A-Z`-y]' =>[qw(1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '(?i)[a-z-]'  =>[qw(0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0)],
 '(?i)[^a-z-]' =>[qw(1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\p{IsAlpha}'     =>[qw(0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[[:alpha:]]'     =>[qw(0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[^[:^alpha:]]'   =>[qw(0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0)],
 '\P{IsAlpha}'     =>[qw(1 1 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[[:^alpha:]]'    =>[qw(1 1 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^[:alpha:]]'    =>[qw(1 1 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\p{IsAlnum}'     =>[qw(0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[[:alnum:]]'     =>[qw(0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[^[:^alnum:]]'   =>[qw(0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0)],
 '\P{IsAlnum}'     =>[qw(1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[[:^alnum:]]'    =>[qw(1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^[:alnum:]]'    =>[qw(1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\p{IsWord}'      =>[qw(0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0)],
 '[[:word:]]'      =>[qw(0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0)],
 '[^[:^word:]]'    =>[qw(0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0)],
 '\P{IsWord}'      =>[qw(1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1)],
 '[[:^word:]]'     =>[qw(1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1)],
 '[^[:word:]]'     =>[qw(1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1)],
 '\p{IsPunct}'     =>[qw(0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0)],
 '[[:punct:]]'     =>[qw(0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0)],
 '[^[:^punct:]]'   =>[qw(0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0)],
 '\P{IsPunct}'     =>[qw(1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1)],
 '[[:^punct:]]'    =>[qw(1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1)],
 '[^[:punct:]]'    =>[qw(1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1)],
 '\p{IsSpace}'     =>[qw(1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[[:space:]]'     =>[qw(1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[^[:^space:]]'   =>[qw(1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[\s\x{8140}]'    =>[qw(1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '\P{IsSpace}'     =>[qw(0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[[:^space:]]'    =>[qw(0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^[:space:]]'    =>[qw(0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^\s\x{8140}]'   =>[qw(0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\p{IsGraph}'     =>[qw(0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[[:graph:]]'     =>[qw(0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^[:^graph:]]'   =>[qw(0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\P{IsGraph}'     =>[qw(1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[[:^graph:]]'    =>[qw(1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[^[:graph:]]'    =>[qw(1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '\p{IsPrint}'     =>[qw(1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[[:print:]]'     =>[qw(1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^[:^print:]]'   =>[qw(1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\P{IsPrint}'     =>[qw(0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[[:^print:]]'    =>[qw(0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[^[:print:]]'    =>[qw(0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '\p{IsCntrl}'     =>[qw(1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[[:cntrl:]]'     =>[qw(1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[^[:^cntrl:]]'   =>[qw(1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '\P{IsCntrl}'     =>[qw(0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[[:^cntrl:]]'    =>[qw(0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^[:cntrl:]]'    =>[qw(0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\p{IsAscii}'     =>[qw(1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[[:ascii:]]'     =>[qw(1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[^[:^ascii:]]'   =>[qw(1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[\0-\c?]'        =>[qw(1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '\P{IsAscii}'     =>[qw(0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[[:^ascii:]]'    =>[qw(0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^[:ascii:]]'    =>[qw(0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^\0-\c?]'       =>[qw(0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\p{IsHankaku}'   =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0)],
 '[[:hankaku:]]'   =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0)],
 '[^[:^hankaku:]]' =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0)],
 '[\xA1-\xDF]'     =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0)],
 '\P{IsHankaku}'   =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1)],
 '[[:^hankaku:]]'  =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1)],
 '[^[:hankaku:]]'  =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1)],
 '[^\xA1-\xDF]'    =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1)],
 '\p{IsZenkaku}'   =>[qw(0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1)],
 '[[:zenkaku:]]'   =>[qw(0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1)],
 '[^[:^zenkaku:]]' =>[qw(0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1)],
 '\P{IsZenkaku}'   =>[qw(1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0)],
 '[[:^zenkaku:]]'  =>[qw(1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0)],
 '[^[:zenkaku:]]'  =>[qw(1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0)],

 '\p{InLatin}'     =>[qw(0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[[:latin:]]'     =>[qw(0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[^[:^latin:]]'   =>[qw(0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[A-Za-z]'        =>[qw(0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)],
 '\P{InLatin}'     =>[qw(1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[[:^latin:]]'    =>[qw(1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^[:latin:]]'    =>[qw(1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^A-Za-z]'       =>[qw(1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\p{InFullLatin}' =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[[:fulllatin:]]' =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0)],
'[^[:^fulllatin:]]'=>[qw(0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0)],
 '[`-y-]'	   =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0)],
 '\P{InFullLatin}' =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[[:^fulllatin:]]'=>[qw(1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^[:fulllatin:]]'=>[qw(1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1)],
 '[^`-y-]'   =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1)],
 '\p{InGreek}'     =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0)],
 '[[:greek:]]'     =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0)],
 '[^[:^greek:]]'   =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0)],
 '[--]'    =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0)],
 '\P{InGreek}'     =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1)],
 '[[:^greek:]]'    =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1)],
 '[^[:greek:]]'    =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1)],
 '[^--]'   =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1)],
 '\p{InCyrillic}'  =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0)],
 '[[:cyrillic:]]'  =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0)],
 '[^[:^cyrillic:]]'=>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0)],
 '[@-`p-]'    =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0)],
 '\P{InCyrillic}'  =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1)],
 '[[:^cyrillic:]]' =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1)],
 '[^[:cyrillic:]]' =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1)],
 '[^@-`p-]'   =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1)],
 '\p{InHalfKana}'  =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0)],
 '[[:halfkana:]]'  =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0)],
 '[^[:^halfkana:]]'=>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0)],
 '[\xA6-\xDF]'     =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0)],
 '\P{InHalfKana}'  =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1)],
 '[[:^halfkana:]]' =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1)],
 '[^[:halfkana:]]' =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1)],
 '[^\xA6-\xDF]'    =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1)],
 '\p{InHiragana}'  =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0)],
 '[[:hiragana:]]'  =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0)],
 '[^[:^hiragana:]]'=>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0)],
 '[-JKTU]' =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0)],
 '\P{InHiragana}'  =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1)],
 '[[:^hiragana:]]' =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1)],
 '[^[:hiragana:]]' =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1)],
 '[^-JKTU]'=>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1)],
 '\p{InKatakana}'  =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0)],
 '[[:katakana:]]'  =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0)],
 '[^[:^katakana:]]'=>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0)],
 '[@-[RS]'   =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0)],
 '\P{InKatakana}'  =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1)],
 '[[:^katakana:]]' =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1)],
 '[^[:katakana:]]' =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1)],
 '[^@-[RS]'  =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1)],
 '\p{InFullKana}'  =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0)],
 '[[:fullkana:]]'  =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0)],
 '[^[:^fullkana:]]'=>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0)],
 '\P{InFullKana}'  =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1)],
 '[[:^fullkana:]]' =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1)],
 '[^[:fullkana:]]' =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1)],
 '\p{InKana}'      =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0)],
 '[[:kana:]]'      =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0)],
 '[^[:^kana:]]'    =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0)],
 '\P{InKana}'      =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 1)],
 '[[:^kana:]]'     =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 1)],
 '[^[:kana:]]'     =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 1)],
 '\p{InKanji1}'    =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0)],
 '[[:kanji1:]]'    =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0)],
 '[^[:^kanji1:]]'  =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0)],
 '[-r]'         =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0)],
 '\P{InKanji1}'    =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1)],
 '[[:^kanji1:]]'   =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1)],
 '[^[:kanji1:]]'   =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1)],
 '[^-r]'        =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 1)],
 '\p{InKanji2}'    =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0)],
 '[[:kanji2:]]'    =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0)],
 '[^[:^kanji2:]]'  =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0)],
 '[-]'         =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0)],
 '\P{InKanji2}'    =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1)],
 '[[:^kanji2:]]'   =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1)],
 '[^[:kanji2:]]'   =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1)],
 '[^-]'        =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1)],
 '\p{InKanji}'     =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0)],
 '[[:kanji:]]'     =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0)],
 '[^[:^kanji:]]'   =>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0)],
 '\P{InKanji}'     =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1)],
 '[[:^kanji:]]'    =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1)],
 '[^[:kanji:]]'    =>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1)],
 '\p{InBoxDrawing}'=>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0)],
 '[[:boxdrawing:]]'=>[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0)],
'[^[:^boxdrawing:]]',[qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0)],
 '\P{InBoxDrawing}'=>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1)],
'[[:^boxdrawing:]]'=>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1)],
'[^[:boxdrawing:]]'=>[qw(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1)],
);

#open RE, ">regexp.txt";
my($mod,$OK,$r,$cl);
for $r (sort keys %res){
  print "$r\n";
  my $re = "^$r\$";
  $mod = $re =~ s/\(\?i\)// ? 'io' : 'o';
# printf RE "%s\n    %s\n", $r, $re;  next;
  for $cl (0..$#cls){
    my $match = grep(match($_, $re, $mod), @{ $char{ $cls[ $cl ] } });
    my $a = $match == @{ $char{ $cls[ $cl ] } } ? 1 : $match == 0 ? 0 : -1;

    my $msg = $a == $res{ $r }[$cl] ? "ok" : "not ok";
    ++$n;
    print "$msg $n\n";
    push @NG, $n.$r." ".$cls[ $cl ]."\n" if $msg ne 'ok';
  }
}
print ! @NG
	? "All tests successful.\n"
	: "Failed ".scalar(@NG).", tests.\n", @NG;
__END__
