#!/usr/bin/perl
#

use strict;
use warnings;
use Test::More tests => 7;

use Net::DNS::Multicast;


my $resolver = Net::DNS::Resolver->new( retrans => 0, retry => 0 );
ok( $resolver, 'Net::DNS::Resolver->new( ... )' );

my $multicast = $resolver->bgsend('example.local.');
ok( $multicast, 'multicast $resolver->bgsend("example.local.")' );

my $unicast = $resolver->bgsend('example.com.');
ok( $unicast, 'unicast $resolver->bgsend("example.com.")' );

my $fake_handle = IO::Select->new();
my $bgbusy	= $resolver->bgbusy($fake_handle);
ok( !$bgbusy, '$resolver->bgbusy($handle)' );

my $bgread = $resolver->bgread($fake_handle);
ok( !$bgread, '$resolver->bgread($handle)' );

my $send = eval { $resolver->send('example.local.'); 1 };
ok( $send, 'multicast $resolver->send("example.local.")' );

my $compat = eval { $resolver->send('example.com.'); 1 };
ok( $compat, 'unicast $resolver->send("example.com.")' );


exit;

__END__

