use strict;
use warnings;

use Module::Build;

# -----------------------------------------------

my $class = Module::Build->subclass(code => <<'EOF');

sub ACTION_authortest
{
	my($self) = @_;

	$self->depends_on('build');
	$self->depends_on('manifest');
	$self->depends_on('distmeta');

	$self->test_files( qw< t xt/author > );
	$self->recursive_test_files(1);

	$self->depends_on('test');

	return;
}
EOF

$class -> new
(
	module_name    => 'File::BOM::Utils',
	license        => 'artistic_2',
	dist_abstract  => 'Check, Add and Remove BOMs',
	dist_author    => 'Ron Savage <ron@savage.net.au>',
	build_requires =>
	{
		'Test::More' => 1.001006,
# 	 	'Test::Pod'  => 1.45, # Make it optional. See xt/author/pod.t.
	},
	configure_requires =>
	{
		'Module::Build' => 0.4210,
	},
	requires =>
	{
		'File::Slurp'     => 9999.19,
		'File::Spec'      => 0,
		'Getopt::Long'    => 0,
		'Moo'             => 1.007000,
		'Pod::Usage'      => 0,
		'strict'          => 0,
		'Types::Standard' => 1.000005,
		'utf8'            => 0,
		'warnings'        => 0,
	},
	resources =>
	{
		bugtracker => 'https://rt.cpan.org/Public/Dist/Display.html?Name=File-BOM-Utils',
		license    => 'http://opensource.org/licenses/Artistic-2.0',
		repository => 'https://github.com/ronsavage/File-BOM-Utils',
	},
	script_files => ['bin/bommer.pl'],
) -> create_build_script();
