package Text::Minify::XS;

# ABSTRACT: Simple text minification

use v5.6;
use strict;
use warnings;

require Exporter;
require XSLoader;

our @ISA = qw(Exporter);
our @EXPORT_OK = qw(minify);

our $VERSION = 'v0.1.0';

XSLoader::load( "Text::Minify::XS", $VERSION );

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Text::Minify::XS - Simple text minification

=head1 VERSION

version v0.1.0

=head1 SYNOPSIS

  use Text::Minify::XS qw/ minify /;

  my $out = minify( $in );

=head1 EXPORTS

=head2 minify

  my $out = minify( $in );

This performs a quick-and-dirty text minifying.

Currently, it only removes leading whitespace and multiple newlines.

=head1 KNOWN ISSUES

This only supports ASCII/Latin-1 text.

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/Text-Minify-XS>
and may be cloned from L<git://github.com/robrwo/Text-Minify-XS.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/Text-Minify-XS/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
