use utf8;

package SemanticWeb::Schema::RentalCarReservation;

# ABSTRACT: A reservation for a rental car

use Moo;

extends qw/ SemanticWeb::Schema::Reservation /;


use MooX::JSON_LD 'RentalCarReservation';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v7.0.2';


has dropoff_location => (
    is        => 'rw',
    predicate => '_has_dropoff_location',
    json_ld   => 'dropoffLocation',
);



has dropoff_time => (
    is        => 'rw',
    predicate => '_has_dropoff_time',
    json_ld   => 'dropoffTime',
);



has pickup_location => (
    is        => 'rw',
    predicate => '_has_pickup_location',
    json_ld   => 'pickupLocation',
);



has pickup_time => (
    is        => 'rw',
    predicate => '_has_pickup_time',
    json_ld   => 'pickupTime',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::RentalCarReservation - A reservation for a rental car

=head1 VERSION

version v7.0.2

=head1 DESCRIPTION

=for html <p>A reservation for a rental car.<br/><br/> Note: This type is for
information about actual reservations, e.g. in confirmation emails or HTML
pages with individual confirmations of reservations.<p>

=head1 ATTRIBUTES

=head2 C<dropoff_location>

C<dropoffLocation>

Where a rental car can be dropped off.

A dropoff_location should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::Place']>

=back

=head2 C<_has_dropoff_location>

A predicate for the L</dropoff_location> attribute.

=head2 C<dropoff_time>

C<dropoffTime>

When a rental car can be dropped off.

A dropoff_time should be one of the following types:

=over

=item C<Str>

=back

=head2 C<_has_dropoff_time>

A predicate for the L</dropoff_time> attribute.

=head2 C<pickup_location>

C<pickupLocation>

Where a taxi will pick up a passenger or a rental car can be picked up.

A pickup_location should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::Place']>

=back

=head2 C<_has_pickup_location>

A predicate for the L</pickup_location> attribute.

=head2 C<pickup_time>

C<pickupTime>

When a taxi will pickup a passenger or a rental car can be picked up.

A pickup_time should be one of the following types:

=over

=item C<Str>

=back

=head2 C<_has_pickup_time>

A predicate for the L</pickup_time> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::Reservation>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2020 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
