use utf8;

package SemanticWeb::Schema::PaymentMethod;

# ABSTRACT: A payment method is a standardized procedure for transferring the monetary amount for a purchase

use Moo;

extends qw/ SemanticWeb::Schema::Enumeration /;


use MooX::JSON_LD 'PaymentMethod';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v14.0.0';




1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::PaymentMethod - A payment method is a standardized procedure for transferring the monetary amount for a purchase

=head1 VERSION

version v14.0.0

=head1 DESCRIPTION

A payment method is a standardized procedure for transferring the monetary amount for a purchase. Payment methods are characterized by the legal and technical structures used, and by the organization or group carrying out the transaction.

Commonly used values:

=over

=item *

http://purl.org/goodrelations/v1#ByBankTransferInAdvance

=item *

http://purl.org/goodrelations/v1#ByInvoice

=item *

http://purl.org/goodrelations/v1#Cash

=item *

http://purl.org/goodrelations/v1#CheckInAdvance

=item *

http://purl.org/goodrelations/v1#COD

=item *

http://purl.org/goodrelations/v1#DirectDebit

=item *

http://purl.org/goodrelations/v1#GoogleCheckout

=item *

http://purl.org/goodrelations/v1#PayPal

=item *

http://purl.org/goodrelations/v1#PaySwarm

=back

=head1 SEE ALSO

L<SemanticWeb::Schema::Enumeration>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2022 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
