use utf8;

package SemanticWeb::Schema::OccupationalExperienceRequirements;

# ABSTRACT: Indicates employment-related experience requirements

use Moo;

extends qw/ SemanticWeb::Schema::Intangible /;


use MooX::JSON_LD 'OccupationalExperienceRequirements';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v13.0.0';


has months_of_experience => (
    is        => 'rw',
    predicate => '_has_months_of_experience',
    json_ld   => 'monthsOfExperience',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::OccupationalExperienceRequirements - Indicates employment-related experience requirements

=head1 VERSION

version v13.0.0

=head1 DESCRIPTION

Indicates employment-related experience requirements, e.g. [[monthsOfExperience]].

=head1 ATTRIBUTES

=head2 C<months_of_experience>

C<monthsOfExperience>

Indicates the minimal number of months of experience required for a
position.

A months_of_experience should be one of the following types:

=over

=item C<Num>

=back

=head2 C<_has_months_of_experience>

A predicate for the L</months_of_experience> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::Intangible>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2021 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
