#-*- mode: perl;-*-

use Test::More tests => 10;

use_ok('Module::MakefilePL::Parse');

{
  my $s = <<TEST1;
use 5.006001;
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    NAME              => 'Module::MakefilePL::Parse',
    VERSION_FROM      => 'lib/Module/MakefilePL/Parse.pm', # finds $VERSION
    PREREQ_PM         => { }, # e.g., Module::Name => 1.1
    ($] >= 5.005 ?     ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM  => 'lib/Module/MakefilePL/Parse.pm', # retrieve abstract from module
       AUTHOR         => 'Robert Rothenberg <rrwo at cpan.org>') : ()),
);
TEST1

#  print STDERR $s;

  my $m = Module::MakefilePL::Parse->new( $s );
  ok(defined $m);

  my $req = $m->required;
  ok(defined $req);
  ok((keys %$req) == 0);
}

{
  my $s = <<TEST2;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME              => 'Module::MakefilePL::Parse',
    VERSION_FROM      => 'lib/Module/MakefilePL/Parse.pm',
    PREREQ_PM         => {
      'Test::More' => 0,
    },
);

TEST2

#  print STDERR $s;

  my $m = Module::MakefilePL::Parse->new( $s );
  ok(defined $m);

  my $req = $m->required;
  ok(defined $req);
  ok((keys %$req) == 1);
}

{
  my $s = <<TEST3;
# Note: this file was auto-generated by Module::Build::Compat version 0.03
use ExtUtils::MakeMaker;
WriteMakefile
(
          'NAME' => 'List::SkipList',
          'VERSION_FROM' => 'lib/List/SkipList.pm',
          'PREREQ_PM' => {
                           'Test::More' => '0',
                           'enum' => '1.016'
                         },
          'INSTALLDIRS' => 'site',
          'PL_FILES' => {}
        )
;
TEST3

#  print STDERR $s;

  my $m = Module::MakefilePL::Parse->new( $s );
  ok(defined $m);

  my $req = $m->required;
  ok(defined $req);
  ok((keys %$req) == 2);
}
