/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.history;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jmx4perl.JmxRequest;
import org.jmx4perl.history.HistoryEntry;
import org.jmx4perl.history.HistoryKey;
import org.json.simple.JSONObject;

public class HistoryStore
implements Serializable {
    private static final long serialVersionUID = 42L;
    private int globalMaxEntries;
    private Map<HistoryKey, HistoryEntry> historyStore;

    public HistoryStore(int pTotalMaxEntries) {
        this.globalMaxEntries = pTotalMaxEntries;
        this.historyStore = new HashMap<HistoryKey, HistoryEntry>();
    }

    public int getGlobalMaxEntries() {
        return this.globalMaxEntries;
    }

    public void setGlobalMaxEntries(int pGlobalMaxEntries) {
        this.globalMaxEntries = pGlobalMaxEntries;
    }

    public void configure(HistoryKey pKey, int pMaxEntries) {
        int maxEntries;
        HistoryEntry entry = this.historyStore.get(pKey);
        if (pMaxEntries == 0) {
            if (entry != null) {
                this.historyStore.remove(pKey);
            }
            return;
        }
        int n = maxEntries = pMaxEntries > this.globalMaxEntries ? this.globalMaxEntries : pMaxEntries;
        if (entry != null) {
            entry.setMaxEntries(maxEntries);
            entry.trim();
        } else {
            entry = new HistoryEntry(maxEntries);
            this.historyStore.put(pKey, entry);
        }
    }

    public synchronized void reset() {
        this.historyStore = new HashMap<HistoryKey, HistoryEntry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateAndAdd(JmxRequest pJmxReq, JSONObject pJson) {
        HistoryEntry entry;
        long timestamp = System.currentTimeMillis() / 1000L;
        pJson.put((Object)"timestamp", (Object)timestamp);
        JmxRequest.Type type = pJmxReq.getType();
        if ((type == JmxRequest.Type.EXEC || type == JmxRequest.Type.READ || type == JmxRequest.Type.WRITE) && (entry = this.historyStore.get(new HistoryKey(pJmxReq))) != null) {
            HistoryEntry historyEntry = entry;
            synchronized (historyEntry) {
                pJson.put((Object)"history", entry.jsonifyValues());
                if (type == JmxRequest.Type.EXEC || type == JmxRequest.Type.READ) {
                    entry.add(pJson.get((Object)"value"), timestamp);
                } else if (type == JmxRequest.Type.WRITE) {
                    entry.add(pJmxReq.getValue(), timestamp);
                }
            }
        }
    }
}

