/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.history;

import java.io.Serializable;
import org.jmx4perl.JmxRequest;

public class HistoryKey
implements Serializable {
    private static final long serialVersionUID = 42L;
    private String type;
    private String mBean;
    private String secondary;
    private String path;
    private String target;

    HistoryKey(JmxRequest pJmxReq) {
        this.validate(pJmxReq);
        JmxRequest.Type rType = pJmxReq.getType();
        if (pJmxReq.getTargetConfig() != null) {
            this.target = pJmxReq.getTargetConfig().getUrl();
        }
        this.mBean = pJmxReq.getObjectNameAsString();
        if (rType == JmxRequest.Type.EXEC) {
            this.type = "operation";
            this.secondary = pJmxReq.getOperation();
            this.path = null;
        } else {
            this.type = "attribute";
            this.secondary = pJmxReq.getAttributeName();
            this.path = pJmxReq.getExtraArgsAsPath();
        }
        if (this.secondary == null) {
            throw new IllegalArgumentException(this.type + " name must not be null");
        }
    }

    private void validate(JmxRequest pJmxRequest) {
        JmxRequest.Type rType = pJmxRequest.getType();
        if (rType != JmxRequest.Type.EXEC && rType != JmxRequest.Type.READ && rType != JmxRequest.Type.WRITE) {
            throw new IllegalArgumentException("History supports only READ/WRITE/EXEC commands (and not " + (Object)((Object)rType) + ")");
        }
        if (pJmxRequest.getObjectNameAsString() == null) {
            throw new IllegalArgumentException("Mbean name must not be null");
        }
    }

    public HistoryKey(String pMBean, String pOperation, String pTarget) {
        this.type = "operation";
        this.mBean = pMBean;
        this.secondary = pOperation;
        this.path = null;
        this.target = pTarget;
    }

    public HistoryKey(String pMBean, String pAttribute, String pPath, String pTarget) {
        this.type = "attribute";
        this.mBean = pMBean;
        this.secondary = pAttribute;
        this.path = pPath;
        this.target = pTarget;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryKey that = (HistoryKey)o;
        if (!this.mBean.equals(that.mBean)) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (!this.secondary.equals(that.secondary)) {
            return false;
        }
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.mBean.hashCode();
        result = 31 * result + this.secondary.hashCode();
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        return result;
    }
}

