/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jmx4perl.converter.StringToObjectConverter;
import org.jmx4perl.converter.json.ObjectToJsonConverter;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapHandler
implements ObjectToJsonConverter.Handler {
    private static final int MAX_STRING_LENGTH = 400;

    @Override
    public Class getType() {
        return Map.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pExtraArgs, boolean jsonify) throws AttributeNotFoundException {
        Map map = (Map)pValue;
        int length = pConverter.getCollectionLength(map.size());
        if (!pExtraArgs.isEmpty()) {
            String decodedKey = pExtraArgs.pop();
            for (Map.Entry entry : map.entrySet()) {
                if (!decodedKey.equals(entry.getKey().toString())) continue;
                return pConverter.extractObject(entry.getValue(), pExtraArgs, jsonify);
            }
            throw new IllegalArgumentException("Map key '" + decodedKey + "' is unknown for map " + this.trimString(pValue.toString()));
        }
        if (jsonify) {
            JSONObject ret = new JSONObject();
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                ret.put(entry.getKey(), pConverter.extractObject(entry.getValue(), pExtraArgs, jsonify));
                if (++i <= length) continue;
                break;
            }
            return ret;
        }
        return map;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, String pValueS) throws IllegalAccessException, InvocationTargetException {
        Map map = (Map)pInner;
        Object oldValue = null;
        String oldKey = pAttribute;
        for (Map.Entry entry : map.entrySet()) {
            if (!pAttribute.equals(entry.getKey().toString())) continue;
            oldValue = entry.getValue();
            oldKey = entry.getKey();
            break;
        }
        String value = oldValue != null ? pConverter.convertFromString(oldValue.getClass().getName(), pValueS) : pValueS;
        map.put(oldKey, value);
        return oldValue;
    }

    private String trimString(String pString) {
        if (pString.length() > 400) {
            return pString.substring(0, 400) + " ...";
        }
        return pString;
    }
}

