/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jmx4perl.JmxRequest;
import org.jmx4perl.config.IpChecker;
import org.jmx4perl.config.Restrictor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyBasedRestrictor
implements Restrictor {
    private Set<JmxRequest.Type> typeSet;
    private Set<ObjectName> patternNameSet;
    private Map<ObjectName, Set<String>> mBeanReadAttributes;
    private Map<ObjectName, Set<String>> mBeanWriteAttributes;
    private Map<ObjectName, Set<String>> mBeanOperations;
    private Set<String> allowedHostsSet;
    private Set<String> allowedSubnetsSet;
    private static final Pattern IP_PATTERN = Pattern.compile("^[\\d.]+$");
    private static final Pattern SUBNET_PATTERN = Pattern.compile("^[\\d.]+/[\\d.]+$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyBasedRestrictor(InputStream pInput) {
        block11: {
            Exception exp = null;
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(pInput);
                this.initTypeSet(doc);
                this.initMBeanSets(doc);
                this.initAllowedHosts(doc);
            }
            catch (SAXException e) {
                exp = e;
                return exp;
            }
            catch (IOException e) {
                exp = e;
                return exp;
            }
            catch (ParserConfigurationException e) {
                exp = e;
                return exp;
            }
            catch (MalformedObjectNameException e) {
                exp = e;
                return exp;
            }
            finally {
                if (exp == null) break block11;
                throw new IllegalStateException("Cannot parse policy file", exp);
            }
        }
    }

    @Override
    public boolean isTypeAllowed(JmxRequest.Type pType) {
        return this.typeSet == null || this.typeSet.contains((Object)pType);
    }

    @Override
    public boolean isAttributeReadAllowed(ObjectName pName, String pAttribute) {
        return this.lookupMBean(this.mBeanReadAttributes, pName, pAttribute);
    }

    @Override
    public boolean isAttributeWriteAllowed(ObjectName pName, String pAttribute) {
        return this.lookupMBean(this.mBeanWriteAttributes, pName, pAttribute);
    }

    @Override
    public boolean isOperationAllowed(ObjectName pName, String pOperation) {
        return this.lookupMBean(this.mBeanOperations, pName, pOperation);
    }

    @Override
    public boolean isRemoteAccessAllowed(String ... pHostOrAddress) {
        if (this.allowedHostsSet == null) {
            return true;
        }
        for (String addr : pHostOrAddress) {
            if (this.allowedHostsSet.contains(addr)) {
                return true;
            }
            if (this.allowedSubnetsSet == null || !IP_PATTERN.matcher(addr).matches()) continue;
            for (String subnet : this.allowedSubnetsSet) {
                if (!IpChecker.matches(subnet, addr)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean lookupMBean(Map<ObjectName, Set<String>> pMap, ObjectName pName, String pAttribute) {
        ObjectName pattern;
        if (pMap == null) {
            return true;
        }
        Set<String> attributes = pMap.get(pName);
        if (attributes == null && (pattern = this.findMatchingMBeanPattern(pName)) != null) {
            attributes = pMap.get(pattern);
        }
        return attributes != null && attributes.contains(pAttribute);
    }

    private ObjectName findMatchingMBeanPattern(ObjectName pName) {
        for (ObjectName pattern : this.patternNameSet) {
            if (!pattern.apply(pName)) continue;
            return pattern;
        }
        return null;
    }

    private void initTypeSet(Document pDoc) {
        NodeList nodes = pDoc.getElementsByTagName("commands");
        if (nodes.getLength() > 0) {
            this.typeSet = new HashSet<JmxRequest.Type>();
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NodeList childs = node.getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                Node commandNode = childs.item(j);
                if (commandNode.getNodeType() != 1) continue;
                this.assertNodeName(commandNode, "command");
                String typeName = commandNode.getTextContent().trim();
                JmxRequest.Type type = JmxRequest.Type.valueOf(typeName.toUpperCase());
                this.typeSet.add(type);
            }
        }
    }

    private void initMBeanSets(Document pDoc) throws MalformedObjectNameException {
        NodeList nodes = pDoc.getElementsByTagName("mbeans");
        if (nodes.getLength() > 0) {
            this.patternNameSet = new HashSet<ObjectName>();
            this.mBeanReadAttributes = new HashMap<ObjectName, Set<String>>();
            this.mBeanWriteAttributes = new HashMap<ObjectName, Set<String>>();
            this.mBeanOperations = new HashMap<ObjectName, Set<String>>();
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            NodeList childs = node.getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                Node mBeanNode = childs.item(j);
                if (mBeanNode.getNodeType() != 1) continue;
                this.assertNodeName(mBeanNode, "mbean");
                NodeList params = mBeanNode.getChildNodes();
                String name = null;
                HashSet<String> readAttributes = new HashSet<String>();
                HashSet<String> writeAttributes = new HashSet<String>();
                HashSet<String> operations = new HashSet<String>();
                for (int k = 0; k < params.getLength(); ++k) {
                    Node param = params.item(k);
                    if (param.getNodeType() != 1) continue;
                    this.assertNodeName(param, "name", "attribute", "operation");
                    String tag = param.getNodeName();
                    if (tag.equals("name")) {
                        if (name != null) {
                            throw new IllegalStateException("<name> given twice as MBean name");
                        }
                        name = param.getTextContent().trim();
                        continue;
                    }
                    if (tag.equals("attribute")) {
                        Node mode = param.getAttributes().getNamedItem("mode");
                        readAttributes.add(param.getTextContent().trim());
                        if (mode != null && mode.getNodeValue().equalsIgnoreCase("read")) continue;
                        writeAttributes.add(param.getTextContent().trim());
                        continue;
                    }
                    operations.add(param.getTextContent().trim());
                }
                if (name == null) {
                    throw new IllegalStateException("No <name> given for <mbean>");
                }
                ObjectName oName = new ObjectName(name);
                if (oName.isPattern()) {
                    this.patternNameSet.add(oName);
                }
                this.mBeanReadAttributes.put(oName, readAttributes);
                this.mBeanWriteAttributes.put(oName, writeAttributes);
                this.mBeanOperations.put(oName, operations);
            }
        }
    }

    private void initAllowedHosts(Document pDoc) {
        NodeList nodes = pDoc.getElementsByTagName("remote");
        if (nodes.getLength() == 0) {
            this.allowedHostsSet = null;
            return;
        }
        this.allowedHostsSet = new HashSet<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NodeList childs = node.getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                Node hostNode = childs.item(j);
                if (hostNode.getNodeType() != 1) continue;
                this.assertNodeName(hostNode, "host");
                String host = hostNode.getTextContent().trim().toLowerCase();
                if (SUBNET_PATTERN.matcher(host).matches()) {
                    if (this.allowedSubnetsSet == null) {
                        this.allowedSubnetsSet = new HashSet<String>();
                    }
                    this.allowedSubnetsSet.add(host);
                    continue;
                }
                this.allowedHostsSet.add(host);
            }
        }
    }

    private void assertNodeName(Node pNode, String ... pExpected) {
        for (String expected : pExpected) {
            if (!pNode.getNodeName().equals(expected)) continue;
            return;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < pExpected.length; ++i) {
            buffer.append(pExpected[i]);
            if (i >= pExpected.length - 1) continue;
            buffer.append(",");
        }
        throw new IllegalStateException("Expected element " + buffer.toString() + " but got " + pNode.getNodeName());
    }
}

