package UnixODBC;

use strict;
use warnings;
use Carp;

require Exporter;
require DynaLoader;
use AutoLoader;
our @ISA = qw(Exporter DynaLoader);
our @EXPORT_OK = qw($SQL_NULL_DATA $SQL_DATA_AT_EXEC $SQL_HANDLE_ENV 
 $SQL_SUCCESS $SQL_SUCCESS_WITH_INFO $SQL_NO_DATA $SQL_ERROR 
 $SQL_INVALID_HANDLE $SQL_STILL_EXECUTING $SQL_NEED_DATA $SQL_NTS $SQL_NTSL 
 $SQL_MAX_MESSAGE_LENGTH $SQL_DATE_LEN $SQL_TIME_LEN $SQL_TIMESTAMP_LEN
 $SQL_HANDLE_STMT $SQL_HANDLE_DESC $SQL_HANDLE_DBC $SQL_ATTR_OUTPUT_NTS 
 $SQL_ATTR_ODBC_VERSION $SQL_ATTR_CONNECTION_POOLING $SQL_ATTR_CP_MATCH
 $SQL_OV_ODBC2 $SQL_OV_ODBC3 $SQL_CP_OFF $SQL_CP_ONE_PER_DRIVER 
 $SQL_CP_ONE_PER_HENV $SQL_CP_DEFAULT $SQL_CP_STRICT_MATCH 
 $SQL_CP_RELAXED_MATCH $SQL_CP_MATCH_DEFAULT $SQL_ATTR_AUTO_IPD 
 $SQL_ATTR_METADATA_ID $SQL_ATTR_APP_ROW_DESC $SQL_ATTR_APP_PARAM_DES
 $SQL_ATTR_IMP_ROW_DESC $SQL_ATTR_IMP_PARAM_DESC $SQL_ATTR_CURSOR_SCROLLABLE 
 $SQL_ATTR_CURSOR_SENSITIVITY $SQL_NONSCROLLABLE $SQL_SCROLLABLE 
 $SQL_DESC_COUNT $SQL_DESC_TYPE $SQL_DESC_LENGTH $SQL_DESC_OCTET_LENGTH_PTR
 $SQL_DESC_PRECISION $SQL_DESC_SCALE $SQL_DESC_OCTET_LENGTH_PTR 
 $SQL_DESC_PRECISION $SQL_DESC_SCALE $SQL_DESC_DATATIME_INTERVAL_CODE
 $SQL_DESC_NULLABLE $SQL_DESC_INDICATOR_PTR $SQL_DESC_DATA_PTR $SQL_DESC_NAME
 $SQL_DESC_UNNAMED$SQL_DESC_OCTET_LENGTH $SQL_DESC_ALLOC_TYPE
 $SQL_DIAG_RETURNCODE $SQL_DIAG_NUMBER $SQL_DIAG_ROW_COUNT $SQL_DIAG_SQLSTATE
 $SQL_DIAG_NATIVE $SQL_DIAG_MESSAGE_TEXT $SQL_DIAG_DYNAMIC_FUNCTION 
 $SQL_DIAG_CLASS_ORIGIN $SQL_DIAG_SUBCLASS_ORIGIN $SQL_DIAG_CONNECTION_NAME
 $SQL_DIAG_SERVER_NAME $SQL_DIAG_DYNAMIC_FUNCTION_CODE $SQL_DIAG_ALTER_DOMAIN
 $SQL_DIAG_ALTER_TABLE $SQL_DIAG_CALL $SQL_DIAG_CREATE_ASSERTION
 $SQL_DIAG_CREATE_CHARACTER_SET $SQL_DIAG_CREATE_COLLATION 
 $SQL_DIAG_CREATE_DOMAIN $SQL_DIAG_CREATE_INDEX $SQL_DIAG_CREATE_SCHEMA
 $SQL_DIAG_CREATE_TABLE $SQL_DIAG_CREATE_TRANSLATION $SQL_DIAG_CREATE_VIEW 
 $SQL_DIAG_DELETE_WHERE $SQL_DIAG_DROP_ASSERTION $SQL_DIAG_DROP_CHARACTER_SET
 $SQL_DIAG_DROP_COLLATION $SQL_DIAG_DROP_DOMAIN $SQL_DIAG_DROP_INDEX 
 $SQL_DIAG_DROP_SCHEMA $SQL_DIAG_DROP_TABLE $SQL_DIAG_DROP_TRANSLATION
 $SQL_DIAG_DROP_VIEW $SQL_DIAG_DYNAMIC_DELETE_CURSOR 
 $SQL_DIAG_DYNAMIC_UPDATE_CURSOR $SQL_DIAG_GRANT $SQL_DIAG_INSERT 
 $SQL_DIAG_REVOKE $SQL_DIAG_SELECT_CURSOR $SQL_DIAG_UNKNOWN_STATEMENT
 $SQL_DIAG_UPDATE_WHERE $SQL_UNKNOWN_TYPE $SQL_CHAR $SQL_NUMERIC $SQL_DECIMAL
 $SQL_INTEGER $SQL_SMALLINT $SQL_FLOAT $SQL_REAL $SQL_DOUBLE $SQL_DATETIME 
 $SQL_VARCHAR $SQL_UNSPECIFIED $SQL_INSENSITIVE $SQL_SENSITIVE $SQL_ALL_TYPES
 $SQL_DEFAULT $SQL_ARD_TYPE $SQL_CODE_DATE $SQL_CODE_TIME 
 $SQL_CODE_TIMESTAMP $SQL_FALSE $SQL_TRUE $SQL_NULLABLE_UNKNOWN 
 $SQL_PRED_NONE $SQL_PRED_CHAR $SQL_PRED_BASIC $SQL_NAMED $SQL_UNNAMED 
 $SQL_DESC_ALLOC_AUTO $SQL_DESC_ALLOC_USER $SQL_CLOSE $SQL_DROP $SQL_UNBIND 
 $SQL_RESET_PARAMS $SQL_FETCH_NEXT $SQL_FETCH_FIRST $SQL_FETCH_LAST 
 $SQL_FETCH_PRIOR $SQL_FETCH_ABSOLUTE $SQL_FETCH_RELATIVE 
 $SQL_FETCH_FIRST_USER $SQL_FETCH_FIRST_SYSTEM 
 $SQL_NULL_HENV 
 $SQL_NULL_HDBC $SQL_NULL_HSTMT $SQL_NULL_HDESC $SQL_NULL_HANDLE 
 $SQL_SCOPE_CURROW $SQL_SCOPE_TRANSACTION $SQL_SCOPE_SESSION $SQL_PC_UNKNOWN 
 $SQL_PC_NON_PSEUDO $SQL_PC_PSEUDO $SQL_ROW_IDENTIFIER $SQL_INDEX_UNIQUE 
 $SQL_INDEX_ALL $SQL_INDEX_CLUSTERED $SQL_INDEX_HASHED $SQL_INDEX_OTHER 
 $SQL_API_SQLALLOCCONNECT $SQL_API_SQLALLOCENV $SQL_API_SQLALLOCHANDLE 
 $SQL_API_SQLALLOCSTMT $SQL_API_SQLBINDCOL $SQL_API_SQLBINDPARAM 
 $SQL_API_SQLCANCEL $SQL_API_SQLCLOSECURSOR $SQL_API_SQLCOLATTRIBUTE 
 $SQL_API_SQLCOLUMNS $SQL_API_SQLCONNECT $SQL_API_SQLCOPYDESC 
 $SQL_API_SQLDATASOURCES $SQL_API_SQLDESCRIBECOL $SQL_API_SQLDISCONNECT 
 $SQL_API_SQLENDTRAN $SQL_API_SQLERROR $SQL_API_SQLEXECDIRECT 
 $SQL_API_SQLEXECUTE $SQL_API_SQLFETCH $SQL_API_SQLFETCHSCROLL 
 $SQL_API_SQLFREECONNECT $SQL_API_SQLFREEENV $SQL_API_SQLFREEHANDLE 
 $SQL_API_SQLFREESTMT $SQL_API_SQLGETCONNECTATTR 
 $SQL_API_SQLGETCONNECTOPTION $SQL_API_SQLGETCURSORNAME
 $SQL_API_SQLGETDATA $SQL_API_SQLGETDESCFIELD $SQL_API_SQLGETDESCREC 
 $SQL_API_SQLGETDIAGFIELD $SQL_API_SQLGETDIAGREC $SQL_API_SQLGETENVATTR 
 $SQL_API_SQLGETFUNCTIONS $SQL_API_SQLGETINFO $SQL_API_SQLGETSTMTATTR 
 $SQL_API_SQLGETSTMTOPTION $SQL_API_SQLGETTYPEINFO $SQL_API_SQLNUMRESULTCOLS 
 $SQL_API_SQLPARAMDATA $SQL_API_SQLPREPARE $SQL_API_SQLPUTDATA 
 $SQL_API_SQLROWCOUNT $SQL_API_SQLSETCONNECTATTR $SQL_API_SQLSETCONNECTOPTION 
 $SQL_API_SQLSETCURSORNAME $SQL_API_SQLSETDESCFIELD $SQL_API_SQLSETDESCREC 
 $SQL_API_SQLSETENVATTR $SQL_API_SQLSETPARAM $SQL_API_SQLSETSTMTATTR 
 $SQL_API_SQLSETSTMTOPTION $SQL_API_SQLSPECIALCOLUMNS $SQL_API_SQLSTATISTICS 
 $SQL_API_SQLTABLES $SQL_API_SQLTRANSACT $SQL_MAX_DRIVER_CONNECTIONS
 $SQL_MAXIMUM_DRIVER_CONNECTIONS $SQL_MAX_CONCURRENT_ACTIVITIES 
 $SQL_MAXIMUM_CONCURRENT_ACTIVITIES $SQL_DATA_SOURCE_NAME 
 $SQL_FETCH_DIRECTION $SQL_SERVER_NAME $SQL_SEARCH_PATTERN_ESCAPE 
 $SQL_DBMS_NAME $SQL_DBMS_VER $SQL_ACCESSIBLE_TABLES 
 $SQL_ACCESSIBLE_PROCEDURES $SQL_CURSOR_COMMIT_BEHAVIOR
 $SQL_DATA_SOURCE_READ_ONLY $SQL_DEFAULT_TXN_ISOLATION $SQL_IDENTIFIER_CASE 
 $SQL_IDENTIFIER_QUOTE_CHAR $SQL_MAX_COLUMN_NAME_LEN 
 $SQL_MAXIMUM_COLUMN_NAME_LENGTH $SQL_MAX_CURSOR_NAME_LEN 
 $SQL_MAXIMUM_CURSOR_NAME_LENGTH $SQL_MAX_SCHEMA_NAME_LEN 
 $SQL_MAXIMUM_SCHEMA_NAME_LENGTH $SQL_MAX_CATALOG_NAME_LEN 
 $SQL_MAXIMUM_CATALOG_NAME_LENGTH $SQL_MAX_TABLE_NAME_LEN 
 $SQL_SCROLL_CONCURRENCY $SQL_TXN_CAPABLE $SQL_TRANSACTION_CAPABLE 
 $SQL_USER_NAME $SQL_TXN_ISOLATION_OPTION $SQL_TRANSACTION_ISOLATION_OPTION 
 $SQL_INTEGRITY $SQL_GETDATA_EXTENSIONS $SQL_NULL_COLLATION $SQL_ALTER_TABLE 
 $SQL_ORDER_BY_COLUMNS_IN_SELECT $SQL_SPECIAL_CHARACTERS 
 $SQL_MAX_COLUMNS_IN_GROUP_BY $SQL_MAXIMUM_COLUMNS_IN_GROUP_BY 
 $SQL_MAX_COLUMNS_IN_INDEX $SQL_MAXIMUM_COLUMNS_IN_INDEX 
 $SQL_MAX_COLUMNS_IN_ORDER_BY $SQL_MAXIMUM_COLUMNS_IN_ORDER_BY 
 $SQL_MAX_COLUMNS_IN_SELECT $SQL_MAXIMUM_COLUMNS_IN_SELECT 
 $SQL_MAX_COLUMNS_IN_TABLE $SQL_MAX_INDEX_SIZE $SQL_MAXIMUM_INDEX_SIZE 
 $SQL_MAX_ROW_SIZE $SQL_MAXIMUM_ROW_SIZE $SQL_MAX_STATEMENT_LEN 
 $SQL_MAXIMUM_STATEMENT_LENGTH $SQL_MAX_TABLES_IN_SELECT 
 $SQL_MAXIMUM_TABLES_IN_SELECT $SQL_MAX_USER_NAME_LEN 
 $SQL_MAXIMUM_USER_NAME_LENGTH $SQL_OJ_CAPABILITIES 
 $SQL_OUTER_JOIN_CAPABILITIES $SQL_XOPEN_CLI_YEAR $SQL_CURSOR_SENSITIVITY 
 $SQL_DESCRIBE_PARAMETER $SQL_CATALOG_NAME $SQL_COLLATION_SEQ 
 $SQL_MAX_IDENTIFIER_LEN $SQL_MAXIMUM_IDENTIFIER_LENGTH 
 $SQL_AT_ADD_COLUMN $SQL_AT_DROP_COLUMN $SQL_AT_ADD_CONSTRAINT 
 $SQL_AT_COLUMN_SINGLE $SQL_AT_ADD_COLUMN_DEFAULT 
 $SQL_AT_ADD_COLUMN_COLLATION $SQL_AT_SET_COLUMN_DEFAULT 
 $SQL_AT_DROP_COLUMN_DEFAULT $SQL_AT_DROP_COLUMN_CASCADE 
 $SQL_AT_DROP_COLUMN_RESTRICT $SQL_AT_ADD_TABLE_CONSTRAINT 
 $SQL_AT_DROP_TABLE_CONSTRAINT_CASCADE $SQL_AT_DROP_TABLE_CONSTRAINT_RESTRICT 
 $SQL_AT_CONSTRAINT_NAME_DEFINITION $SQL_AT_CONSTRAINT_INITIALLY_DEFERRED 
 $SQL_AT_CONSTRAINT_INITIALLY_IMMEDIATE $SQL_AT_CONSTRAINT_DEFERRABLE 
 $SQL_AT_CONSTRAINT_NON_DEFERRABLE $SQL_AM_NONE $SQL_AM_CONNECTION 
 $SQL_AM_STATEMENT $SQL_CB_DELETE $SQL_CB_CLOSE $SQL_CB_PRESERVE 
 $SQL_FD_FETCH_NEXT $SQL_FD_FETCH_FIRST $SQL_FD_FETCH_LAST 
 $SQL_FD_FETCH_PRIOR $SQL_FD_FETCH_ABSOLUTE $SQL_FD_FETCH_RELATIVE 
 $SQL_GD_ANY_COLUMN $SQL_GD_ANY_ORDER $SQL_IC_UPPER $SQL_IC_LOWER 
 $SQL_IC_SENSITIVE $SQL_IC_MIXED $SQL_OJ_LEFT $SQL_OJ_RIGHT $SQL_OJ_FULL 
 $SQL_OJ_NESTED $SQL_OJ_NOT_ORDERED $SQL_OJ_INNER $SQL_OJ_ALL_COMPARISON_OPS 
 $SQL_SCCO_READ_ONLY $SQL_SCCO_LOCK $SQL_SCCO_OPT_ROWVER 
 $SQL_SCCO_OPT_VALUES $SQL_TC_NONE $SQL_TC_DML $SQL_TC_ALL $SQL_TC_DDL_COMMIT
 $SQL_TC_DDL_IGNORE $SQL_TXN_READ_UNCOMMITTED 
 $SQL_TRANSACTION_READ_UNCOMMITTED $SQL_TXN_READ_COMMITTED 
 $SQL_TRANSACTION_READ_COMMITTED $SQL_TXN_REPEATABLE_READ 
 $SQL_TRANSACTION_REPEATABLE_READ $SQL_TXN_SERIALIZABLE 
 $SQL_TRANSACTION_SERIALIZABLE $SQL_NC_HIGH $SQL_NC_LOW 
 $SQL_HANDLE_SENV $SQL_NO_DATA_FOUND $SQL_DATETIME $SQL_INTERVAL $SQL_TIME 
 $SQL_TIME $SQL_LONGVARCHAR $SQL_BINARY $SQL_VARBINARY $SQL_LONGVARBINARY 
 $SQL_BIGINT $SQL_TINYINT $SQL_BIT $SQL_GUID $SQL_INTERVAL_YEAR 
 $SQL_INTERVAL_MONTH $SQL_INTERVAL_YEAR_TO_MONTH $SQL_INTERVAL_DAY 
 $SQL_INTERVAL_HOUR $SQL_INTERVAL_MINUTE $SQL_INTERVAL_SECOND 
 $SQL_INTERVAL_DAY_TO_HOUR $SQL_INTERVAL_DAY_TO_MINUTE 
 $SQL_INTERVAL_DAY_TO_SECOND $SQL_INTERVAL_HOUR_TO_MINUTE
 $SQL_INTERVAL_HOUR_TO_SECOND $SQL_INTERVAL_MINUTE_TO_SECOND
 $SQL_WCHAR $SQL_WVARCHAR $SQL_WLONGVARCHAR $SQL_C_WCHAR
 $SQL_UNICODE $SQL_UNICODE_VARCHAR $SQL_UNICODE_LONGVARCHAR $SQL_UNICODE_CHAR
 $SQL_TYPE_DRIVER_START $SQL_TYPE_DRIVER_END $SQL_SIGNED_OFFSET 
 $SQL_UNSIGNED_OFFSET $SQL_C_CHAR $SQL_C_LONG $SQL_INTEGER $SQL_C_SHORT 
 $SQL_C_FLOAT $SQL_C_DOUBLE $SQL_C_NUMERIC $SQL_C_DEFAULT $SQL_C_TIME
 $SQL_C_TIMESTAMP $SQL_C_BINARY $SQL_C_BIT $SQL_C_TINYINT $SQL_C_SLONG 
 $SQL_C_SSHORT $SQL_C_ULONG $SQL_C_USHORT $SQL_C_UTINYINT $SQL_C_BOOKMARK
 $SQL_C_DATE $SQL_C_TIME $SQL_C_TIMESTAMP $SQL_C_BINARY $SQL_C_BIT
 $SQL_C_STINYINT $SQL_TYPE_NULL $SQL_TYPE_MIN $SQL_TYPE_MAX 
 $SQL_DEFAULT_PARAM $SQL_IGNORE $SQL_LEN_DATA_AT_EXEC_OFFSET 
 SQL_LEN_DATA_AT_EXEC $SQL_COLUMN_IGNORE $SQL_C_TYPE_DATE $SQL_C_TYPE_TIME 
 $SQL_C_TYPE_TIMESTAMP $SQL_C_INTERVAL_YEAR $SQL_C_INTERVAL_MONTH 
 $SQL_C_INTERVAL_DAY $SQL_C_INTERVAL_HOUR $SQL_C_INTERVAL_MINUTE 
 $SQL_C_INTERVAL_SECOND $SQL_C_INTERVAL_YEAR_TO_MONTH $SQL_C_INTERVAL_DAY_TO_HOUR 
 $SQL_C_INTERVAL_DAY_TO_MINUTE $SQL_C_INTERVAL_DAY_TO_SECOND 
 $SQL_C_INTERVAL_HOUR_TO_MINUTE $SQL_C_INTERVAL_HOUR_TO_SECOND 
 $SQL_C_INTERVAL_MINUTE_TO_SECOND $SQL_C_SBIGINT $SQL_C_UBIGINT 
 $SQL_C_GUID $SQL_C_VARBOOKMARK $SQL_TYPE_DATE $SQL_TYPE_TIME
 $SQL_TYPE_TIMESTAMP $SQL_COLUMN_NAME $SQL_COLUMN_TYPE
 $SQL_LEN_BINARY_ATTR_OFFSET SQL_LEN_BINARY_ATTR $SQL_COLUMN_COUNT
 $SQL_COLUMN_LENGTH $SQL_COLUMN_PRECISION $SQL_COLUMN_SCALE 
 $SQL_COLUMN_DISPLAY_SIZE $SQL_COLUMN_NULLABLE $SQL_COLUMN_UNSIGNED 
 $SQL_COLUMN_MONEY $SQL_COLUMN_UPDATABLE $SQL_COLUMN_AUTO_INCREMENT 
 $SQL_COLUMN_CASE_SENSITIVE $SQL_COLUMN_SEARCHABLE $SQL_COLUMN_TYPE_NAME 
 $SQL_COLUMN_TABLE_NAME $SQL_COLUMN_OWNER_NAME $SQL_COLUMN_QUALIFIER_NAME 
 $SQL_COLUMN_LABEL $SQL_COLATT_OPT_MAX $SQL_COLUMN_DRIVER_START 
 $SQL_COLATT_OPT_MIN $SQL_ATTR_READONLY $SQL_ATTR_WRITE 
 $SQL_ATTR_READWRITE_UNKNOWN $SQL_UNSEARCHABLE $SQL_LIKE_ONLY 
 $SQL_ALL_EXCEPT_LIKE $SQL_SEARCHABLE $SQL_PRED_SEARCHABLE 
 $SQL_DRIVER_NOPROMPT $SQL_DRIVER_COMPLETE $SQL_DRIVER_PROMPT 
 $SQL_DRIVER_COMPLETE_REQUIRED $SQL_ACCESS_MODE $SQL_AUTOCOMMIT 
 $SQL_LOGIN_TIMEOUT $SQL_OPT_TRACE $SQL_OPT_TRACEFILE 
 $SQL_TRANSLATE_DLL $SQL_TRANSLATE_OPTION $SQL_TXN_ISOLATION 
 $SQL_CURRENT_QUALIFIER $SQL_ODBC_CURSORS $SQL_QUIET_MODE $SQL_PACKET_SIZE 
 $SQL_ATTR_CONNECTION_DEAD $SQL_MODE_READ_WRITE $SQL_MODE_READ_ONLY
 $SQL_MODE_DEFAULT $SQL_AUTOCOMMIT_OFF $SQL_AUTOCOMMIT_ON 
 $SQL_AUTOCOMMIT_DEFAULT $SQL_CUR_USE_IF_NEEDED $SQL_CUR_USE_ODBC 
 $SQL_CUR_USE_DRIVER $SQL_CUR_DEFAULT $SQL_OPT_TRACE_OFF 
 $SQL_OPT_TRACE_ON $SQL_OPT_TRACE_DEFAULT $SQL_OPT_TRACE_FILE_DEFAULT 
 $SQL_CD_TRUE $SQL_CD_FALSE $SQL_EXT_API_LAST $SQL_NUM_FUNCTIONS 
 $SQL_EXT_API_START $SQL_NUM_EXTENSIONS $SQL_API_SQLALLOCHANDLESTD 
 $SQL_API_SQLBULKOPERATIONS $SQL_API_SQLBINDPARAMETER 
 $SQL_API_SQLBROWSECONNECT $SQL_API_SQLCOLATTRIBUTES 
 $SQL_API_SQLCOLUMNPRIVILEGES $SQL_API_SQLDESCRIBEPARAM 
 $SQL_API_SQLDRIVERCONNECT $SQL_API_SQLDRIVERS $SQL_API_SQLEXTENDEDFETCH 
 $SQL_API_SQLFOREIGNKEYS $SQL_API_SQLMORERESULTS $SQL_API_SQLNATIVESQL 
 $SQL_API_SQLNUMPARAMS $SQL_API_SQLPARAMOPTIONS $SQL_API_SQLPRIMARYKEYS 
 $SQL_API_SQLPROCEDURECOLUMNS $SQL_API_SQLPROCEDURES $SQL_API_SQLSETPOS 
 $SQL_API_SQLSETSCROLLOPTIONS $SQL_API_SQLTABLEPRIVILEGES 
 $SQL_CODE_YEAR $SQL_CODE_MONTH $SQL_CODE_DAY $SQL_CODE_HOUR 
 $SQL_CODE_MINUTE $SQL_CODE_SECOND $SQL_CODE_YEAR_TO_MONTH 
 $SQL_CODE_DAY_TO_HOUR $SQL_CODE_DAY_TO_MINUTE $SQL_CODE_DAY_TO_SECOND 
 $SQL_CODE_HOUR_TO_MINUTE $SQL_CODE_HOUR_TO_SECOND 
 $SQL_CODE_MINUTE_TO_SECOND $SQL_ATTR_ACCESS_MODE $SQL_ATTR_AUTOCOMMIT 
 $SQL_ATTR_CONNECTION_TIMEOUT $SQL_ATTR_CURRENT_CATALOG 
 $SQL_ATTR_DISCONNECT_BEHAVIOR $SQL_ATTR_ENLIST_IN_DTC $SQL_ATTR_ENLIST_IN_XA 
 $SQL_ATTR_LOGIN_TIMEOUT $SQL_ATTR_ODBC_CURSORS $SQL_ATTR_PACKET_SIZE 
 $SQL_ATTR_QUIET_MODE $SQL_ATTR_TRACE $SQL_ATTR_TRACEFILE $SQL_ATTR_TRANSLATE_LIB 
 $SQL_ATTR_TRANSLATE_OPTION $SQL_ATTR_TXN_ISOLATION $SQL_AA_TRUE $SQL_AA_FALSE 
 $SQL_DB_RETURN_TO_POOL $SQL_DB_DISCONNECT $SQL_DB_DEFAULT $SQL_DTC_DONE
 $SQL_ATTR_ANSI_APP $SQL_DESC_ARRAY_SIZE $SQL_DESC_ARRAY_STATUS_PTR 
 $SQL_DESC_AUTO_UNIQUE_VALUE $SQL_DESC_BASE_COLUMN_NAME $SQL_DESC_BASE_TABLE_NAME 
 $SQL_DESC_BIND_OFFSET_PTR $SQL_DESC_BIND_TYPE $SQL_DESC_CASE_SENSITIVE 
 $SQL_DESC_CATALOG_NAME $SQL_DESC_CONCISE_TYPE 
 $SQL_DESC_DATETIME_INTERVAL_PRECISION $SQL_DESC_DISPLAY_SIZE 
 $SQL_DESC_FIXED_PREC_SCALE $SQL_DESC_LABEL $SQL_DESC_LITERAL_PREFIX 
 $SQL_DESC_LITERAL_SUFFIX $SQL_DESC_LOCAL_TYPE_NAME $SQL_DESC_MAXIMUM_SCALE 
 $SQL_DESC_MINIMUM_SCALE $SQL_DESC_NUM_PREC_RADIX $SQL_DESC_PARAMETER_TYPE 
 $SQL_DESC_ROWS_PROCESSED_PTR $SQL_DESC_ROWVER $SQL_DESC_SCHEMA_NAME 
 $SQL_DESC_SEARCHABLE $SQL_DESC_TYPE_NAME $SQL_DESC_TABLE_NAME 
 $SQL_DESC_UNSIGNED $SQL_DESC_UPDATABLE $SQL_DIAG_CURSOR_ROW_COUNT
 $SQL_DIAG_ROW_NUMBER $SQL_DIAG_COLUMN_NUMBER $SQL_NO_ROW_NUMBER 
 $SQL_NO_COLUMN_NUMBER $SQL_ROW_NUMBER_UNKNOWN 
 $SQL_COLUMN_NUMBER_UNKNOWN $SQL_API_ALL_FUNCTIONS $SQL_API_LOADBYORDINAL 
 $SQL_INFO_FIRST $SQL_ACTIVE_CONNECTIONS $SQL_ACTIVE_STATEMENTS 
 $SQL_DRIVER_HDBC $SQL_DRIVER_HENV $SQL_DRIVER_HSTMT $SQL_DRIVER_NAME 
 $SQL_DRIVER_VER $SQL_ODBC_API_CONFORMANCE $SQL_ODBC_VER $SQL_ROW_UPDATES 
 $SQL_ODBC_SAG_CLI_CONFORMANCE $SQL_ODBC_SQL_CONFORMANCE $SQL_PROCEDURES 
 $SQL_CONCAT_NULL_BEHAVIOR $SQL_CURSOR_ROLLBACK_BEHAVIOR 
 $SQL_EXPRESSIONS_IN_ORDERBY $SQL_MAX_OWNER_NAME_LEN $SQL_MAX_PROCEDURE_NAME_LEN 
 $SQL_MAX_QUALIFIER_NAME_LEN $SQL_MULT_RESULT_SETS $SQL_MULTIPLE_ACTIVE_TXN 
 $SQL_OUTER_JOINS $SQL_OWNER_TERM $SQL_PROCEDURE_TERM 
 $SQL_QUALIFIER_NAME_SEPARATOR $SQL_QUALIFIER_TERM $SQL_SCROLL_OPTIONS 
 $SQL_TABLE_TERM $SQL_CONVERT_FUNCTIONS $SQL_NUMERIC_FUNCTIONS 
 $SQL_STRING_FUNCTIONS $SQL_SYSTEM_FUNCTIONS $SQL_TIMEDATE_FUNCTIONS 
 $SQL_CONVERT_BIGINT $SQL_CONVERT_BINARY $SQL_CONVERT_BIT $SQL_CONVERT_CHAR
 $SQL_CONVERT_DATE $SQL_CONVERT_DECIMAL $SQL_CONVERT_DOUBLE $SQL_CONVERT_FLOAT 
 $SQL_CONVERT_INTEGER $SQL_CONVERT_LONGVARCHAR $SQL_CONVERT_NUMERIC 
 $SQL_CONVERT_REAL $SQL_CONVERT_SMALLINT $SQL_CONVERT_TIME $SQL_CONVERT_TIMESTAMP 
 $SQL_CONVERT_TINYINT $SQL_CONVERT_VARBINARY $SQL_CONVERT_VARCHAR 
 $SQL_CONVERT_LONGVARBINARY $SQL_ODBC_SQL_OPT_IEF $SQL_CORRELATION_NAME 
 $SQL_NON_NULLABLE_COLUMNS $SQL_DRIVER_HLIB $SQL_DRIVER_ODBC_VER 
 $SQL_LOCK_TYPES $SQL_POS_OPERATIONS $SQL_POSITIONED_STATEMENTS 
 $SQL_BOOKMARK_PERSISTENCE $SQL_STATIC_SENSITIVITY $SQL_FILE_USAGE 
 $SQL_COLUMN_ALIAS $SQL_GROUP_BY $SQL_KEYWORDS $SQL_OWNER_USAGE 
 $SQL_QUALIFIER_USAGE $SQL_QUOTED_IDENTIFIER_CASE $SQL_SUBQUERIES 
 $SQL_UNION $SQL_MAX_ROW_SIZE_INCLUDES_LONG $SQL_MAX_CHAR_LITERAL_LEN 
 $SQL_TIMEDATE_ADD_INTERVALS $SQL_TIMEDATE_DIFF_INTERVALS $SQL_NEED_LONG_DATA_LEN 
 $SQL_MAX_BINARY_LITERAL_LEN $SQL_LIKE_ESCAPE_CLAUSE $SQL_INFO_DRIVER_START
 $SQL_ACTIVE_ENVIRONMENTS $SQL_ALTER_DOMAIN $SQL_SQL_CONFORMANCE 
 $SQL_DATETIME_LITERALS $SQL_ASYNC_MODE $SQL_BATCH_ROW_COUNT $SQL_BATCH_SUPPORT 
 $SQL_CATALOG_LOCATION $SQL_CATALOG_NAME_SEPARATOR $SQL_CATALOG_TERM 
 $SQL_CATALOG_USAGE $SQL_CONVERT_WCHAR $SQL_CONVERT_INTERVAL_DAY_TIME 
 $SQL_CONVERT_INTERVAL_YEAR_MONTH $SQL_CONVERT_WLONGVARCHAR $SQL_CONVERT_WVARCHAR 
 $SQL_CREATE_ASSERTION $SQL_CREATE_CHARACTER_SET $SQL_CREATE_COLLATION 
 $SQL_CREATE_DOMAIN $SQL_CREATE_SCHEMA $SQL_CREATE_TABLE $SQL_CREATE_TRANSLATION 
 $SQL_CREATE_VIEW $SQL_DRIVER_HDESC $SQL_DROP_ASSERTION $SQL_DROP_CHARACTER_SET
 $SQL_DROP_COLLATION $SQL_DROP_DOMAIN $SQL_DROP_SCHEMA $SQL_DROP_TABLE 
 $SQL_DROP_TRANSLATION $SQL_DROP_VIEW $SQL_DYNAMIC_CURSOR_ATTRIBUTES1
 $SQL_DYNAMIC_CURSOR_ATTRIBUTES2 $SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES1
 $SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES2 $SQL_INDEX_KEYWORDS $SQL_INFO_SCHEMA_VIEWS
 $SQL_KEYSET_CURSOR_ATTRIBUTES1 $SQL_KEYSET_CURSOR_ATTRIBUTES2
 $SQL_MAX_ASYNC_CONCURRENT_STATEMENTS $SQL_ODBC_INTERFACE_CONFORMANCE
 $SQL_PARAM_ARRAY_ROW_COUNTS $SQL_PARAM_ARRAY_SELECTS
 $SQL_SCHEMA_TERM $SQL_SCHEMA_USAGE $SQL_SQL92_DATETIME_FUNCTIONS
 $SQL_SQL92_FOREIGN_KEY_DELETE_RULE $SQL_SQL92_FOREIGN_KEY_UPDATE_RULE
 $SQL_SQL92_GRANT $SQL_SQL92_NUMERIC_VALUE_FUNCTIONS
 $SQL_SQL92_PREDICATES $SQL_SQL92_RELATIONAL_JOIN_OPERATORS
 $SQL_SQL92_REVOKE $SQL_SQL92_ROW_VALUE_CONSTRUCTOR
 $SQL_SQL92_STRING_FUNCTIONS $SQL_SQL92_VALUE_EXPRESSIONS
 $SQL_STANDARD_CLI_CONFORMANCE $SQL_STATIC_CURSOR_ATTRIBUTES1
 $SQL_STATIC_CURSOR_ATTRIBUTES2 $SQL_AGGREGATE_FUNCTIONS
 $SQL_DDL_INDEX $SQL_DM_VER $SQL_INSERT_STATEMENT $SQL_UNION_STATEMENT
 $SQL_DTC_TRANSITION_COST $SQL_AF_AVG $SQL_AF_COUNT $SQL_AF_MAX $SQL_AF_MIN
 $SQL_AF_SUM $SQL_AF_DISTINCT $SQL_AF_ALL $SQL_AD_CONSTRAINT_NAME_DEFINITION 
 $SQL_AD_ADD_DOMAIN_CONSTRAINT $SQL_AD_DROP_DOMAIN_CONSTRAINT 
 $SQL_AD_ADD_DOMAIN_DEFAULT $SQL_AD_DROP_DOMAIN_DEFAULT 
 $SQL_AD_ADD_CONSTRAINT_INITIALLY_DEFERRED 
 $SQL_AD_ADD_CONSTRAINT_INITIALLY_IMMEDIATE 
 $SQL_AD_ADD_CONSTRAINT_DEFERRABLE 
 $SQL_AD_ADD_CONSTRAINT_NON_DEFERRABLE 
 $SQL_BRC_PROCEDURES $SQL_BRC_EXPLICIT $SQL_BRC_ROLLED_UP $SQL_BS_SELECT_EXPLICIT 
 $SQL_BS_ROW_COUNT_EXPLICIT $SQL_BS_SELECT_PROC $SQL_BS_ROW_COUNT_PROC 
 $SQL_BP_CLOSE $SQL_BP_DELETE $SQL_BP_DROP $SQL_BP_TRANSACTION $SQL_BP_UPDATE 
 $SQL_BP_OTHER_HSTMT $SQL_BP_SCROLL $SQL_CL_START $SQL_CL_END $SQL_QL_START
 $SQL_QL_END $SQL_CU_DML_STATEMENTS $SQL_CU_PROCEDURE_INVOCATION
 $SQL_CU_TABLE_DEFINITION $SQL_CU_INDEX_DEFINITION $SQL_CU_PRIVILEGE_DEFINITION
 $SQL_CB_NULL $SQL_CB_NON_NULL $SQL_CVT_CHAR $SQL_CVT_NUMERIC $SQL_CVT_DECIMAL
 $SQL_CVT_INTEGER $SQL_CVT_SMALLINT $SQL_CVT_FLOAT $SQL_CVT_REAL $SQL_CVT_DOUBLE
 $SQL_CVT_VARCHAR $SQL_CVT_LONGVARCHAR $SQL_CVT_BINARY $SQL_CVT_VARBINARY
 $SQL_CVT_BIT $SQL_CVT_TINYINT $SQL_CVT_BIGINT $SQL_CVT_DATE $SQL_CVT_TIME
 $SQL_CVT_TIMESTAMP $SQL_CVT_LONGVARBINARY $SQL_CVT_INTERVAL_YEAR_MONTH
 $SQL_CVT_INTERVAL_DAY_TIME $SQL_CVT_WCHAR $SQL_CVT_WLONGVARCHAR
 $SQL_CVT_WVARCHAR $SQL_FN_CVT_CONVERT $SQL_FN_CVT_CAST
 $SQL_CA_CREATE_ASSERTION $SQL_CA_CONSTRAINT_INITIALLY_DEFERRED
 $SQL_CA_CONSTRAINT_INITIALLY_IMMEDIATE $SQL_CA_CONSTRAINT_DEFERRABLE
 $SQL_CA_CONSTRAINT_NON_DEFERRABLE $SQL_CCS_CREATE_CHARACTER_SET
 $SQL_CCS_COLLATE_CLAUSE $SQL_CCS_LIMITED_COLLATION
 $SQL_CDO_CREATE_DOMAIN $SQL_CDO_DEFAULT $SQL_CDO_CONSTRAINT 
 $SQL_CDO_COLLATION $SQL_CDO_CONSTRAINT_NAME_DEFINITION
 $SQL_CDO_CONSTRAINT_INITIALLY_DEFERRED $SQL_CDO_CONSTRAINT_INITIALLY_IMMEDIATE
 $SQL_CDO_CONSTRAINT_DEFERRABLE $SQL_CDO_CONSTRAINT_NON_DEFERRABLE 
 $SQL_CS_CREATE_SCHEMA $SQL_CS_AUTHORIZATION $SQL_CS_DEFAULT_CHARACTER_SET 
 $SQL_CT_CREATE_TABLE $SQL_CT_COMMIT_PRESERVE $SQL_CT_COMMIT_DELETE 
 $SQL_CT_GLOBAL_TEMPORARY $SQL_CT_LOCAL_TEMPORARY 
 $SQL_CT_CONSTRAINT_INITIALLY_DEFERRED $SQL_CT_CONSTRAINT_INITIALLY_IMMEDIATE 
 $SQL_CT_CONSTRAINT_DEFERRABLE $SQL_CT_CONSTRAINT_NON_DEFERRABLE 
 $SQL_CT_COLUMN_CONSTRAINT $SQL_CT_COLUMN_DEFAULT $SQL_CT_COLUMN_COLLATION 
 $SQL_CT_TABLE_CONSTRAINT $SQL_CT_CONSTRAINT_NAME_DEFINITION $SQL_DL_SQL92_DATE
 $SQL_DL_SQL92_TIME $SQL_DL_SQL92_TIMESTAMP $SQL_DL_SQL92_INTERVAL_YEAR
 $SQL_DL_SQL92_INTERVAL_MONTH $SQL_DL_SQL92_INTERVAL_DAY
 $SQL_DL_SQL92_INTERVAL_HOUR $SQL_DL_SQL92_INTERVAL_MINUTE
 $SQL_DL_SQL92_INTERVAL_SECOND $SQL_DL_SQL92_INTERVAL_YEAR_TO_MONTH
 $SQL_DL_SQL92_INTERVAL_DAY_TO_HOUR $SQL_DL_SQL92_INTERVAL_DAY_TO_MINUTE
 $SQL_DL_SQL92_INTERVAL_DAY_TO_SECOND $SQL_DL_SQL92_INTERVAL_HOUR_TO_MINUTE
 $SQL_DL_SQL92_INTERVAL_HOUR_TO_SECOND $SQL_DL_SQL92_INTERVAL_MINUTE_TO_SECOND
 $SQL_QU_DML_STATEMENTS $SQL_QU_PROCEDURE_INVOCATION
 $SQL_QU_TABLE_DEFINITION $SQL_QU_INDEX_DEFINITION $SQL_QU_PRIVILEGE_DEFINITION
 $SQL_INFO_LAST $SQL_QUALIFIER_LOCATION $SQL_DI_CREATE_INDEX
 $SQL_DI_DROP_INDEX $SQL_DA_DROP_ASSERTION $SQL_DC_DROP_COLLATION
 $SQL_DD_DROP_DOMAIN $SQL_DD_RESTRICT $SQL_DD_CASCADE $SQL_DS_DROP_SCHEMA
 $SQL_DS_RESTRICT $SQL_DS_CASCADE $SQL_DT_DROP_TABLE $SQL_DT_RESTRICT
 $SQL_DT_CASCADE $SQL_DTR_DROP_TRANSLATION $SQL_DV_DROP_VIEW
 $SQL_DV_RESTRICT $SQL_DV_CASCADE $SQL_DTC_ENLIST_EXPENSIVE
 $SQL_DTC_UNENLIST_EXPENSIVE $SQL_CA1_NEXT $SQL_CA1_ABSOLUTE $SQL_CA1_RELATIVE 
 $SQL_CA1_BOOKMARK $SQL_CA1_LOCK_NO_CHANGE $SQL_CA1_LOCK_EXCLUSIVE
 $SQL_CA1_LOCK_UNLOCK $SQL_CA1_POS_POSITION $SQL_CA1_POS_UPDATE
 $SQL_CA1_POS_DELETE $SQL_CA1_POS_REFRESH $SQL_CA1_POSITIONED_UPDATE
 $SQL_CA1_POSITIONED_DELETE $SQL_CA1_SELECT_FOR_UPDATE $SQL_CA1_BULK_ADD 
 $SQL_CA1_BULK_UPDATE_BY_BOOKMARK $SQL_CA1_BULK_DELETE_BY_BOOKMARK 
 $SQL_CA1_BULK_FETCH_BY_BOOKMARK $SQL_CA2_READ_ONLY_CONCURRENCY
 $SQL_CA2_LOCK_CONCURRENCY $SQL_CA2_OPT_ROWVER_CONCURRENCY
 $SQL_CA2_OPT_VALUES_CONCURRENCY $SQL_CA2_MAX_ROWS_SELECT 
 $SQL_CA2_MAX_ROWS_INSERT $SQL_CA2_MAX_ROWS_DELETE $SQL_CA2_MAX_ROWS_UPDATE
 $SQL_CA2_MAX_ROWS_CATALOG $SQL_CA2_MAX_ROWS_AFFECTS_ALL $SQL_FD_FETCH_RESUME
 $SQL_FD_FETCH_BOOKMARK $SQL_FILE_NOT_SUPPORTED $SQL_FILE_TABLE
 $SQL_FILE_QUALIFIER $SQL_FILE_CATALOG $SQL_GD_BLOCK $SQL_GD_BOUND
 $SQL_GB_NOT_SUPPORTED $SQL_GB_GROUP_BY_EQUALS_SELECT
 $SQL_GB_GROUP_BY_CONTAINS_SELECT $SQL_GB_NO_RELATION $SQL_GB_COLLATE
 $SQL_IK_NONE $SQL_IK_ASC $SQL_IK_DESC $SQL_IK_ALL $SQL_ISV_ASSERTIONS
 $SQL_ISV_CHARACTER_SETS $SQL_ISV_CHECK_CONSTRAINTS $SQL_ISV_COLLATIONS
 $SQL_ISV_COLUMN_DOMAIN_USAGE $SQL_ISV_COLUMN_PRIVILEGES $SQL_ISV_COLUMNS
 $SQL_ISV_CONSTRAINT_COLUMN_USAGE $SQL_ISV_CONSTRAINT_TABLE_USAGE
 $SQL_ISV_DOMAIN_CONSTRAINTS $SQL_ISV_DOMAINS $SQL_ISV_KEY_COLUMN_USAGE
 $SQL_ISV_REFERENTIAL_CONSTRAINTS $SQL_ISV_SCHEMATA $SQL_ISV_SQL_LANGUAGES
 $SQL_ISV_TABLE_CONSTRAINTS $SQL_ISV_TABLE_PRIVILEGES $SQL_ISV_TABLES
 $SQL_ISV_TRANSLATIONS $SQL_ISV_USAGE_PRIVILEGES $SQL_ISV_VIEW_COLUMN_USAGE
 $SQL_ISV_VIEW_TABLE_USAGE $SQL_ISV_VIEWS $SQL_IS_INSERT_LITERALS
 $SQL_IS_INSERT_SEARCHED $SQL_IS_SELECT_INTO $SQL_LCK_NO_CHANGE
 $SQL_LCK_EXCLUSIVE $SQL_LCK_UNLOCK $SQL_POS_POSITION
 $SQL_POS_REFRESH $SQL_POS_UPDATE $SQL_POS_DELETE
 $SQL_POS_ADD $SQL_NNC_NULL $SQL_NNC_NON_NULL $SQL_NC_START $SQL_NC_END
 $SQL_FN_NUM_ABS $SQL_FN_NUM_ACOS $SQL_FN_NUM_ASIN $SQL_FN_NUM_ATAN
 $SQL_FN_NUM_ATAN2 $SQL_FN_NUM_CEILING $SQL_FN_NUM_COS $SQL_FN_NUM_COT
 $SQL_FN_NUM_EXP $SQL_FN_NUM_FLOOR $SQL_FN_NUM_LOG $SQL_FN_NUM_MOD
 $SQL_FN_NUM_SIGN $SQL_FN_NUM_SIN $SQL_FN_NUM_SQRT $SQL_FN_NUM_TAN
 $SQL_FN_NUM_PI $SQL_FN_NUM_RAND $SQL_FN_NUM_DEGREES $SQL_FN_NUM_LOG10
 $SQL_FN_NUM_POWER $SQL_FN_NUM_RADIANS $SQL_FN_NUM_ROUND $SQL_FN_NUM_TRUNCATE
 $SQL_OAC_NONE $SQL_OAC_LEVEL1 $SQL_OAC_LEVEL2 $SQL_OIC_CORE $SQL_OIC_LEVEL1
 $SQL_OIC_LEVEL2 $SQL_OSCC_NOT_COMPLIANT $SQL_OSCC_COMPLIANT $SQL_OSC_MINIMUM 
 $SQL_OSC_CORE $SQL_OSC_EXTENDED $SQL_OU_DML_STATEMENTS 
 $SQL_OU_PROCEDURE_INVOCATION $SQL_OU_TABLE_DEFINITION $SQL_OU_INDEX_DEFINITION 
 $SQL_OU_PRIVILEGE_DEFINITION $SQL_PARC_BATCH $SQL_PARC_NO_BATCH
 $SQL_PAS_BATCH $SQL_PAS_NO_BATCH $SQL_PAS_NO_SELECT $SQL_PS_POSITIONED_DELETE
 $SQL_PS_POSITIONED_UPDATE $SQL_PS_SELECT_FOR_UPDATE $SQL_SU_DML_STATEMENTS
 $SQL_SU_PROCEDURE_INVOCATION $SQL_SU_TABLE_DEFINITION $SQL_SU_INDEX_DEFINITION
 $SQL_SU_PRIVILEGE_DEFINITION $SQL_SO_FORWARD_ONLY $SQL_SO_KEYSET_DRIVEN
 $SQL_SO_DYNAMIC $SQL_SO_MIXED $SQL_SO_STATIC $SQL_SC_SQL92_ENTRY
 $SQL_SC_FIPS127_2_TRANSITIONAL $SQL_SC_SQL92_INTERMEDIATE
 $SQL_SC_SQL92_FULL $SQL_SDF_CURRENT_DATE $SQL_SDF_CURRENT_TIME 
 $SQL_SDF_CURRENT_TIMESTAMP $SQL_SFKD_CASCADE $SQL_SFKD_NO_ACTION 
 $SQL_SFKD_SET_DEFAULT $SQL_SFKD_SET_NULL $SQL_SFKU_CASCADE $SQL_SFKU_NO_ACTION 
 $SQL_SFKU_SET_DEFAULT $SQL_SFKU_SET_NULL $SQL_SG_USAGE_ON_DOMAIN 
 $SQL_SG_USAGE_ON_CHARACTER_SET $SQL_SG_USAGE_ON_COLLATION 
 $SQL_SG_USAGE_ON_TRANSLATION $SQL_SG_WITH_GRANT_OPTION $SQL_SG_DELETE_TABLE 
 $SQL_SG_INSERT_TABLE $SQL_SG_INSERT_COLUMN $SQL_SG_REFERENCES_TABLE 
 $SQL_SG_REFERENCES_COLUMN $SQL_SG_SELECT_TABLE $SQL_SG_UPDATE_TABLE 
 $SQL_SG_UPDATE_COLUMN $SQL_SNVF_BIT_LENGTH $SQL_SNVF_CHAR_LENGTH 
 $SQL_SNVF_CHARACTER_LENGTH $SQL_SNVF_EXTRACT $SQL_SNVF_OCTET_LENGTH 
 $SQL_SNVF_POSITION $SQL_SP_EXISTS $SQL_SP_ISNOTNULL $SQL_SP_ISNULL 
 $SQL_SP_MATCH_FULL $SQL_SP_MATCH_PARTIAL $SQL_SP_MATCH_UNIQUE_FULL 
 $SQL_SP_MATCH_UNIQUE_PARTIAL $SQL_SP_OVERLAPS $SQL_SP_UNIQUE $SQL_SP_LIKE 
 $SQL_SP_IN $SQL_SP_BETWEEN $SQL_SP_COMPARISON $SQL_SP_QUANTIFIED_COMPARISON 
 $SQL_SRJO_CORRESPONDING_CLAUSE $SQL_SRJO_CROSS_JOIN $SQL_SRJO_EXCEPT_JOIN 
 $SQL_SRJO_FULL_OUTER_JOIN $SQL_SRJO_INNER_JOIN $SQL_SRJO_INTERSECT_JOIN 
 $SQL_SRJO_LEFT_OUTER_JOIN $SQL_SRJO_NATURAL_JOIN $SQL_SRJO_RIGHT_OUTER_JOIN 
 $SQL_SRJO_UNION_JOIN $SQL_SR_USAGE_ON_DOMAIN $SQL_SR_USAGE_ON_CHARACTER_SET 
 $SQL_SR_USAGE_ON_COLLATION $SQL_SR_USAGE_ON_TRANSLATION $SQL_SR_GRANT_OPTION_FOR 
 $SQL_SR_CASCADE $SQL_SR_RESTRICT $SQL_SR_DELETE_TABLE $SQL_SR_INSERT_TABLE 
 $SQL_SR_INSERT_COLUMN $SQL_SR_REFERENCES_TABLE $SQL_SR_REFERENCES_COLUMN 
 $SQL_SR_SELECT_TABLE $SQL_SR_UPDATE_TABLE $SQL_SR_UPDATE_COLUMN
 $SQL_SRVC_VALUE_EXPRESSION $SQL_SRVC_NULL $SQL_SRVC_DEFAULT 
 $SQL_SRVC_ROW_SUBQUERY $SQL_SSF_CONVERT $SQL_SSF_LOWER $SQL_SSF_UPPER
 $SQL_SSF_SUBSTRING $SQL_SSF_TRANSLATE $SQL_SSF_TRIM_BOTH $SQL_SSF_TRIM_LEADING
 $SQL_SSF_TRIM_TRAILING $SQL_SVE_CASE $SQL_SVE_CAST $SQL_SVE_COALESCE
 $SQL_SVE_NULLIF $SQL_SCC_XOPEN_CLI_VERSION1 $SQL_SCC_ISO92_CLI
 $SQL_SS_ADDITIONS  $SQL_SS_DELETIONS $SQL_SS_UPDATES $SQL_SQ_COMPARISON 
 $SQL_SQ_EXISTS $SQL_SQ_IN $SQL_SQ_QUANTIFIED $SQL_SQ_CORRELATED_SUBQUERIES 
 $SQL_FN_SYS_USERNAME $SQL_FN_SYS_DBNAME $SQL_FN_SYS_IFNULL $SQL_FN_STR_CONCAT
 $SQL_FN_STR_INSERT $SQL_FN_STR_LEFT $SQL_FN_STR_LTRIM $SQL_FN_STR_LENGTH
 $SQL_FN_STR_LOCATE $SQL_FN_STR_LCASE $SQL_FN_STR_REPEAT $SQL_FN_STR_REPLACE
 $SQL_FN_STR_RIGHT $SQL_FN_STR_RTRIM $SQL_FN_STR_SUBSTRING $SQL_FN_STR_UCASE
 $SQL_FN_STR_ASCII $SQL_FN_STR_CHAR $SQL_FN_STR_DIFFERENCE $SQL_FN_STR_LOCATE_2
 $SQL_FN_STR_SOUNDEX $SQL_FN_STR_SPACE $SQL_FN_STR_BIT_LENGTH
 $SQL_FN_STR_CHAR_LENGTH $SQL_FN_STR_CHARACTER_LENGTH $SQL_FN_STR_OCTET_LENGTH
 $SQL_FN_STR_POSITION $SQL_FN_TSI_FRAC_SECOND $SQL_FN_TSI_SECOND 
 $SQL_FN_TSI_MINUTE $SQL_FN_TSI_HOUR $SQL_FN_TSI_DAY $SQL_FN_TSI_WEEK 
 $SQL_FN_TSI_MONTH $SQL_FN_TSI_QUARTER $SQL_FN_TSI_YEAR $SQL_FN_TD_NOW 
 $SQL_FN_TD_CURDATE $SQL_FN_TD_DAYOFMONTH $SQL_FN_TD_DAYOFWEEK 
 $SQL_FN_TD_DAYOFYEAR $SQL_FN_TD_MONTH $SQL_FN_TD_QUARTER $SQL_FN_TD_WEEK 
 $SQL_FN_TD_YEAR $SQL_FN_TD_CURTIME $SQL_FN_TD_HOUR $SQL_FN_TD_MINUTE 
 $SQL_FN_TD_SECOND $SQL_FN_TD_TIMESTAMPADD $SQL_FN_TD_TIMESTAMPDIFF 
 $SQL_FN_TD_DAYNAME $SQL_FN_TD_MONTHNAME $SQL_FN_TD_CURRENT_DATE 
 $SQL_FN_TD_CURRENT_TIME $SQL_FN_TD_CURRENT_TIMESTAMP $SQL_FN_TD_EXTRACT 
 $SQL_TXN_VERSIONING $SQL_U_UNION $SQL_U_UNION_ALL $SQL_US_UNION
 $SQL_US_UNION_ALL $SQL_CV_CREATE_VIEW $SQL_CV_CHECK_OPTION
 $SQL_CV_CASCADED $SQL_CV_LOCAL $SQL_ATTR_ASYNC_ENABLE $SQL_ATTR_CONCURRENCY
 $SQL_ATTR_CURSOR_TYPE $SQL_ATTR_ENABLE_AUTO_IPD $SQL_ATTR_FETCH_BOOKMARK_PTR
 $SQL_ATTR_KEYSET_SIZE $SQL_ATTR_MAX_LENGTH $SQL_ATTR_MAX_ROWS 
 $SQL_ATTR_NOSCAN $SQL_ATTR_PARAM_BIND_OFFSET_PTR $SQL_ATTR_PARAM_BIND_TYPE 
 $SQL_ATTR_PARAM_OPERATION_PTR $SQL_ATTR_PARAM_STATUS_PTR
 $SQL_ATTR_PARAMS_PROCESSED_PTR $SQL_ATTR_PARAMSET_SIZE
 $SQL_ATTR_QUERY_TIMEOUT $SQL_ATTR_RETRIEVE_DATA $SQL_ATTR_ROW_BIND_OFFSET_PTR 
 $SQL_ATTR_ROW_BIND_TYPE $SQL_ATTR_ROW_NUMBER $SQL_ATTR_ROW_OPERATION_PTR 
 $SQL_ATTR_ROW_STATUS_PTR $SQL_ATTR_ROWS_FETCHED_PTR $SQL_ATTR_ROW_ARRAY_SIZE 
 $SQL_ATTR_SIMULATE_CURSOR $SQL_ATTR_USE_BOOKMARKS $SQL_STMT_OPT_MAX 
 $SQL_STMT_OPT_MIN $SQL_ASYNC_ENABLE_OFF $SQL_ASYNC_ENABLE_ON 
 $SQL_ASYNC_ENABLE_DEFAULT $SQL_PARAM_BIND_BY_COLUMN $SQL_PARAM_BIND_TYPE_DEFAULT
 $SQL_BIND_BY_COLUMN $SQL_BIND_TYPE_DEFAULT $SQL_CONCUR_READ_ONLY 
 $SQL_CONCUR_LOCK $SQL_CONCUR_ROWVER $SQL_CONCUR_VALUES $SQL_CONCUR_DEFAULT
 $SQL_CURSOR_FORWARD_ONLY $SQL_CURSOR_KEYSET_DRIVEN $SQL_CURSOR_DYNAMIC
 $SQL_CURSOR_STATIC $SQL_CURSOR_TYPE_DEFAULT $SQL_KEYSET_SIZE_DEFAULT
 $SQL_MAX_LENGTH_DEFAULT $SQL_MAX_ROWS_DEFAULT $SQL_NOSCAN_OFF
 $SQL_NOSCAN_ON $SQL_NOSCAN_DEFAULT $SQL_QUERY_TIMEOUT_DEFAULT
 $SQL_ROWSET_SIZE_DEFAULT $SQL_UB_OFF $SQL_UB_ON $SQL_UB_DEFAULT 
 $SQL_UB_FIXED $SQL_UB_VARIABLE $SQL_COL_PRED_CHAR
 $SQL_COL_PRED_BASIC $SQL_POSITION $SQL_REFRESH $SQL_UPDATE $SQL_DELETE 
 $SQL_ADD $SQL_SETPOS_MAX_OPTION_VALUE $SQL_UPDATE_BY_BOOKMARK
 $SQL_DELETE_BY_BOOKMARK $SQL_FETCH_BY_BOOKMARK $SQL_LOCK_NO_CHANGE 
 $SQL_LOCK_EXCLUSIVE $SQL_LOCK_UNLOCK $SQL_SETPOS_MAX_LOCK_VALUE
 $SQL_BEST_ROWID $SQL_ROWVER $SQL_FETCH_BOOKMARK 
 $SQL_PC_NOT_PSEUDO $SQL_DATABASE_NAME $SQL_FD_FETCH_PREV 
 $SQL_FETCH_PREV $SQL_CONCUR_TIMESTAMP $SQL_SCCO_OPT_TIMESTAMP 
 $SQL_CC_DELETE $SQL_CR_DELETE $SQL_CC_CLOSE 
 $SQL_CR_CLOSE $SQL_CC_PRESERVE $SQL_CR_PRESERVE 
 $SQL_FETCH_RESUME $SQL_SCROLL_FORWARD_ONLY $SQL_SCROLL_KEYSET_DRIVEN 
 $SQL_SCROLL_DYNAMIC $SQL_SCROLL_STATIC $SQL_ROW_SUCCESS $SQL_ROW_DELETED 
 $SQL_ROW_UPDATED $SQL_ROW_NOROW $SQL_ROW_ADDED 
 $SQL_ROW_ERROR $SQL_ROW_SUCCESS_WITH_INFO $SQL_ROW_PROCEED 
 $SQL_ROW_IGNORE $SQL_PARAM_SUCCESS $SQL_PARAM_SUCCESS_WITH_INFO 
 $SQL_PARAM_ERROR $SQL_PARAM_UNUSED $SQL_PARAM_DIAG_UNAVAILABLE 
 $SQL_PARAM_PROCEED $SQL_PARAM_IGNORE $SQL_CASCADE 
 $SQL_RESTRICT $SQL_SET_NULL $SQL_NO_ACTION $SQL_SET_DEFAULT 
 $SQL_INITIALLY_DEFERRED $SQL_INITIALLY_IMMEDIATE $SQL_NOT_DEFERRABLE
 $SQL_PARAM_TYPE_UNKNOWN $SQL_PARAM_INPUT $SQL_PARAM_INPUT_OUTPUT 
 $SQL_RESULT_COL $SQL_PARAM_OUTPUT $SQL_RETURN_VALUE $SQL_PT_UNKNOWN 
 $SQL_PT_PROCEDURE $SQL_PT_FUNCTION $SQL_PARAM_TYPE_DEFAULT 
 $SQL_SETPARAM_VALUE_MAX $SQL_QUICK $SQL_ENSURE $SQL_TABLE_STAT 
 $SQL_ALL_CATALOGS $SQL_ALL_SCHEMAS $SQL_ALL_TABLE_TYPES $SQL_YEAR 
 $SQL_MONTH $SQL_DAY $SQL_HOUR $SQL_MINUTE $SQL_SECOND $SQL_YEAR_TO_MONTH 
 $SQL_DAY_TO_HOUR $SQL_DAY_TO_MINUTE $SQL_DAY_TO_SECOND $SQL_HOUR_TO_MINUTE 
 $SQL_HOUR_TO_SECOND $SQL_MINUTE_TO_SECOND 
 @SQL_ODBC_KEYWORDS 
 &SQLAllocHandle &SQLSetEnvAttr &SQLSetConnectAttr &SQLFreeConnect
 &SQLConnect &SQLGetDiagRec &SQLDisconnect &SQLGetInfo &SQLFreeHandle
 &SQLDataSources &SQLAllocConnect &SQLAllocEnv &SQLAllocHandleStd
 &SQLAllocStmt &SQLBindCol &SQLNumResultCols &SQLRowCount 
 &SQLGetData &SQLDrivers &SQLFreeStmt &SQLColAttribute
 &SQLColAttributes &SQLGetStmtAttr &SQLSetStmtAttr &SQLGetFunctions
 &SQLGetTypeInfo &SQLGetEnvAttr &SQLExecDirect &SQLFetch
 &SQLPrepare &SQLExecute &SQLNativeSql &SQLSetCursorName &SQLGetCursorName
 &SQLDescribeCol &SQLFetchScroll &SQLSetPos &SQLMoreResults 
 &SQLGetDiagField &SQLColumnPrivileges &SQLColumns &SQLCloseCursor
 &SQLForeignKeys &SQLPrimaryKeys &SQLProcedureColumns &SQLProcedures
 &SQLSpecialColumns &SQLStatistics &SQLTables &SQLTablePrivileges
 &SQLSetStmtOption
 &dm_log_open &dm_log_close
);

# This allows declaration	use UnixODBC ':all';
our %EXPORT_TAGS = ( 'all' => [@EXPORT_OK] );

our @EXPORT = qw();
our $VERSION = '0.20';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    our $AUTOLOAD;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant($constname, @_ ? $_[0] : 0);
    if ($! != 0) {
	if ($! =~ /Invalid/ || $!{EINVAL}) {
	    $AutoLoader::AUTOLOAD = $AUTOLOAD;
	    goto &AutoLoader::AUTOLOAD;
	}
	else {
	    croak "Your vendor has not defined UnixODBC macro $constname";
	}
    }
    {
	no strict 'refs';
	# Fixed between 5.005_53 and 5.005_61
	if ($] >= 5.00561) {
	    *$AUTOLOAD = sub () { $val };
	}
	else {
	    *$AUTOLOAD = sub { $val };
	}
    }
    goto &$AUTOLOAD;
}

### ODBC constants from sql.h and sqlext.h
# Return values
our $SQL_NULL_DATA = -1;
our $SQL_DATA_AT_EXEC = -2;
our $SQL_SUCCESS = 0;
our $SQL_SUCCESS_WITH_INFO = 1;
our $SQL_NO_DATA = 100;
our $SQL_NO_DATA_FOUND = $SQL_NO_DATA;
our $SQL_ERROR = -1;
our $SQL_INVALID_HANDLE = -2;
our $SQL_STILL_EXECUTING = 2;
our $SQL_NEED_DATA = 99;

# String terminators
our $SQL_NTS = -3;
our $SQL_NTSL = -3;

# Maximum message length
our $SQL_MAX_MESSAGE_LENGTH = 512;

# Attribute Lengths
our $SQL_IS_POINTER = -4;
our $SQL_IS_UINTEGER = -5;
our $SQL_IS_INTEGER = -6;
our $SQL_IS_USMALLINT = -7;
our $SQL_IS_SMALLINT = -8;

# Date/time length constants
our $SQL_DATE_LEN = 10;
our $SQL_TIME_LEN = 8;
our $SQL_TIMESTAMP_LEN = 19;

# Handle type identifiers
our $SQL_HANDLE_ENV = 1;
our $SQL_HANDLE_DBC = 2;
our $SQL_HANDLE_STMT = 3;
our $SQL_HANDLE_DESC = 4;
# ODBC 3
our $SQL_HANDLE_SENV = 5;  ###

# SetEnvAttr arguments
our $SQL_ATTR_OUTPUT_NTS = 10001;
our $SQL_ATTR_ODBC_VERSION = 200;
our $SQL_ATTR_CONNECTION_POOLING = 201;
our $SQL_ATTR_CP_MATCH = 202;

# Connection attributes
our $SQL_ATTR_AUTO_IPD = 10001;
our $SQL_ATTR_METADATA_ID = 10014;

# Statement Attributes
our $SQL_ATTR_APP_ROW_DESC = 10010;
our $SQL_ATTR_APP_PARAM_DESC = 10011;
our $SQL_ATTR_IMP_ROW_DESC = 10012;
our $SQL_ATTR_APP_IMP_PARAM_DESC = 10013;
our $SQL_ATTR_CURSOR_SCROLLABLE = -1;
our $SQL_ATTR_CURSOR_SENSITIVITY = -2;

our $SQL_NONSCROLLABLE = undef;
our $SQL_SCROLLABLE = undef;

# SQL Descriptor field identifiers
our $SQL_DESC_COUNT = 1001;
our $SQL_DESC_TYPE = 1002;
our $SQL_DESC_LENGTH = 1003;
our $SQL_DESC_OCTET_LENGTH_PTR = 1004;
our $SQL_DESC_PRECISION = 1005;
our $SQL_DESC_SCALE = 1006;
our $SQL_DESC_DATETIME_INTERVAL_CODE = 1007;
our $SQL_DESC_NULLABLE = 1008;
our $SQL_DESC_INDICATOR_PTR = 1009;
our $SQL_DESC_DATA_PTR = 1010;
our $SQL_DESC_NAME = 1011;
our $SQL_DESC_UNNAMED = 1012;
our $SQL_DESC_OCTET_LENGTH = 1013;
our $SQL_DESC_ALLOC_TYPE = 1099;

# Diagnostics area field indentifiers
our $SQL_DIAG_RETURNCODE = 1;
our $SQL_DIAG_NUMBER = 2;
our $SQL_DIAG_ROW_COUNT = 3;
our $SQL_DIAG_SQLSTATE = 4;
our $SQL_DIAG_NATIVE = 5;
our $SQL_DIAG_MESSAGE_TEXT = 6;
our $SQL_DIAG_DYNAMIC_FUNCTION = 7;
our $SQL_DIAG_CLASS_ORIGIN = 8;
our $SQL_DIAG_SUBCLASS_ORIGIN = 9;
our $SQL_DIAG_CONNECTION_NAME = 10;
our $SQL_DIAG_SERVER_NAME = 11;
our $SQL_DIAG_DYNAMIC_FUNCTION_CODE = 12;

# Dynamic function codes
our $SQL_DIAG_ALTER_DOMAIN = 3;
our $SQL_DIAG_ALTER_TABLE = 4;
our $SQL_DIAG_CALL = 7;
our $SQL_DIAG_CREATE_ASSERTION = 6;
our $SQL_DIAG_CREATE_CHARACTER_SET = 8;
our $SQL_DIAG_CREATE_COLLATION = 10;
our $SQL_DIAG_CREATE_DOMAIN = 23;
our $SQL_DIAG_CREATE_INDEX = -1;
our $SQL_DIAG_CREATE_SCHEMA = 64;
our $SQL_DIAG_CREATE_TABLE = 77;
our $SQL_DIAG_CREATE_TRANSLATION = 79;
our $SQL_DIAG_CREATE_VIEW = 84;
our $SQL_DIAG_DELETE_WHERE = 19;
our $SQL_DIAG_DROP_ASSERTION = 24;
our $SQL_DIAG_DROP_CHARACTER_SET = 25;
our $SQL_DIAG_DROP_COLLATION = 26;
our $SQL_DIAG_DROP_DOMAIN = 27;
our $SQL_DIAG_DROP_INDEX = -2;
our $SQL_DIAG_DROP_SCHEMA = 31;
our $SQL_DIAG_DROP_TABLE = 32;
our $SQL_DIAG_DROP_TRANSLATION = 33;
our $SQL_DIAG_DROP_VIEW = 36;
our $SQL_DIAG_DYNAMIC_DELETE_CURSOR = 38;
our $SQL_DIAG_DYNAMIC_UPDATE_CURSOR = 81;
our $SQL_DIAG_GRANT = 48;
our $SQL_DIAG_INSERT = 50;
our $SQL_DIAG_REVOKE = 59;
our $SQL_DIAG_SELECT_CURSOR = 85;
our $SQL_DIAG_UNKNOWN_STATEMENT = 0;
our $SQL_DIAG_UPDATE_WHERE = 82;

# Data type codes
our $SQL_UNKNOWN_TYPE = 0;
our $SQL_CHAR = 1;
our $SQL_NUMERIC = 2;
our $SQL_DECIMAL = 3;
our $SQL_INTEGER = 4;
our $SQL_SMALLINT = 5;
our $SQL_FLOAT = 6;
our $SQL_REAL = 7;
our $SQL_DOUBLE = 8;
our $SQL_DATETIME = 9;
our $SQL_DATE = $SQL_DATETIME;
our $SQL_VARCHAR = 12;
# ODBC 3
our $SQL_INTERVAL = 10;
our $SQL_TIME = 10;
our $SQL_TIMESTAMP = 11;
our $SQL_LONGVARCHAR = -1;
our $SQL_BINARY = -2;
our $SQL_VARBINARY = -3;
our $SQL_LONGVARBINARY = -4;
our $SQL_BIGINT = -5;
our $SQL_TINYINT = -6;
our $SQL_BIT = -7;
# ODBC 3.5
our $SQL_GUID = -11;

# ODBC 3 Intervals

our $SQL_CODE_YEAR = 1;
our $SQL_CODE_MONTH = 2;
our $SQL_CODE_DAY = 3;
our $SQL_CODE_HOUR = 4;
our $SQL_CODE_MINUTE = 5;
our $SQL_CODE_SECOND = 6;
our $SQL_CODE_YEAR_TO_MONTH = 7;
our $SQL_CODE_DAY_TO_HOUR = 8;
our $SQL_CODE_DAY_TO_MINUTE = 9;
our $SQL_CODE_DAY_TO_SECOND = 10;
our $SQL_CODE_HOUR_TO_MINUTE = 11;
our $SQL_CODE_HOUR_TO_SECOND = 12;
our $SQL_CODE_MINUTE_TO_SECOND = 13;
our $SQL_INTERVAL_YEAR = (100 + $SQL_CODE_YEAR);
our $SQL_INTERVAL_MONTH = (100 + $SQL_CODE_MONTH);
our $SQL_INTERVAL_DAY = (100 + $SQL_CODE_DAY);
our $SQL_INTERVAL_HOUR = (100 + $SQL_CODE_HOUR);
our $SQL_INTERVAL_MINUTE = (100 + $SQL_CODE_MINUTE);
our $SQL_INTERVAL_SECOND = (100 + $SQL_CODE_SECOND);
our $SQL_INTERVAL_YEAR_TO_MONTH = (100 + $SQL_CODE_YEAR_TO_MONTH);
our $SQL_INTERVAL_DAY_TO_HOUR = (100 + $SQL_CODE_DAY_TO_HOUR);
our $SQL_INTERVAL_DAY_TO_MINUTE = (100 + $SQL_CODE_DAY_TO_MINUTE);
our $SQL_INTERVAL_DAY_TO_SECOND = (100 + $SQL_CODE_DAY_TO_SECOND);
our $SQL_INTERVAL_HOUR_TO_MINUTE = (100 + $SQL_CODE_HOUR_TO_MINUTE);
our $SQL_INTERVAL_HOUR_TO_SECOND = (100 + $SQL_CODE_HOUR_TO_SECOND);
our $SQL_INTERVAL_MINUTE_TO_SECOND = (100 + $SQL_CODE_MINUTE_TO_SECOND);

# Unicode - from sqlext.h and sqlucode.h
our $SQL_WCHAR = (-8);
our $SQL_WVARCHAR = (-9);
our $SQL_WLONGVARCHAR = (-10);
our $SQL_C_WCHAR = $SQL_WCHAR;
our $SQL_UNICODE = $SQL_WCHAR;
our $SQL_UNICODE_VARCHAR = $SQL_WVARCHAR;
our $SQL_UNICODE_LONGVARCHAR = $SQL_WLONGVARCHAR;
our $SQL_UNICODE_CHAR = $SQL_WCHAR;

our $SQL_TYPE_DRIVER_START = $SQL_INTERVAL_YEAR;
our $SQL_TYPE_DRIVER_END = $SQL_UNICODE_LONGVARCHAR;
our $SQL_SIGNED_OFFSET = $SQL_INTERVAL_YEAR;
our $SQL_UNSIGNED_OFFSET = $SQL_UNICODE_VARCHAR;
our $SQL_TYPE_NULL = 0;
our $SQL_TYPE_MIN = $SQL_BIT;
our $SQL_TYPE_MAX = $SQL_VARCHAR;

# C data types
our $SQL_C_CHAR = $SQL_CHAR;
our $SQL_C_LONG = $SQL_INTEGER;
our $SQL_C_SHORT = $SQL_SMALLINT;
our $SQL_C_FLOAT = $SQL_REAL;
our $SQL_C_DOUBLE = $SQL_DOUBLE;
# ODBC 3
our $SQL_C_NUMERIC = $SQL_NUMERIC;
our $SQL_C_DEFAULT = 99;

our $SQL_C_DATE = $SQL_DATE;
our $SQL_C_TIME = $SQL_TIME;
our $SQL_C_TIMESTAMP = $SQL_TIMESTAMP;
our $SQL_C_BINARY = $SQL_BINARY;
our $SQL_C_BIT = $SQL_BIT;
our $SQL_C_TINYINT = $SQL_TINYINT;
our $SQL_C_SLONG = ($SQL_C_LONG + $SQL_SIGNED_OFFSET);
our $SQL_C_SSHORT = ($SQL_C_SHORT + $SQL_SIGNED_OFFSET);
our $SQL_C_STINYINT = ($SQL_TINYINT + $SQL_SIGNED_OFFSET);
our $SQL_C_ULONG = ($SQL_C_LONG + $SQL_UNSIGNED_OFFSET);
our $SQL_C_USHORT = ($SQL_C_SHORT + $SQL_UNSIGNED_OFFSET);
our $SQL_C_UTINYINT = ($SQL_TINYINT + $SQL_UNSIGNED_OFFSET);
our $SQL_C_BOOKMARK = $SQL_C_ULONG;

# Statement cursor sensitivity attributes
our $SQL_UNSPECIFIED = 0;
our $SQL_INSENSITIVE = 1;
our $SQL_SENSITIVE = 2;

# GetTypeInfo request
our $SQL_ALL_TYPES = 0;

# Default conversion code for SQLBindCol, SQLBindParam, and SQLGetData
our $SQL_DEFAULT = 99;

# SQLBindParam
our $SQL_DEFAULT_PARAM	= -5;
our $SQL_IGNORE = -6;
our $SQL_COLUMN_IGNORE = $SQL_IGNORE;
our $SQL_LEN_DATA_AT_EXEC_OFFSET = -100;
# takes one param, length
sub SQL_LEN_DATA_AT_EXEC {(-($_[0]) + $SQL_LEN_DATA_AT_EXEC_OFFSET)}

# Length for driver attributes
our $SQL_LEN_BINARY_ATTR_OFFSET = -100;
# takes length as param
sub SQL_LEN_BINARY_ATTR { (-($+[0]) + $SQL_LEN_BINARY_ATTR_OFFSET) }


# SQLGetData code for application row descriptor data type
our $SQL_ARD_TYPE = -99;

# SQL Date/Time type subcodes
our $SQL_CODE_DATE = 1;
our $SQL_CODE_TIME = 2;
our $SQL_CODE_TIMESTAMP = 3;

# Column Attributes ODBC 2
our $SQL_COLUMN_COUNT = 0;
our $SQL_COLUMN_NAME = 1;
our $SQL_COLUMN_TYPE = 2;
our $SQL_COLUMN_LENGTH = 3;
our $SQL_COLUMN_PRECISION = 4;
our $SQL_COLUMN_SCALE = 5;
our $SQL_COLUMN_DISPLAY_SIZE = 6;
our $SQL_COLUMN_NULLABLE = 7;
our $SQL_COLUMN_UNSIGNED = 8;
our $SQL_COLUMN_MONEY = 9;
our $SQL_COLUMN_UPDATABLE = 10;
our $SQL_COLUMN_AUTO_INCREMENT = 11;
our $SQL_COLUMN_CASE_SENSITIVE = 12;
our $SQL_COLUMN_SEARCHABLE = 13;
our $SQL_COLUMN_TYPE_NAME = 14;
our $SQL_COLUMN_TABLE_NAME = 15;
our $SQL_COLUMN_OWNER_NAME = 16;
our $SQL_COLUMN_QUALIFIER_NAME = 17;
our $SQL_COLUMN_LABEL = 18;
our $SQL_COLATT_OPT_MIN = $SQL_COLUMN_COUNT;
our $SQL_COLATT_OPT_MAX = $SQL_COLUMN_LABEL;
our $SQL_COLUMN_DRIVER_START = 1000;

# Attributes for SQLColAttributes SQL_COLUMN_UPDATABLE attributes
our $SQL_ATTR_READONLY = 0;
our $SQL_ATTR_WRITE = 1;
our $SQL_ATTR_READWRITE_UNKNOWN = 2;

# Attributes for SQL_COLUMN_SEARCHABLE
our $SQL_UNSEARCHABLE = 0;
our $SQL_LIKE_ONLY = 1;
our $SQL_ALL_EXCEPT_LIKE = 2;
our $SQL_SEARCHABLE = 3;
our $SQL_PRED_SEARCHABLE = $SQL_SEARCHABLE;


# CLI option values
our $SQL_FALSE = 0;
our $SQL_TRUE = 1;

# Value for SQLGetTypeInfo for unknown nullable data type
our $SQL_NULLABLE_UNKNOWN = 2;

# Values returned by SQLGetTypeInfo to show WHERE clauses supported
our $SQL_PRED_NONE = 0;
our $SQL_PRED_CHAR = 1;
our $SQL_PRED_BASIC = 2;

# Values of UNNAMED field in descriptor
our $SQL_NAMED = 0;
our $SQL_UNNAMED = 1;

# Values of ALLOC_TYPE field in descriptor
our $SQL_DESC_ALLOC_AUTO = 1;
our $SQL_DESC_ALLOC_USER = 2;

# FreeStmt options 
our $SQL_CLOSE = 0;
our $SQL_DROP = 1;
our $SQL_UNBIND = 2;
our $SQL_RESET_PARAMS = 3;

# FetchOrientation codes in SQLFetchScroll and SQLDataSources
our $SQL_FETCH_NEXT = 1;
our $SQL_FETCH_FIRST = 2;
our $SQL_FETCH_LAST = 3;
our $SQL_FETCH_PRIOR = 4;
our $SQL_FETCH_ABSOLUTE = 5;
our $SQL_FETCH_RELATIVE = 6;
our $SQL_FETCH_FIRST_USER = 31;
our $SQL_FETCH_FIRST_SYSTEM = 32;

# Null handles returned by SQLAllocHandle
our $SQL_NULL_HENV = 0;
our $SQL_NULL_HDBC = 0;
our $SQL_NULL_HSTMT = 0;
our $SQL_NULL_HDESC = 0;

# Null handle used instead of parent handle when allocating HENV
our $SQL_NULL_HANDLE = 0;

# Values that may appear in the result set of SQLSpecialColumns() 
our $SQL_SCOPE_CURROW = 0;
our $SQL_SCOPE_TRANSACTION = 1;
our $SQL_SCOPE_SESSION = 2;

our $SQL_PC_UNKNOWN = 0;
our $SQL_PC_NON_PSEUDO = 1;
our $SQL_PC_PSEUDO = 2;

# Reserved value for the IdentifierType argument of SQLSpecialColumns() 
our $SQL_ROW_IDENTIFIER = 1;

# Reserved values for UNIQUE argument of SQLStatistics() 
our $SQL_INDEX_UNIQUE = 0;
our $SQL_INDEX_ALL = 1;

# Values that may appear in the result set of SQLStatistics() 
our $SQL_INDEX_CLUSTERED = 1;
our $SQL_INDEX_HASHED = 2;
our $SQL_INDEX_OTHER  = 3;

# SQLGetFunctions() values to identify ODBC APIs 
our $SQL_API_SQLALLOCHANDLESTD = 73;
our $SQL_API_SQLBULKOPERATIONS = 24;
our $SQL_API_SQLALLOCCONNECT = 1;
our $SQL_API_SQLALLOCENV = 2;
our $SQL_API_SQLALLOCHANDLE = 1001;
our $SQL_API_SQLALLOCSTMT = 3;
our $SQL_API_SQLBINDCOL = 4;
our $SQL_API_SQLBINDPARAM = 1002;
our $SQL_API_SQLCANCEL = 5;
our $SQL_API_SQLCLOSECURSOR = 1003;
our $SQL_API_SQLCOLATTRIBUTE = 6;
our $SQL_API_SQLCOLUMNS = 40;
our $SQL_API_SQLCONNECT = 7;
our $SQL_API_SQLCOPYDESC = 1004;
our $SQL_API_SQLDATASOURCES = 57;
our $SQL_API_SQLDESCRIBECOL = 8;
our $SQL_API_SQLDISCONNECT = 9;
our $SQL_API_SQLENDTRAN = 1005;
our $SQL_API_SQLERROR = 10;
our $SQL_API_SQLEXECDIRECT = 11;
our $SQL_API_SQLEXECUTE = 12;
our $SQL_API_SQLFETCH = 13;
our $SQL_API_SQLFETCHSCROLL = 1021;
our $SQL_API_SQLFREECONNECT = 14;
our $SQL_API_SQLFREEENV = 15;
our $SQL_API_SQLFREEHANDLE = 1006;
our $SQL_API_SQLFREESTMT = 16;
our $SQL_API_SQLGETCONNECTATTR = 1007;
our $SQL_API_SQLGETCONNECTOPTION = 42;
our $SQL_API_SQLGETCURSORNAME = 17;
our $SQL_API_SQLGETDATA = 43;
our $SQL_API_SQLGETDESCFIELD = 1008;
our $SQL_API_SQLGETDESCREC = 1009;
our $SQL_API_SQLGETDIAGFIELD = 1010;
our $SQL_API_SQLGETDIAGREC = 1011;
our $SQL_API_SQLGETENVATTR = 1012;
our $SQL_API_SQLGETFUNCTIONS = 44;
our $SQL_API_SQLGETINFO = 45;
our $SQL_API_SQLGETSTMTATTR = 1014;
our $SQL_API_SQLGETSTMTOPTION = 46;
our $SQL_API_SQLGETTYPEINFO = 47;
our $SQL_API_SQLNUMRESULTCOLS = 18;
our $SQL_API_SQLPARAMDATA = 48;
our $SQL_API_SQLPREPARE = 19;
our $SQL_API_SQLPUTDATA = 49;
our $SQL_API_SQLROWCOUNT = 20;
our $SQL_API_SQLSETCONNECTATTR = 1016;
our $SQL_API_SQLSETCONNECTOPTION = 50;
our $SQL_API_SQLSETCURSORNAME = 21;
our $SQL_API_SQLSETDESCFIELD = 1017;
our $SQL_API_SQLSETDESCREC = 1018;
our $SQL_API_SQLSETENVATTR = 1019;
our $SQL_API_SQLSETPARAM = 22;
our $SQL_API_SQLSETSTMTATTR = 1020;
our $SQL_API_SQLSETSTMTOPTION = 51;
our $SQL_API_SQLSPECIALCOLUMNS = 52;
our $SQL_API_SQLSTATISTICS = 53;
our $SQL_API_SQLTABLES = 54;
our $SQL_API_SQLTRANSACT = 23;

# Information requested by SQLGetInfo() 
our $SQL_MAX_DRIVER_CONNECTIONS = 0;
our $SQL_MAXIMUM_DRIVER_CONNECTIONS = 0;
our $SQL_MAX_CONCURRENT_ACTIVITIES = 1;
our $SQL_MAXIMUM_CONCURRENT_ACTIVITIES = 1;	
our $SQL_DATA_SOURCE_NAME = 2;
our $SQL_FETCH_DIRECTION = 8;
our $SQL_SERVER_NAME = 13;
our $SQL_SEARCH_PATTERN_ESCAPE = 14;
our $SQL_DBMS_NAME = 17;
our $SQL_DBMS_VER = 18;
our $SQL_ACCESSIBLE_TABLES = 19;
our $SQL_ACCESSIBLE_PROCEDURES = 20;
our $SQL_CURSOR_COMMIT_BEHAVIOR = 23;
our $SQL_DATA_SOURCE_READ_ONLY = 25;
our $SQL_DEFAULT_TXN_ISOLATION = 26;
our $SQL_IDENTIFIER_CASE = 28;
our $SQL_IDENTIFIER_QUOTE_CHAR = 29;
our $SQL_MAX_COLUMN_NAME_LEN = 30;
our $SQL_MAXIMUM_COLUMN_NAME_LENGTH = 30;
our $SQL_MAX_CURSOR_NAME_LEN = 31;
our $SQL_MAXIMUM_CURSOR_NAME_LENGTH = 31;
our $SQL_MAX_SCHEMA_NAME_LEN = 32;
our $SQL_MAXIMUM_SCHEMA_NAME_LENGTH = 32;
our $SQL_MAX_CATALOG_NAME_LEN = 34;
our $SQL_MAXIMUM_CATALOG_NAME_LENGTH = 34;
our $SQL_MAX_TABLE_NAME_LEN = 35;
our $SQL_SCROLL_CONCURRENCY = 43;
our $SQL_TXN_CAPABLE = 46;
our $SQL_TRANSACTION_CAPABLE = 46;
our $SQL_USER_NAME = 47;
our $SQL_TXN_ISOLATION_OPTION = 72;
our $SQL_TRANSACTION_ISOLATION_OPTION = 72;
our $SQL_INTEGRITY = 73;
our $SQL_GETDATA_EXTENSIONS = 81;
our $SQL_NULL_COLLATION = 85;
our $SQL_ALTER_TABLE = 86;
our $SQL_ORDER_BY_COLUMNS_IN_SELECT = 90;
our $SQL_SPECIAL_CHARACTERS = 94;
our $SQL_MAX_COLUMNS_IN_GROUP_BY = 97;
our $SQL_MAXIMUM_COLUMNS_IN_GROUP_BY = 97;
our $SQL_MAX_COLUMNS_IN_INDEX = 98;
our $SQL_MAXIMUM_COLUMNS_IN_INDEX = 98;
our $SQL_MAX_COLUMNS_IN_ORDER_BY = 99;
our $SQL_MAXIMUM_COLUMNS_IN_ORDER_BY = 99;
our $SQL_MAX_COLUMNS_IN_SELECT = 100;
our $SQL_MAXIMUM_COLUMNS_IN_SELECT = 100;
our $SQL_MAX_COLUMNS_IN_TABLE = 101;
our $SQL_MAX_INDEX_SIZE = 102;
our $SQL_MAXIMUM_INDEX_SIZE = 102;
our $SQL_MAX_ROW_SIZE = 104;
our $SQL_MAXIMUM_ROW_SIZE = 104;
our $SQL_MAX_STATEMENT_LEN = 105;
our $SQL_MAXIMUM_STATEMENT_LENGTH = 105;
our $SQL_MAX_TABLES_IN_SELECT = 106;
our $SQL_MAXIMUM_TABLES_IN_SELECT = 106;
our $SQL_MAX_USER_NAME_LEN = 107;
our $SQL_MAXIMUM_USER_NAME_LENGTH = 107;
our $SQL_OJ_CAPABILITIES = 115;
our $SQL_OUTER_JOIN_CAPABILITIES = 115;

our $SQL_XOPEN_CLI_YEAR = 10000;
our $SQL_CURSOR_SENSITIVITY = 10001;
our $SQL_DESCRIBE_PARAMETER = 10002;
our $SQL_CATALOG_NAME = 10003;
our $SQL_COLLATION_SEQ = 10004;
our $SQL_MAX_IDENTIFIER_LEN = 10005;
our $SQL_MAXIMUM_IDENTIFIER_LENGTH = 10005;

# SQL_ALTER_TABLE bitmasks 
our $SQL_AT_ADD_COLUMN = 0x00000001;
our $SQL_AT_DROP_COLUMN = 0x00000002;

our $SQL_AT_ADD_CONSTRAINT = 0x00000008;

# The following bitmasks are ODBC extensions and defined in sqlext.h
our $SQL_AT_COLUMN_SINGLE = 0x00000020;	
our $SQL_AT_ADD_COLUMN_DEFAULT = 0x00000040;
our $SQL_AT_ADD_COLUMN_COLLATION = 0x00000080;
our $SQL_AT_SET_COLUMN_DEFAULT = 0x00000100;
our $SQL_AT_DROP_COLUMN_DEFAULT = 0x00000200;
our $SQL_AT_DROP_COLUMN_CASCADE = 0x00000400;
our $SQL_AT_DROP_COLUMN_RESTRICT = 0x00000800;
our $SQL_AT_ADD_TABLE_CONSTRAINT = 0x00001000;
our $SQL_AT_DROP_TABLE_CONSTRAINT_CASCADE = 0x00002000;
our $SQL_AT_DROP_TABLE_CONSTRAINT_RESTRICT = 0x00004000;
our $SQL_AT_CONSTRAINT_NAME_DEFINITION = 0x00008000;
our $SQL_AT_CONSTRAINT_INITIALLY_DEFERRED = 0x00010000;
our $SQL_AT_CONSTRAINT_INITIALLY_IMMEDIATE = 0x00020000;
our $SQL_AT_CONSTRAINT_DEFERRABLE = 0x00040000;
our $SQL_AT_CONSTRAINT_NON_DEFERRABLE = 0x00080000;

our $SQL_ASYNC_MODE = 10021;
# SQL_ASYNC_MODE values 
our $SQL_AM_NONE = 0;
our $SQL_AM_CONNECTION = 1;
our $SQL_AM_STATEMENT = 2;

# SQL_CURSOR_COMMIT_BEHAVIOR values 
our $SQL_CB_DELETE = 0;
our $SQL_CB_CLOSE = 1;
our $SQL_CB_PRESERVE = 2;

# SQL_FETCH_DIRECTION bitmasks 
our $SQL_FD_FETCH_NEXT = 0x00000001;
our $SQL_FD_FETCH_FIRST = 0x00000002;
our $SQL_FD_FETCH_LAST = 0x00000004;
our $SQL_FD_FETCH_PRIOR = 0x00000008;
our $SQL_FD_FETCH_ABSOLUTE = 0x00000010;
our $SQL_FD_FETCH_RELATIVE = 0x00000020;

# SQL_GETDATA_EXTENSIONS bitmasks 
our $SQL_GD_ANY_COLUMN = 0x00000001;
our $SQL_GD_ANY_ORDER = 0x00000002;

# SQL_IDENTIFIER_CASE values 
our $SQL_IC_UPPER = 1;
our $SQL_IC_LOWER = 2;
our $SQL_IC_SENSITIVE = 3;
our $SQL_IC_MIXED = 4;

# SQL_OJ_CAPABILITIES bitmasks 
# NB: this means 'outer join', not what  you may be thinking 
our $SQL_OJ_LEFT = 0x00000001;
our $SQL_OJ_RIGHT = 0x00000002;
our $SQL_OJ_FULL = 0x00000004;
our $SQL_OJ_NESTED = 0x00000008;
our $SQL_OJ_NOT_ORDERED = 0x00000010;
our $SQL_OJ_INNER = 0x00000020;
our $SQL_OJ_ALL_COMPARISON_OPS = 0x00000040;

# SQL_SCROLL_CONCURRENCY bitmasks 
our $SQL_SCCO_READ_ONLY = 0x00000001;
our $SQL_SCCO_LOCK = 0x00000002;
our $SQL_SCCO_OPT_ROWVER = 0x00000004;
our $SQL_SCCO_OPT_VALUES = 0x00000008;

# SQL_TXN_CAPABLE values 
our $SQL_TC_NONE = 0;
our $SQL_TC_DML = 1;
our $SQL_TC_ALL = 2;
our $SQL_TC_DDL_COMMIT = 3;
our $SQL_TC_DDL_IGNORE = 4;

# SQL_TXN_ISOLATION_OPTION bitmasks 
our $SQL_TXN_READ_UNCOMMITTED = 0x00000001;
our $SQL_TRANSACTION_READ_UNCOMMITTED = 0x00000001;
our $SQL_TXN_READ_COMMITTED = 0x00000002;
our $SQL_TRANSACTION_READ_COMMITTED = 0x00000002;
our $SQL_TXN_REPEATABLE_READ = 0x00000004;
our $SQL_TRANSACTION_REPEATABLE_READ = 0x00000004;
our $SQL_TXN_SERIALIZABLE = 0x00000008;
our $SQL_TRANSACTION_SERIALIZABLE = 0x00000008;

# SQL_NULL_COLLATION values 
our $SQL_NC_HIGH = 0;
our $SQL_NC_LOW = 1;

# SQLDriverConnect Attributes
our $SQL_DRIVER_NOPROMPT = 0;
our $SQL_DRIVER_COMPLETE = 1;
our $SQL_DRIVER_PROMPT = 2;
our $SQL_DRIVER_COMPLETE_REQUIRED = 3;

# SQLGetConnectAttr ODBC 2
our $SQL_ACCESS_MODE = 101;
our $SQL_AUTOCOMMIT = 102;
our $SQL_LOGIN_TIMEOUT = 103;
our $SQL_OPT_TRACE = 104;
our $SQL_OPT_TRACEFILE = 105;
our $SQL_TRANSLATE_DLL = 106;
our $SQL_TRANSLATE_OPTION = 107;
our $SQL_TXN_ISOLATION = 108;
our $SQL_CURRENT_QUALIFIER = 109;
our $SQL_ODBC_CURSORS = 110;
our $SQL_QUIET_MODE = 111;
our $SQL_PACKET_SIZE = 112;
our $SQL_ATTR_CONNECTION_DEAD =  1209; # GetConnectAttr only

# SQLGetConnectAttr SQL_ACCESS_MODE 
our $SQL_MODE_READ_WRITE = 0;
our $SQL_MODE_READ_ONLY	= 1;
our $SQL_MODE_DEFAULT = $SQL_MODE_READ_WRITE;

# SQLGetConnectAttr - SQL_AUTOCOMMIT
our $SQL_AUTOCOMMIT_OFF = 0;
our $SQL_AUTOCOMMIT_ON = 1;
our $SQL_AUTOCOMMIT_DEFAULT = $SQL_AUTOCOMMIT_ON;

# SQLGetConnectAttr SQL_LOGIN_TIMEOUT attributes
our $SQL_LOGIN_TIMEOUT_DEFAULT = 15;

# SQLGetConnectAttr SQL_ODBC_CURSORS attributes
our $SQL_CUR_USE_IF_NEEDED = 0;
our $SQL_CUR_USE_ODBC = 1;
our $SQL_CUR_USE_DRIVER = 2;
our $SQL_CUR_DEFAULT = $SQL_CUR_USE_DRIVER;

# SQLGetConnectAttr SQL_OPT_TRACE attributes
our $SQL_OPT_TRACE_OFF = 0;
our $SQL_OPT_TRACE_ON = 1;
our $SQL_OPT_TRACE_DEFAULT = $SQL_OPT_TRACE_OFF;
## if defined (WIN32)
## define SQL_OPT_TRACE_FILE_DEFAULT		"\\SQL.LOG"
## else
our $SQL_OPT_TRACE_FILE_DEFAULT = "/tmp/odbc.log";

# SQLGetConnectAttr SQL_ATTR_CONNECTION_DEAD attributes
our $SQL_CD_TRUE = 1; 
our $SQL_CD_FALSE = 0; 

#  SQLGetConnectAttr SQL_ATTR_ANSI_APP attribute
our $SQL_AA_TRUE = 1; # ANSI 
our $SQL_AA_FALSE = 0; # Unicode

#  SQLGetConnectAttr SQL_ATTR_DISCONNECT_BEHAVIOR attribute
our $SQL_DB_RETURN_TO_POOL = 0;
our $SQL_DB_DISCONNECT = 1;
our $SQL_DB_DEFAULT = $SQL_DB_RETURN_TO_POOL;

# SQLGetConnectAttr SQL_ATTR_ENLIST_IN_DTC attribute
our $SQL_DTC_DONE = 0;

# SQLGetConnectAttr for Unicode drivers
our $SQL_ATTR_ANSI_APP = 115;

# SQLGetData
our $SQL_NO_TOTAL = -4; 

# SQLGetEnvAttr SQL_ATTR_ODBC_VERSION
our $SQL_OV_ODBC2 = 2;
our $SQL_OV_ODBC3 = 3;

our $SQL_API_SQLBINDPARAMETER = 72;
our $SQL_API_SQLBROWSECONNECT = 55;
our $SQL_API_SQLCOLATTRIBUTES = 6;
our $SQL_API_SQLCOLUMNPRIVILEGES = 56;
our $SQL_API_SQLDESCRIBEPARAM = 58;
our $SQL_API_SQLDRIVERCONNECT = 41;
our $SQL_API_SQLDRIVERS	= 71;
our $SQL_API_SQLEXTENDEDFETCH = 59;
our $SQL_API_SQLFOREIGNKEYS = 60;
our $SQL_API_SQLMORERESULTS = 61;
our $SQL_API_SQLNATIVESQL = 62;
our $SQL_API_SQLNUMPARAMS = 63;
our $SQL_API_SQLPARAMOPTIONS = 64;
our $SQL_API_SQLPRIMARYKEYS = 65;
our $SQL_API_SQLPROCEDURECOLUMNS = 66;
our $SQL_API_SQLPROCEDURES = 67;
our $SQL_API_SQLSETPOS = 68;
our $SQL_API_SQLSETSCROLLOPTIONS = 69;
our $SQL_API_SQLTABLEPRIVILEGES = 70;

our $SQL_TYPE_DATE = 91;
our $SQL_TYPE_TIME = 92;
our $SQL_TYPE_TIMESTAMP	= 93;

our $SQL_EXT_API_LAST = $SQL_API_SQLBINDPARAMETER;
our $SQL_NUM_FUNCTIONS = 23;
our $SQL_EXT_API_START = 40;
our $SQL_NUM_EXTENSIONS = ($SQL_EXT_API_LAST - $SQL_EXT_API_START + 1);
our $SQL_C_TYPE_DATE = $SQL_TYPE_DATE;
our $SQL_C_TYPE_TIME = $SQL_TYPE_TIME;
our $SQL_C_TYPE_TIMESTAMP = $SQL_TYPE_TIMESTAMP;
our $SQL_C_INTERVAL_YEAR = $SQL_INTERVAL_YEAR;
our $SQL_C_INTERVAL_MONTH = $SQL_INTERVAL_MONTH;
our $SQL_C_INTERVAL_DAY = $SQL_INTERVAL_DAY;
our $SQL_C_INTERVAL_HOUR = $SQL_INTERVAL_HOUR;
our $SQL_C_INTERVAL_MINUTE = $SQL_INTERVAL_MINUTE;
our $SQL_C_INTERVAL_SECOND = $SQL_INTERVAL_SECOND;
our $SQL_C_INTERVAL_YEAR_TO_MONTH = $SQL_INTERVAL_YEAR_TO_MONTH;
our $SQL_C_INTERVAL_DAY_TO_HOUR = $SQL_INTERVAL_DAY_TO_HOUR;
our $SQL_C_INTERVAL_DAY_TO_MINUTE = $SQL_INTERVAL_DAY_TO_MINUTE;
our $SQL_C_INTERVAL_DAY_TO_SECOND = $SQL_INTERVAL_DAY_TO_SECOND;
our $SQL_C_INTERVAL_HOUR_TO_MINUTE = $SQL_INTERVAL_HOUR_TO_MINUTE;
our $SQL_C_INTERVAL_HOUR_TO_SECOND = $SQL_INTERVAL_HOUR_TO_SECOND;
our $SQL_C_INTERVAL_MINUTE_TO_SECOND = $SQL_INTERVAL_MINUTE_TO_SECOND;
our $SQL_C_SBIGINT = ($SQL_BIGINT + $SQL_SIGNED_OFFSET);
our $SQL_C_UBIGINT = ($SQL_BIGINT + $SQL_UNSIGNED_OFFSET);
our $SQL_C_GUID = $SQL_GUID;
our $SQL_C_VARBOOKMARK = $SQL_C_BINARY;

our $SQL_ATTR_ACCESS_MODE = $SQL_ACCESS_MODE;
our $SQL_ATTR_AUTOCOMMIT = $SQL_AUTOCOMMIT;
our $SQL_ATTR_CONNECTION_TIMEOUT = 113;
our $SQL_ATTR_CURRENT_CATALOG = $SQL_CURRENT_QUALIFIER;
our $SQL_ATTR_DISCONNECT_BEHAVIOR = 114;
our $SQL_ATTR_ENLIST_IN_DTC = 1207;
our $SQL_ATTR_ENLIST_IN_XA = 1208;
our $SQL_ATTR_LOGIN_TIMEOUT = $SQL_LOGIN_TIMEOUT;
our $SQL_ATTR_ODBC_CURSORS = $SQL_ODBC_CURSORS;
our $SQL_ATTR_PACKET_SIZE = $SQL_PACKET_SIZE;
our $SQL_ATTR_QUIET_MODE = $SQL_QUIET_MODE;
our $SQL_ATTR_TRACE = $SQL_OPT_TRACE;
our $SQL_ATTR_TRACEFILE = $SQL_OPT_TRACEFILE;
our $SQL_ATTR_TRANSLATE_LIB = $SQL_TRANSLATE_DLL;
our $SQL_ATTR_TRANSLATE_OPTION = $SQL_TRANSLATE_OPTION;
our $SQL_ATTR_TXN_ISOLATION = $SQL_TXN_ISOLATION;

#  SQLGetDescField 
our $SQL_DESC_ARRAY_SIZE = 20;
our $SQL_DESC_ARRAY_STATUS_PTR = 21;
our $SQL_DESC_AUTO_UNIQUE_VALUE = $SQL_COLUMN_AUTO_INCREMENT;
our $SQL_DESC_BASE_COLUMN_NAME = 22;
our $SQL_DESC_BASE_TABLE_NAME = 23;
our $SQL_DESC_BIND_OFFSET_PTR = 24;
our $SQL_DESC_BIND_TYPE = 25;
our $SQL_DESC_CASE_SENSITIVE = $SQL_COLUMN_CASE_SENSITIVE;
our $SQL_DESC_CATALOG_NAME = $SQL_COLUMN_QUALIFIER_NAME;
our $SQL_DESC_CONCISE_TYPE = $SQL_COLUMN_TYPE;
our $SQL_DESC_DATETIME_INTERVAL_PRECISION = 26;
our $SQL_DESC_DISPLAY_SIZE = $SQL_COLUMN_DISPLAY_SIZE;
our $SQL_DESC_FIXED_PREC_SCALE = $SQL_COLUMN_MONEY;
our $SQL_DESC_LABEL = $SQL_COLUMN_LABEL;
our $SQL_DESC_LITERAL_PREFIX = 27;
our $SQL_DESC_LITERAL_SUFFIX = 28;
our $SQL_DESC_LOCAL_TYPE_NAME = 29;
our $SQL_DESC_MAXIMUM_SCALE = 30;
our $SQL_DESC_MINIMUM_SCALE = 31;
our $SQL_DESC_NUM_PREC_RADIX = 32;
our $SQL_DESC_PARAMETER_TYPE = 33;
our $SQL_DESC_ROWS_PROCESSED_PTR = 34;
our $SQL_DESC_ROWVER = 35;
our $SQL_DESC_SCHEMA_NAME = $SQL_COLUMN_OWNER_NAME;
our $SQL_DESC_SEARCHABLE = $SQL_COLUMN_SEARCHABLE;
our $SQL_DESC_TYPE_NAME = $SQL_COLUMN_TYPE_NAME;
our $SQL_DESC_TABLE_NAME = $SQL_COLUMN_TABLE_NAME;
our $SQL_DESC_UNSIGNED = $SQL_COLUMN_UNSIGNED;
our $SQL_DESC_UPDATABLE = $SQL_COLUMN_UPDATABLE;

# SQLGetDiagField
our $SQL_DIAG_CURSOR_ROW_COUNT = -1249;
our $SQL_DIAG_ROW_NUMBER = -1248;
our $SQL_DIAG_COLUMN_NUMBER = -1247;

#  SQLGetDiagField  attributes for 
#  SQL_DIAG_ROW_NUMBER and SQL_DIAG_COLUMN_NUMBER
our $SQL_NO_ROW_NUMBER = -1;
our $SQL_NO_COLUMN_NUMBER = -1;
our $SQL_ROW_NUMBER_UNKNOWN = -2;
our $SQL_COLUMN_NUMBER_UNKNOWN = -2;

# SQLGetEnvAttr ODBC 2
our $SQL_API_ALL_FUNCTIONS = 0;
our $SQL_API_LOADBYORDINAL = 199;

#  SQLGetFunctions SQL_API_ODBC3_ALL_FUNCTIONS attributes
our $SQL_API_ODBC3_ALL_FUNCTIONS = 999;
our $SQL_API_ODBC3_ALL_FUNCTIONS_SIZE = 250;
## #define SQL_FUNC_EXISTS(pfExists, uwAPI) \
##     ((*(((UWORD*) (pfExists)) + ((uwAPI) >> 4)) & (1 << ((uwAPI) & 0x000F))) \
##     ? SQL_TRUE : SQL_FALSE)

#  ODBC 2 SQLGetInfo 
our $SQL_INFO_FIRST = 0;
our $SQL_ACTIVE_CONNECTIONS = 0; 
our $SQL_ACTIVE_STATEMENTS = 1;
our $SQL_ACTIVE_ENVIRONMENTS = 116;
our $SQL_ALTER_DOMAIN = 117;
our $SQL_DRIVER_HDBC = 3;
our $SQL_DRIVER_HENV = 4;
our $SQL_DRIVER_HSTMT = 5;
our $SQL_DRIVER_NAME = 6;
our $SQL_DRIVER_VER = 7;
our $SQL_ODBC_API_CONFORMANCE = 9;
our $SQL_ODBC_VER = 10;
our $SQL_ROW_UPDATES = 11;
our $SQL_ODBC_SAG_CLI_CONFORMANCE = 12;
our $SQL_ODBC_SQL_CONFORMANCE = 15;
our $SQL_PROCEDURES = 21;
our $SQL_CONCAT_NULL_BEHAVIOR = 22;
our $SQL_CURSOR_ROLLBACK_BEHAVIOR = 24;
our $SQL_EXPRESSIONS_IN_ORDERBY = 27;
our $SQL_MAX_OWNER_NAME_LEN = 32;
our $SQL_MAX_PROCEDURE_NAME_LEN = 33;
our $SQL_MAX_QUALIFIER_NAME_LEN = 34;
our $SQL_MULT_RESULT_SETS = 36;
our $SQL_MULTIPLE_ACTIVE_TXN = 37;
our $SQL_OUTER_JOINS = 38;
our $SQL_OWNER_TERM = 39;
our $SQL_PROCEDURE_TERM = 40;
our $SQL_QUALIFIER_NAME_SEPARATOR = 41;
our $SQL_QUALIFIER_TERM = 42;
our $SQL_SCROLL_OPTIONS = 44;
our $SQL_TABLE_TERM = 45;
our $SQL_CONVERT_FUNCTIONS = 48;
our $SQL_NUMERIC_FUNCTIONS = 49;
our $SQL_STRING_FUNCTIONS = 50;
our $SQL_SYSTEM_FUNCTIONS = 51;
our $SQL_TIMEDATE_FUNCTIONS = 52;
our $SQL_CONVERT_BIGINT	= 53;
our $SQL_CONVERT_BINARY = 54;
our $SQL_CONVERT_BIT = 55;
our $SQL_CONVERT_CHAR = 56;
our $SQL_CONVERT_DATE = 57;
our $SQL_CONVERT_DECIMAL = 58;
our $SQL_CONVERT_DOUBLE = 59;
our $SQL_CONVERT_FLOAT = 60;
our $SQL_CONVERT_INTEGER = 61;
our $SQL_CONVERT_LONGVARCHAR = 62;
our $SQL_CONVERT_NUMERIC = 63;
our $SQL_CONVERT_REAL = 64;
our $SQL_CONVERT_SMALLINT = 65;
our $SQL_CONVERT_TIME = 66;
our $SQL_CONVERT_TIMESTAMP = 67;
our $SQL_CONVERT_TINYINT = 68;
our $SQL_CONVERT_VARBINARY = 69;
our $SQL_CONVERT_VARCHAR = 70;
our $SQL_CONVERT_LONGVARBINARY = 71;
our $SQL_ODBC_SQL_OPT_IEF = 73;
our $SQL_CORRELATION_NAME = 74;
our $SQL_NON_NULLABLE_COLUMNS = 75;
our $SQL_DRIVER_HLIB = 76;
our $SQL_DRIVER_ODBC_VER = 77;
our $SQL_LOCK_TYPES = 78;
our $SQL_POS_OPERATIONS = 79;
our $SQL_POSITIONED_STATEMENTS = 80;
our $SQL_BOOKMARK_PERSISTENCE = 82;
our $SQL_STATIC_SENSITIVITY = 83;
our $SQL_FILE_USAGE = 84;
our $SQL_COLUMN_ALIAS = 87;
our $SQL_GROUP_BY = 88;
our $SQL_KEYWORDS = 89;
our $SQL_OWNER_USAGE = 91;
our $SQL_QUALIFIER_USAGE = 92;
our $SQL_QUOTED_IDENTIFIER_CASE = 93;
our $SQL_SUBQUERIES = 95;
our $SQL_UNION = 96;
our $SQL_MAX_ROW_SIZE_INCLUDES_LONG = 103;
our $SQL_MAX_CHAR_LITERAL_LEN = 108;
our $SQL_TIMEDATE_ADD_INTERVALS = 109;
our $SQL_TIMEDATE_DIFF_INTERVALS = 110;
our $SQL_NEED_LONG_DATA_LEN = 111;
our $SQL_MAX_BINARY_LITERAL_LEN = 112;
our $SQL_LIKE_ESCAPE_CLAUSE = 113;
our $SQL_QUALIFIER_LOCATION = 114;

our $SQL_INFO_LAST = $SQL_QUALIFIER_LOCATION;
our $SQL_INFO_DRIVER_START = 1000;

our $SQL_SQL_CONFORMANCE = 118;
our $SQL_DATETIME_LITERALS = 119;

our $SQL_BATCH_ROW_COUNT = 120;
our $SQL_BATCH_SUPPORT = 121;
our $SQL_CATALOG_LOCATION = $SQL_QUALIFIER_LOCATION;
our $SQL_CATALOG_NAME_SEPARATOR = $SQL_QUALIFIER_NAME_SEPARATOR;
our $SQL_CATALOG_TERM = $SQL_QUALIFIER_TERM;
our $SQL_CATALOG_USAGE = $SQL_QUALIFIER_USAGE;
our $SQL_CONVERT_WCHAR = 122;
our $SQL_CONVERT_INTERVAL_DAY_TIME = 123;
our $SQL_CONVERT_INTERVAL_YEAR_MONTH = 124;
our $SQL_CONVERT_WLONGVARCHAR = 125;
our $SQL_CONVERT_WVARCHAR = 126;
our $SQL_CREATE_ASSERTION = 127;
our $SQL_CREATE_CHARACTER_SET = 128;
our $SQL_CREATE_COLLATION = 129;
our $SQL_CREATE_DOMAIN = 130;
our $SQL_CREATE_SCHEMA = 131;
our $SQL_CREATE_TABLE = 132;
our $SQL_CREATE_TRANSLATION = 133;
our $SQL_CREATE_VIEW = 134;
our $SQL_DRIVER_HDESC = 135;
our $SQL_DROP_ASSERTION	= 136;
our $SQL_DROP_CHARACTER_SET = 137;
our $SQL_DROP_COLLATION	= 138;
our $SQL_DROP_DOMAIN = 139;
our $SQL_DROP_SCHEMA = 140;
our $SQL_DROP_TABLE = 141;
our $SQL_DROP_TRANSLATION = 142;
our $SQL_DROP_VIEW = 143;
our $SQL_DYNAMIC_CURSOR_ATTRIBUTES1 = 144;
our $SQL_DYNAMIC_CURSOR_ATTRIBUTES2 = 145;
our $SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES1 = 146;
our $SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES2 = 147;
our $SQL_INDEX_KEYWORDS	= 148;
our $SQL_INFO_SCHEMA_VIEWS = 149;
our $SQL_KEYSET_CURSOR_ATTRIBUTES1 = 150;
our $SQL_KEYSET_CURSOR_ATTRIBUTES2 = 151;
our $SQL_MAX_ASYNC_CONCURRENT_STATEMENTS = 10022;
our $SQL_ODBC_INTERFACE_CONFORMANCE = 152;
our $SQL_PARAM_ARRAY_ROW_COUNTS = 153;
our $SQL_PARAM_ARRAY_SELECTS = 154;
our $SQL_SCHEMA_TERM = $SQL_OWNER_TERM;
our $SQL_SCHEMA_USAGE = $SQL_OWNER_USAGE;
our $SQL_SQL92_DATETIME_FUNCTIONS = 155;
our $SQL_SQL92_FOREIGN_KEY_DELETE_RULE = 156;
our $SQL_SQL92_FOREIGN_KEY_UPDATE_RULE = 157;
our $SQL_SQL92_GRANT = 158;
our $SQL_SQL92_NUMERIC_VALUE_FUNCTIONS = 159;
our $SQL_SQL92_PREDICATES = 160;
our $SQL_SQL92_RELATIONAL_JOIN_OPERATORS = 161;
our $SQL_SQL92_REVOKE = 162;
our $SQL_SQL92_ROW_VALUE_CONSTRUCTOR = 163;
our $SQL_SQL92_STRING_FUNCTIONS = 164;
our $SQL_SQL92_VALUE_EXPRESSIONS = 165;
our $SQL_STANDARD_CLI_CONFORMANCE = 166;
our $SQL_STATIC_CURSOR_ATTRIBUTES1 = 167;
our $SQL_STATIC_CURSOR_ATTRIBUTES2 = 168;
our $SQL_AGGREGATE_FUNCTIONS = 169;
our $SQL_DDL_INDEX = 170;
our $SQL_DM_VER	= 171;
our $SQL_INSERT_STATEMENT = 172;
our $SQL_UNION_STATEMENT = $SQL_UNION;

our $SQL_DTC_TRANSITION_COST = 1750;

#  SQLGetInfo SQL_AGGREGATE_FUNCTIONS attributes
our $SQL_AF_AVG = 0x00000001;
our $SQL_AF_COUNT = 0x00000002;
our $SQL_AF_MAX = 0x00000004;
our $SQL_AF_MIN	= 0x00000008;
our $SQL_AF_SUM	= 0x00000010;
our $SQL_AF_DISTINCT = 0x00000020;
our $SQL_AF_ALL	= 0x00000040;

#  SQLGetInfo - SQL_ALTER_DOMAIN
our $SQL_AD_CONSTRAINT_NAME_DEFINITION = 0x00000001;
our $SQL_AD_ADD_DOMAIN_CONSTRAINT = 0x00000002;
our $SQL_AD_DROP_DOMAIN_CONSTRAINT = 0x00000004;
our $SQL_AD_ADD_DOMAIN_DEFAULT = 0x00000008;
our $SQL_AD_DROP_DOMAIN_DEFAULT = 0x00000010;
our $SQL_AD_ADD_CONSTRAINT_INITIALLY_DEFERRED = 0x00000020;
our $SQL_AD_ADD_CONSTRAINT_INITIALLY_IMMEDIATE = 0x00000040;
our $SQL_AD_ADD_CONSTRAINT_DEFERRABLE = 0x00000080;
our $SQL_AD_ADD_CONSTRAINT_NON_DEFERRABLE = 0x00000100;

#  SQLGetInfo SQL_BATCH_ROW_COUNT attributes
our $SQL_BRC_PROCEDURES = 0x0000001;
our $SQL_BRC_EXPLICIT = 0x0000002;
our $SQL_BRC_ROLLED_UP = 0x0000004;

#  SQLGetInfo - SQL_BATCH_SUPPORT attributes
our $SQL_BS_SELECT_EXPLICIT = 0x00000001;
our $SQL_BS_ROW_COUNT_EXPLICIT = 0x00000002;
our $SQL_BS_SELECT_PROC = 0x00000004;
our $SQL_BS_ROW_COUNT_PROC = 0x00000008;

#  SQLGetInfo - SQL_BOOKMARK_PERSISTENCE attributes
our $SQL_BP_CLOSE = 0x00000001;
our $SQL_BP_DELETE = 0x00000002;
our $SQL_BP_DROP = 0x00000004;
our $SQL_BP_TRANSACTION = 0x00000008;
our $SQL_BP_UPDATE = 0x00000010;
our $SQL_BP_OTHER_HSTMT = 0x00000020;
our $SQL_BP_SCROLL = 0x00000040;

#  SQLGetInfo SQL_QUALIFIER_LOCATION
our $SQL_QL_START = 0x0001;
our $SQL_QL_END = 0x0002;

#  SQLGetInfo - SQL_CATALOG_LOCATION attributes
our $SQL_CL_START = $SQL_QL_START;
our $SQL_CL_END = $SQL_QL_END;

#  SQLGetInfo SQL_QUALIFIER_USAGE attributes
our $SQL_QU_DML_STATEMENTS = 0x00000001;
our $SQL_QU_PROCEDURE_INVOCATION = 0x00000002;
our $SQL_QU_TABLE_DEFINITION = 0x00000004;
our $SQL_QU_INDEX_DEFINITION = 0x00000008;
our $SQL_QU_PRIVILEGE_DEFINITION = 0x00000010;

#  SQLGetInfo - SQL_CATALOG_USAGE attributes
our $SQL_CU_DML_STATEMENTS = $SQL_QU_DML_STATEMENTS;
our $SQL_CU_PROCEDURE_INVOCATION = $SQL_QU_PROCEDURE_INVOCATION;
our $SQL_CU_TABLE_DEFINITION = $SQL_QU_TABLE_DEFINITION;
our $SQL_CU_INDEX_DEFINITION = $SQL_QU_INDEX_DEFINITION;
our $SQL_CU_PRIVILEGE_DEFINITION = $SQL_QU_PRIVILEGE_DEFINITION;

#  SQLGetInfo SQL_CONCAT_NULL_BEHAVIOR attributes
our $SQL_CB_NULL = 0x0000;
our $SQL_CB_NON_NULL = 0x0001;

#  SQLGetInfo SQL_CONVERT_* bitmask values
our $SQL_CVT_CHAR = 0x00000001;
our $SQL_CVT_NUMERIC = 0x00000002;
our $SQL_CVT_DECIMAL = 0x00000004;
our $SQL_CVT_INTEGER = 0x00000008;
our $SQL_CVT_SMALLINT = 0x00000010;
our $SQL_CVT_FLOAT = 0x00000020;
our $SQL_CVT_REAL = 0x00000040;
our $SQL_CVT_DOUBLE = 0x00000080;
our $SQL_CVT_VARCHAR = 0x00000100;
our $SQL_CVT_LONGVARCHAR = 0x00000200;
our $SQL_CVT_BINARY = 0x00000400;
our $SQL_CVT_VARBINARY = 0x00000800;
our $SQL_CVT_BIT = 0x00001000;
our $SQL_CVT_TINYINT = 0x00002000;
our $SQL_CVT_BIGINT = 0x00004000;
our $SQL_CVT_DATE = 0x00008000;
our $SQL_CVT_TIME = 0x00010000;
our $SQL_CVT_TIMESTAMP = 0x00020000;
our $SQL_CVT_LONGVARBINARY = 0x00040000;
our $SQL_CVT_INTERVAL_YEAR_MONTH = 0x00080000;
our $SQL_CVT_INTERVAL_DAY_TIME = 0x00100000;
our $SQL_CVT_WCHAR = 0x00200000;
our $SQL_CVT_WLONGVARCHAR = 0x00400000;
our $SQL_CVT_WVARCHAR = 0x00800000;

#   SQLGetInfo SQL_CONVERT_FUNCTIONS attributes
our $SQL_FN_CVT_CONVERT = 0x00000001;
our $SQL_FN_CVT_CAST = 0x00000002;

#  SQLGetInfo SQL_CORRELATION_NAME attributes
our $SQL_CN_NONE = 0x0000;
our $SQL_CN_DIFFERENT = 0x0001;
our $SQL_CN_ANY = 0x0002;

#  SQLGetInfo SQL_CREATE_ASSERTION attributes
our $SQL_CA_CREATE_ASSERTION = 0x00000001;
our $SQL_CA_CONSTRAINT_INITIALLY_DEFERRED = 0x00000010;
our $SQL_CA_CONSTRAINT_INITIALLY_IMMEDIATE = 0x00000020;
our $SQL_CA_CONSTRAINT_DEFERRABLE = 0x00000040;
our $SQL_CA_CONSTRAINT_NON_DEFERRABLE = 0x00000080;

#  SQLGetInfo SQL_CREATE_CHARACTER_SET attributes
our $SQL_CCS_CREATE_CHARACTER_SET = 0x00000001;
our $SQL_CCS_COLLATE_CLAUSE = 0x00000002;
our $SQL_CCS_LIMITED_COLLATION = 0x00000004;

#  SQLGetInfo SQL_CREATE_COLLATION attributes
our $SQL_CCOL_CREATE_COLLATION = 0x00000001;

#  SQLGetInfo SQL_CREATE_DOMAIN attributes
our $SQL_CDO_CREATE_DOMAIN = 0x00000001;
our $SQL_CDO_DEFAULT = 0x00000002;
our $SQL_CDO_CONSTRAINT = 0x00000004;
our $SQL_CDO_COLLATION = 0x00000008;
our $SQL_CDO_CONSTRAINT_NAME_DEFINITION	= 0x00000010;
our $SQL_CDO_CONSTRAINT_INITIALLY_DEFERRED = 0x00000020;
our $SQL_CDO_CONSTRAINT_INITIALLY_IMMEDIATE = 0x00000040;
our $SQL_CDO_CONSTRAINT_DEFERRABLE = 0x00000080;
our $SQL_CDO_CONSTRAINT_NON_DEFERRABLE = 0x00000100;

#   SQLGetInfo SQL_CREATE_SCHEMA attributes
our $SQL_CS_CREATE_SCHEMA = 0x00000001;
our $SQL_CS_AUTHORIZATION = 0x00000002;
our $SQL_CS_DEFAULT_CHARACTER_SET = 0x00000004;

#  SQLGetInfo SQL_CREATE_TABLE attributes
our $SQL_CT_CREATE_TABLE = 0x00000001;
our $SQL_CT_COMMIT_PRESERVE = 0x00000002;
our $SQL_CT_COMMIT_DELETE = 0x00000004;
our $SQL_CT_GLOBAL_TEMPORARY = 0x00000008;
our $SQL_CT_LOCAL_TEMPORARY = 0x00000010;
our $SQL_CT_CONSTRAINT_INITIALLY_DEFERRED = 0x00000020;
our $SQL_CT_CONSTRAINT_INITIALLY_IMMEDIATE = 0x00000040;
our $SQL_CT_CONSTRAINT_DEFERRABLE = 0x00000080;
our $SQL_CT_CONSTRAINT_NON_DEFERRABLE = 0x00000100;
our $SQL_CT_COLUMN_CONSTRAINT = 0x00000200;
our $SQL_CT_COLUMN_DEFAULT = 0x00000400;
our $SQL_CT_COLUMN_COLLATION = 0x00000800;
our $SQL_CT_TABLE_CONSTRAINT = 0x00001000;
our $SQL_CT_CONSTRAINT_NAME_DEFINITION = 0x00002000;

#  SQLGetInfo SQL_CREATE_TRANSLATION attributes
our $SQL_CTR_CREATE_TRANSLATION = 0x00000001;

#  SQLGetInfo SQL_DATETIME_LITERALS attributes
our $SQL_DL_SQL92_DATE = 0x00000001;
our $SQL_DL_SQL92_TIME = 0x00000002;
our $SQL_DL_SQL92_TIMESTAMP = 0x00000004;
our $SQL_DL_SQL92_INTERVAL_YEAR = 0x00000008;
our $SQL_DL_SQL92_INTERVAL_MONTH = 0x00000010;
our $SQL_DL_SQL92_INTERVAL_DAY = 0x00000020;
our $SQL_DL_SQL92_INTERVAL_HOUR = 0x00000040;
our $SQL_DL_SQL92_INTERVAL_MINUTE = 0x00000080;
our $SQL_DL_SQL92_INTERVAL_SECOND = 0x00000100;
our $SQL_DL_SQL92_INTERVAL_YEAR_TO_MONTH = 0x00000200;
our $SQL_DL_SQL92_INTERVAL_DAY_TO_HOUR = 0x00000400;
our $SQL_DL_SQL92_INTERVAL_DAY_TO_MINUTE = 0x00000800;
our $SQL_DL_SQL92_INTERVAL_DAY_TO_SECOND = 0x00001000;
our $SQL_DL_SQL92_INTERVAL_HOUR_TO_MINUTE = 0x00002000;
our $SQL_DL_SQL92_INTERVAL_HOUR_TO_SECOND = 0x00004000;
our $SQL_DL_SQL92_INTERVAL_MINUTE_TO_SECOND = 0x00008000;

#  SQLGetInfo SQL_DDL_INDEX attributes
our $SQL_DI_CREATE_INDEX = 0x00000001;
our $SQL_DI_DROP_INDEX = 0x00000002;

#  SQLGetInfo SQL_DROP_ASSERTION attributes
our $SQL_DA_DROP_ASSERTION = 0x00000001;

# SQLGetInfo SQL_DROP_CHARACTER_SET attributes
our $SQL_DCS_DROP_CHARACTER_SET = 0x00000001;

#  SQLGetInfo SQL_DROP_COLLATION attributes
our $SQL_DC_DROP_COLLATION = 0x00000001;

#  SQLGetInfo SQL_DROP_DOMAIN attributes
our $SQL_DD_DROP_DOMAIN = 0x00000001;
our $SQL_DD_RESTRICT = 0x00000002;
our $SQL_DD_CASCADE = 0x00000004;

# SQLGetInfo SQL_DROP_SCHEMA attributes
our $SQL_DS_DROP_SCHEMA = 0x00000001;
our $SQL_DS_RESTRICT = 0x00000002;
our $SQL_DS_CASCADE = 0x00000004;

#  SQLGetInfo SQL_DROP_TABLE attributes
our $SQL_DT_DROP_TABLE = 0x00000001;
our $SQL_DT_RESTRICT = 0x00000002;
our $SQL_DT_CASCADE = 0x00000004;

#  SQLGetInfo SQL_DROP_TRANSLATION attributes
our $SQL_DTR_DROP_TRANSLATION = 0x00000001;

#  SQLGetInfo SQL_DROP_VIEW attributes
our $SQL_DV_DROP_VIEW = 0x00000001;
our $SQL_DV_RESTRICT = 0x00000002;
our $SQL_DV_CASCADE = 0x00000004;

#  SQLGetInfo SQL_DTC_TRANSITION_COST attributes
our $SQL_DTC_ENLIST_EXPENSIVE = 0x00000001;
our $SQL_DTC_UNENLIST_EXPENSIVE = 0x00000002;

#  SQLFetchScroll FetchOrientation attributes
our $SQL_CA1_NEXT = 0x00000001;
our $SQL_CA1_ABSOLUTE = 0x00000002;
our $SQL_CA1_RELATIVE = 0x00000004;
our $SQL_CA1_BOOKMARK = 0x00000008;

#  SQLSetPos LockType attributes
our $SQL_CA1_LOCK_NO_CHANGE = 0x00000040;
our $SQL_CA1_LOCK_EXCLUSIVE = 0x00000080;
our $SQL_CA1_LOCK_UNLOCK = 0x00000100;

#  SQLSetPos Operations attributes
our $SQL_CA1_POS_POSITION = 0x00000200;
our $SQL_CA1_POS_UPDATE = 0x00000400;
our $SQL_CA1_POS_DELETE = 0x00000800;
our $SQL_CA1_POS_REFRESH = 0x00001000;

our $SQL_CA1_POSITIONED_UPDATE = 0x00002000;
our $SQL_CA1_POSITIONED_DELETE = 0x00004000;
our $SQL_CA1_SELECT_FOR_UPDATE = 0x00008000;

#  SQLBulkOperations
our $SQL_CA1_BULK_ADD = 0x00010000;
our $SQL_CA1_BULK_UPDATE_BY_BOOKMARK = 0x00020000;
our $SQL_CA1_BULK_DELETE_BY_BOOKMARK = 0x00040000;
our $SQL_CA1_BULK_FETCH_BY_BOOKMARK = 0x00080000;
our $SQL_CA2_READ_ONLY_CONCURRENCY = 0x00000001;
our $SQL_CA2_LOCK_CONCURRENCY = 0x00000002;
our $SQL_CA2_OPT_ROWVER_CONCURRENCY = 0x00000004;
our $SQL_CA2_OPT_VALUES_CONCURRENCY = 0x00000008;
our $SQL_CA2_SENSITIVITY_ADDITIONS = 0x00000010;
our $SQL_CA2_SENSITIVITY_DELETIONS = 0x00000020;
our $SQL_CA2_SENSITIVITY_UPDATES = 0x00000040;

# SQL_ATTR_MAX_ROWS
our $SQL_CA2_MAX_ROWS_SELECT = 0x00000080;
our $SQL_CA2_MAX_ROWS_INSERT = 0x00000100;
our $SQL_CA2_MAX_ROWS_DELETE = 0x00000200;
our $SQL_CA2_MAX_ROWS_UPDATE = 0x00000400;
our $SQL_CA2_MAX_ROWS_CATALOG = 0x00000800;
our $SQL_CA2_MAX_ROWS_AFFECTS_ALL = 
    ($SQL_CA2_MAX_ROWS_SELECT || $SQL_CA2_MAX_ROWS_INSERT || 
     $SQL_CA2_MAX_ROWS_DELETE || $SQL_CA2_MAX_ROWS_UPDATE ||
     $SQL_CA2_MAX_ROWS_CATALOG);

#  SQL_DIAG_CURSOR_ROW_COUNT
our $SQL_CA2_CRC_EXACT = 0x00001000;
our $SQL_CA2_CRC_APPROXIMATE = 0x00002000;

our $SQL_CA2_SIMULATE_NON_UNIQUE = 0x00004000;
our $SQL_CA2_SIMULATE_TRY_UNIQUE = 0x00008000;
our $SQL_CA2_SIMULATE_UNIQUE = 0x00010000;

#  SQLGetInfo SQL_FETCH_DIRECTION attributes
our $SQL_FD_FETCH_RESUME = 0x00000040;

our $SQL_FD_FETCH_BOOKMARK = 0x00000080;

#  SQLGetInfo SQL_FILE_USAGE attributes
our $SQL_FILE_NOT_SUPPORTED = 0x0000;
our $SQL_FILE_TABLE = 0x0001;
our $SQL_FILE_QUALIFIER = 0x0002;
our $SQL_FILE_CATALOG = $SQL_FILE_QUALIFIER;

#  SQLGetInfo SQL_GETDATA_EXTENSIONS attributes
our $SQL_GD_BLOCK = 0x00000004;
our $SQL_GD_BOUND = 0x00000008;

#  SQLGetInfo SQL_GROUP_BY attributes
our $SQL_GB_NOT_SUPPORTED = 0x0000;
our $SQL_GB_GROUP_BY_EQUALS_SELECT = 0x0001;
our $SQL_GB_GROUP_BY_CONTAINS_SELECT = 0x0002;
our $SQL_GB_NO_RELATION = 0x0003;
our $SQL_GB_COLLATE = 0x0004;

#  SQLGetInfo SQL_INDEX_KEYWORDS attributes
our $SQL_IK_NONE = 0x00000000;
our $SQL_IK_ASC = 0x00000001;
our $SQL_IK_DESC = 0x00000002;
our $SQL_IK_ALL = ($SQL_IK_ASC || $SQL_IK_DESC);

#  SQLGetInfo SQL_INFO_SCHEMA_VIEWS attributes
our $SQL_ISV_ASSERTIONS = 0x00000001;
our $SQL_ISV_CHARACTER_SETS = 0x00000002;
our $SQL_ISV_CHECK_CONSTRAINTS = 0x00000004;
our $SQL_ISV_COLLATIONS = 0x00000008;
our $SQL_ISV_COLUMN_DOMAIN_USAGE = 0x00000010;
our $SQL_ISV_COLUMN_PRIVILEGES = 0x00000020;
our $SQL_ISV_COLUMNS = 0x00000040;
our $SQL_ISV_CONSTRAINT_COLUMN_USAGE = 0x00000080;
our $SQL_ISV_CONSTRAINT_TABLE_USAGE = 0x00000100;
our $SQL_ISV_DOMAIN_CONSTRAINTS = 0x00000200;
our $SQL_ISV_DOMAINS = 0x00000400;
our $SQL_ISV_KEY_COLUMN_USAGE = 0x00000800;
our $SQL_ISV_REFERENTIAL_CONSTRAINTS = 0x00001000;
our $SQL_ISV_SCHEMATA = 0x00002000;
our $SQL_ISV_SQL_LANGUAGES = 0x00004000;
our $SQL_ISV_TABLE_CONSTRAINTS = 0x00008000;
our $SQL_ISV_TABLE_PRIVILEGES = 0x00010000;
our $SQL_ISV_TABLES = 0x00020000;
our $SQL_ISV_TRANSLATIONS = 0x00040000;
our $SQL_ISV_USAGE_PRIVILEGES = 0x00080000;
our $SQL_ISV_VIEW_COLUMN_USAGE = 0x00100000;
our $SQL_ISV_VIEW_TABLE_USAGE = 0x00200000;
our $SQL_ISV_VIEWS = 0x00400000;

#  SQLGetInfo SQL_INSERT_STATEMENT attributes
our $SQL_IS_INSERT_LITERALS = 0x00000001;
our $SQL_IS_INSERT_SEARCHED = 0x00000002;
our $SQL_IS_SELECT_INTO = 0x00000004;

#  SQLGetInfo SQL_LOCK_TYPES attributes
our $SQL_LCK_NO_CHANGE = 0x00000001;
our $SQL_LCK_EXCLUSIVE = 0x00000002;
our $SQL_LCK_UNLOCK = 0x00000004;

#  SQLGetInfo SQL_POS_OPERATIONS attributes
our $SQL_POS_POSITION = 0x00000001;
our $SQL_POS_REFRESH = 0x00000002;
our $SQL_POS_UPDATE = 0x00000004;
our $SQL_POS_DELETE = 0x00000008;
our $SQL_POS_ADD = 0x00000010;

#  SQLGetInfo SQL_NON_NULLABLE_COLUMNS attributes
our $SQL_NNC_NULL = 0x0000;
our $SQL_NNC_NON_NULL = 0x0001;

#  SQLGetInfo SQL_NULL_COLLATION attributes
our $SQL_NC_START = 0x0002;
our $SQL_NC_END = 0x0004;

#  SQLGetInfo SQL_NUMERIC_FUNCTIONS attributes
our $SQL_FN_NUM_ABS = 0x00000001;
our $SQL_FN_NUM_ACOS = 0x00000002;
our $SQL_FN_NUM_ASIN = 0x00000004;
our $SQL_FN_NUM_ATAN = 0x00000008;
our $SQL_FN_NUM_ATAN2 = 0x00000010;
our $SQL_FN_NUM_CEILING = 0x00000020;
our $SQL_FN_NUM_COS = 0x00000040;
our $SQL_FN_NUM_COT = 0x00000080;
our $SQL_FN_NUM_EXP = 0x00000100;
our $SQL_FN_NUM_FLOOR = 0x00000200;
our $SQL_FN_NUM_LOG = 0x00000400;
our $SQL_FN_NUM_MOD = 0x00000800;
our $SQL_FN_NUM_SIGN = 0x00001000;
our $SQL_FN_NUM_SIN = 0x00002000;
our $SQL_FN_NUM_SQRT = 0x00004000;
our $SQL_FN_NUM_TAN = 0x00008000;
our $SQL_FN_NUM_PI = 0x00010000;
our $SQL_FN_NUM_RAND = 0x00020000;
our $SQL_FN_NUM_DEGREES = 0x00040000;
our $SQL_FN_NUM_LOG10 = 0x00080000;
our $SQL_FN_NUM_POWER = 0x00100000;
our $SQL_FN_NUM_RADIANS	= 0x00200000;
our $SQL_FN_NUM_ROUND = 0x00400000;
our $SQL_FN_NUM_TRUNCATE = 0x00800000;

#  SQLGetInfo SQL_ODBC_API_CONFORMANCE attributes
our $SQL_OAC_NONE = 0x0000;
our $SQL_OAC_LEVEL1 = 0x0001;
our $SQL_OAC_LEVEL2 = 0x0002;

#  SQLGetInfo SQL_ODBC_INTERFACE_CONFORMANCE attributes
our $SQL_OIC_CORE = 1;
our $SQL_OIC_LEVEL1 = 2;
our $SQL_OIC_LEVEL2 = 3;

#  SQLGetInfo SQL_ODBC_SAG_CLI_CONFORMANCE attributes
our $SQL_OSCC_NOT_COMPLIANT = 0x0000;
our $SQL_OSCC_COMPLIANT = 0x0001;

#  SQLGetInfo SQL_ODBC_SQL_CONFORMANCE attributes
our $SQL_OSC_MINIMUM = 0x0000;
our $SQL_OSC_CORE = 0x0001;
our $SQL_OSC_EXTENDED =	0x0002;

#  SQLGetInfo SQL_OWNER_USAGE attributes
our $SQL_OU_DML_STATEMENTS = 0x00000001;
our $SQL_OU_PROCEDURE_INVOCATION = 0x00000002;
our $SQL_OU_TABLE_DEFINITION = 0x00000004;
our $SQL_OU_INDEX_DEFINITION = 0x00000008;
our $SQL_OU_PRIVILEGE_DEFINITION = 0x00000010;

#  SQLGetInfo SQL_PARAM_ARRAY_ROW_COUNTS attributes
our $SQL_PARC_BATCH = 1;
our $SQL_PARC_NO_BATCH = 2;

#  SQLGetInfo SQL_PARAM_ARRAY_SELECTS attributes
our $SQL_PAS_BATCH = 1;
our $SQL_PAS_NO_BATCH = 2;
our $SQL_PAS_NO_SELECT = 3;

#  SQLGetInfo SQL_POSITIONED_STATEMENTS Attributes
our $SQL_PS_POSITIONED_DELETE = 0x00000001;
our $SQL_PS_POSITIONED_UPDATE = 0x00000002;
our $SQL_PS_SELECT_FOR_UPDATE = 0x00000004;

#  SQLGetInfo  SQL_SCHEMA_USAGE attributes
our $SQL_SU_DML_STATEMENTS = $SQL_OU_DML_STATEMENTS;
our $SQL_SU_PROCEDURE_INVOCATION = $SQL_OU_PROCEDURE_INVOCATION;
our $SQL_SU_TABLE_DEFINITION = $SQL_OU_TABLE_DEFINITION;
our $SQL_SU_INDEX_DEFINITION = $SQL_OU_INDEX_DEFINITION;
our $SQL_SU_PRIVILEGE_DEFINITION = $SQL_OU_PRIVILEGE_DEFINITION;

#  SQLGetInfo SQL_SCROLL_OPTIONS attributes
our $SQL_SO_FORWARD_ONLY = 0x00000001;
our $SQL_SO_KEYSET_DRIVEN = 0x00000002;
our $SQL_SO_DYNAMIC = 0x00000004;
our $SQL_SO_MIXED = 0x00000008;
our $SQL_SO_STATIC = 0x00000010;

#  SQLGetInfo SQL_SQL_CONFORMANCE attributes
our $SQL_SC_SQL92_ENTRY = 0x00000001;
our $SQL_SC_FIPS127_2_TRANSITIONAL = 0x00000002;
our $SQL_SC_SQL92_INTERMEDIATE = 0x00000004;
our $SQL_SC_SQL92_FULL = 0x00000008;

#  SQLGetInfo SQL_SQL92_DATETIME_FUNCTIONS attributes
our $SQL_SDF_CURRENT_DATE = 0x00000001;
our $SQL_SDF_CURRENT_TIME = 0x00000002;
our $SQL_SDF_CURRENT_TIMESTAMP = 0x00000004;

#  SQLGetInfo SQL_SQL92_FOREIGN_KEY_DELETE_RULE attributes
our $SQL_SFKD_CASCADE = 0x00000001;
our $SQL_SFKD_NO_ACTION = 0x00000002;
our $SQL_SFKD_SET_DEFAULT = 0x00000004;
our $SQL_SFKD_SET_NULL = 0x00000008;

#  SQLGetInfo SQL_SQL92_FOREIGN_KEY_UPDATE_RULE attributes
our $SQL_SFKU_CASCADE = 0x00000001;
our $SQL_SFKU_NO_ACTION = 0x00000002;
our $SQL_SFKU_SET_DEFAULT = 0x00000004;
our $SQL_SFKU_SET_NULL = 0x00000008;

#  SQLGetInfo - SQL_SQL92_GRANT attributes
our $SQL_SG_USAGE_ON_DOMAIN = 0x00000001;
our $SQL_SG_USAGE_ON_CHARACTER_SET = 0x00000002;
our $SQL_SG_USAGE_ON_COLLATION = 0x00000004;
our $SQL_SG_USAGE_ON_TRANSLATION = 0x00000008;
our $SQL_SG_WITH_GRANT_OPTION = 0x00000010;
our $SQL_SG_DELETE_TABLE = 0x00000020;
our $SQL_SG_INSERT_TABLE = 0x00000040;
our $SQL_SG_INSERT_COLUMN = 0x00000080;
our $SQL_SG_REFERENCES_TABLE = 0x00000100;
our $SQL_SG_REFERENCES_COLUMN = 0x00000200;
our $SQL_SG_SELECT_TABLE = 0x00000400;
our $SQL_SG_UPDATE_TABLE = 0x00000800;
our $SQL_SG_UPDATE_COLUMN = 0x00001000;

#  SQLGetInfo SQL_SQL92_NUMERIC_VALUE_FUNCTIONS attributes
our $SQL_SNVF_BIT_LENGTH = 0x00000001;
our $SQL_SNVF_CHAR_LENGTH = 0x00000002;
our $SQL_SNVF_CHARACTER_LENGTH = 0x00000004;
our $SQL_SNVF_EXTRACT = 0x00000008;
our $SQL_SNVF_OCTET_LENGTH = 0x00000010;
our $SQL_SNVF_POSITION = 0x00000020;

#  SQLGetInfo SQL_SQL92_PREDICATES attributes
our $SQL_SP_EXISTS = 0x00000001;
our $SQL_SP_ISNOTNULL = 0x00000002;
our $SQL_SP_ISNULL = 0x00000004;
our $SQL_SP_MATCH_FULL = 0x00000008;
our $SQL_SP_MATCH_PARTIAL = 0x00000010;
our $SQL_SP_MATCH_UNIQUE_FULL = 0x00000020;
our $SQL_SP_MATCH_UNIQUE_PARTIAL = 0x00000040;
our $SQL_SP_OVERLAPS = 0x00000080;
our $SQL_SP_UNIQUE = 0x00000100;
our $SQL_SP_LIKE = 0x00000200;
our $SQL_SP_IN = 0x00000400;
our $SQL_SP_BETWEEN = 0x00000800;
our $SQL_SP_COMPARISON = 0x00001000;
our $SQL_SP_QUANTIFIED_COMPARISON = 0x00002000;

#  SQLGetInfo SQL_SQL92_RELATIONAL_JOIN_OPERATORS attributes
our $SQL_SRJO_CORRESPONDING_CLAUSE = 0x00000001;
our $SQL_SRJO_CROSS_JOIN = 0x00000002;
our $SQL_SRJO_EXCEPT_JOIN = 0x00000004;
our $SQL_SRJO_FULL_OUTER_JOIN = 0x00000008;
our $SQL_SRJO_INNER_JOIN = 0x00000010;
our $SQL_SRJO_INTERSECT_JOIN = 0x00000020;
our $SQL_SRJO_LEFT_OUTER_JOIN = 0x00000040;
our $SQL_SRJO_NATURAL_JOIN = 0x00000080;
our $SQL_SRJO_RIGHT_OUTER_JOIN = 0x00000100;
our $SQL_SRJO_UNION_JOIN = 0x00000200;

#  SQLGetInfo SQL_SQL92_REVOKE attributes
our $SQL_SR_USAGE_ON_DOMAIN = 0x00000001;
our $SQL_SR_USAGE_ON_CHARACTER_SET = 0x00000002;
our $SQL_SR_USAGE_ON_COLLATION = 0x00000004;
our $SQL_SR_USAGE_ON_TRANSLATION = 0x00000008;
our $SQL_SR_GRANT_OPTION_FOR = 0x00000010;
our $SQL_SR_CASCADE = 0x00000020;
our $SQL_SR_RESTRICT = 0x00000040;
our $SQL_SR_DELETE_TABLE = 0x00000080;
our $SQL_SR_INSERT_TABLE = 0x00000100;
our $SQL_SR_INSERT_COLUMN = 0x00000200;
our $SQL_SR_REFERENCES_TABLE = 0x00000400;
our $SQL_SR_REFERENCES_COLUMN = 0x00000800;
our $SQL_SR_SELECT_TABLE = 0x00001000;
our $SQL_SR_UPDATE_TABLE = 0x00002000;
our $SQL_SR_UPDATE_COLUMN = 0x00004000;

#  SQLGetInfo SQL_SQL92_ROW_VALUE_CONSTRUCTOR attributes
our $SQL_SRVC_VALUE_EXPRESSION = 0x00000001;
our $SQL_SRVC_NULL = 0x00000002;
our $SQL_SRVC_DEFAULT = 0x00000004;
our $SQL_SRVC_ROW_SUBQUERY = 0x00000008;

#  SQLGetInfo SQL_SQL92_STRING_FUNCTIONS attributes
our $SQL_SSF_CONVERT = 0x00000001;
our $SQL_SSF_LOWER = 0x00000002;
our $SQL_SSF_UPPER = 0x00000004;
our $SQL_SSF_SUBSTRING = 0x00000008;
our $SQL_SSF_TRANSLATE = 0x00000010;
our $SQL_SSF_TRIM_BOTH = 0x00000020;
our $SQL_SSF_TRIM_LEADING = 0x00000040;
our $SQL_SSF_TRIM_TRAILING = 0x00000080;

#  SQLGetInfo SQL_SQL92_VALUE_EXPRESSIONS attributes
our $SQL_SVE_CASE = 0x00000001;
our $SQL_SVE_CAST = 0x00000002;
our $SQL_SVE_COALESCE = 0x00000004;
our $SQL_SVE_NULLIF = 0x00000008;

#  SQLGetInfo SQL_STANDARD_CLI_CONFORMANCE attributes
our $SQL_SCC_XOPEN_CLI_VERSION1 = 0x00000001;
our $SQL_SCC_ISO92_CLI = 0x00000002;

#  SQLGetInfo SQL_STATIC_SENSITIVITY attributes
our $SQL_SS_ADDITIONS = 0x00000001;
our $SQL_SS_DELETIONS = 0x00000002;
our $SQL_SS_UPDATES = 0x00000004;

#  SQLGetInfo SQL_SUBQUERIES attributes
our $SQL_SQ_COMPARISON = 0x00000001;
our $SQL_SQ_EXISTS = 0x00000002;
our $SQL_SQ_IN = 0x00000004;
our $SQL_SQ_QUANTIFIED = 0x00000008;
our $SQL_SQ_CORRELATED_SUBQUERIES = 0x00000010;

#  SQLGetInfo SQL_SYSTEM_FUNCTIONS attributes
our $SQL_FN_SYS_USERNAME = 0x00000001;
our $SQL_FN_SYS_DBNAME = 0x00000002;
our $SQL_FN_SYS_IFNULL = 0x00000004;

#  SQLGetInfo SQL_STRING_FUNCTIONS attributes
our $SQL_FN_STR_CONCAT = 0x00000001;
our $SQL_FN_STR_INSERT = 0x00000002;
our $SQL_FN_STR_LEFT = 0x00000004;
our $SQL_FN_STR_LTRIM = 0x00000008;
our $SQL_FN_STR_LENGTH = 0x00000010;
our $SQL_FN_STR_LOCATE = 0x00000020;
our $SQL_FN_STR_LCASE = 0x00000040;
our $SQL_FN_STR_REPEAT = 0x00000080;
our $SQL_FN_STR_REPLACE = 0x00000100;
our $SQL_FN_STR_RIGHT = 0x00000200;
our $SQL_FN_STR_RTRIM = 0x00000400;
our $SQL_FN_STR_SUBSTRING = 0x00000800;
our $SQL_FN_STR_UCASE = 0x00001000;
our $SQL_FN_STR_ASCII = 0x00002000;
our $SQL_FN_STR_CHAR = 0x00004000;
our $SQL_FN_STR_DIFFERENCE = 0x00008000;
our $SQL_FN_STR_LOCATE_2 = 0x00010000;
our $SQL_FN_STR_SOUNDEX = 0x00020000;
our $SQL_FN_STR_SPACE = 0x00040000;
our $SQL_FN_STR_BIT_LENGTH = 0x00080000;
our $SQL_FN_STR_CHAR_LENGTH = 0x00100000;
our $SQL_FN_STR_CHARACTER_LENGTH = 0x00200000;
our $SQL_FN_STR_OCTET_LENGTH = 0x00400000;
our $SQL_FN_STR_POSITION = 0x00800000;

#  SQLGetInfo SQL_TIMEDATE_ADD_INTERVALS and SQL_TIMEDATE_DIFF_INTERVALS
#  attributes
our $SQL_FN_TSI_FRAC_SECOND = 0x00000001;
our $SQL_FN_TSI_SECOND = 0x00000002;
our $SQL_FN_TSI_MINUTE = 0x00000004;
our $SQL_FN_TSI_HOUR = 0x00000008;
our $SQL_FN_TSI_DAY = 0x00000010;
our $SQL_FN_TSI_WEEK = 0x00000020;
our $SQL_FN_TSI_MONTH = 0x00000040;
our $SQL_FN_TSI_QUARTER = 0x00000080;
our $SQL_FN_TSI_YEAR = 0x00000100;

#  SQLGetInfo SQL_TIMEDATE_FUNCTIONS attributes
our $SQL_FN_TD_NOW = 0x00000001;
our $SQL_FN_TD_CURDATE = 0x00000002;
our $SQL_FN_TD_DAYOFMONTH = 0x00000004;
our $SQL_FN_TD_DAYOFWEEK = 0x00000008;
our $SQL_FN_TD_DAYOFYEAR = 0x00000010;
our $SQL_FN_TD_MONTH = 0x00000020;
our $SQL_FN_TD_QUARTER = 0x00000040;
our $SQL_FN_TD_WEEK = 0x00000080;
our $SQL_FN_TD_YEAR = 0x00000100;
our $SQL_FN_TD_CURTIME = 0x00000200;
our $SQL_FN_TD_HOUR = 0x00000400;
our $SQL_FN_TD_MINUTE = 0x00000800;
our $SQL_FN_TD_SECOND = 0x00001000;
our $SQL_FN_TD_TIMESTAMPADD = 0x00002000;
our $SQL_FN_TD_TIMESTAMPDIFF = 0x00004000;
our $SQL_FN_TD_DAYNAME = 0x00008000;
our $SQL_FN_TD_MONTHNAME = 0x00010000;
our $SQL_FN_TD_CURRENT_DATE = 0x00020000;
our $SQL_FN_TD_CURRENT_TIME = 0x00040000;
our $SQL_FN_TD_CURRENT_TIMESTAMP = 0x00080000;
our $SQL_FN_TD_EXTRACT = 0x00100000;

#  SQLGetInfo SQL_TXN_ISOLATION_OPTION attributes
our $SQL_TXN_VERSIONING = 0x00000010;

#  SQLGetInfo SQL_UNION attributes
our $SQL_U_UNION = 0x00000001;
our $SQL_U_UNION_ALL = 0x00000002;

#  SQLGetInfo SQL_UNION_STATEMENT attributes
our $SQL_US_UNION = $SQL_U_UNION;
our $SQL_US_UNION_ALL = $SQL_U_UNION_ALL;

#  SQLGetInfo SQL_VIEW attributes
our $SQL_CV_CREATE_VIEW = 0x00000001;
our $SQL_CV_CHECK_OPTION = 0x00000002;
our $SQL_CV_CASCADED = 0x00000004;
our $SQL_CV_LOCAL = 0x00000008;

#  SQLGetStmtAttr ODBC 2 attributes
our $SQL_QUERY_TIMEOUT = 0;
our $SQL_MAX_ROWS = 1;
our $SQL_NOSCAN = 2;
our $SQL_MAX_LENGTH = 3;
our $SQL_ASYNC_ENABLE = 4;
our $SQL_BIND_TYPE = 5;
our $SQL_CURSOR_TYPE = 6;
our $SQL_CONCURRENCY = 7;
our $SQL_KEYSET_SIZE = 8;
our $SQL_ROWSET_SIZE = 9;
our $SQL_SIMULATE_CURSOR = 10;
our $SQL_RETRIEVE_DATA = 11;
our $SQL_USE_BOOKMARKS = 12;
our $SQL_GET_BOOKMARK = 13;
our $SQL_ROW_NUMBER = 14;

#  SQLGetStmtAttr ODBC 3 attributes
our $SQL_ATTR_ASYNC_ENABLE = 4;
our $SQL_ATTR_CONCURRENCY = $SQL_CONCURRENCY;
our $SQL_ATTR_CURSOR_TYPE = $SQL_CURSOR_TYPE;
our $SQL_ATTR_ENABLE_AUTO_IPD = 15;
our $SQL_ATTR_FETCH_BOOKMARK_PTR = 16;
our $SQL_ATTR_KEYSET_SIZE = $SQL_KEYSET_SIZE;
our $SQL_ATTR_MAX_LENGTH = $SQL_MAX_LENGTH;
our $SQL_ATTR_MAX_ROWS = $SQL_MAX_ROWS;
our $SQL_ATTR_NOSCAN = $SQL_NOSCAN;
our $SQL_ATTR_PARAM_BIND_OFFSET_PTR = 17;
our $SQL_ATTR_PARAM_BIND_TYPE = 18;
our $SQL_ATTR_PARAM_OPERATION_PTR = 19;
our $SQL_ATTR_PARAM_STATUS_PTR = 20;
our $SQL_ATTR_PARAMS_PROCESSED_PTR = 21;
our $SQL_ATTR_PARAMSET_SIZE = 22;
our $SQL_ATTR_QUERY_TIMEOUT = $SQL_QUERY_TIMEOUT;
our $SQL_ATTR_RETRIEVE_DATA = $SQL_RETRIEVE_DATA;
our $SQL_ATTR_ROW_BIND_OFFSET_PTR = 23;
our $SQL_ATTR_ROW_BIND_TYPE = $SQL_BIND_TYPE;
our $SQL_ATTR_ROW_NUMBER = $SQL_ROW_NUMBER;
our $SQL_ATTR_ROW_OPERATION_PTR = 24;
our $SQL_ATTR_ROW_STATUS_PTR = 25;
our $SQL_ATTR_ROWS_FETCHED_PTR = 26;
our $SQL_ATTR_ROW_ARRAY_SIZE = 27;
our $SQL_ATTR_SIMULATE_CURSOR = $SQL_SIMULATE_CURSOR;
our $SQL_ATTR_USE_BOOKMARKS = $SQL_USE_BOOKMARKS;
our $SQL_STMT_OPT_MAX = $SQL_ROW_NUMBER;
our $SQL_STMT_OPT_MIN = $SQL_QUERY_TIMEOUT;

#  SQLGetStmtAttr SQL_ATTR_ASYNC_ENABLE attributes
our $SQL_ASYNC_ENABLE_OFF = 0;
our $SQL_ASYNC_ENABLE_ON = 1;
our $SQL_ASYNC_ENABLE_DEFAULT = $SQL_ASYNC_ENABLE_OFF;

#  SQLGetStmtAttr SQL_ATTR_PARAM_BIND_TYPE attributes
our $SQL_PARAM_BIND_BY_COLUMN = 0;
our $SQL_PARAM_BIND_TYPE_DEFAULT = $SQL_PARAM_BIND_BY_COLUMN;

#   SQLGetStmtAttr SQL_BIND_TYPE attributes
our $SQL_BIND_BY_COLUMN = 0;
our $SQL_BIND_TYPE_DEFAULT = $SQL_BIND_BY_COLUMN;

#  SQLGetStmtAttr SQL_CONCURRENCY attributes
our $SQL_CONCUR_READ_ONLY = 1;
our $SQL_CONCUR_LOCK  = 2;
our $SQL_CONCUR_ROWVER = 3;
our $SQL_CONCUR_VALUES = 4;
our $SQL_CONCUR_DEFAULT	= $SQL_CONCUR_READ_ONLY;

#  SQLGetStmtAttr SQL_CURSOR_TYPE attributes
our $SQL_CURSOR_FORWARD_ONLY = 0;
our $SQL_CURSOR_KEYSET_DRIVEN = 1;
our $SQL_CURSOR_DYNAMIC	= 2;
our $SQL_CURSOR_STATIC = 3;
our $SQL_CURSOR_TYPE_DEFAULT = $SQL_CURSOR_FORWARD_ONLY;

#  SQLGetStmtAttr SQL_KEYSET_SIZE attributes
our $SQL_KEYSET_SIZE_DEFAULT = 0;

#  SQLGetStmtAttr SQL_MAX_LENGTH attributes
our $SQL_MAX_LENGTH_DEFAULT = 0;

#  SQLGetStmtAttr SQL_MAX_ROWS attributes
our $SQL_MAX_ROWS_DEFAULT = 0;

#  SQLGetStmtAttr SQL_NOSCAN attributes
our $SQL_NOSCAN_OFF = 0;
our $SQL_NOSCAN_ON = 1;
our $SQL_NOSCAN_DEFAULT = $SQL_NOSCAN_OFF;

#  SQLGetStmtAttr SQL_QUERY_TIMEOUT attributes
our $SQL_QUERY_TIMEOUT_DEFAULT = 0;

#  SQLGetStmtAttr SQL_RETRIEVE_DATA attributes
our $SQL_RD_OFF = 0;
our $SQL_RD_ON = 1;
our $SQL_RD_DEFAULT = $SQL_RD_ON;

#  SQLGetStmtAttr SQL_ROWSET_SIZE attributes
our $SQL_ROWSET_SIZE_DEFAULT = 1;

#  SQLGetStmtAttr SQL_SIMULATE_CURSOR attributes
our $SQL_SC_NON_UNIQUE = 0;
our $SQL_SC_TRY_UNIQUE = 1;
our $SQL_SC_UNIQUE = 2;

#  SQLGetStmtAttr SQL_USE_BOOKMARKS attributes
our $SQL_UB_OFF = 0;
our $SQL_UB_ON = 1;
our $SQL_UB_DEFAULT = $SQL_UB_OFF;
our $SQL_UB_FIXED = $SQL_UB_ON;
our $SQL_UB_VARIABLE = 2;

#  SQLGetTypeInfo SEARCHABLE attributes
our $SQL_COL_PRED_CHAR = $SQL_LIKE_ONLY;
our $SQL_COL_PRED_BASIC = $SQL_ALL_EXCEPT_LIKE;

#  SQLSetPos
our $SQL_ENTIRE_ROWSET = 0;

#  SQLSetPos 
our $SQL_POSITION = 0;
our $SQL_REFRESH = 1;
our $SQL_UPDATE = 2;
our $SQL_DELETE = 3;

#  SQLBulkOperations 
our $SQL_ADD = 4;
our $SQL_SETPOS_MAX_OPTION_VALUE = $SQL_ADD;
our $SQL_UPDATE_BY_BOOKMARK = 5;
our $SQL_DELETE_BY_BOOKMARK = 6;
our $SQL_FETCH_BY_BOOKMARK = 7;

#  SQLSetPos - LockType
our $SQL_LOCK_NO_CHANGE = 0;
our $SQL_LOCK_EXCLUSIVE	= 1;
our $SQL_LOCK_UNLOCK = 2;
our $SQL_SETPOS_MAX_LOCK_VALUE = $SQL_LOCK_UNLOCK;

#  SQLSpecialColumns Column types and scopes attributes
our $SQL_BEST_ROWID = 1;
our $SQL_ROWVER = 2;

#  SQLExtendedFetch - fFetchType
our $SQL_FETCH_BOOKMARK = 8;

#  SQLSpecialColumns PSEUDO_COLUMN attribute
our $SQL_PC_NOT_PSEUDO = 1;

# For backwards compatibility - deprecated
our $SQL_DATABASE_NAME = 16;
our $SQL_FD_FETCH_PREV = $SQL_FD_FETCH_PRIOR;
our $SQL_FETCH_PREV = $SQL_FETCH_PRIOR;
our $SQL_CONCUR_TIMESTAMP = $SQL_CONCUR_ROWVER;
our $SQL_SCCO_OPT_TIMESTAMP = $SQL_SCCO_OPT_ROWVER;
our $SQL_CC_DELETE = $SQL_CB_DELETE;
our $SQL_CR_DELETE = $SQL_CB_DELETE;
our $SQL_CC_CLOSE = $SQL_CB_CLOSE;
our $SQL_CR_CLOSE = $SQL_CB_CLOSE;
our $SQL_CC_PRESERVE = $SQL_CB_PRESERVE;
our $SQL_CR_PRESERVE = $SQL_CB_PRESERVE;
our $SQL_FETCH_RESUME = 7;
our $SQL_SCROLL_FORWARD_ONLY = 0;
our $SQL_SCROLL_KEYSET_DRIVEN = -1;
our $SQL_SCROLL_DYNAMIC	= -2;
our $SQL_SCROLL_STATIC = -3;

#  SQLExtendedFetch rgfRowStatus
our $SQL_ROW_SUCCESS = 0;
our $SQL_ROW_DELETED = 1;
our $SQL_ROW_UPDATED = 2;
our $SQL_ROW_NOROW = 3;
our $SQL_ROW_ADDED = 4;
our $SQL_ROW_ERROR = 5;
our $SQL_ROW_SUCCESS_WITH_INFO = 6;
our $SQL_ROW_PROCEED = 0;
our $SQL_ROW_IGNORE = 1;

#  SQL_DESC_ARRAY_STATUS_PTR
our $SQL_PARAM_SUCCESS = 0;
our $SQL_PARAM_SUCCESS_WITH_INFO = 6;
our $SQL_PARAM_ERROR = 5;
our $SQL_PARAM_UNUSED = 7;
our $SQL_PARAM_DIAG_UNAVAILABLE = 1;
our $SQL_PARAM_PROCEED = 0;
our $SQL_PARAM_IGNORE = 1;

#  SQLForeignKeys UPDATE_RULE/DELETE_RULE
our $SQL_CASCADE = 0;
our $SQL_RESTRICT = 1;
our $SQL_SET_NULL = 2;
our $SQL_NO_ACTION = 3;
our $SQL_SET_DEFAULT = 4;

#  SQLForeignKeys DEFERABILITY attributes
our $SQL_INITIALLY_DEFERRED = 5;
our $SQL_INITIALLY_IMMEDIATE = 6;
our $SQL_NOT_DEFERRABLE	= 7;

# SQLBindParameter - fParamType
# SQLProcedureColumns - COLUMN_TYPE
our $SQL_PARAM_TYPE_UNKNOWN = 0;
our $SQL_PARAM_INPUT = 1;
our $SQL_PARAM_INPUT_OUTPUT = 2;
our $SQL_RESULT_COL = 3;
our $SQL_PARAM_OUTPUT = 4;
our $SQL_RETURN_VALUE = 5;

#  SQLProcedures PROCEDURE_TYPE attributes
our $SQL_PT_UNKNOWN = 0;
our $SQL_PT_PROCEDURE = 1;
our $SQL_PT_FUNCTION = 2;

#  SQLSetParam to SQLBindParameter conversion
our $SQL_PARAM_TYPE_DEFAULT = $SQL_PARAM_INPUT_OUTPUT;
our $SQL_SETPARAM_VALUE_MAX = -1;

#  SQLStatistics - fAccuracy
our $SQL_QUICK = 0;
our $SQL_ENSURE = 1;

#  SQLStatistics TYPE attribute
our $SQL_TABLE_STAT = 0;

#  SQLTables
our $SQL_ALL_CATALOGS = "%";
our $SQL_ALL_SCHEMAS = "%";
our $SQL_ALL_TABLE_TYPES = "%";

# Type aliases
our $SQL_YEAR = $SQL_CODE_YEAR;
our $SQL_MONTH = $SQL_CODE_MONTH;
our $SQL_DAY = $SQL_CODE_DAY;
our $SQL_HOUR = $SQL_CODE_HOUR;
our $SQL_MINUTE	= $SQL_CODE_MINUTE;
our $SQL_SECOND = $SQL_CODE_SECOND;
our $SQL_YEAR_TO_MONTH = $SQL_CODE_YEAR_TO_MONTH;
our $SQL_DAY_TO_HOUR = $SQL_CODE_DAY_TO_HOUR;
our $SQL_DAY_TO_MINUTE = $SQL_CODE_DAY_TO_MINUTE;
our $SQL_DAY_TO_SECOND = $SQL_CODE_DAY_TO_SECOND;
our $SQL_HOUR_TO_MINUTE = $SQL_CODE_HOUR_TO_MINUTE;
our $SQL_HOUR_TO_SECOND = $SQL_CODE_HOUR_TO_SECOND;
our $SQL_MINUTE_TO_SECOND = $SQL_CODE_MINUTE_TO_SECOND;

our @SQL_ODBC_KEYWORDS = qw(ABSOLUTE ACTION ADA ADD ALL ALLOCATE ALTER AND 
  ANY ARE AS ASC ASSERTION AT AUTHORIZATION AVG BEGIN BETWEEN BIT BIT_LENGTH
  BOTH BY CASCADE CASCADED CASE CAST CATALOG CHAR CHAR_LENGTH CHARACTER
  CHARACTER_LENGTH CHECK CLOSE COALESCE COLLATE COLLATION COLUMN COMMIT
  CONNECT CONNECTION CONSTRAINT CONSTRAINTS CONTINUE CONVERT CORRESPONDING
  COUNT CREATE CROSS CURRENT CURRENT_DATE CURRENT_TIME CURRENT_TIMESTAMP
  CURRENT_USER CURSOR DATE DAY DEALLOCATE DEC DECIMAL DECLARE DEFAULT
  DEFERRABLE DEFERRED DELETE DESC DESCRIBE DESCRIPTOR DIAGNOSTICS DISCONNECT
  DISTINCT DOMAIN DOUBLE DROP ELSE END END-EXEC ESCAPE EXCEPT EXCEPTION
  EXEC EXECUTE EXISTS EXTERNAL EXTRACT FALSE FETCH FIRST FLOAT FOR FOREIGN
  FORTRAN FOUND FROM FULL GET GLOBAL GO GOTO GRANT GROUP HAVING HOUR
  IDENTITY IMMEDIATE IN INCLUDE INDEX INDICATOR INITIALLY INNER
  INPUT INSENSITIVE INSERT INT INTEGER INTERSECT INTERVAL INTO IS ISOLATION
  JOIN KEY LANGUAGE LAST LEADING LEFT LEVEL LIKE LOCAL LOWER MATCH MAX
  MIN MINUTE MODULE MONTH NAMES NATIONAL NATURAL NCHAR NEXT NO
  NONE NOT NULL NULLIF NUMERIC OCTET_LENGTH OF ON ONLY OPEN OPTION OR ORDER
  OUTER OUTPUT OVERLAPS PAD PARTIAL PASCAL PLI POSITION PRECISION PREPARE
  PRESERVE PRIMARY PRIOR PRIVILEGES PROCEDURE PUBLIC READ REAL REFERENCES
  RELATIVE RESTRICT REVOKE RIGHT ROLLBACK ROWS SCHEMA SCROLL SECOND
  SECTION SELECT SESSION SESSION_USER SET SIZE SMALLINT SOME SPACE SQL
  SfQLCA SQLCODE SQLERROR SQLSTATE SQLWARNING SUBSTRING SUM SYSTEM_USER
  TABLE TEMPORARY THEN TIME TIMESTAMP TIMEZONE_HOUR TIMEZONE_MINUTE
  TO TRAILING TRANSACTION TRANSLATE TRANSLATION TRIM TRUE
  UNION UNIQUE UNKNOWN UPDATE UPPER USAGE USER USING VALUE VALUES VARCHAR
  VARYING VIEW WHEN WHENEVER WHERE WITH WORK WRITE YEAR ZONE);


## 
## /* sqlext.h */
## 
## /*
##  *  SQLSetPos macros
##  */
# our $SQL_POSITION_TO(hstmt,irow) 	\
##     SQLSetPos(hstmt,irow,SQL_POSITION,SQL_LOCK_NO_CHANGE)
# our $SQL_LOCK_RECORD(hstmt,irow,fLock) \
##     SQLSetPos(hstmt,irow,SQL_POSITION,fLock)
# our $SQL_REFRESH_RECORD(hstmt,irow,fLock) \
##     SQLSetPos(hstmt,irow,SQL_REFRESH,fLock)
# our $SQL_UPDATE_RECORD(hstmt,irow) \
##     SQLSetPos(hstmt,irow,SQL_UPDATE,SQL_LOCK_NO_CHANGE)
# our $SQL_DELETE_RECORD(hstmt,irow) \
##     SQLSetPos(hstmt,irow,SQL_DELETE,SQL_LOCK_NO_CHANGE)
# our $SQL_ADD_RECORD(hstmt,irow) \
##     SQLSetPos(hstmt,irow,SQL_ADD,SQL_LOCK_NO_CHANGE)
## 
## 
## 
## /*
##  *  SQLAllocHandleStd - make SQLAllocHandle compatible with X/Open standard
##  *
##  *  NOTE: An application should not call SQLAllocHandleStd directly
##  */
## #ifdef ODBC_STD
# our $SQLAllocHandle			SQLAllocHandleStd
# our $SQLAllocEnv(phenv) \
##     SQLAllocHandleStd(SQL_HANDLE_ENV, SQL_NULL_HANDLE, phenv)
## 
## #if (ODBCVER >= 0x0300)
## SQLRETURN SQL_API SQLAllocHandleStd (
##     SQLSMALLINT fHandleType,
##     SQLHANDLE hInput,
##     SQLHANDLE * phOutput);
## #endif


bootstrap UnixODBC $VERSION;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__

=head1 NAME

UnixODBC - Perl extension for unixODBC 2.2.0.

=head1 SYNOPSIS

  use UnixODBC ':all';

  my $evh;    # Environment handle
  my $cnh;    # Connection handle
  my $sth;    # Statement handle
  my $r;      # result
  my $buf;    # Buffer for results
  my $buflen; # Size of buffer.
  my $rlen;   # Length of result.

  my $query = 'select * from customers;';

  $r = SQLPrepare ($sth, $query, length ($query));

=head1 DESCRIPTION

Perl library for unixODBC 2.2.1 API.

=head1 API

=head2 SQLAllocHandle ($handle_type, $parent_handle, $new_handle)

  # Allocate environment handle

  $r = &UnixODBC::SQLAllocHandle ($SQL_HANDLE_ENV, $SQL_NULL_HANDLE, 
				  $evh);

  # Allocate connection handle

  $r = &UnixODBC::SQLAllocHandle ($SQL_HANDLE_DBC, $evh, $cnh);

  # Allocate statement handle

  $r = &UnixODBC::SQLAllocHandle ($SQL_HANDLE_STMT, $cnh, $sth);

=head2 SQLAllocEnv ($evh)

  $r = SQLAllocEnv ($evh);

=head2 SQLAllocConnect ($evh,$cnh);

  $r = SQLAllocConnect ($evh,$cnh);

=head2 SQLColAttribute ($sth, $column_number, $attr_selector, $text_attr, $maxsize, $returned_text_length, $numeric_attr);

  $r = SQLColAttribute ($sth, $column_number, $attr_selector,
                        $text_attr, $maxsize, $returned_text_length, 
			$numeric_attr);

=head2 SQLColumnPrivileges ($sth, $catalog_name, $catalog_name_length, $schema_name, $schema_name_length, $table_name, $table_name_length, $column_name, $column_name_length);

  $r = SQLColumnPrivileges ($sth, $catalog_name, $catalog_name_length, 
			    $schema_name, $schema_name_length, 
			    $table_name, $table_name_length,
			    $column_name, $column_name_length);

=head2 SQLColumns ($sth, $catalog_name, $catalog_name_length, $schema_name, $schema_name_length, $table_name, $table_name_length,o $column_name, $column_name_length)

  $r = SQLColumns ($sth, $catalog_name, $catalog_name_length,
		   $schema_name, $schema_name_length,
		   $table_name, $table_name_length,
		   $column_name, $column_name_length);

=head2 SQLConnect ($cnh, $DSN, $DSN_length, $UserName, $UserName_length, $PassWord, $PassWord_length)

  $r = SQLConnect ($cnh, $DSN, $DSN_length, $UserName, $UserName_length,
		   $PassWord, $PassWord_length);

=head2 SQLDataSources ($evh, $direction, $DSN, $DSN_max_length, $returned_DSN_length, $drivername, $drivername_max_length, $returned_driver_length )

=head2 SQLDescribeCol ($sth, $column_number, $column_name, $max_length, $returned_length, $data_type, $column_size, $decimal_digits, $nullable)

=head2 SQLDisconnect ($sth) 

=head2 SQLDrivers ($evh, $direction, $driver_desc, $max_desc_len, $returned_desc_length, $driver_attributes, $max_attr_length, $returned_attr_length)

=head2 SQLError ($evh, $cnh, $sth, $sqlstate, $native_error, $text, $max_len, $text_len)

=head2 SQLExecute ($sth)

=head2 SQLFetchScroll ($sth, $direction, $row_number)

=head2 SQLForeignKeys ($sth, '', 0, '', 0, '', 0, '', 0, '', 0, '', 0)

=head2 SQLFreeStmt ($sth, $option)

=head2 SQLFreeConnect ($cnh)

=head2 SQLFreeHandle ($handle_type, $handle)

=head2 SQLGetConnectAttr ($cnh, <attrib>, $buf, $buflen, $rlen)

=head2 SQLGetCursorName ($sth, $resultbuffer, 255, $length)

=head2 SQLGetData ($sth, $column_number, <sqltype>, $buf, $column_width, $rlen)

=head2 SQLGetDiagField ($SQL_HANDLE_DBC, $cnh, 1, $SQL_DIAG_RETURNCODE, $ibuf, 255, $mlen)

=head2 SQLGetDiagRec

=head2 SQLGetEnvAttr ($evh, <attrib>, $buf, $buflen, $rlen)

=head2 SQLGetFunctions ($cnh, $function, $supported)

=head2 SQLGetInfo ($cnh, $attr, $buf, $buflen, $rlen)

=head2 SQLGetStmtAttr ($sth, $SQL_ATTR_ROW_NUMBER, $resultbuffer, 255, $length)

=head2 SQLGetTypeInfo ($sthandle, $SQL_ALL_TYPES)

=head2 SQLMoreResults ($sth)

=head2 SQLNumResultCols ($sth, $ncols)

=head2 SQLPrepare ($sth, $query, length ($query))

=head2 SQLPrimaryKeys ($sth, '', 0, '', 0, 'titles', 6)

=head2 SQLProcedureColumns ($sth, '', 0, '', 0, '', 0, '', 0)

=head2 SQLProcedures ($sth, '', 0, '', 0, '', 0)

=head2 SQLRowCount ($sth,$nrows)

=head2 SQLSetConnectAttr ($cnh, <attrib>, <value>, <length>)

  # deprecated

=head2 SQLSetConnectOption 

=head2 SQLSetCursorName ($sth, $cursorname, length ($cursorname))

=head2 SQLSetEnvAttr ($evh, <attrib>, <value>, <length>)

=head2 SQLSetPos ($sth, 1, $SQL_POSITION, $SQL_LOCK_NO_CHANGE)

=head2 SQLSetScrollOptions($sth, f_concurrency, crow_keyset, crow_rowset)

=head2 SQLSetStmtAttr ($sth, $SQL_ATTR_METADATA_ID, '1', length ('1'))

=head2 SQLSpecialColumns ($sth, $SQL_ROWVER, '', 0, '', 0, 'titles', 6, $SQL_SCOPE_CURROW, 0)

=head2 SQLStatistics ($sth, '', 0, '', 0, 'titles', 6, 1, 1)

=head2 SQLTablePrivileges ($sth, $catalog_name, $catalog_name_length, $schema_name, $schema_name_length, $table_name, $table_name_length)

=head2 SQLTables ($sth, $catalog_name, $catalog_name_length, $schema_name, $schema_name_length, $table_name, $table_name_length, $column_name, $column_name_length)


=head2   dm_log_open ('programname', 'logfilename');

=head2   dm_log_close ();


=head2 Using UnixODBC.pm with Apache

If SQLGetDiagRec returns an error that it can't locate a library,
the Apache environment needs to be configured so that it knows
about all of the library directories.  If mod_env (part of the
standard Apache configuration) is installed, use the SetEnv
directive in the httpd.conf file.  

For MySQL and MyODBC, this directive in httpd.conf solves the problem:

SetEnv LD_LIBRARY_PATH /lib:/usr/lib:/usr/local/lib:/usr/local/mysql/lib/mysql

=head2 EXPORT

Refer to the @EXPORT_OK array in UnixODBC.pm.

=head1 TO DO

1. GUI interface for SQLDriverConnect.

2. Implement SQLBrowseConnect with drivers that support it.

3. Implement descriptor handle type and descriptor handle functions
   in drivers that support it, and functions that depend on
   descriptor records, like SQLBulkOperations.

4. Implement SQLBindParameter, SQLDescribeParam, SQLNumParams,
   SQLParamData, SQLPutData, and other parameter functions.

5. Implement SQLBindCol and the functions that depend on it.

=head1 AUTHOR

Robert Allan Kiesling <rkiesling@earthlink.net>

=head1 SEE ALSO

perl(1), tkdm(1), UnixODBC::BridgeServer(3)

The source code for unixODBC. 

=cut
