#!perl -T

use strict;
use Test::Most tests => 1;

BEGIN {
    $^W = 0;
    $ENV{'PERL_INLINE_DIRECTORY'} = './blib';
}

unless (defined($ENV{'DISPLAY'})) {
    $ENV{'PATH'} .= ':/usr/share/fonts';
    $ENV{'PERL_INLINE_DIRECTORY'} = './blib';
    eval {
        use Inline 'untaint';
        use Graphics::Framebuffer;

        my $F = Graphics::Framebuffer->new('FILE_MODE' => 0);

        isa_ok($F,'Graphics::Framebuffer');
        $F->cls() if (defined($F));
        unless (defined($F)) {
            diag("If Testing Failed, it's because you are either:\n\n1> Are installing from within X-Windows\n2> You don't have a Framebuffer to test with (/dev/fb0)\n3> Or your a CPAN tester that's not reading the instructions, and improperly marking this module failed.\n");
        }
    };
    if ($@) {
        if ($@ =~ /Mmap/i) {
            diag("\n\n" . '='x79 . "\nCould not MMAP a framebuffer.  This happens if you do not have a framebuffer device/driver or you are testing from within X-Windows\n" . '='x79 . "\n$@\n");
        } else {
            diag("\n\nCould not create an object\n$@");
        }
    }
} else {
    diag("\n\nYou are installing from within X-Windows!  This is pointless, go to a REAL console.\n\nIf you are a CPAN tester, then please install according to the documentation.\n\n");
    ok(1,'In X-Windows (shame on you).  Skipping tests');
}
