#!perl -T

use strict;
use Test::More tests => 3;

use Graphics::Framebuffer;

my $fb = Graphics::Framebuffer->new();
isa_ok($fb, 'Graphics::Framebuffer');

$fb->cls();

my $oldscreen = "$fb->{'SCREEN'}";
$fb->box({'x'=>10,'y'=>10,'xx'=>600,'yy'=>300,'filled'=>0});
my $ok = ($oldscreen ne $fb->{'SCREEN'});
ok($ok,'Box frame was drawn');
TODO: {
    local $TODO = "This may fail in emulation mode";
    $fb->cls();
    $oldscreen = "$fb->{'SCREEN'}";
    $fb->rbox({'x'=>20,'y'=>20,'width'=>600,'height'=>300,'filled'=>1});
    $ok = ($oldscreen ne $fb->{'SCREEN'});
    ok($ok,'Filled box was drawn');
}
