
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Get all the prereqs for WebGUI",
  "AUTHOR" => "JT Smith <jt\@plainblack.com>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Task-WebGUI",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Task::WebGUI",
  "PREREQ_PM" => {
    "Algorithm::C3" => "0.07",
    "Any::Moose" => "0.15",
    "App::Nopaste" => "0.17",
    "App::cpanminus" => "1.5006",
    "Archive::Any" => "0.0932",
    "Archive::Tar" => "1.44",
    "Archive::Zip" => "1.26",
    "Array::Compare" => "2.01",
    "Authen::SASL" => "2.12",
    "BSD::Resource" => "1.2902",
    "Business::PayPal::API" => "0.69",
    "Business::Tax::VAT::Validation" => "0.20",
    "CAM::PDF" => "1.52",
    "CGI" => "3.42",
    "CSS::Minifier::XS" => "0.03",
    "CSS::Packer" => "1.002",
    "Carp::Assert" => "0.20",
    "Carp::Assert::More" => "1.12",
    "Class::C3" => "0.21",
    "Class::C3::XS" => "0.11",
    "Class::Data::Accessor" => "0.04004",
    "Class::Data::Inheritable" => "0.08",
    "Class::InsideOut" => "1.09",
    "Class::MOP" => "0.97",
    "Class::MakeMethods" => "1.01",
    "Class::Member" => "1.6",
    "Class::Singleton" => "1.4",
    "Clipboard" => "0.09",
    "Clone" => "0.31",
    "Color::Calc" => "1.05",
    "Compress::Raw::Zlib" => "2.015",
    "Compress::Zlib" => "2.015",
    "Config::INI" => "0.014",
    "Config::JSON" => "1.5100",
    "Convert::ASN1" => "0.22",
    "Crypt::CBC" => "2.30",
    "Crypt::DH" => "0.06",
    "Crypt::OpenSSL::RSA" => "0.26",
    "Crypt::OpenSSL::Random" => "0.04",
    "Crypt::RC4" => "2.02",
    "Crypt::SSLeay" => "0.57",
    "DBD::mysql" => "4.018",
    "DBI" => "1.615",
    "Data::OptList" => "0.104",
    "Data::Structure::Util" => "0.15",
    "DateTime" => "0.4501",
    "DateTime::Event::ICal" => "0.09",
    "DateTime::Event::Recurrence" => "0.16",
    "DateTime::Format::Mail" => "0.3001",
    "DateTime::Format::Strptime" => "1.0800",
    "DateTime::Locale" => "0.42",
    "DateTime::Set" => "0.26",
    "DateTime::TimeZone" => "0.84",
    "Devel::Cycle" => "1.10",
    "Devel::GlobalDestruction" => "0.02",
    "Devel::StackTrace" => "1.20",
    "Devel::Symdump" => "2.08",
    "Devel::XRay" => "0.95",
    "Digest::BubbleBabble" => "0.01",
    "Digest::HMAC" => "1.01",
    "Digest::MD5" => "2.39",
    "Digest::SHA" => "5.47",
    "Digest::SHA1" => "2.12",
    "Error" => "0.17016",
    "Exception::Class" => "1.26",
    "ExtUtils::CBuilder" => "0.24",
    "ExtUtils::MakeMaker" => "6.48",
    "ExtUtils::XSBuilder" => "0.28",
    "File::MMagic" => "1.27",
    "File::Path" => "2.07",
    "File::Slurp" => "9999.13",
    "File::Spec" => "3.29",
    "File::Temp" => "0.21",
    "File::Which" => "0.05",
    "Finance::Quote" => "1.17",
    "Getopt::Long::Descriptive" => "0.081",
    "GraphViz" => "2.04",
    "Graphics::ColorNames" => "2.11",
    "HTML::Highlight" => "0.20",
    "HTML::Packer" => "1.002001",
    "HTML::Parser" => "3.64",
    "HTML::TableExtract" => "2.10",
    "HTML::TagCloud" => "0.34",
    "HTML::TagFilter" => "1.03",
    "HTML::Tagset" => "3.20",
    "HTML::Template" => "2.9",
    "HTML::Template::Expr" => "0.07",
    "HTML::Tree" => "3.23",
    "HTTP::Response::Encoding" => "0.05",
    "HTTP::Server::Simple" => "0.44",
    "IO::Socket::SSL" => "1.22",
    "IO::String" => "1.08",
    "IO::Stringy" => "2.110",
    "IO::Zlib" => "1.09",
    "IPC::Run" => "0.82",
    "Image::ExifTool" => "8.00",
    "JSON" => "2.17",
    "JSON::XS" => "2.26",
    "JavaScript::Minifier::XS" => "0.05",
    "JavaScript::Packer" => "1.004",
    "LWP" => "5.834",
    "LWPx::ParanoidAgent" => "1.04",
    "List::MoreUtils" => "0.22",
    "List::Util" => "1.19",
    "Locale::US" => "1.2",
    "Locales" => "0.19",
    "Log::Log4perl" => "1.20",
    "MIME::Tools" => "5.427",
    "MIME::Types" => "1.27",
    "MRO::Compat" => "0.11",
    "Mail::Mailer" => "2.04",
    "Math::BigInt::FastCalc" => "0.19",
    "Mixin::Linewise" => "0.002",
    "Module::Build" => "0.31012",
    "Module::Find" => "0.06",
    "Module::Load" => "0.16",
    "Moose" => "0.93",
    "MooseX::Getopt" => "0.25",
    "Mouse" => "0.93",
    "MySQL::Diff" => "0.33",
    "Net::CIDR::Lite" => "0.20",
    "Net::DNS" => "0.65",
    "Net::IP" => "1.25",
    "Net::LDAP" => "0.39",
    "Net::SSLeay" => "1.36",
    "POE" => "1.283",
    "POE::Component::Client::DNS" => "1.051",
    "POE::Component::Client::HTTP" => "0.893",
    "POE::Component::Client::Keepalive" => "0.262",
    "POE::Component::IKC" => "0.2002",
    "PadWalker" => "1.7",
    "Params::Util" => "1.00",
    "Params::Validate" => "0.91",
    "Parse::RecDescent" => "1.96.0",
    "Path::Class" => "0.16",
    "Plack" => "0.9985",
    "Pod::Coverage" => "0.19",
    "Pod::Escapes" => "1.04",
    "Pod::Simple" => "3.10",
    "Pod::Text" => "2.2.2",
    "Proc::ProcessTable" => "0.44",
    "Readonly" => "1.03",
    "Regexp::RegGrp" => "1.002",
    "SOAP::Lite" => "0.710.08",
    "Scope::Guard" => "0.03",
    "Set::Infinite" => "0.63",
    "Spiffy" => "0.30",
    "String::CRC32" => "1.4",
    "String::Random" => "0.22",
    "Sub::Exporter" => "0.982",
    "Sub::Install" => "0.925",
    "Sub::Name" => "0.04",
    "Sub::Uplevel" => "0.2002",
    "Task::Weaken" => "1.03",
    "Template" => "2.22",
    "Test::Class" => "0.31",
    "Test::Deep" => "0.103",
    "Test::Exception" => "0.27",
    "Test::Harness" => "3.17",
    "Test::JSON" => "0.06",
    "Test::LongString" => "0.15",
    "Test::Memory::Cycle" => "1.04",
    "Test::MockObject" => "1.20110612",
    "Test::NoWarnings" => "1.02",
    "Test::Pod" => "1.26",
    "Test::Simple" => "0.94",
    "Test::Taint" => "1.04",
    "Test::Tester" => "0.107",
    "Test::WWW::Mechanize" => "1.24",
    "Test::Warn" => "0.11",
    "Text::Balanced" => "2.02",
    "Text::CSV_XS" => "0.69",
    "Text::Diff::HTML" => "0.06",
    "Text::PDF" => "0.29",
    "Tie::CPHash" => "1.04",
    "Tie::IxHash" => "1.21",
    "Time::Format" => "1.09",
    "Time::HiRes" => "1.9719",
    "Time::Local" => "1.1901",
    "Tree::DAG_Node" => "1.06",
    "Try::Tiny" => "0.02",
    "UNIVERSAL::can" => "1.15",
    "UNIVERSAL::isa" => "1.03",
    "URI" => "1.51",
    "WWW::Mechanize" => "1.54",
    "WWW::Pastebin::PastebinCom::Create" => "0.003",
    "WWW::Pastebin::RafbNet::Create" => "0.001",
    "Weather::Com" => "0.5.3",
    "XML::FeedPP" => "0.40",
    "XML::Filter::BufferText" => "1.01",
    "XML::NamespaceSupport" => "1.09",
    "XML::Parser" => "2.36",
    "XML::RSSLite" => "0.11",
    "XML::SAX" => "0.96",
    "XML::SAX::Base" => "1.02",
    "XML::SAX::Expat" => "0.40",
    "XML::SAX::Writer" => "0.53",
    "XML::Simple" => "2.18",
    "XML::TreePP" => "0.38",
    "YAML" => "0.68",
    "common::sense" => "3.4",
    "version" => "0.76"
  },
  "VERSION" => "0.0101",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



