package Parrot::Embed;

# $Id: Embed.pm 24009 2007-12-17 10:57:57Z timbo $

use strict;
use warnings;

our $VERSION = '0.02';

use base qw(DynaLoader Exporter);

our @EXPORT_OK = qw(Parrot_revision);

Parrot::Embed->bootstrap($VERSION);

1;

__END__

=head1 NAME

Parrot::Embed - use Parrot from Perl 5

=head1 VERSION

Version 0.02

=head1 SYNOPSIS

  use Parrot::Embed qw(Parrot_revision);

=head1 DESCRIPTION

This module embeds libparrot in Perl 5 programs.  You can load Parrot bytecode,
compile your own code, and call Parrot subroutines and send and receive values
to them.

It provides the core implementation used by the L<Parrot::Interpreter> module.
Do consider using L<Parrot::Interpreter> first however.  See also
L<Parrot::PMC>.

The only useful interface provided by this module is Parrot_revision().

=head2 Parrot_revision()

Returns the integer revision number of the embedded libparrot.

=head1 AUTHOR

chromatic, C<< <chromatic at wgz.org> >>

=head1 BUGS

Please report any bugs or feature requests to the Parrot Porters mailing list.
Someday there may be a CPAN version of this code.  Who knows?

=head1 COPYRIGHT & LICENSE

Copyright (C) 2006-2007 The Perl Foundation / chromatic.

This program is free software; you can redistribute it and/or modify it
under the same terms as Parrot itself.

=cut

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
