# 5F-list_words.t version 0.01
# A script to run tests on the Lingua::Norms::USF module.
# Checks correct returns of data from list_words
use strict;
use warnings;
use Test::More tests => 14;
use constant EPS => 1e-2;

my ($dat, @ari) = ();

BEGIN { use_ok('Lingua::Norms::USF') };

my $usf = Lingua::Norms::USF->new();

# these counts verified manually:
my %dat_ref = (
    Flen3_all => 24, # all words in all files of length 2 or 3 starting with F
    Flen3_cues => 21, # all the words in F-file of length 2 or 3 starting with F
    Flen3_cues_last => 'FUR', # last of above if alphabetically sorted
    Fssz26t33_cues => 4,
    Fssz26t33_hmg_cues => 2,
    Fssz26t33_hmg_noun_cues => 2,
    n23_all_excult => 180,
);

my %common_crits = (first => [qw/F/], chars => [3, 3], ref => 0, );

$dat = scalar $usf->list_words(cues_only => 0, %common_crits);
ok( is_equal($dat, $dat_ref{'Flen3_all'}), "N words returned = $dat, should be $dat_ref{'Flen3_all'}" );

@ari = $usf->list_words(cues_only => 1, sortby => 'alpha', %common_crits);
$dat = scalar @ari;
ok( is_equal($dat, $dat_ref{'Flen3_cues'}), "N words returned = $dat, should be $dat_ref{'Flen3_cues'}" );
ok( char_equal($ari[-1], $dat_ref{'Flen3_cues_last'}), "Last word returned = $ari[-1], should be $dat_ref{'Flen3_cues_last'}" );

# check get as aref and for SSZ limit:
my $aref = $usf->list_words(first => 'F', SSZ => [26, 33], ref => 1, cues_only => 1); # fort, fray, free, farmer
$dat = scalar @$aref;
ok( is_equal($dat, $dat_ref{'Fssz26t33_cues'}), "N words returned = $dat, should be $dat_ref{'Fssz26t33_cues'}" );

# Attend to HMG field:
#- Want any, HMG or not:
$aref = $usf->list_words(first => 'F', SSZ => [26, 33], HMG => '', ref => 1, cues_only => 1); # fort, fray, free, farmer
$dat = scalar @$aref;
ok( is_equal($dat, $dat_ref{'Fssz26t33_cues'}), "N words returned = $dat, should be $dat_ref{'Fssz26t33_cues'}" );
#- Want whatever is NOT a homograph:
$aref = $usf->list_words(first => 'F', SSZ => [26, 33], HMG => 0, ref => 1, cues_only => 1, sortby => 'alpha'); # farmer, fort
$dat = scalar @$aref;
ok( is_equal($dat, $dat_ref{'Fssz26t33_hmg_cues'}), "N words returned = $dat, should be $dat_ref{'Fssz26t33_hmg_cues'}" );
ok( char_equal($aref->[0], 'FARMER'), "Word returned = $aref->[0], should be FARMER" );
ok( char_equal($aref->[1], 'FORT'), "Word returned = $aref->[1], should be FORT" );
#- Want only what IS a homograph:
$aref = $usf->list_words(first => 'F', SSZ => [26, 33], HMG => 1, ref => 1, cues_only => 1, sortby => 'alpha'); # farmer, fort
$dat = scalar @$aref;
ok( is_equal($dat, $dat_ref{'Fssz26t33_hmg_cues'}), "N words returned = $dat, should be $dat_ref{'Fssz26t33_hmg_cues'}" );
ok( char_equal($aref->[0], 'FRAY'), "Word returned = $aref->[0], should be FRAY" );
ok( char_equal($aref->[1], 'FREE'), "Word returned = $aref->[1], should be FREE" );

# try single part-of-speech: nouns only: drop 'free' which is not a noun:
@ari = $usf->list_words(first => 'F', SSZ => [26, 33], HMG => 1, PSP => 'N', ref => 0, cues_only => 1, sortby => 'alpha'); # fray, not free
ok( is_equal($dat, $dat_ref{'Fssz26t33_hmg_noun_cues'}), "N words returned = $dat, should be $dat_ref{'Fssz26t33_hmg_noun_cues'}" );
# recall 'free' for adjectives AND nouns OK: 
@ari = $usf->list_words(first => 'F', SSZ => [26, 33], HMG => 1, PSP => ['AJ', 'N'], ref => 0, cues_only => 1, sortby => 'alpha'); # fray, free
ok( is_equal($dat, $dat_ref{'Fssz26t33_hmg_cues'}), "N words returned = $dat, should be $dat_ref{'Fssz26t33_hmg_cues'}" );

sub is_equal {
    return 1 if $_[0] == $_[1];
    return 0;
}

sub char_equal {
    return 1 if $_[0] eq $_[1];
    return 0;
}

sub about_equal {
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
