# 5B-list_overlaps.t version 0.01
# A script to run tests on the Lingua::Norms::USF module.
# Checks correct returns of data from list_overlaps
use strict;
use warnings;

use Test::More tests => 8;
use constant EPS => 1e-9;

BEGIN { use_ok('Lingua::Norms::USF') };

my $usf = Lingua::Norms::USF->new();

my ($word1, $word2, $dat, $aref, @ari) = (qw/court jury/);


my %dat_ref = (
    nshareds => 2,
    depth1 => 0,
    depth2 => 1,
    depth10 => 2,
    depthval1s5 => .021,
);

# Test list_associates:
$aref = $usf->list_overlaps($word1, $word2, ref => 1); # assume data => 0
$dat = scalar(@$aref);
ok( is_equal($dat, $dat_ref{'nshareds'}), "N shareds returned = $dat, should be $dat_ref{'nshareds'}" );

#- as open array:
@ari = $usf->list_overlaps($word1, $word2, ref => 0); # assume ref => 1, data => 0
$dat = scalar(@ari);
ok( is_equal($dat, $dat_ref{'nshareds'}), "N shareds returned = $dat, should be $dat_ref{'nshareds'}" );

#-controlling depth:
$aref = $usf->list_overlaps($word1, $word2, depth => 1, ref => 1); # assume data => 0
$dat = scalar(@$aref);
ok( is_equal($dat, $dat_ref{'depth1'}), "Seeking $dat_ref{'depth1'} shared, got $dat" );

# - try to gain one overlap:
$aref = $usf->list_overlaps($word1, $word2, depth => 2, ref => 1); # assume data => 0
$dat = scalar(@$aref);
ok( is_equal($dat, $dat_ref{'depth2'}), "Seeking $dat_ref{'depth2'} shared, got $dat" );

# - try to gain two overlaps:
$aref = $usf->list_overlaps($word1, $word2, depth => 10, ref => 1); # assume data => 0
$dat = scalar(@$aref);
ok( is_equal($dat, $dat_ref{'depth10'}), "Seeking $dat_ref{'depth10'} shared, got $dat" );

#- try to get data, not just word list:
$aref = $usf->list_overlaps($word1, $word2, depth => 10, data => 1, ref => 1); 
# -- expect only 2 lines - check the value of the 5th col in the 2nd line:
$dat = $aref->[1]->[5];
ok( is_equal($dat, $dat_ref{'depthval1s5'}), "Seeking $dat_ref{'depthval1s5'} meds, got $dat");
# - same but as a reference of hashed lines:
$aref = $usf->list_overlaps($word1, $word2, depth => 10, data => 2, ref => 1); 
$dat = $aref->[1]->{'FSG'};
ok( is_equal($dat, $dat_ref{'depthval1s5'}), "Seeking $dat_ref{'depthval1s5'} meds, got $dat");

sub is_equal {
    return 1 if $_[0] == $_[1];
    return 0;
}

sub char_equal {
    return 1 if $_[0] eq $_[1];
    return 0;
}

sub about_equal {
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
