# 5A-list_associates.t version 0.01
# A script to run tests on the Lingua::Norms::USF module.
# Checks correct returns of data from list_associates
use strict;
use warnings;

use Test::More tests => 9;
use constant EPS => 1e-9;

BEGIN { use_ok('Lingua::Norms::USF') };

my $usf = Lingua::Norms::USF->new();

my ($word1, $word2, $dat, $aref, @ari) = (qw/milk cow/);

my %dat_ref = (
    nassoc => 18,
    lastassoc => 'SKIM',
    depthassoc => 4,
    depthword => 'WHITE',
    valassoc5 => 0.073,
);

# Test list_associates:
$aref = $usf->list_associates($word1, ref => 1); # assume data => 0
$dat = scalar(@$aref);
ok( is_equal($dat, $dat_ref{'nassoc'}), "N associates returned = $dat, should be $dat_ref{'nassoc'}" );

#- as open array:
@ari = $usf->list_associates($word1, ref => 0); # assume data => 0
$dat = scalar(@ari);
ok( is_equal($dat, $dat_ref{'nassoc'}), "N associates returned = $dat, should be $dat_ref{'nassoc'}" );

#- check got right to the proper end of list:
ok(char_equal($ari[-1], $dat_ref{'lastassoc'}), "Last associate returned = $ari[-1], should be $dat_ref{'lastassoc'}");

#-controlling depth:
$aref = $usf->list_associates($word1, depth => 4, ref => 1); # assume  data => 0
$dat = scalar(@$aref);
ok( is_equal($dat, $dat_ref{'depthassoc'}), "Seeking $dat_ref{'depthassoc'} associates, got $dat" );

#- check got right to the proper end of list:
ok(char_equal($aref->[-1], $dat_ref{'depthword'}), "Last associate returned = $aref->[-1], should be $dat_ref{'depthword'}");

#- try to get data, not just word list:
$aref = $usf->list_associates($word1, depth => 4, data => 1, ref => 1);

# -- ensuring only up to the 4th assoc, as a reference of 4 referenced lines - checking the value of the 5th value in the 3rd line:
$dat = scalar(@$aref);
ok( is_equal($dat, $dat_ref{'depthassoc'}), "Seeking $dat_ref{'depthassoc'} associates, got $dat");
my $datline = $aref->[2];
ok( is_equal($datline->[5], $dat_ref{'valassoc5'}), "Seeking $dat_ref{'valassoc5'} associates, got $datline->[5]");

# - same but as a reference of hashed lines:
$aref = $usf->list_associates($word1, depth => 4, data => 2, ref => 1);
$datline = $aref->[2];
ok( is_equal($datline->{'FSG'}, $dat_ref{'valassoc5'}), "Seeking $dat_ref{'valassoc5'} associates, got $datline->{'FSG'}");

sub is_equal {
    return 1 if $_[0] == $_[1];
    return 0;
}

sub char_equal {
    return 1 if $_[0] eq $_[1];
    return 0;
}

sub about_equal {
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
